/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ClockTestUtil;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BoundaryTimerNonInterruptingEventTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected TaskService taskService;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.taskService = this.engineRule.getTaskService();
    }

    @After
    public void tearDown() {
        ClockUtil.reset();
    }

    @Deployment
    @Test
    public void testMultipleTimersOnUserTask() {
        Date startTime = new Date();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimersOnUserTask");
        Task task1 = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"First Task", (Object)task1.getName());
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        Assert.assertEquals((long)2L, (long)jobs.size());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3605000L));
        this.testHelper.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().desc()).list();
        Assert.assertEquals((Object)"First Task", (Object)((Task)taskList.get(0)).getName());
        Assert.assertEquals((Object)"Escalation Task 1", (Object)((Task)taskList.get(1)).getName());
        this.taskService.complete(((Task)taskList.get(1)).getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((Object)"First Task", (Object)((Task)this.taskService.createTaskQuery().singleResult()).getName());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 7205000L));
        this.testHelper.waitForJobExecutorToProcessAllJobs(5000L);
        Assert.assertEquals((long)0L, (long)jobQuery.count());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        taskList = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().desc()).list();
        Assert.assertEquals((Object)"First Task", (Object)((Task)taskList.get(0)).getName());
        Assert.assertEquals((Object)"Escalation Task 2", (Object)((Task)taskList.get(1)).getName());
        this.taskService.complete(((Task)taskList.get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task escalationTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Escalation Task 2", (Object)escalationTask.getName());
        this.taskService.complete(escalationTask.getId());
        this.testHelper.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testTimerOnMiUserTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimersOnUserTask");
        List taskList = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)5L, (long)taskList.size());
        for (Task task : taskList) {
            Assert.assertEquals((Object)"First Task", (Object)task.getName());
        }
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        taskList = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)6L, (long)taskList.size());
        Task escalationTask = (Task)taskList.remove(0);
        Assert.assertEquals((Object)"Escalation Task 1", (Object)escalationTask.getName());
        this.taskService.complete(escalationTask.getId());
        for (Task task : taskList) {
            this.taskService.complete(task.getId());
        }
        this.testHelper.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testJoin() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testJoin");
        Task task1 = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Main Task", (Object)task1.getName());
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.taskService.complete(task1.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task2 = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Escalation Task", (Object)task2.getName());
        this.taskService.complete(task2.getId());
        this.testHelper.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testTimerOnConcurrentMiTasks() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("timerOnConcurrentMiTasks");
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().desc()).list();
        Assert.assertEquals((long)6L, (long)taskList.size());
        Task secondTask = (Task)taskList.remove(0);
        Assert.assertEquals((Object)"Second Task", (Object)secondTask.getName());
        for (Task task : taskList) {
            Assert.assertEquals((Object)"First Task", (Object)task.getName());
        }
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(pi.getId()).singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        taskList = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        Assert.assertEquals((long)7L, (long)taskList.size());
        Task escalationTask = (Task)taskList.remove(0);
        Assert.assertEquals((Object)"Escalation Task 1", (Object)escalationTask.getName());
        this.taskService.complete(escalationTask.getId());
        for (Task task : taskList) {
            this.taskService.complete(task.getId());
        }
        this.testHelper.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testTimerOnConcurrentTasks() {
        String procId = this.runtimeService.startProcessInstanceByKey("nonInterruptingOnConcurrentTasks").getId();
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        for (Task t : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(t.getId());
        }
        this.testHelper.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/BoundaryTimerNonInterruptingEventTest.testTimerOnConcurrentTasks.bpmn20.xml"})
    @Test
    public void testTimerOnConcurrentTasks2() {
        String procId = this.runtimeService.startProcessInstanceByKey("nonInterruptingOnConcurrentTasks").getId();
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("firstTask").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("secondTask").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask").singleResult();
        this.taskService.complete(task.getId());
        this.testHelper.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testTimerWithCycle() throws Exception {
        this.runtimeService.startProcessInstanceByKey("nonInterruptingCycle").getId();
        TaskQuery tq = this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask");
        Assert.assertEquals((long)0L, (long)tq.count());
        this.moveByHours(1);
        Assert.assertEquals((long)1L, (long)tq.count());
        this.moveByHours(1);
        Assert.assertEquals((long)2L, (long)tq.count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        this.moveByHours(1);
        Assert.assertEquals((long)2L, (long)tq.count());
    }

    @Deployment
    @Test
    public void testTimerOnEmbeddedSubprocess() {
        String id = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimerOnEmbeddedSubprocess").getId();
        TaskQuery tq = this.taskService.createTaskQuery().taskAssignee("kermit");
        Assert.assertEquals((long)1L, (long)tq.count());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        tq = this.taskService.createTaskQuery().taskAssignee("kermit");
        Assert.assertEquals((long)2L, (long)tq.count());
        List tasks = tq.list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.testHelper.assertProcessEnded(id);
    }

    @Deployment
    @Test
    public void testReceiveTaskWithBoundaryTimer() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("timeCycle", "R/PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingCycle", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        List executions = this.runtimeService.createExecutionQuery().activityId("task").list();
        Assert.assertEquals((long)1L, (long)executions.size());
        List activeActivityIds = this.runtimeService.getActiveActivityIds(((Execution)executions.get(0)).getId());
        Assert.assertEquals((long)1L, (long)activeActivityIds.size());
        Assert.assertEquals((Object)"task", activeActivityIds.get(0));
        this.runtimeService.signal(((Execution)executions.get(0)).getId());
        this.testHelper.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testTimerOnConcurrentSubprocess() {
        String procId = this.runtimeService.startProcessInstanceByKey("testTimerOnConcurrentSubprocess").getId();
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().count());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Assert.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub1task1").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub1task2").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub2task1").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub2task2").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask").singleResult();
        this.taskService.complete(task.getId());
        this.testHelper.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/BoundaryTimerNonInterruptingEventTest.testTimerOnConcurrentSubprocess.bpmn20.xml"})
    @Test
    public void testTimerOnConcurrentSubprocess2() {
        String procId = this.runtimeService.startProcessInstanceByKey("testTimerOnConcurrentSubprocess").getId();
        Assert.assertEquals((long)4L, (long)this.taskService.createTaskQuery().count());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        Assert.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub1task1").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub1task2").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub2task1").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub2task2").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        this.testHelper.assertProcessEnded(procId);
    }

    @Deployment
    @Test
    public void testMultipleOutgoingSequenceFlows() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)3L, (long)taskQuery.count());
        List tasks = taskQuery.list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testHelper.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testMultipleOutgoingSequenceFlowsOnSubprocess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask1").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask2").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask1").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask2").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testHelper.assertProcessEnded(pi.getId());
        pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimer");
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask1").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask2").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask1").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask2").singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testHelper.assertProcessEnded(pi.getId());
    }

    @Deployment
    @Test
    public void testMultipleOutgoingSequenceFlowsOnSubprocessMi() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Assert.assertEquals((long)10L, (long)taskQuery.count());
        List tasks = taskQuery.list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testHelper.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/BoundaryTimerNonInterruptingEventTest.testTimerWithCycle.bpmn20.xml"})
    @Test
    public void testTimeCycle() {
        this.runtimeService.startProcessInstanceByKey("nonInterruptingCycle");
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String anotherJobId = ((Job)jobQuery.singleResult()).getId();
        Assert.assertFalse((boolean)jobId.equals(anotherJobId));
    }

    @Deployment
    @Test
    public void testFailingTimeCycle() {
        this.runtimeService.startProcessInstanceByKey("process");
        JobQuery failedJobQuery = this.managementService.createJobQuery();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        failedJobQuery.jobId(jobId);
        try {
            this.managementService.executeJob(jobId);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Job failedJob = (Job)failedJobQuery.singleResult();
        Assert.assertEquals((long)2L, (long)failedJob.getRetries());
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        Assert.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        failedJob = (Job)failedJobQuery.singleResult();
        Assert.assertEquals((long)1L, (long)failedJob.getRetries());
        Assert.assertEquals((long)2L, (long)jobQuery.count());
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        Assert.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
    }

    @Deployment
    @Test
    public void testUpdateTimerRepeat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Calendar currentTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)currentTime.getTime());
        this.runtimeService.startProcessInstanceByKey("timerRepeat");
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"User Waiting", (Object)((Task)tasks.get(0)).getName());
        TimerEntity timerJob = (TimerEntity)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)timerJob);
        Assert.assertEquals((Object)("R5/" + sdf.format(ClockUtil.getCurrentTime()) + "/PT1H"), (Object)timerJob.getRepeat());
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            TimerEntity timerEntity = (TimerEntity)commandContext.getProcessEngineConfiguration().getManagementService().createJobQuery().singleResult();
            timerEntity.setRepeat("R3/PT3H");
            return null;
        });
        TimerEntity updatedTimerJob = (TimerEntity)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((Object)"R3/PT3H", (Object)updatedTimerJob.getRepeat());
        currentTime.add(10, 1);
        ClockUtil.setCurrentTime((Date)currentTime.getTime());
        this.managementService.executeJob(timerJob.getId());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskCreateTime().asc()).list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"User Waiting", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"Timer Fired", (Object)((Task)tasks.get(1)).getName());
        TimerEntity secondTimerJob = (TimerEntity)this.managementService.createJobQuery().singleResult();
        currentTime.add(10, 3);
        Assert.assertEquals((Object)"R3/PT3H", (Object)secondTimerJob.getRepeat());
        Assert.assertEquals((Object)sdf.format(currentTime.getTime()), (Object)sdf.format(secondTimerJob.getDuedate()));
    }

    @Test
    public void shouldExecuteTimerJobOnOrAfterDueDate() {
        Date currentTime = ClockTestUtil.setClockToDateWithoutMilliseconds();
        Date timerDueDate = Date.from(currentTime.toInstant().plusMillis(3000L));
        BpmnModelInstance instance = ((BoundaryEventBuilder)((BoundaryEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"timerProcess").startEvent().camundaAsyncBefore()).userTask("user-task-with-timer").boundaryEvent("non-interuption-timer").cancelActivity(Boolean.valueOf(false))).timerWithDuration("R/PT3S")).endEvent().moveToActivity("user-task-with-timer").endEvent().done();
        this.testHelper.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("timerProcess");
        this.testHelper.waitForJobExecutorToProcessAllJobs(6000L);
        Job timerJob = (Job)this.managementService.createJobQuery().timers().activityId("non-interuption-timer").singleResult();
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)userTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)timerJob, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)timerJob.getDuedate(), (Matcher)Matchers.is((Object)timerDueDate));
    }

    @Test(timeout=10000L)
    public void shouldExecuteTimeoutListenerJobOnOrAfterDueDate() {
        Date currentTime = ClockTestUtil.setClockToDateWithoutMilliseconds();
        Date timerDueDate = Date.from(currentTime.toInstant().plusMillis(3000L));
        BpmnModelInstance instance = ((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"timoutProcess").startEvent().camundaAsyncBefore()).userTask("user-task-with-timer").camundaTaskListenerExpressionTimeoutWithCycle("timeout", "${true}", "R/PT3S")).endEvent().done();
        this.testHelper.deploy(instance);
        this.runtimeService.startProcessInstanceByKey("timoutProcess");
        this.testHelper.waitForJobExecutorToProcessAllJobs(6000L);
        Job timerJob = (Job)this.managementService.createJobQuery().timers().singleResult();
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)userTask, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)timerJob, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)timerJob.getDuedate(), (Matcher)Matchers.is((Object)timerDueDate));
    }

    private void moveByHours(int hours) throws Exception {
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + (long)(hours * 60 * 1000 * 60 + 5000)));
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        Thread.sleep(1000L);
        jobExecutor.shutdown();
    }
}

