/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.exclusive;

import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;

public class ExclusiveThrowEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testNonExclusiveThrowEvent() {
        this.runtimeService.startProcessInstanceByKey("exclusive");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ExclusiveThrowEventTest.assertNotNull((Object)job);
        ExclusiveThrowEventTest.assertFalse((boolean)((JobEntity)job).isExclusive());
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ExclusiveThrowEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testExclusiveThrowEvent() {
        this.runtimeService.startProcessInstanceByKey("exclusive");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        ExclusiveThrowEventTest.assertNotNull((Object)job);
        ExclusiveThrowEventTest.assertTrue((boolean)((JobEntity)job).isExclusive());
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ExclusiveThrowEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }

    @Deployment
    public void testExclusiveThrowEventConcurrent() {
        this.runtimeService.startProcessInstanceByKey("exclusive");
        ExclusiveThrowEventTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().count());
        this.waitForJobExecutorToProcessAllJobs(6000L);
        ExclusiveThrowEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
    }
}

