/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.decisiontask;

import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnDecisionResultEntries;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.cmmn.decisiontask.DecisionResultTestListener;
import org.camunda.bpm.engine.variable.Variables;

public class DmnDecisionTaskResultListenerTest
extends CmmnProcessEngineTestCase {
    protected static final String TEST_CASE = "org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn";
    protected static final String TEST_DECISION = "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml";
    protected static final String TEST_DECISION_COLLECT_SUM = "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml";
    protected static final String TEST_DECISION_COLLECT_COUNT = "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectCountHitPolicyTest.dmn11.xml";
    protected DmnDecisionResult results;

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testNoOutput() {
        this.startTestCase("no output");
        DmnDecisionTaskResultListenerTest.assertTrue((String)"The decision result 'ruleResult' should be empty", (boolean)this.results.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testEmptyOutput() {
        this.startTestCase("empty output");
        DmnDecisionTaskResultListenerTest.assertFalse((String)"The decision result 'ruleResult' should not be empty", (boolean)this.results.isEmpty());
        DmnDecisionResultEntries decisionOutput = (DmnDecisionResultEntries)this.results.get(0);
        DmnDecisionTaskResultListenerTest.assertNull((Object)decisionOutput.getFirstEntry());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testEmptyMap() {
        this.startTestCase("empty map");
        DmnDecisionTaskResultListenerTest.assertEquals((int)2, (int)this.results.size());
        for (DmnDecisionResultEntries output : this.results) {
            DmnDecisionTaskResultListenerTest.assertTrue((String)"The decision output should be empty", (boolean)output.isEmpty());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testSingleEntry() {
        this.startTestCase("single entry");
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        DmnDecisionTaskResultListenerTest.assertEquals((String)"foo", (String)((String)firstOutput.getFirstEntry()));
        DmnDecisionTaskResultListenerTest.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testMultipleEntries() {
        this.startTestCase("multiple entries");
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        DmnDecisionTaskResultListenerTest.assertEquals((Object)"foo", (Object)firstOutput.get((Object)"result1"));
        DmnDecisionTaskResultListenerTest.assertEquals((Object)"bar", (Object)firstOutput.get((Object)"result2"));
        DmnDecisionTaskResultListenerTest.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)firstOutput.getEntryTyped("result1"));
        DmnDecisionTaskResultListenerTest.assertEquals((Object)Variables.stringValue((String)"bar"), (Object)firstOutput.getEntryTyped("result2"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testSingleEntryList() {
        this.startTestCase("single entry list");
        DmnDecisionTaskResultListenerTest.assertEquals((int)2, (int)this.results.size());
        for (DmnDecisionResultEntries output : this.results) {
            DmnDecisionTaskResultListenerTest.assertEquals((String)"foo", (String)((String)output.getFirstEntry()));
            DmnDecisionTaskResultListenerTest.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)output.getFirstEntryTyped());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultTest.dmn11.xml"})
    public void testMultipleEntriesList() {
        this.startTestCase("multiple entries list");
        DmnDecisionTaskResultListenerTest.assertEquals((int)2, (int)this.results.size());
        for (DmnDecisionResultEntries output : this.results) {
            DmnDecisionTaskResultListenerTest.assertEquals((int)2, (int)output.size());
            DmnDecisionTaskResultListenerTest.assertEquals((Object)"foo", (Object)output.get((Object)"result1"));
            DmnDecisionTaskResultListenerTest.assertEquals((Object)"bar", (Object)output.get((Object)"result2"));
            DmnDecisionTaskResultListenerTest.assertEquals((Object)Variables.stringValue((String)"foo"), (Object)output.getEntryTyped("result1"));
            DmnDecisionTaskResultListenerTest.assertEquals((Object)Variables.stringValue((String)"bar"), (Object)output.getEntryTyped("result2"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectCountHitPolicyTest.dmn11.xml"})
    public void testCollectCountHitPolicyNoOutput() {
        this.startTestCase("no output");
        DmnDecisionTaskResultListenerTest.assertEquals((int)1, (int)this.results.size());
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        DmnDecisionTaskResultListenerTest.assertEquals((int)0, (int)((Integer)firstOutput.getFirstEntry()));
        DmnDecisionTaskResultListenerTest.assertEquals((Object)Variables.integerValue((Integer)0), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    public void testCollectSumHitPolicyNoOutput() {
        this.startTestCase("no output");
        DmnDecisionTaskResultListenerTest.assertTrue((String)"The decision result 'ruleResult' should be empty", (boolean)this.results.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    public void testCollectSumHitPolicySingleEntry() {
        this.startTestCase("single entry");
        DmnDecisionTaskResultListenerTest.assertEquals((int)1, (int)this.results.size());
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        DmnDecisionTaskResultListenerTest.assertEquals((int)12, (int)((Integer)firstOutput.getFirstEntry()));
        DmnDecisionTaskResultListenerTest.assertEquals((Object)Variables.integerValue((Integer)12), (Object)firstOutput.getFirstEntryTyped());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/decisiontask/DmnDecisionTaskResultListenerTest.cmmn", "org/camunda/bpm/engine/test/dmn/result/DmnDecisionResultCollectSumHitPolicyTest.dmn11.xml"})
    public void testCollectSumHitPolicySingleEntryList() {
        this.startTestCase("single entry list");
        DmnDecisionTaskResultListenerTest.assertEquals((int)1, (int)this.results.size());
        DmnDecisionResultEntries firstOutput = (DmnDecisionResultEntries)this.results.get(0);
        DmnDecisionTaskResultListenerTest.assertEquals((int)33, (int)((Integer)firstOutput.getFirstEntry()));
        DmnDecisionTaskResultListenerTest.assertEquals((Object)Variables.integerValue((Integer)33), (Object)firstOutput.getFirstEntryTyped());
    }

    protected CaseInstance startTestCase(String input) {
        CaseInstance caseInstance = this.createCaseInstanceByKey("case", Variables.createVariables().putValue("input", (Object)input));
        this.results = DecisionResultTestListener.getDecisionResult();
        DmnDecisionTaskResultListenerTest.assertNotNull((Object)this.results);
        return caseInstance;
    }

    protected void tearDown() throws Exception {
        DecisionResultTestListener.reset();
    }
}

