/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.humantask;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.camunda.bpm.engine.impl.test.CmmnProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.joda.time.Period;

public class HumanTaskFollowUpDateTest
extends CmmnProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/humantask/HumanTaskFollowUpDateTest.testHumanTaskFollowUpDate.cmmn"})
    public void testHumanTaskFollowUpDateExtension() throws Exception {
        Date date = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss").parse("01-01-2015 12:10:00");
        HashMap<String, Date> variables = new HashMap<String, Date>();
        variables.put("dateVariable", date);
        String caseInstanceId = this.caseService.createCaseInstanceByKey("case", variables).getId();
        Task task = (Task)this.taskService.createTaskQuery().caseInstanceId(caseInstanceId).singleResult();
        HumanTaskFollowUpDateTest.assertNotNull((Object)task.getFollowUpDate());
        HumanTaskFollowUpDateTest.assertEquals((Object)date, (Object)task.getFollowUpDate());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/humantask/HumanTaskFollowUpDateTest.testHumanTaskFollowUpDate.cmmn"})
    public void testHumanTaskFollowUpDateStringExtension() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("dateVariable", "2015-01-01T12:10:00");
        String caseInstanceId = this.caseService.createCaseInstanceByKey("case", variables).getId();
        Task task = (Task)this.taskService.createTaskQuery().caseInstanceId(caseInstanceId).singleResult();
        HumanTaskFollowUpDateTest.assertNotNull((Object)task.getFollowUpDate());
        Date date = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").parse("01-01-2015 12:10:00");
        HumanTaskFollowUpDateTest.assertEquals((Object)date, (Object)task.getFollowUpDate());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/humantask/HumanTaskFollowUpDateTest.testHumanTaskFollowUpDate.cmmn"})
    public void testHumanTaskRelativeFollowUpDate() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("dateVariable", "P2DT2H30M");
        String caseInstanceId = this.caseService.createCaseInstanceByKey("case", variables).getId();
        Task task = (Task)this.taskService.createTaskQuery().caseInstanceId(caseInstanceId).singleResult();
        Date followUpDate = task.getFollowUpDate();
        HumanTaskFollowUpDateTest.assertNotNull((Object)followUpDate);
        Period period = new Period(task.getCreateTime().getTime(), followUpDate.getTime());
        HumanTaskFollowUpDateTest.assertEquals((int)period.getDays(), (int)2);
        HumanTaskFollowUpDateTest.assertEquals((int)period.getHours(), (int)2);
        HumanTaskFollowUpDateTest.assertEquals((int)period.getMinutes(), (int)30);
    }
}

