/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.tasklistener;

import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.cmmn.tasklistener.util.FieldInjectionTaskListener;
import org.camunda.bpm.engine.test.cmmn.tasklistener.util.MySpecialTaskListener;
import org.camunda.bpm.engine.test.cmmn.tasklistener.util.MyTaskListener;
import org.camunda.bpm.engine.test.cmmn.tasklistener.util.NotTaskListener;
import org.camunda.bpm.engine.test.cmmn.tasklistener.util.TaskDeleteListener;

public class TaskListenerTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCreateListenerByClass.cmmn"})
    public void testCreateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)3L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCreateListenerByExpression.cmmn"})
    public void testCreateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)4L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCreateListenerByDelegateExpression.cmmn"})
    public void testCreateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)4L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCreateListenerByScript.cmmn"})
    public void testCreateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)2L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCompleteListenerByClass.cmmn"})
    public void testCompleteListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)3L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCompleteListenerByExpression.cmmn"})
    public void testCompleteListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)4L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCompleteListenerByDelegateExpression.cmmn"})
    public void testCompleteListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)4L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testCompleteListenerByScript.cmmn"})
    public void testCompleteListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)2L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDeleteListenerByClass.cmmn"})
    public void testDeleteListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)3L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDeleteListenerByExpression.cmmn"})
    public void testDeleteListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)4L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDeleteListenerByDelegateExpression.cmmn"})
    public void testDeleteListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)4L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDeleteListenerByScript.cmmn"})
    public void testDeleteListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)2L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDeleteListenerByCaseInstanceDeletion.cmmn"})
    public void testDeleteListenerByCaseInstanceDeletion() {
        TaskDeleteListener.clear();
        final String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getCaseExecutionManager().deleteCaseInstance(caseInstanceId, null);
                return null;
            }
        });
        TaskListenerTest.assertEquals((int)1, (int)TaskDeleteListener.eventCounter);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAssignmentListenerByClass.cmmn"})
    public void testAssignmentListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)3L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAssignmentListenerByExpression.cmmn"})
    public void testAssignmentListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)4L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAssignmentListenerByDelegateExpression.cmmn"})
    public void testAssignmentListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)4L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAssignmentListenerByScript.cmmn"})
    public void testAssignmentListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)2L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAssignmentListenerByInitialInstantiation.cmmn"})
    public void testAssignmentListenerByInitialInstantiation() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)3L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testUpdateListenerByClass.cmmn"})
    public void testUpdateListenerByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)3L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testUpdateListenerByExpression.cmmn"})
    public void testUpdateListenerByExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)4L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testUpdateListenerByDelegateExpression.cmmn"})
    public void testUpdateListenerByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)4L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testUpdateListenerByScript.cmmn"})
    public void testUpdateListenerByScript() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)2L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testUpdateListenerByInitialInstantiation.cmmn"})
    public void testUpdateListenerNotInvokedByInitialInstantiation() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)0L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByClass.cmmn"})
    public void testAllListenerByClassExcludingDeletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)9L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByClass.cmmn"})
    public void testAllListenerByClassExcludingCompletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)9L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByExpression.cmmn"})
    public void testAllListenerByExpressionExcludingDeletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)10L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByExpression.cmmn"})
    public void testAllListenerByExpressionExcludingCompletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MyTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)10L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByDelegateExpression.cmmn"})
    public void testAllListenerByDelegateExpressionExcludingDeletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)10L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByDelegateExpression.cmmn"})
    public void testAllListenerByDelegateExpressionExcludingCompletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new MySpecialTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)10L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByScript.cmmn"})
    public void testAllListenerByScriptExcludingDeletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)9L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testAllListenerByScript.cmmn"})
    public void testAllListenerByScriptExcludingCompletion() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.terminate(humanTaskId);
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)9L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("update").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("updateEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("delete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("deleteEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)4, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testFieldInjectionByClass.cmmn"})
    public void testFieldInjectionByClass() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)4L, (long)query.count());
        TaskListenerTest.assertEquals((Object)"Hello from The Case", (Object)((VariableInstance)query.variableName("greeting").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)"Hello World", (Object)((VariableInstance)query.variableName("helloWorld").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)"cam", (Object)((VariableInstance)query.variableName("prefix").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)"unda", (Object)((VariableInstance)query.variableName("suffix").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testFieldInjectionByDelegateExpression.cmmn"})
    public void testFieldInjectionByDelegateExpression() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new FieldInjectionTaskListener()).create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)5L, (long)query.count());
        TaskListenerTest.assertEquals((Object)"Hello from The Case", (Object)((VariableInstance)query.variableName("greeting").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)"Hello World", (Object)((VariableInstance)query.variableName("helloWorld").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)"cam", (Object)((VariableInstance)query.variableName("prefix").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)"unda", (Object)((VariableInstance)query.variableName("suffix").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testListenerByScriptResource.cmmn", "org/camunda/bpm/engine/test/cmmn/tasklistener/taskListener.groovy"})
    public void testListenerByScriptResource() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("case").create().getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().caseExecutionId(humanTaskId).singleResult()).getId();
        this.taskService.setAssignee(taskId, "jonny");
        this.caseService.withCaseExecution(humanTaskId).complete();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery().caseInstanceIdIn(new String[]{caseInstanceId});
        TaskListenerTest.assertEquals((long)7L, (long)query.count());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("create").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("createEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("assignment").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("assignmentEventCounter").singleResult()).getValue());
        TaskListenerTest.assertTrue((boolean)((Boolean)((VariableInstance)query.variableName("complete").singleResult()).getValue()));
        TaskListenerTest.assertEquals((Object)1, (Object)((VariableInstance)query.variableName("completeEventCounter").singleResult()).getValue());
        TaskListenerTest.assertEquals((Object)3, (Object)((VariableInstance)query.variableName("eventCounter").singleResult()).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDoesNotImplementTaskListenerInterfaceByClass.cmmn"})
    public void testDoesNotImplementTaskListenerInterfaceByClass() {
        try {
            this.caseService.withCaseDefinitionByKey("case").create().getId();
            TaskListenerTest.fail((String)"exception expected");
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String message = cause.getMessage();
            this.assertTextPresent("NotTaskListener doesn't implement " + TaskListener.class, message);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testDoesNotImplementTaskListenerInterfaceByDelegateExpression.cmmn"})
    public void testDoesNotImplementTaskListenerInterfaceByDelegateExpression() {
        try {
            this.caseService.withCaseDefinitionByKey("case").setVariable("myTaskListener", (Object)new NotTaskListener()).create().getId();
            TaskListenerTest.fail((String)"exception expected");
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String message = cause.getMessage();
            this.assertTextPresent("Delegate expression ${myTaskListener} did not resolve to an implementation of interface " + TaskListener.class.getName(), message);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/cmmn/tasklistener/TaskListenerTest.testTaskListenerDoesNotExist.cmmn"})
    public void testTaskListenerDoesNotExist() {
        try {
            this.caseService.withCaseDefinitionByKey("case").create().getId();
            TaskListenerTest.fail((String)"exception expected");
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            String message = cause.getMessage();
            this.assertTextPresent("Exception while instantiating class 'org.camunda.bpm.engine.test.cmmn.tasklistener.util.NotExistingTaskListener'", message);
        }
    }

    protected void terminate(final String caseExecutionId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                CmmnExecution caseTask = (CmmnExecution)TaskListenerTest.this.caseService.createCaseExecutionQuery().caseExecutionId(caseExecutionId).singleResult();
                caseTask.terminate();
                return null;
            }
        });
    }
}

