/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.impl.cmd.SetLicenseKeyCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;

public class CompetingLicenseKeyAccessTest
extends ConcurrencyTestCase {
    private ConcurrencyTestCase.ThreadControl asyncThread;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.managementService.setLicenseKey("testLicenseKey");
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.managementService.deleteLicenseKey();
    }

    public void testConcurrentlyDeleteAndSetLicense() {
        this.managementService.setLicenseKey("testLicenseKey");
        this.asyncThread = this.executeControllableCommand(new FetchAndUpdateLicenseCmd());
        this.asyncThread.waitForSync();
        this.managementService.deleteLicenseKey();
        this.asyncThread.reportInterrupts();
        this.asyncThread.waitUntilDone();
        Throwable exception = this.asyncThread.getException();
        Assertions.assertThat((Throwable)exception).isNotNull();
        Assertions.assertThat((boolean)(exception instanceof OptimisticLockingException)).isTrue();
    }

    public void testConcurrentlyAlterLicense() {
        this.managementService.setLicenseKey("testLicenseKey");
        this.asyncThread = this.executeControllableCommand(new FetchAndUpdateLicenseCmd());
        this.asyncThread.waitForSync();
        this.managementService.setLicenseKey("updatedTestLicenseKey");
        this.asyncThread.reportInterrupts();
        this.asyncThread.waitUntilDone();
        Throwable exception = this.asyncThread.getException();
        Assertions.assertThat((Throwable)exception).isNotNull();
        Assertions.assertThat((boolean)(exception instanceof OptimisticLockingException)).isTrue();
    }

    private static class FetchAndUpdateLicenseCmd
    extends ConcurrencyTestCase.ControllableCommand<Long> {
        private FetchAndUpdateLicenseCmd() {
        }

        public Long execute(CommandContext commandContext) {
            ResourceEntity licenseKey = commandContext.getResourceManager().findLicenseKeyResource();
            TestCase.assertNotNull((String)"license key is expected to be not null", (Object)licenseKey);
            this.monitor.sync();
            licenseKey.setBytes("updatedTestLicenseKeyBySecondThread".getBytes());
            new SetLicenseKeyCmd(new String(licenseKey.getBytes())).execute(commandContext);
            return null;
        }
    }
}

