/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.BootstrapEngineCommand;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;

public class ConcurrentHistoryCleanupReconfigureTest
extends ConcurrencyTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        this.clearDatabase();
        super.tearDown();
    }

    public void testReconfigureCleanupJobs() {
        String jobId = this.historyService.cleanUpHistoryAsync(true).getId();
        this.makeEverLivingJobFail(jobId);
        ConcurrencyTestCase.ThreadControl engineOne = this.executeControllableCommand(new EngineOne());
        ConcurrencyTestCase.ThreadControl engineTwo = this.executeControllableCommand(new EngineTwo());
        engineTwo.waitForSync();
        engineOne.makeContinue();
        engineOne.join();
        engineTwo.makeContinue();
        engineTwo.join();
    }

    protected void initializeProcessEngine() {
        this.processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml");
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime("12:00");
        this.processEngine = this.processEngineConfiguration.buildProcessEngine();
    }

    protected void clearDatabase() {
        this.deleteHistoryCleanupJobs();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                commandContext.getMeterLogManager().deleteAll();
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("history-cleanup");
                return null;
            }
        });
    }

    protected void makeEverLivingJobFail(final String jobId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobEntity job = commandContext.getJobManager().findJobById(jobId);
                job.setExceptionStacktrace("foo");
                return null;
            }
        });
    }

    public class EngineTwo
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        public Void execute(CommandContext commandContext) {
            ConcurrentHistoryCleanupReconfigureTest.this.historyService.findHistoryCleanupJobs();
            this.monitor.sync();
            new BootstrapEngineCommand().execute(commandContext);
            return null;
        }
    }

    public class EngineOne
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        public Void execute(CommandContext commandContext) {
            new BootstrapEngineCommand().execute(commandContext);
            return null;
        }
    }
}

