/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;

public class UserOperationLogJobTest
extends AbstractUserOperationLogTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testSetJobPriority() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobPriority(job.getId(), 42L);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("SetPriority").singleResult();
        UserOperationLogJobTest.assertNotNull((Object)userOperationLogEntry);
        UserOperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobTest.assertEquals((String)job.getId(), (String)userOperationLogEntry.getJobId());
        UserOperationLogJobTest.assertEquals((String)"SetPriority", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobTest.assertEquals((String)"priority", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobTest.assertEquals((String)"42", (String)userOperationLogEntry.getNewValue());
        UserOperationLogJobTest.assertEquals((String)"0", (String)userOperationLogEntry.getOrgValue());
        UserOperationLogJobTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobTest.assertEquals((String)job.getJobDefinitionId(), (String)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessInstanceId(), (String)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessDefinitionId(), (String)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessDefinitionKey(), (String)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobTest.assertEquals((String)this.deploymentId, (String)userOperationLogEntry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testSetRetries() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 4);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("SetJobRetries").singleResult();
        UserOperationLogJobTest.assertNotNull((Object)userOperationLogEntry);
        UserOperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobTest.assertEquals((String)job.getId(), (String)userOperationLogEntry.getJobId());
        UserOperationLogJobTest.assertEquals((String)"SetJobRetries", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobTest.assertEquals((String)"retries", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobTest.assertEquals((String)"4", (String)userOperationLogEntry.getNewValue());
        UserOperationLogJobTest.assertEquals((String)"3", (String)userOperationLogEntry.getOrgValue());
        UserOperationLogJobTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobTest.assertEquals((String)job.getJobDefinitionId(), (String)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessInstanceId(), (String)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessDefinitionId(), (String)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessDefinitionKey(), (String)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobTest.assertEquals((String)this.deploymentId, (String)userOperationLogEntry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testSetRetriesByJobDefinitionId() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetriesByJobDefinitionId(job.getJobDefinitionId(), 4);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("SetJobRetries").singleResult();
        UserOperationLogJobTest.assertNotNull((Object)userOperationLogEntry);
        UserOperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getJobId());
        UserOperationLogJobTest.assertEquals((String)"SetJobRetries", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobTest.assertEquals((String)"retries", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobTest.assertEquals((String)"4", (String)userOperationLogEntry.getNewValue());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getOrgValue());
        UserOperationLogJobTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobTest.assertEquals((String)job.getJobDefinitionId(), (String)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessDefinitionId(), (String)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessDefinitionKey(), (String)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobTest.assertEquals((String)this.deploymentId, (String)userOperationLogEntry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testSetRetriesAsync() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Batch batch = this.managementService.setJobRetriesAsync(Arrays.asList(job.getId()), 4);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("SetJobRetries");
        UserOperationLogJobTest.assertEquals((long)3L, (long)query.count());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)query.property("retries").singleResult();
        UserOperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getJobId());
        UserOperationLogJobTest.assertEquals((String)"SetJobRetries", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobTest.assertEquals((String)"retries", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobTest.assertEquals((String)"4", (String)userOperationLogEntry.getNewValue());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getOrgValue());
        UserOperationLogJobTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobTest.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobTest.assertNull((String)this.deploymentId, (Object)userOperationLogEntry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
        userOperationLogEntry = (UserOperationLogEntry)query.property("nrOfInstances").singleResult();
        UserOperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getJobId());
        UserOperationLogJobTest.assertEquals((String)"SetJobRetries", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobTest.assertEquals((String)"nrOfInstances", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobTest.assertEquals((String)"1", (String)userOperationLogEntry.getNewValue());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getOrgValue());
        UserOperationLogJobTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobTest.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobTest.assertNull((String)this.deploymentId, (Object)userOperationLogEntry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
        userOperationLogEntry = (UserOperationLogEntry)query.property("async").singleResult();
        UserOperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getJobId());
        UserOperationLogJobTest.assertEquals((String)"SetJobRetries", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobTest.assertEquals((String)"async", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobTest.assertEquals((String)"true", (String)userOperationLogEntry.getNewValue());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getOrgValue());
        UserOperationLogJobTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobTest.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobTest.assertNull((String)this.deploymentId, (Object)userOperationLogEntry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testSetRetriesAsyncProcessInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Batch batch = this.managementService.setJobRetriesAsync(Arrays.asList(processInstance.getId()), (ProcessInstanceQuery)null, 4);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("SetJobRetries");
        UserOperationLogJobTest.assertEquals((long)3L, (long)query.count());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)query.property("retries").singleResult();
        UserOperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getJobId());
        UserOperationLogJobTest.assertEquals((String)"SetJobRetries", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobTest.assertEquals((String)"retries", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobTest.assertEquals((String)"4", (String)userOperationLogEntry.getNewValue());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getOrgValue());
        UserOperationLogJobTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobTest.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobTest.assertNull((String)this.deploymentId, (Object)userOperationLogEntry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
        userOperationLogEntry = (UserOperationLogEntry)query.property("nrOfInstances").singleResult();
        UserOperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getJobId());
        UserOperationLogJobTest.assertEquals((String)"SetJobRetries", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobTest.assertEquals((String)"nrOfInstances", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobTest.assertEquals((String)"1", (String)userOperationLogEntry.getNewValue());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getOrgValue());
        UserOperationLogJobTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobTest.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobTest.assertNull((String)this.deploymentId, (Object)userOperationLogEntry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
        userOperationLogEntry = (UserOperationLogEntry)query.property("async").singleResult();
        UserOperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getJobId());
        UserOperationLogJobTest.assertEquals((String)"SetJobRetries", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobTest.assertEquals((String)"async", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobTest.assertEquals((String)"true", (String)userOperationLogEntry.getNewValue());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getOrgValue());
        UserOperationLogJobTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobTest.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobTest.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobTest.assertNull((String)this.deploymentId, (Object)userOperationLogEntry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testSetJobDueDate() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Date newDate = new Date(ClockUtil.getCurrentTime().getTime() + 2000L);
        this.managementService.setJobDuedate(job.getId(), newDate);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("SetDueDate");
        UserOperationLogJobTest.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.singleResult();
        UserOperationLogJobTest.assertEquals((String)job.getId(), (String)entry.getJobId());
        UserOperationLogJobTest.assertEquals((String)job.getDeploymentId(), (String)entry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)job.getJobDefinitionId(), (String)entry.getJobDefinitionId());
        UserOperationLogJobTest.assertEquals((String)"duedate", (String)entry.getProperty());
        UserOperationLogJobTest.assertNull((Object)entry.getOrgValue());
        UserOperationLogJobTest.assertEquals((Object)newDate, (Object)new Date(Long.valueOf(entry.getNewValue())));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/TimerRecalculationTest.testFinishedJob.bpmn20.xml"})
    public void testRecalculateJobDueDate() {
        HashMap<String, Date> variables1 = new HashMap<String, Date>();
        Date duedate = ClockUtil.getCurrentTime();
        variables1.put("dueDate", duedate);
        this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables1);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.recalculateJobDuedate(job.getId(), false);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("RecalculateDueDate");
        UserOperationLogJobTest.assertEquals((long)2L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("duedate").singleResult();
        UserOperationLogJobTest.assertEquals((String)job.getId(), (String)entry.getJobId());
        UserOperationLogJobTest.assertEquals((String)job.getDeploymentId(), (String)entry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)job.getJobDefinitionId(), (String)entry.getJobDefinitionId());
        UserOperationLogJobTest.assertEquals((String)"duedate", (String)entry.getProperty());
        UserOperationLogJobTest.assertTrue((boolean)DateUtils.truncatedEquals((Date)duedate, (Date)new Date(Long.valueOf(entry.getOrgValue())), (int)13));
        UserOperationLogJobTest.assertTrue((boolean)DateUtils.truncatedEquals((Date)duedate, (Date)new Date(Long.valueOf(entry.getNewValue())), (int)13));
        entry = (UserOperationLogEntry)query.property("creationDateBased").singleResult();
        UserOperationLogJobTest.assertEquals((String)job.getId(), (String)entry.getJobId());
        UserOperationLogJobTest.assertEquals((String)job.getDeploymentId(), (String)entry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)job.getJobDefinitionId(), (String)entry.getJobDefinitionId());
        UserOperationLogJobTest.assertEquals((String)"creationDateBased", (String)entry.getProperty());
        UserOperationLogJobTest.assertNull((Object)entry.getOrgValue());
        UserOperationLogJobTest.assertFalse((boolean)Boolean.valueOf(entry.getNewValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testDelete() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.deleteJob(job.getId());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("Delete").singleResult();
        UserOperationLogJobTest.assertNotNull((Object)userOperationLogEntry);
        UserOperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobTest.assertEquals((String)job.getId(), (String)userOperationLogEntry.getJobId());
        UserOperationLogJobTest.assertEquals((String)"Delete", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getProperty());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getNewValue());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getOrgValue());
        UserOperationLogJobTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobTest.assertEquals((String)job.getJobDefinitionId(), (String)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessInstanceId(), (String)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessDefinitionId(), (String)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessDefinitionKey(), (String)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobTest.assertEquals((String)this.deploymentId, (String)userOperationLogEntry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testExecute() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("Execute").singleResult();
        UserOperationLogJobTest.assertNotNull((Object)userOperationLogEntry);
        UserOperationLogJobTest.assertEquals((String)"Job", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobTest.assertEquals((String)job.getId(), (String)userOperationLogEntry.getJobId());
        UserOperationLogJobTest.assertEquals((String)"Execute", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getProperty());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getNewValue());
        UserOperationLogJobTest.assertNull((Object)userOperationLogEntry.getOrgValue());
        UserOperationLogJobTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobTest.assertEquals((String)job.getJobDefinitionId(), (String)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessInstanceId(), (String)userOperationLogEntry.getProcessInstanceId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessDefinitionId(), (String)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobTest.assertEquals((String)job.getProcessDefinitionKey(), (String)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobTest.assertEquals((String)this.deploymentId, (String)userOperationLogEntry.getDeploymentId());
        UserOperationLogJobTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testExecuteByJobExecutor() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        UserOperationLogJobTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.waitForJobExecutorToProcessAllJobs(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS));
        UserOperationLogJobTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        long logEntriesCount = this.historyService.createUserOperationLogQuery().operationType("Execute").count();
        UserOperationLogJobTest.assertEquals((long)0L, (long)logEntriesCount);
    }
}

