/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.standalone.history.RecordHistoryLevel;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class DecisionInstanceHistoryTest
extends ResourceProcessEngineTestCase {
    public static final String DECISION_SINGLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";

    public DecisionInstanceHistoryTest() {
        super("org/camunda/bpm/engine/test/standalone/history/decisionInstanceHistory.camunda.cfg.xml");
    }

    protected void setUp() throws Exception {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
        super.tearDown();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testDecisionDefinitionPassedToHistoryLevel() {
        RecordHistoryLevel historyLevel = (RecordHistoryLevel)this.processEngineConfiguration.getHistoryLevel();
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("testDecision").singleResult();
        VariableMap variables = Variables.createVariables().putValue("input1", (Object)true);
        this.decisionService.evaluateDecisionTableByKey("testDecision", (Map)variables);
        List<RecordHistoryLevel.ProducedHistoryEvent> producedHistoryEvents = historyLevel.getProducedHistoryEvents();
        DecisionInstanceHistoryTest.assertEquals((int)1, (int)producedHistoryEvents.size());
        RecordHistoryLevel.ProducedHistoryEvent producedHistoryEvent = producedHistoryEvents.get(0);
        DecisionInstanceHistoryTest.assertEquals((Object)HistoryEventTypes.DMN_DECISION_EVALUATE, (Object)producedHistoryEvent.eventType);
        DecisionDefinition entity = (DecisionDefinition)producedHistoryEvent.entity;
        DecisionInstanceHistoryTest.assertNotNull((Object)entity);
        DecisionInstanceHistoryTest.assertEquals((String)decisionDefinition.getId(), (String)entity.getId());
    }
}

