/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.form.handler.StartFormHandler;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;

public class ProcessDefinitionEntity
extends ProcessDefinitionImpl
implements ProcessDefinition,
ResourceDefinitionEntity<ProcessDefinitionEntity>,
DbEntity,
HasDbRevision {
    private static final long serialVersionUID = 1L;
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected String key;
    protected int revision = 1;
    protected int version;
    protected String category;
    protected String deploymentId;
    protected String resourceName;
    protected Integer historyLevel;
    protected StartFormHandler startFormHandler;
    protected String diagramResourceName;
    protected boolean isGraphicalNotationDefined;
    protected Map<String, TaskDefinition> taskDefinitions;
    protected boolean hasStartFormKey;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String tenantId;
    protected String versionTag;
    protected Integer historyTimeToLive;
    protected boolean isIdentityLinksInitialized = false;
    protected List<IdentityLinkEntity> definitionIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
    protected Set<Expression> candidateStarterUserIdExpressions = new HashSet<Expression>();
    protected Set<Expression> candidateStarterGroupIdExpressions = new HashSet<Expression>();
    protected boolean isStartableInTasklist;
    protected boolean firstVersion = false;
    protected String previousProcessDefinitionId;

    public ProcessDefinitionEntity() {
        super(null);
    }

    protected void ensureNotSuspended() {
        if (this.isSuspended()) {
            throw LOG.suspendedEntityException("Process Definition", this.id);
        }
    }

    @Override
    public ExecutionEntity createProcessInstance() {
        return (ExecutionEntity)super.createProcessInstance();
    }

    @Override
    public ExecutionEntity createProcessInstance(String businessKey) {
        return (ExecutionEntity)super.createProcessInstance(businessKey);
    }

    @Override
    public ExecutionEntity createProcessInstance(String businessKey, String caseInstanceId) {
        return (ExecutionEntity)super.createProcessInstance(businessKey, caseInstanceId);
    }

    @Override
    public ExecutionEntity createProcessInstance(String businessKey, ActivityImpl initial) {
        return (ExecutionEntity)super.createProcessInstance(businessKey, initial);
    }

    @Override
    protected PvmExecutionImpl newProcessInstance() {
        ExecutionEntity newExecution = ExecutionEntity.createNewExecution();
        if (this.tenantId != null) {
            newExecution.setTenantId(this.tenantId);
        }
        return newExecution;
    }

    @Override
    public ExecutionEntity createProcessInstance(String businessKey, String caseInstanceId, ActivityImpl initial) {
        this.ensureNotSuspended();
        ExecutionEntity processInstance = (ExecutionEntity)this.createProcessInstanceForInitial(initial);
        processInstance.setProcessDefinition(this.processDefinition);
        processInstance.setProcessInstance(processInstance);
        if (businessKey != null) {
            processInstance.setBusinessKey(businessKey);
        }
        if (caseInstanceId != null) {
            processInstance.setCaseInstanceId(caseInstanceId);
        }
        if (this.tenantId != null) {
            processInstance.setTenantId(this.tenantId);
        }
        return processInstance;
    }

    public IdentityLinkEntity addIdentityLink(String userId, String groupId) {
        IdentityLinkEntity identityLinkEntity = IdentityLinkEntity.newIdentityLink();
        this.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setProcessDef(this);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType("candidate");
        identityLinkEntity.setTenantId(this.getTenantId());
        identityLinkEntity.insert();
        return identityLinkEntity;
    }

    public void deleteIdentityLink(String userId, String groupId) {
        List<IdentityLinkEntity> identityLinks = Context.getCommandContext().getIdentityLinkManager().findIdentityLinkByProcessDefinitionUserAndGroup(this.id, userId, groupId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            identityLink.delete();
        }
    }

    public List<IdentityLinkEntity> getIdentityLinks() {
        if (!this.isIdentityLinksInitialized) {
            this.definitionIdentityLinkEntities = Context.getCommandContext().getIdentityLinkManager().findIdentityLinksByProcessDefinitionId(this.id);
            this.isIdentityLinksInitialized = true;
        }
        return this.definitionIdentityLinkEntities;
    }

    @Override
    public String toString() {
        return "ProcessDefinitionEntity[" + this.id + "]";
    }

    @Override
    public void updateModifiableFieldsFromEntity(ProcessDefinitionEntity updatingProcessDefinition) {
        if (this.key.equals(updatingProcessDefinition.key) && this.deploymentId.equals(updatingProcessDefinition.deploymentId)) {
            this.revision = updatingProcessDefinition.revision;
            this.suspensionState = updatingProcessDefinition.suspensionState;
            this.historyTimeToLive = updatingProcessDefinition.historyTimeToLive;
        } else {
            LOG.logUpdateUnrelatedProcessDefinitionEntity(this.key, updatingProcessDefinition.key, this.deploymentId, updatingProcessDefinition.deploymentId);
        }
    }

    @Override
    public ProcessDefinitionEntity getPreviousDefinition() {
        ProcessDefinitionEntity previousProcessDefinition = null;
        String previousProcessDefinitionId = this.getPreviousProcessDefinitionId();
        if (previousProcessDefinitionId != null && (previousProcessDefinition = this.loadProcessDefinition(previousProcessDefinitionId)) == null) {
            this.resetPreviousProcessDefinitionId();
            previousProcessDefinitionId = this.getPreviousProcessDefinitionId();
            if (previousProcessDefinitionId != null) {
                previousProcessDefinition = this.loadProcessDefinition(previousProcessDefinitionId);
            }
        }
        return previousProcessDefinition;
    }

    protected ProcessDefinitionEntity loadProcessDefinition(String processDefinitionId) {
        CommandContext commandContext;
        ProcessDefinitionManager processDefinitionManager;
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = configuration.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findProcessDefinitionFromCache(processDefinitionId);
        if (processDefinition == null && (processDefinition = (processDefinitionManager = (commandContext = Context.getCommandContext()).getProcessDefinitionManager()).findLatestProcessDefinitionById(processDefinitionId)) != null) {
            processDefinition = deploymentCache.resolveProcessDefinition(processDefinition);
        }
        return processDefinition;
    }

    public String getPreviousProcessDefinitionId() {
        this.ensurePreviousProcessDefinitionIdInitialized();
        return this.previousProcessDefinitionId;
    }

    protected void resetPreviousProcessDefinitionId() {
        this.previousProcessDefinitionId = null;
        this.ensurePreviousProcessDefinitionIdInitialized();
    }

    protected void setPreviousProcessDefinitionId(String previousProcessDefinitionId) {
        this.previousProcessDefinitionId = previousProcessDefinitionId;
    }

    protected void ensurePreviousProcessDefinitionIdInitialized() {
        if (this.previousProcessDefinitionId == null && !this.firstVersion) {
            this.previousProcessDefinitionId = Context.getCommandContext().getProcessDefinitionManager().findPreviousProcessDefinitionId(this.key, this.version, this.tenantId);
            if (this.previousProcessDefinitionId == null) {
                this.firstVersion = true;
            }
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Integer> persistentState = new HashMap<String, Integer>();
        persistentState.put("suspensionState", this.suspensionState);
        persistentState.put("historyTimeToLive", this.historyTimeToLive);
        return persistentState;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getDescription() {
        return (String)this.getProperty("documentation");
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    @Override
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
        this.firstVersion = this.version == 1;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(Integer historyLevel) {
        this.historyLevel = historyLevel;
    }

    public StartFormHandler getStartFormHandler() {
        return this.startFormHandler;
    }

    public void setStartFormHandler(StartFormHandler startFormHandler) {
        this.startFormHandler = startFormHandler;
    }

    public Map<String, TaskDefinition> getTaskDefinitions() {
        return this.taskDefinitions;
    }

    public void setTaskDefinitions(Map<String, TaskDefinition> taskDefinitions) {
        this.taskDefinitions = taskDefinitions;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getDiagramResourceName() {
        return this.diagramResourceName;
    }

    @Override
    public void setDiagramResourceName(String diagramResourceName) {
        this.diagramResourceName = diagramResourceName;
    }

    @Override
    public boolean hasStartFormKey() {
        return this.hasStartFormKey;
    }

    public boolean getHasStartFormKey() {
        return this.hasStartFormKey;
    }

    public void setStartFormKey(boolean hasStartFormKey) {
        this.hasStartFormKey = hasStartFormKey;
    }

    public void setHasStartFormKey(boolean hasStartFormKey) {
        this.hasStartFormKey = hasStartFormKey;
    }

    public boolean isGraphicalNotationDefined() {
        return this.isGraphicalNotationDefined;
    }

    public void setGraphicalNotationDefined(boolean isGraphicalNotationDefined) {
        this.isGraphicalNotationDefined = isGraphicalNotationDefined;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    public Set<Expression> getCandidateStarterUserIdExpressions() {
        return this.candidateStarterUserIdExpressions;
    }

    public void addCandidateStarterUserIdExpression(Expression userId) {
        this.candidateStarterUserIdExpressions.add(userId);
    }

    public Set<Expression> getCandidateStarterGroupIdExpressions() {
        return this.candidateStarterGroupIdExpressions;
    }

    public void addCandidateStarterGroupIdExpression(Expression groupId) {
        this.candidateStarterGroupIdExpressions.add(groupId);
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getVersionTag() {
        return this.versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    @Override
    public Integer getHistoryTimeToLive() {
        return this.historyTimeToLive;
    }

    @Override
    public void setHistoryTimeToLive(Integer historyTimeToLive) {
        this.historyTimeToLive = historyTimeToLive;
    }

    @Override
    public boolean isStartableInTasklist() {
        return this.isStartableInTasklist;
    }

    public void setStartableInTasklist(boolean isStartableInTasklist) {
        this.isStartableInTasklist = isStartableInTasklist;
    }
}

