/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.engine.impl.batch.builder;

import org.junit.Test;

import static org.assertj.core.api.Assertions.assertThat;

public class BatchCalculateTotalJobsTest {

  protected BatchBuilder batchBuilder = new BatchBuilder(null);
  
  @Test
  public void shouldReturnCorrectSizeUneven() {
    testConfiguration(2, 5, 3);
  }

  @Test
  public void shouldReturnCorrectSizeZeroBatchSize() {
    testConfiguration(0, 2, 0);
  }

  @Test
  public void shouldReturnCorrectSizeEven() {
    testConfiguration(2, 4, 2);
  }

  @Test
  public void shouldReturnCorrectSizeZeroInstances() {
    testConfiguration(2, 0, 0);
  }

  @Test
  public void shouldReturnCorrectSizeZeroInstancesZeroBatchSize() {
    testConfiguration(0, 0, 0);
  }
  
  private void testConfiguration(int invocationPerBatchJob,
                                 int instanceCount,
                                 int expectedResult) {
    assertThat(batchBuilder.calculateTotalJobs(instanceCount, invocationPerBatchJob))
        .isEqualTo(expectedResult);
  }
}
