/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg;

import java.util.Arrays;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.CompositeProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEnginePlugin;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class CompositeProcessEnginePluginTest {
    private static final ProcessEnginePlugin PLUGIN_A = CompositeProcessEnginePluginTest.processEnginePlugin("PluginA");
    private static final ProcessEnginePlugin PLUGIN_B = CompositeProcessEnginePluginTest.processEnginePlugin("PluginB");
    private static final InOrder ORDER = Mockito.inOrder((Object[])new Object[]{PLUGIN_A, PLUGIN_B});
    private static final ProcessEngineConfigurationImpl CONFIGURATION = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
    private static final ProcessEngine ENGINE = (ProcessEngine)Mockito.mock(ProcessEngine.class);
    private InOrder inOrder;

    @Test
    public void addPlugin() throws Exception {
        CompositeProcessEnginePlugin composite = new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[0]);
        Assert.assertThat((Object)composite.getPlugins().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(composite.getPlugins().get(0), (Matcher)Is.is((Object)PLUGIN_A));
        composite.addProcessEnginePlugin(PLUGIN_B, new ProcessEnginePlugin[0]);
        Assert.assertThat((Object)composite.getPlugins().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(composite.getPlugins().get(1), (Matcher)Is.is((Object)PLUGIN_B));
    }

    @Test
    public void addPlugins() throws Exception {
        CompositeProcessEnginePlugin composite = new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[0]);
        composite.addProcessEnginePlugins(Arrays.asList(PLUGIN_B));
        Assert.assertThat((Object)composite.getPlugins().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(composite.getPlugins().get(0), (Matcher)Is.is((Object)PLUGIN_A));
        Assert.assertThat(composite.getPlugins().get(1), (Matcher)Is.is((Object)PLUGIN_B));
    }

    @Test
    public void allPluginsOnPreInit() throws Exception {
        new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[]{PLUGIN_B}).preInit(CONFIGURATION);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_A)).preInit(CONFIGURATION);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_B)).preInit(CONFIGURATION);
    }

    @Test
    public void allPluginsOnPostInit() throws Exception {
        new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[]{PLUGIN_B}).postInit(CONFIGURATION);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_A)).postInit(CONFIGURATION);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_B)).postInit(CONFIGURATION);
    }

    @Test
    public void allPluginsOnPostProcessEngineBuild() throws Exception {
        new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[]{PLUGIN_B}).postProcessEngineBuild(ENGINE);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_A)).postProcessEngineBuild(ENGINE);
        ((ProcessEnginePlugin)ORDER.verify((Object)PLUGIN_B)).postProcessEngineBuild(ENGINE);
    }

    @Test
    public void verifyToString() throws Exception {
        Assert.assertThat((Object)new CompositeProcessEnginePlugin(PLUGIN_A, new ProcessEnginePlugin[]{PLUGIN_B}).toString(), (Matcher)Is.is((Object)"CompositeProcessEnginePlugin[PluginA, PluginB]"));
    }

    private static ProcessEnginePlugin processEnginePlugin(String name) {
        ProcessEnginePlugin plugin = (ProcessEnginePlugin)Mockito.mock(ProcessEnginePlugin.class);
        Mockito.when((Object)plugin.toString()).thenReturn((Object)name);
        return plugin;
    }
}

