/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class IdentityServiceWithJdbcSimpleProcessingTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setJdbcBatchProcessing(false);
            return configuration;
        }
    };
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private IdentityService identityService;

    @Before
    public void init() {
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
    }

    @Test
    public void testUserOptimisticLockingException() {
        User user = this.identityService.newUser("kermit");
        this.identityService.saveUser(user);
        User user1 = (User)this.identityService.createUserQuery().singleResult();
        User user2 = (User)this.identityService.createUserQuery().singleResult();
        user1.setFirstName("name one");
        this.identityService.saveUser(user1);
        this.thrown.expect(OptimisticLockingException.class);
        user2.setFirstName("name two");
        this.identityService.saveUser(user2);
    }

    @Test
    public void testGroupOptimisticLockingException() {
        Group group = this.identityService.newGroup("group");
        this.identityService.saveGroup(group);
        Group group1 = (Group)this.identityService.createGroupQuery().singleResult();
        Group group2 = (Group)this.identityService.createGroupQuery().singleResult();
        group1.setName("name one");
        this.identityService.saveGroup(group1);
        this.thrown.expect(OptimisticLockingException.class);
        group2.setName("name two");
        this.identityService.saveGroup(group2);
    }
}

