/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.suspensionstate;

import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.multitenancy.StaticTenantIdTestProvider;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyProcessDefinitionSuspensionStateTenantIdProviderTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final BpmnModelInstance PROCESS = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"testProcess").startEvent().userTask().camundaAsyncBefore()).endEvent().done();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            StaticTenantIdTestProvider tenantIdProvider = new StaticTenantIdTestProvider(MultiTenancyProcessDefinitionSuspensionStateTenantIdProviderTest.TENANT_ONE);
            configuration.setTenantIdProvider((TenantIdProvider)tenantIdProvider);
            return configuration;
        }
    };
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.testRule.deploy(PROCESS);
    }

    @Test
    public void suspendProcessDefinitionByIdIncludeInstancesFromAllTenants() {
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().withoutTenantId().singleResult();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionId(processDefinition.getId());
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).includeProcessInstances(true).suspend();
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void activateProcessDefinitionByIdIncludeInstancesFromAllTenants() {
        this.engineRule.getRuntimeService().createProcessInstanceByKey(PROCESS_DEFINITION_KEY).processDefinitionWithoutTenantId().execute();
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionKey(PROCESS_DEFINITION_KEY).includeProcessInstances(true).suspend();
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().withoutTenantId().singleResult();
        ProcessInstanceQuery query = this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionId(processDefinition.getId());
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.suspended().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)0L));
        this.engineRule.getRepositoryService().updateProcessDefinitionSuspensionState().byProcessDefinitionId(processDefinition.getId()).includeProcessInstances(true).activate();
        Assert.assertThat((Object)query.suspended().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.active().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.active().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }
}

