/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.List;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DecisionRequirementsDefinitionQueryTest {
    protected static final String DRD_SCORE_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdScore.dmn11.xml";
    protected static final String DRD_DISH_RESOURCE = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected static final String DRD_XYZ_RESOURCE = "org/camunda/bpm/engine/test/api/repository/drdXyz_.dmn11.xml";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected String decisionRequirementsDefinitionId;
    protected String firstDeploymentId;
    protected String secondDeploymentId;
    protected String thirdDeploymentId;

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.firstDeploymentId = this.testRule.deploy(DRD_DISH_RESOURCE, DRD_SCORE_RESOURCE).getId();
        this.secondDeploymentId = this.testRule.deploy(DRD_DISH_RESOURCE).getId();
        this.thirdDeploymentId = this.testRule.deploy(DRD_XYZ_RESOURCE).getId();
        this.decisionRequirementsDefinitionId = ((DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionKey("score").singleResult()).getId();
    }

    @Test
    public void queryByDecisionRequirementsDefinitionId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionId("notExisting").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionId(this.decisionRequirementsDefinitionId).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)query.singleResult()).getKey(), (Matcher)CoreMatchers.is((Object)"score"));
    }

    @Test
    public void queryByDecisionRequirementsDefinitionIds() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionIdIn(new String[]{"not", "existing"}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionIdIn(new String[]{this.decisionRequirementsDefinitionId, "notExisting"}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)query.singleResult()).getKey(), (Matcher)CoreMatchers.is((Object)"score"));
    }

    @Test
    public void queryByDecisionRequirementsDefinitionKey() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionKey("notExisting").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionKey("score").count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)query.singleResult()).getKey(), (Matcher)CoreMatchers.is((Object)"score"));
    }

    @Test
    public void queryByDecisionRequirementsDefinitionKeyLike() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionKeyLike("%notExisting%").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionKeyLike("%sco%").count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionKeyLike("%dis%").count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionKeyLike("%s%").count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void queryByDecisionRequirementsDefinitionName() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionName("notExisting").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionName("Score").count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)query.singleResult()).getKey(), (Matcher)CoreMatchers.is((Object)"score"));
    }

    @Test
    public void queryByDecisionRequirementsDefinitionNameLike() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionNameLike("%notExisting%").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionNameLike("%Sco%").count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionNameLike("%ish%").count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void queryByDecisionRequirementsDefinitionCategory() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionCategory("notExisting").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionCategory("test-drd-1").count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)query.singleResult()).getKey(), (Matcher)CoreMatchers.is((Object)"score"));
    }

    @Test
    public void queryByDecisionRequirementsDefinitionCategoryLike() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionCategoryLike("%notExisting%").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionCategoryLike("%test%").count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionCategoryLike("%z\\_").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void queryByResourceName() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionResourceName("notExisting").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionResourceName(DRD_SCORE_RESOURCE).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)query.singleResult()).getKey(), (Matcher)CoreMatchers.is((Object)"score"));
    }

    @Test
    public void queryByResourceNameLike() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionResourceNameLike("%notExisting%").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionResourceNameLike("%.dmn11.xml%").count(), (Matcher)CoreMatchers.is((Object)4L));
    }

    @Test
    public void queryByResourceNameLikeEscape() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionResourceNameLike("%z\\_.%").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void queryByVersion() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.decisionRequirementsDefinitionVersion(Integer.valueOf(1)).count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionVersion(Integer.valueOf(2)).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionVersion(Integer.valueOf(3)).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void queryByLatest() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.latestVersion().count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.decisionRequirementsDefinitionKey("score").latestVersion().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void queryByDeploymentId() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        Assert.assertThat((Object)query.deploymentId("notExisting").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.deploymentId(this.firstDeploymentId).count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.deploymentId(this.secondDeploymentId).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void orderByDecisionRequirementsDefinitionId() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionId().asc()).list();
        Assert.assertThat((Object)decisionRequirementsDefinitions.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getId(), (Matcher)CoreMatchers.startsWith((String)"dish:1"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getId(), (Matcher)CoreMatchers.startsWith((String)"dish:2"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getId(), (Matcher)CoreMatchers.startsWith((String)"score:1"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getId(), (Matcher)CoreMatchers.startsWith((String)"xyz:1"));
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionId().desc()).list();
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getId(), (Matcher)CoreMatchers.startsWith((String)"xyz:1"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getId(), (Matcher)CoreMatchers.startsWith((String)"score:1"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getId(), (Matcher)CoreMatchers.startsWith((String)"dish:2"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getId(), (Matcher)CoreMatchers.startsWith((String)"dish:1"));
    }

    @Test
    public void orderByDecisionRequirementsDefinitionKey() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionKey().asc()).list();
        Assert.assertThat((Object)decisionRequirementsDefinitions.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getKey(), (Matcher)CoreMatchers.is((Object)"dish"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getKey(), (Matcher)CoreMatchers.is((Object)"dish"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getKey(), (Matcher)CoreMatchers.is((Object)"score"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getKey(), (Matcher)CoreMatchers.is((Object)"xyz"));
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionKey().desc()).list();
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getKey(), (Matcher)CoreMatchers.is((Object)"xyz"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getKey(), (Matcher)CoreMatchers.is((Object)"score"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getKey(), (Matcher)CoreMatchers.is((Object)"dish"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getKey(), (Matcher)CoreMatchers.is((Object)"dish"));
    }

    @Test
    public void orderByDecisionRequirementsDefinitionName() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionName().asc()).list();
        Assert.assertThat((Object)decisionRequirementsDefinitions.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getName(), (Matcher)CoreMatchers.is((Object)"Dish"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getName(), (Matcher)CoreMatchers.is((Object)"Dish"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getName(), (Matcher)CoreMatchers.is((Object)"Score"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getName(), (Matcher)CoreMatchers.is((Object)"Xyz"));
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionName().desc()).list();
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getName(), (Matcher)CoreMatchers.is((Object)"Xyz"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getName(), (Matcher)CoreMatchers.is((Object)"Score"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getName(), (Matcher)CoreMatchers.is((Object)"Dish"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getName(), (Matcher)CoreMatchers.is((Object)"Dish"));
    }

    @Test
    public void orderByDecisionRequirementsDefinitionCategory() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionCategory().asc()).list();
        Assert.assertThat((Object)decisionRequirementsDefinitions.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getCategory(), (Matcher)CoreMatchers.is((Object)"test-drd-1"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getCategory(), (Matcher)CoreMatchers.is((Object)"test-drd-2"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getCategory(), (Matcher)CoreMatchers.is((Object)"test-drd-2"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getCategory(), (Matcher)CoreMatchers.is((Object)"xyz_"));
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionCategory().desc()).list();
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getCategory(), (Matcher)CoreMatchers.is((Object)"xyz_"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getCategory(), (Matcher)CoreMatchers.is((Object)"test-drd-2"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getCategory(), (Matcher)CoreMatchers.is((Object)"test-drd-2"));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getCategory(), (Matcher)CoreMatchers.is((Object)"test-drd-1"));
    }

    @Test
    public void orderByDecisionRequirementsDefinitionVersion() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionVersion().asc()).list();
        Assert.assertThat((Object)decisionRequirementsDefinitions.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionVersion().desc()).list();
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void orderByDeploymentId() {
        List decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDeploymentId().asc()).list();
        Assert.assertThat((Object)decisionRequirementsDefinitions.size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getDeploymentId(), (Matcher)CoreMatchers.is((Object)this.firstDeploymentId));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getDeploymentId(), (Matcher)CoreMatchers.is((Object)this.firstDeploymentId));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getDeploymentId(), (Matcher)CoreMatchers.is((Object)this.secondDeploymentId));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getDeploymentId(), (Matcher)CoreMatchers.is((Object)this.thirdDeploymentId));
        decisionRequirementsDefinitions = ((DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDeploymentId().desc()).list();
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(0)).getDeploymentId(), (Matcher)CoreMatchers.is((Object)this.thirdDeploymentId));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(1)).getDeploymentId(), (Matcher)CoreMatchers.is((Object)this.secondDeploymentId));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(2)).getDeploymentId(), (Matcher)CoreMatchers.is((Object)this.firstDeploymentId));
        Assert.assertThat((Object)((DecisionRequirementsDefinition)decisionRequirementsDefinitions.get(3)).getDeploymentId(), (Matcher)CoreMatchers.is((Object)this.firstDeploymentId));
    }
}

