/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.AsyncProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationVariablesTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setJavaSerializationFormatEnabled(true);
            return configuration;
        }
    };
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule(bootstrapRule);
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    protected static final BpmnModelInstance ONE_BOUNDARY_TASK = ((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.ONE_TASK_PROCESS).activityBuilder("userTask").boundaryEvent().message("Message")).done();
    protected static final BpmnModelInstance CONCURRENT_BOUNDARY_TASKS = ((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_PROCESS).activityBuilder("userTask1").boundaryEvent().message("Message")).moveToActivity("userTask2").boundaryEvent().message("Message")).done();
    protected static final BpmnModelInstance SUBPROCESS_CONCURRENT_BOUNDARY_TASKS = ((BoundaryEventBuilder)((BoundaryEventBuilder)ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS).activityBuilder("userTask1").boundaryEvent().message("Message")).moveToActivity("userTask2").boundaryEvent().message("Message")).done();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected TaskService taskService;

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.taskService = this.rule.getTaskService();
    }

    @Test
    public void testVariableAtScopeExecutionInScopeActivity() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_BOUNDARY_TASK);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_BOUNDARY_TASK);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree scopeExecution = executionTreeBeforeMigration.getExecutions().get(0);
        this.runtimeService.setVariableLocal(scopeExecution.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, beforeMigration.getExecutionId());
    }

    @Test
    public void testVariableAtConcurrentExecutionInScopeActivity() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CONCURRENT_BOUNDARY_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CONCURRENT_BOUNDARY_TASKS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree concurrentExecution = executionTreeBeforeMigration.getExecutions().get(0);
        this.runtimeService.setVariableLocal(concurrentExecution.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, beforeMigration.getExecutionId());
    }

    @Test
    public void testVariableAtScopeExecutionInNonScopeActivity() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId(), (Map)Variables.createVariables().putValue("foo", (Object)42));
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, beforeMigration.getExecutionId());
    }

    @Test
    public void testVariableAtConcurrentExecutionInNonScopeActivity() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree concurrentExecution = executionTreeBeforeMigration.getExecutions().get(0);
        this.runtimeService.setVariableLocal(concurrentExecution.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, beforeMigration.getExecutionId());
    }

    @Test
    public void testVariableAtConcurrentExecutionInScopeActivityAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CONCURRENT_BOUNDARY_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(SUBPROCESS_CONCURRENT_BOUNDARY_TASKS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree userTask1CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0).getParent();
        this.runtimeService.setVariableLocal(userTask1CCExecutionBefore.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        ExecutionTree userTask1CCExecutionAfter = this.testHelper.snapshotAfterMigration.getExecutionTree().getLeafExecutions("userTask1").get(0).getParent();
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        ActivityInstance subProcessInstance = this.testHelper.getSingleActivityInstanceAfterMigration("subProcess");
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, userTask1CCExecutionAfter.getId(), subProcessInstance.getId());
    }

    @Test
    public void testVariableAtConcurrentExecutionInScopeActivityRemoveParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(SUBPROCESS_CONCURRENT_BOUNDARY_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(CONCURRENT_BOUNDARY_TASKS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree userTask1CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0).getParent();
        this.runtimeService.setVariableLocal(userTask1CCExecutionBefore.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        ExecutionTree userTask1CCExecutionAfter = this.testHelper.snapshotAfterMigration.getExecutionTree().getLeafExecutions("userTask1").get(0).getParent();
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, userTask1CCExecutionAfter.getId(), processInstance.getId());
    }

    @Test
    public void testVariableAtConcurrentExecutionInNonScopeActivityAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree userTask1CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0);
        this.runtimeService.setVariableLocal(userTask1CCExecutionBefore.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        ExecutionTree userTask1CCExecutionAfter = this.testHelper.snapshotAfterMigration.getExecutionTree().getLeafExecutions("userTask1").get(0);
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, userTask1CCExecutionAfter.getId());
    }

    @Test
    public void testVariableAtConcurrentExecutionInNonScopeActivityRemoveParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree userTask1CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0);
        this.runtimeService.setVariableLocal(userTask1CCExecutionBefore.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        ExecutionTree userTask1CCExecutionAfter = this.testHelper.snapshotAfterMigration.getExecutionTree().getLeafExecutions("userTask1").get(0);
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, userTask1CCExecutionAfter.getId());
    }

    @Test
    public void testVariableAtScopeExecutionInScopeActivityAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_BOUNDARY_TASK);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(SUBPROCESS_CONCURRENT_BOUNDARY_TASKS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask1").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree scopeExecution = executionTreeBeforeMigration.getExecutions().get(0);
        this.runtimeService.setVariableLocal(scopeExecution.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, beforeMigration.getExecutionId());
    }

    @Test
    public void testVariableAtTask() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariableLocal(task.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, beforeMigration.getExecutionId());
    }

    @Test
    public void testVariableAtTaskAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.setVariableLocal(task.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        ExecutionTree userTask1ExecutionAfter = this.testHelper.snapshotAfterMigration.getExecutionTree().getLeafExecutions("userTask1").get(0);
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, userTask1ExecutionAfter.getId());
    }

    @Test
    public void testVariableAtTaskAndConcurrentExecutionAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask1").singleResult();
        this.taskService.setVariableLocal(task.getId(), "foo", (Object)42);
        this.runtimeService.setVariableLocal(task.getExecutionId(), "foo", (Object)52);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance taskVarBeforeMigration = this.testHelper.snapshotBeforeMigration.getSingleTaskVariable(task.getId(), "foo");
        ExecutionTree userTask1ExecutionAfter = this.testHelper.snapshotAfterMigration.getExecutionTree().getLeafExecutions("userTask1").get(0);
        Assert.assertEquals((long)2L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(taskVarBeforeMigration, userTask1ExecutionAfter.getId());
    }

    @Test
    public void testVariableAtScopeExecutionBecomeNonScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_BOUNDARY_TASK);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree scopeExecution = executionTreeBeforeMigration.getExecutions().get(0);
        this.runtimeService.setVariableLocal(scopeExecution.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("userTask")).execute();
        VariableInstance variableAfterExpansion = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)variableAfterExpansion);
        Assert.assertNotSame((Object)processInstance.getId(), (Object)variableAfterExpansion.getExecutionId());
    }

    @Test
    public void testVariableAtConcurrentExecutionBecomeScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_SCOPE_TASKS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree concurrentExecution = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0);
        this.runtimeService.setVariableLocal(concurrentExecution.getId(), "foo", (Object)42);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        VariableInstance beforeMigration = this.testHelper.snapshotBeforeMigration.getSingleVariable("foo");
        ExecutionTree userTask1CCExecution = this.testHelper.snapshotAfterMigration.getExecutionTree().getLeafExecutions("userTask1").get(0).getParent();
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        this.testHelper.assertVariableMigratedToExecution(beforeMigration, userTask1CCExecution.getId());
    }

    @Test
    public void testVariableAtConcurrentAndScopeExecutionBecomeNonScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(CONCURRENT_BOUNDARY_TASKS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree scopeExecution = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0);
        ExecutionTree concurrentExecution = scopeExecution.getParent();
        this.runtimeService.setVariableLocal(scopeExecution.getId(), "foo", (Object)42);
        this.runtimeService.setVariableLocal(concurrentExecution.getId(), "foo", (Object)42);
        try {
            this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"The variable 'foo' exists in both, this scope and concurrent local in the parent scope. Migrating to a non-scope activity would overwrite one of them."));
        }
    }

    @Test
    public void testVariableAtParentScopeExecutionAndScopeExecutionBecomeNonScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ONE_BOUNDARY_TASK);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree scopeExecution = executionTreeBeforeMigration.getLeafExecutions("userTask").get(0);
        this.runtimeService.setVariableLocal(scopeExecution.getId(), "foo", (Object)"userTaskScopeValue");
        this.runtimeService.setVariableLocal(processInstance.getId(), "foo", (Object)"processScopeValue");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)1L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        VariableInstance variable = this.testHelper.snapshotAfterMigration.getVariables().iterator().next();
        Assert.assertEquals((Object)"userTaskScopeValue", (Object)variable.getValue());
    }

    @Test
    public void testVariableAtConcurrentExecutionAddParentScopeBecomeNonConcurrent() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_TASK_AND_SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaInputParameter("foo", "subProcessValue").done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree task1CcExecution = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0);
        ExecutionTree task2CcExecution = executionTreeBeforeMigration.getLeafExecutions("userTask2").get(0);
        this.runtimeService.setVariableLocal(task1CcExecution.getId(), "foo", (Object)"task1Value");
        this.runtimeService.setVariableLocal(task2CcExecution.getId(), "foo", (Object)"task2Value");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)2L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        ArrayList<String> values = new ArrayList<String>();
        for (VariableInstance variable : this.testHelper.snapshotAfterMigration.getVariables()) {
            values.add((String)variable.getValue());
        }
        Assert.assertTrue((boolean)values.contains("task1Value"));
        Assert.assertTrue((boolean)values.contains("task2Value"));
    }

    @Test
    public void testAddScopeWithInputMappingAndVariableOnConcurrentExecutions() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS).activityBuilder("subProcess").camundaInputParameter("foo", "inputOutputValue").done());
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree userTask1CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0);
        ExecutionTree userTask2CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask2").get(0);
        this.runtimeService.setVariableLocal(userTask1CCExecutionBefore.getId(), "foo", (Object)"customValue");
        this.runtimeService.setVariableLocal(userTask2CCExecutionBefore.getId(), "foo", (Object)"customValue");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Collection<VariableInstance> variables = this.testHelper.snapshotAfterMigration.getVariables();
        Assert.assertEquals((long)2L, (long)variables.size());
        for (VariableInstance variable : variables) {
            Assert.assertEquals((Object)"customValue", (Object)variable.getValue());
        }
        ExecutionTree subProcessExecution = this.testHelper.snapshotAfterMigration.getExecutionTree().getLeafExecutions("userTask2").get(0).getParent();
        Assert.assertNotNull((Object)this.testHelper.snapshotAfterMigration.getSingleVariable(subProcessExecution.getId(), "foo"));
    }

    @Test
    public void testVariableAtScopeAndConcurrentExecutionAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree userTask1CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0);
        ExecutionTree userTask2CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask2").get(0);
        this.runtimeService.setVariableLocal(processInstance.getId(), "foo", (Object)"processInstanceValue");
        this.runtimeService.setVariableLocal(userTask1CCExecutionBefore.getId(), "foo", (Object)"task1Value");
        this.runtimeService.setVariableLocal(userTask2CCExecutionBefore.getId(), "foo", (Object)"task2Value");
        VariableInstance processScopeVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableValueEquals("foo", (Object)"processInstanceValue").singleResult();
        VariableInstance task1Variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableValueEquals("foo", (Object)"task1Value").singleResult();
        VariableInstance task2Variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableValueEquals("foo", (Object)"task2Value").singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Assert.assertEquals((long)3L, (long)this.testHelper.snapshotAfterMigration.getVariables().size());
        VariableInstance processScopeVariableAfterMigration = this.testHelper.snapshotAfterMigration.getVariable(processScopeVariable.getId());
        Assert.assertNotNull((Object)processScopeVariableAfterMigration);
        Assert.assertEquals((Object)"processInstanceValue", (Object)processScopeVariableAfterMigration.getValue());
        VariableInstance task1VariableAfterMigration = this.testHelper.snapshotAfterMigration.getVariable(task1Variable.getId());
        Assert.assertNotNull((Object)task1VariableAfterMigration);
        Assert.assertEquals((Object)"task1Value", (Object)task1VariableAfterMigration.getValue());
        VariableInstance task2VariableAfterMigration = this.testHelper.snapshotAfterMigration.getVariable(task2Variable.getId());
        Assert.assertNotNull((Object)task2VariableAfterMigration);
        Assert.assertEquals((Object)"task2Value", (Object)task2VariableAfterMigration.getValue());
    }

    @Test
    public void testVariableAtScopeAndConcurrentExecutionRemoveParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.PARALLEL_GATEWAY_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask1", "userTask1").mapActivities("userTask2", "userTask2").build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        ExecutionTree executionTreeBeforeMigration = ExecutionTree.forExecution(processInstance.getId(), this.rule.getProcessEngine());
        ExecutionTree userTask1CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask1").get(0);
        ExecutionTree userTask2CCExecutionBefore = executionTreeBeforeMigration.getLeafExecutions("userTask2").get(0);
        ExecutionTree subProcessExecution = userTask1CCExecutionBefore.getParent();
        this.runtimeService.setVariableLocal(subProcessExecution.getId(), "foo", (Object)"subProcessValue");
        this.runtimeService.setVariableLocal(userTask1CCExecutionBefore.getId(), "foo", (Object)"task1Value");
        this.runtimeService.setVariableLocal(userTask2CCExecutionBefore.getId(), "foo", (Object)"task2Value");
        VariableInstance task1Variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableValueEquals("foo", (Object)"task1Value").singleResult();
        VariableInstance task2Variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableValueEquals("foo", (Object)"task2Value").singleResult();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Collection<VariableInstance> variables = this.testHelper.snapshotAfterMigration.getVariables();
        Assert.assertEquals((long)2L, (long)variables.size());
        VariableInstance task1VariableAfterMigration = this.testHelper.snapshotAfterMigration.getVariable(task1Variable.getId());
        Assert.assertNotNull((Object)task1VariableAfterMigration);
        Assert.assertEquals((Object)"task1Value", (Object)task1VariableAfterMigration.getValue());
        VariableInstance task2VariableAfterMigration = this.testHelper.snapshotAfterMigration.getVariable(task2Variable.getId());
        Assert.assertNotNull((Object)task2VariableAfterMigration);
        Assert.assertEquals((Object)"task2Value", (Object)task2VariableAfterMigration.getValue());
    }

    @Test
    public void testVariableAtConcurrentExecutionInTransition() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("userTask")).startBeforeActivity("userTask")).execute();
        Execution concurrentExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("userTask").list().get(0);
        Job jobForExecution = (Job)this.rule.getManagementService().createJobQuery().executionId(concurrentExecution.getId()).singleResult();
        this.runtimeService.setVariableLocal(concurrentExecution.getId(), "var", (Object)"value");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Job jobAfterMigration = (Job)this.rule.getManagementService().createJobQuery().jobId(jobForExecution.getId()).singleResult();
        this.testHelper.assertVariableMigratedToExecution(this.testHelper.snapshotBeforeMigration.getSingleVariable("var"), jobAfterMigration.getExecutionId());
    }

    @Test
    public void testVariableAtConcurrentExecutionInTransitionAddParentScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(AsyncProcessModels.ASYNC_BEFORE_SUBPROCESS_USER_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.rule.getRuntimeService().createProcessInstanceById(sourceProcessDefinition.getId()).startBeforeActivity("userTask")).startBeforeActivity("userTask")).execute();
        Execution concurrentExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("userTask").list().get(0);
        Job jobForExecution = (Job)this.rule.getManagementService().createJobQuery().executionId(concurrentExecution.getId()).singleResult();
        this.runtimeService.setVariableLocal(concurrentExecution.getId(), "var", (Object)"value");
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        Job jobAfterMigration = (Job)this.rule.getManagementService().createJobQuery().jobId(jobForExecution.getId()).singleResult();
        this.testHelper.assertVariableMigratedToExecution(this.testHelper.snapshotBeforeMigration.getSingleVariable("var"), jobAfterMigration.getExecutionId());
    }

    @Test
    public void testCanMigrateWithObjectVariableThatFailsOnDeserialization() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(sourceProcessDefinition.getId());
        ObjectValue objectValue = (ObjectValue)Variables.serializedObjectValue((String)"does/not/deserialize").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName("and.this.is.a.nonexisting.Class").create();
        this.runtimeService.setVariable(processInstance.getId(), "var", (Object)objectValue);
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        ObjectValue migratedValue = (ObjectValue)this.runtimeService.getVariableTyped(processInstance.getId(), "var", false);
        Assert.assertEquals((Object)objectValue.getValueSerialized(), (Object)migratedValue.getValueSerialized());
        Assert.assertEquals((Object)objectValue.getObjectTypeName(), (Object)migratedValue.getObjectTypeName());
    }
}

