/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.SetProcessDefinitionVersionCmd;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.Variables;

public class SetProcessDefinitionVersionCmdTest
extends PluggableProcessEngineTestCase {
    private static final String TEST_PROCESS_WITH_PARALLEL_GATEWAY = "org/camunda/bpm/engine/test/bpmn/gateway/ParallelGatewayTest.testForkJoin.bpmn20.xml";
    private static final String TEST_PROCESS = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersion.bpmn20.xml";
    private static final String TEST_PROCESS_ACTIVITY_MISSING = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionActivityMissing.bpmn20.xml";
    private static final String TEST_PROCESS_CALL_ACTIVITY = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.withCallActivity.bpmn20.xml";
    private static final String TEST_PROCESS_USER_TASK_V1 = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithTask.bpmn20.xml";
    private static final String TEST_PROCESS_USER_TASK_V2 = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithTaskV2.bpmn20.xml";
    private static final String TEST_PROCESS_SERVICE_TASK_V1 = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithServiceTask.bpmn20.xml";
    private static final String TEST_PROCESS_SERVICE_TASK_V2 = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithServiceTaskV2.bpmn20.xml";
    private static final String TEST_PROCESS_WITH_MULTIPLE_PARENTS = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithMultipleParents.bpmn";
    private static final String TEST_PROCESS_ONE_JOB = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.oneJobProcess.bpmn20.xml";
    private static final String TEST_PROCESS_TWO_JOBS = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.twoJobsProcess.bpmn20.xml";
    private static final String TEST_PROCESS_ATTACHED_TIMER = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testAttachedTimer.bpmn20.xml";

    public void testSetProcessDefinitionVersionEmptyArguments() {
        try {
            new SetProcessDefinitionVersionCmd(null, Integer.valueOf(23));
            SetProcessDefinitionVersionCmdTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process instance id is mandatory: processInstanceId is null", ae.getMessage());
        }
        try {
            new SetProcessDefinitionVersionCmd("", Integer.valueOf(23));
            SetProcessDefinitionVersionCmdTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process instance id is mandatory: processInstanceId is empty", ae.getMessage());
        }
        try {
            new SetProcessDefinitionVersionCmd("42", null);
            SetProcessDefinitionVersionCmdTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition version is mandatory: processDefinitionVersion is null", ae.getMessage());
        }
        try {
            new SetProcessDefinitionVersionCmd("42", Integer.valueOf(-1));
            SetProcessDefinitionVersionCmdTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The process definition version must be positive: processDefinitionVersion is not greater than 0", ae.getMessage());
        }
    }

    public void testSetProcessDefinitionVersionNonExistingPI() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        try {
            commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd("42", Integer.valueOf(23)));
            SetProcessDefinitionVersionCmdTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("No process instance found for id = '42'.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/ParallelGatewayTest.testForkJoin.bpmn20.xml"})
    public void testSetProcessDefinitionVersionPIIsSubExecution() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("forkJoin");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("receivePayment").singleResult();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        SetProcessDefinitionVersionCmd command = new SetProcessDefinitionVersionCmd(execution.getId(), Integer.valueOf(1));
        try {
            commandExecutor.execute((Command)command);
            SetProcessDefinitionVersionCmdTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("A process instance id is required, but the provided id '" + execution.getId() + "' points to a child execution of process instance '" + pi.getId() + "'. Please invoke the " + command.getClass().getSimpleName() + " with a root execution id.", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersion.bpmn20.xml"})
    public void testSetProcessDefinitionVersionNonExistingPD() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("receiveTask");
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        try {
            commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(23)));
            SetProcessDefinitionVersionCmdTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no processes deployed with key = 'receiveTask', version = '23'", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersion.bpmn20.xml"})
    public void testSetProcessDefinitionVersionActivityMissing() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("receiveTask");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("waitState1").singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)execution);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_ACTIVITY_MISSING).deploy();
        SetProcessDefinitionVersionCmdTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        SetProcessDefinitionVersionCmd setProcessDefinitionVersionCmd = new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2));
        try {
            commandExecutor.execute((Command)setProcessDefinitionVersionCmd);
            SetProcessDefinitionVersionCmdTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("The new process definition (key = 'receiveTask') does not contain the current activity (id = 'waitState1') of the process instance (id = '", ae.getMessage());
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment
    public void testSetProcessDefinitionVersion() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("receiveTask");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).activityId("waitState1").singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)execution);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS).deploy();
        SetProcessDefinitionVersionCmdTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
        this.runtimeService.signal(execution.getId());
        ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2)).singleResult();
        pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertEquals((String)newProcessDefinition.getId(), (String)pi.getProcessDefinitionId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(pi.getId()).singleResult();
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/gateway/ParallelGatewayTest.testForkJoin.bpmn20.xml"})
    public void testSetProcessDefinitionVersionSubExecutions() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("forkJoin");
        SetProcessDefinitionVersionCmdTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_WITH_PARALLEL_GATEWAY).deploy();
        SetProcessDefinitionVersionCmdTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
        ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2)).singleResult();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).list();
        for (Execution execution : executions) {
            SetProcessDefinitionVersionCmdTest.assertEquals((String)newProcessDefinition.getId(), (String)((ExecutionEntity)execution).getProcessDefinitionId());
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.withCallActivity.bpmn20.xml"})
    public void testSetProcessDefinitionVersionWithCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("parentProcess");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("waitState1").processDefinitionKey("childProcess").singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)execution);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_CALL_ACTIVITY).deploy();
        SetProcessDefinitionVersionCmdTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("parentProcess").count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
        this.runtimeService.signal(execution.getId());
        SetProcessDefinitionVersionCmdTest.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceId(pi.getId()).count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithTask.bpmn20.xml"})
    public void testSetProcessDefinitionVersionWithWithTask() {
        try {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("userTask");
            SetProcessDefinitionVersionCmdTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().processInstanceId(pi.getId()).count());
            org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_USER_TASK_V2).deploy();
            SetProcessDefinitionVersionCmdTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("userTask").count());
            ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("userTask").processDefinitionVersion(Integer.valueOf(2)).singleResult();
            this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
            Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
            SetProcessDefinitionVersionCmdTest.assertEquals((String)newProcessDefinition.getId(), (String)task.getProcessDefinitionId());
            SetProcessDefinitionVersionCmdTest.assertEquals((String)"testFormKey", (String)this.formService.getTaskFormData(task.getId()).getFormKey());
            this.taskService.complete(task.getId());
            this.assertProcessEnded(pi.getId());
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithServiceTask.bpmn20.xml"})
    public void testSetProcessDefinitionVersionWithFollowUpTask() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_SERVICE_TASK_V2).deploy().getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        Job migrationJob = (Job)this.managementService.createJobQuery().singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)migrationJob);
        this.managementService.executeJob(migrationJob.getId());
        Task followUpTask = (Task)this.taskService.createTaskQuery().singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((String)"Should have migrated to the new version and immediately executed the correct follow-up activity", (Object)followUpTask);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testSetProcessDefinitionVersionWithMultipleParents.bpmn"})
    public void testSetProcessDefinitionVersionWithMultipleParents() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("multipleJoins");
        SetProcessDefinitionVersionCmdTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task1").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task4").singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)task);
        Job job = (Job)this.managementService.createJobQuery().executionId(task.getExecutionId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)job);
        SetProcessDefinitionVersionCmdTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_WITH_MULTIPLE_PARENTS).deploy();
        SetProcessDefinitionVersionCmdTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(pi.getId(), Integer.valueOf(2)));
        ProcessDefinition newProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionVersion(Integer.valueOf(2)).singleResult();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).list();
        for (Execution execution : executions) {
            SetProcessDefinitionVersionCmdTest.assertEquals((String)newProcessDefinition.getId(), (String)((ExecutionEntity)execution).getProcessDefinitionId());
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.oneJobProcess.bpmn20.xml"})
    public void testSetProcessDefinitionVersionMigrateJob() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneJobProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)job);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_ONE_JOB).deploy();
        ProcessDefinition newDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)newDefinition);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(instance.getId(), Integer.valueOf(2)));
        Job migratedJob = (Job)this.managementService.createJobQuery().singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)migratedJob);
        SetProcessDefinitionVersionCmdTest.assertEquals((String)job.getId(), (String)migratedJob.getId());
        SetProcessDefinitionVersionCmdTest.assertEquals((String)newDefinition.getId(), (String)migratedJob.getProcessDefinitionId());
        SetProcessDefinitionVersionCmdTest.assertEquals((String)deployment.getId(), (String)migratedJob.getDeploymentId());
        JobDefinition newJobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().processDefinitionId(newDefinition.getId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)newJobDefinition);
        SetProcessDefinitionVersionCmdTest.assertEquals((String)newJobDefinition.getId(), (String)migratedJob.getJobDefinitionId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.twoJobsProcess.bpmn20.xml"})
    public void testMigrateJobWithMultipleDefinitionsOnActivity() {
        ProcessInstance asyncAfterInstance = this.runtimeService.startProcessInstanceByKey("twoJobsProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        Job asyncAfterJob = (Job)this.managementService.createJobQuery().singleResult();
        ProcessInstance asyncBeforeInstance = this.runtimeService.startProcessInstanceByKey("twoJobsProcess");
        Job asyncBeforeJob = (Job)this.managementService.createJobQuery().processInstanceId(asyncBeforeInstance.getId()).singleResult();
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_TWO_JOBS).deploy();
        ProcessDefinition newDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)newDefinition);
        JobDefinition asnycBeforeJobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobConfiguration("async-before").processDefinitionId(newDefinition.getId()).singleResult();
        JobDefinition asnycAfterJobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().jobConfiguration("async-after").processDefinitionId(newDefinition.getId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)asnycBeforeJobDefinition);
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)asnycAfterJobDefinition);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(asyncBeforeInstance.getId(), Integer.valueOf(2)));
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(asyncAfterInstance.getId(), Integer.valueOf(2)));
        Job migratedAsyncBeforeJob = (Job)this.managementService.createJobQuery().processInstanceId(asyncBeforeInstance.getId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertEquals((String)asyncBeforeJob.getId(), (String)migratedAsyncBeforeJob.getId());
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)migratedAsyncBeforeJob);
        SetProcessDefinitionVersionCmdTest.assertEquals((String)asnycBeforeJobDefinition.getId(), (String)migratedAsyncBeforeJob.getJobDefinitionId());
        Job migratedAsyncAfterJob = (Job)this.managementService.createJobQuery().processInstanceId(asyncAfterInstance.getId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertEquals((String)asyncAfterJob.getId(), (String)migratedAsyncAfterJob.getId());
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)migratedAsyncAfterJob);
        SetProcessDefinitionVersionCmdTest.assertEquals((String)asnycAfterJobDefinition.getId(), (String)migratedAsyncAfterJob.getJobDefinitionId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.oneJobProcess.bpmn20.xml"})
    public void testSetProcessDefinitionVersionMigrateIncident() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneJobProcess", (Map)Variables.createVariables().putValue("shouldFail", (Object)true));
        this.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)incident);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_ONE_JOB).deploy();
        ProcessDefinition newDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)newDefinition);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(instance.getId(), Integer.valueOf(2)));
        Incident migratedIncident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)migratedIncident);
        SetProcessDefinitionVersionCmdTest.assertEquals((String)newDefinition.getId(), (String)migratedIncident.getProcessDefinitionId());
        SetProcessDefinitionVersionCmdTest.assertEquals((String)instance.getId(), (String)migratedIncident.getProcessInstanceId());
        SetProcessDefinitionVersionCmdTest.assertEquals((String)instance.getId(), (String)migratedIncident.getExecutionId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.oneJobProcess.bpmn20.xml"})
    public void testPreserveTimestampOnUpdatedIncident() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("oneJobProcess", (Map)Variables.createVariables().putValue("shouldFail", (Object)true));
        this.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)incident);
        Date timestamp = incident.getIncidentTimestamp();
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_ONE_JOB).deploy();
        ProcessDefinition newDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)newDefinition);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(instance.getId(), Integer.valueOf(2)));
        Incident migratedIncident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        SetProcessDefinitionVersionCmdTest.assertEquals((Object)timestamp, (Object)migratedIncident.getIncidentTimestamp());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.testAttachedTimer.bpmn20.xml"})
    public void testSetProcessDefinitionVersionAttachedTimer() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("attachedTimer");
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource(TEST_PROCESS_ATTACHED_TIMER).deploy();
        ProcessDefinition newDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)newDefinition);
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(instance.getId(), Integer.valueOf(2)));
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        SetProcessDefinitionVersionCmdTest.assertNotNull((Object)job);
        SetProcessDefinitionVersionCmdTest.assertEquals((String)newDefinition.getId(), (String)job.getProcessDefinitionId());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    public void testHistoryOfSetProcessDefinitionVersionCmd() {
        String resource = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.bpmn";
        org.camunda.bpm.engine.repository.Deployment firstDeployment = this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        org.camunda.bpm.engine.repository.Deployment secondDeployment = this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
        ProcessDefinition processDefinitionV1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(firstDeployment.getId()).singleResult();
        ProcessDefinition processDefinitionV2 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(secondDeployment.getId()).singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionV1.getId());
        this.setProcessDefinitionVersion(processInstance.getId(), 2);
        ProcessInstance processInstanceAfterMigration = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        SetProcessDefinitionVersionCmdTest.assertEquals((String)processDefinitionV2.getId(), (String)processInstanceAfterMigration.getProcessDefinitionId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
            SetProcessDefinitionVersionCmdTest.assertEquals((String)processDefinitionV2.getId(), (String)historicProcessInstance.getProcessDefinitionId());
        }
        this.repositoryService.deleteDeployment(firstDeployment.getId(), true);
        this.repositoryService.deleteDeployment(secondDeployment.getId(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOpLogSetProcessDefinitionVersionCmd() {
        try {
            this.identityService.setAuthenticatedUserId("demo");
            String resource = "org/camunda/bpm/engine/test/api/runtime/migration/SetProcessDefinitionVersionCmdTest.bpmn";
            org.camunda.bpm.engine.repository.Deployment firstDeployment = this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
            org.camunda.bpm.engine.repository.Deployment secondDeployment = this.repositoryService.createDeployment().addClasspathResource(resource).deploy();
            ProcessDefinition processDefinitionV1 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(firstDeployment.getId()).singleResult();
            ProcessDefinition processDefinitionV2 = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(secondDeployment.getId()).singleResult();
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionV1.getId());
            this.setProcessDefinitionVersion(processInstance.getId(), 2);
            ProcessInstance processInstanceAfterMigration = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
            SetProcessDefinitionVersionCmdTest.assertEquals((String)processDefinitionV2.getId(), (String)processInstanceAfterMigration.getProcessDefinitionId());
            if (this.processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
                List userOperations = this.historyService.createUserOperationLogQuery().processInstanceId(processInstance.getId()).operationType("ModifyProcessInstance").list();
                SetProcessDefinitionVersionCmdTest.assertEquals((int)1, (int)userOperations.size());
                UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)userOperations.get(0);
                SetProcessDefinitionVersionCmdTest.assertEquals((String)"processDefinitionVersion", (String)userOperationLogEntry.getProperty());
                SetProcessDefinitionVersionCmdTest.assertEquals((String)"1", (String)userOperationLogEntry.getOrgValue());
                SetProcessDefinitionVersionCmdTest.assertEquals((String)"2", (String)userOperationLogEntry.getNewValue());
            }
            this.repositoryService.deleteDeployment(firstDeployment.getId(), true);
            this.repositoryService.deleteDeployment(secondDeployment.getId(), true);
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }

    protected void setProcessDefinitionVersion(String processInstanceId, int newProcessDefinitionVersion) {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequiresNew();
        commandExecutor.execute((Command)new SetProcessDefinitionVersionCmd(processInstanceId, Integer.valueOf(newProcessDefinitionVersion)));
    }
}

