/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.event.error.ThrowBpmnErrorDelegate;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;

public class AsyncAfterTest
extends PluggableProcessEngineTestCase {
    public void testTransitionIdRequired() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/async/AsyncAfterTest.testTransitionIdRequired.bpmn20.xml").deploy();
            AsyncAfterTest.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            this.assertTextPresent("Sequence flow with sourceRef='service' must have an id, activity with id 'service' uses 'asyncAfter'.", e.getMessage());
            Assertions.assertThat((List)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getElementIds()).containsExactly((Object[])new String[]{"service"});
        }
    }

    @Deployment
    public void testAsyncAfterServiceTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterMultiInstanceUserTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("process");
        List list = this.taskService.createTaskQuery().list();
        Assert.assertThat((Object)list, (Matcher)IsCollectionWithSize.hasSize((int)3));
        for (Task task : list) {
            this.taskService.complete(task.getId());
        }
        this.waitForJobExecutorToProcessAllJobs(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS));
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeServiceTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotBehaviorInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterServiceTaskMultipleTransitions() {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("flowToTake", "flow2");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", varMap);
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        this.managementService.executeJob(continuationJob.getId());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow2").singleResult());
        AsyncAfterTest.assertNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow3").singleResult());
        this.runtimeService.signal(pi.getId());
        varMap = new HashMap();
        varMap.put("flowToTake", "flow3");
        pi = this.runtimeService.startProcessInstanceByKey("testProcess", varMap);
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        this.managementService.executeJob(continuationJob.getId());
        AsyncAfterTest.assertNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow2").singleResult());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow3").singleResult());
    }

    @Deployment
    public void testAsyncAfterServiceTaskMultipleTransitionsConcurrent() {
        HashMap varMap = new HashMap();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", varMap);
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        List jobs = this.managementService.createJobQuery().list();
        AsyncAfterTest.assertEquals((int)2, (int)jobs.size());
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        this.managementService.executeJob(((Job)jobs.get(1)).getId());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow2").singleResult());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow3").singleResult());
    }

    @Deployment
    public void testAsyncAfterWithoutTransition() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(pi.getId(), "process-listenerEndInvoked"));
        this.managementService.executeJob(continuationJob.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterInNestedWithoutTransition() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(pi.getId(), "subprocess-listenerEndInvoked"));
        this.managementService.executeJob(continuationJob.getId());
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi.getId(), "subprocess-listenerEndInvoked")));
    }

    @Deployment
    public void testAsyncAfterManualTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testManualTask");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeManualTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testManualTask");
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterIntermediateCatchEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testIntermediateCatchEvent");
        this.runtimeService.correlateMessage("testMessage1");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeIntermediateCatchEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testIntermediateCatchEvent");
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.executeAvailableJobs();
        this.runtimeService.correlateMessage("testMessage1");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterIntermediateThrowEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testIntermediateThrowEvent");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeIntermediateThrowEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testIntermediateThrowEvent");
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterInclusiveGateway() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testInclusiveGateway");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        AsyncAfterTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().active().count());
        this.executeAvailableJobs();
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        AsyncAfterTest.assertEquals((long)2L, (long)taskQuery.active().count());
        List tasks = taskQuery.active().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getProcessInstanceId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeInclusiveGateway() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testInclusiveGateway");
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        List jobs = this.managementService.createJobQuery().active().list();
        AsyncAfterTest.assertEquals((int)2, (int)jobs.size());
    }

    @Deployment
    public void testAsyncAfterExclusiveGateway() {
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("flow", false);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExclusiveGateway", variables);
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        AsyncAfterTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().active().count());
        this.executeAvailableJobs();
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        AsyncAfterTest.assertEquals((long)1L, (long)taskQuery.active().count());
        List tasks = taskQuery.active().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getProcessInstanceId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeExclusiveGateway() {
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("flow", false);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExclusiveGateway", variables);
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        AsyncAfterTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().active().count());
    }

    @Deployment
    public void testAsyncAfterWithExecutionListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.assertNotListenerTakeInvoked((Execution)processInstance);
        this.managementService.executeJob(job.getId());
        job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNull((Object)job);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)task);
        this.assertListenerTakeInvoked((Execution)processInstance);
    }

    @Deployment
    public void testAsyncAfterOnParallelGatewayFork() {
        String configuration = PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE.getCanonicalName();
        String config1 = configuration + "$afterForkFlow1";
        String config2 = configuration + "$afterForkFlow2";
        this.runtimeService.startProcessInstanceByKey("process");
        List jobs = this.managementService.createJobQuery().list();
        AsyncAfterTest.assertEquals((int)2, (int)jobs.size());
        Job jobToExecute = this.fetchFirstJobByHandlerConfiguration(jobs, config1);
        AsyncAfterTest.assertNotNull((Object)jobToExecute);
        this.managementService.executeJob(jobToExecute.getId());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("theTask1").singleResult();
        AsyncAfterTest.assertNotNull((Object)task1);
        jobs = this.managementService.createJobQuery().list();
        AsyncAfterTest.assertEquals((int)1, (int)jobs.size());
        jobToExecute = this.fetchFirstJobByHandlerConfiguration(jobs, config2);
        this.managementService.executeJob(jobToExecute.getId());
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("theTask2").singleResult();
        AsyncAfterTest.assertNotNull((Object)task2);
        AsyncAfterTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    public void testAsyncAfterParallelMultiInstanceWithServiceTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked(pi, 5);
        this.assertListenerEndInvoked((Execution)pi);
        this.executeAvailableJobs(1);
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterServiceWrappedInParallelMultiInstance() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked(pi, 5);
        this.assertListenerEndInvoked((Execution)pi);
        AsyncAfterTest.assertEquals((long)5L, (long)this.managementService.createJobQuery().count());
        this.executeAvailableJobs(5);
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterServiceWrappedInSequentialMultiInstance() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked(pi, 1);
        this.assertListenerEndInvoked((Execution)pi);
        AsyncAfterTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.executeAvailableJobs(5);
        this.assertBehaviorInvoked(pi, 5);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void FAILING_testAsyncAfterOnParallelGatewayJoin() {
        String configuration = PvmAtomicOperation.ACTIVITY_END.getCanonicalName();
        this.runtimeService.startProcessInstanceByKey("process");
        List jobs = this.managementService.createJobQuery().list();
        AsyncAfterTest.assertEquals((int)3, (int)jobs.size());
        Job jobToExecute = this.fetchFirstJobByHandlerConfiguration(jobs, configuration);
        AsyncAfterTest.assertNotNull((Object)jobToExecute);
        this.managementService.executeJob(jobToExecute.getId());
        jobs = this.managementService.createJobQuery().list();
        AsyncAfterTest.assertEquals((int)2, (int)jobs.size());
        jobToExecute = this.fetchFirstJobByHandlerConfiguration(jobs, configuration);
        this.managementService.executeJob(jobToExecute.getId());
        jobToExecute = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)jobToExecute);
        this.managementService.executeJob(jobToExecute.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)task);
    }

    @Deployment
    public void testAsyncAfterBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("Process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)task);
        this.runtimeService.correlateMessage("foo");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncAfterTest.assertNull((Object)task);
    }

    @Deployment
    public void testAsyncBeforeBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("Process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)task);
        this.runtimeService.correlateMessage("foo");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncAfterTest.assertNull((Object)task);
    }

    public void testAsyncAfterErrorEvent() {
        BpmnModelInstance instance = ((ServiceTaskBuilder)((BoundaryEventBuilder)((BoundaryEventBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("servTask").camundaClass(ThrowBpmnErrorDelegate.class)).boundaryEvent().camundaAsyncAfter(true)).camundaFailedJobRetryTimeCycle("R10/PT10S")).errorEventDefinition().errorEventDefinitionDone().serviceTask().camundaClass("foo")).endEvent().moveToActivity("servTask").endEvent().done();
        this.deployment(new BpmnModelInstance[]{instance});
        this.runtimeService.startProcessInstanceByKey("process");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        try {
            this.managementService.executeJob(job.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)9L, (long)job.getRetries());
    }

    protected Job fetchFirstJobByHandlerConfiguration(List<Job> jobs, String configuration) {
        for (Job job : jobs) {
            JobEntity jobEntity = (JobEntity)job;
            String jobConfig = jobEntity.getJobHandlerConfigurationRaw();
            if (!configuration.equals(jobConfig)) continue;
            return job;
        }
        return null;
    }

    protected void assertListenerStartInvoked(Execution e) {
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(e.getId(), "listenerStartInvoked")));
    }

    protected void assertListenerTakeInvoked(Execution e) {
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(e.getId(), "listenerTakeInvoked")));
    }

    protected void assertListenerEndInvoked(Execution e) {
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(e.getId(), "listenerEndInvoked")));
    }

    protected void assertBehaviorInvoked(Execution e) {
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(e.getId(), "behaviorInvoked")));
    }

    private void assertBehaviorInvoked(ProcessInstance pi, int times) {
        Long behaviorInvoked = (Long)this.runtimeService.getVariable(pi.getId(), "behaviorInvoked");
        AsyncAfterTest.assertNotNull((String)"behavior was not invoked", (Object)behaviorInvoked);
        AsyncAfterTest.assertEquals((int)times, (int)behaviorInvoked.intValue());
    }

    protected void assertNotListenerStartInvoked(Execution e) {
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(e.getId(), "listenerStartInvoked"));
    }

    protected void assertNotListenerTakeInvoked(Execution e) {
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(e.getId(), "listenerTakeInvoked"));
    }

    protected void assertNotListenerEndInvoked(Execution e) {
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(e.getId(), "listenerEndInvoked"));
    }

    protected void assertNotBehaviorInvoked(Execution e) {
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(e.getId(), "behaviorInvoked"));
    }
}

