/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.dmn.feel;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class FeelIntegrationTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.thrown);
    protected DecisionService decisionService;

    @Before
    public void setup() {
        this.decisionService = this.engineRule.getProcessEngine().getDecisionService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/feel/literal-expression.dmn"})
    public void shouldEvaluateLiteralExpression() {
        String result = (String)this.decisionService.evaluateDecisionByKey("c").evaluate().getSingleEntry();
        Assertions.assertThat((String)result).isEqualTo((Object)"foo");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/feel/input-expression.dmn"})
    public void shouldEvaluateInputExpression() {
        String result = (String)this.decisionService.evaluateDecisionByKey("c").evaluate().getSingleEntry();
        Assertions.assertThat((String)result).isEqualTo((Object)"foo");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/feel/input-rule.dmn"})
    public void shouldEvaluateInputRule() {
        String result = (String)this.decisionService.evaluateDecisionTableByKey("c", (Map)Variables.putValue((String)"cellInput", (Object)6)).getSingleEntry();
        Assertions.assertThat((String)result).isEqualTo((Object)"foo");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/feel/output-rule.dmn"})
    public void shouldEvaluateOutputRule() {
        String result = (String)this.decisionService.evaluateDecisionByKey("c").evaluate().getSingleEntry();
        Assertions.assertThat((String)result).isEqualTo((Object)"foo");
    }
}

