/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.dmn;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.history.DecisionServiceDelegate;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceDecisionServiceEvaluationTest {
    protected static final String DECISION_PROCESS_WITH_DECISION_SERVICE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideDelegation.bpmn20.xml";
    protected static final String DECISION_PROCESS_WITH_START_LISTENER = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideStartListener.bpmn20.xml";
    protected static final String DECISION_PROCESS_WITH_END_LISTENER = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideEndListener.bpmn20.xml";
    protected static final String DECISION_PROCESS_WITH_TAKE_LISTENER = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideTakeListener.bpmn20.xml";
    protected static final String DECISION_PROCESS_INSIDE_EXPRESSION = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideExpression.bpmn20.xml";
    protected static final String DECISION_PROCESS_INSIDE_DELEGATE_EXPRESSION = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testDecisionEvaluatedWithDecisionServiceInsideDelegateExpression.bpmn20.xml";
    protected static final String DECISION_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    protected static final String DECISION_DEFINITION_KEY = "testDecision";
    @Parameterized.Parameter(value=0)
    public String process;
    @Parameterized.Parameter(value=1)
    public String activityId;
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected HistoryService historyService;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({DECISION_PROCESS_WITH_DECISION_SERVICE, "task"}, {DECISION_PROCESS_WITH_START_LISTENER, "task"}, {DECISION_PROCESS_WITH_END_LISTENER, "task"}, {DECISION_PROCESS_INSIDE_EXPRESSION, "task"}, {DECISION_PROCESS_INSIDE_DELEGATE_EXPRESSION, "task"}, {DECISION_PROCESS_WITH_TAKE_LISTENER, "start"});
    }

    @Before
    public void init() {
        this.testRule.deploy(DECISION_DMN, this.process);
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Before
    public void enableDmnFeelLegacyBehavior() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
    }

    @After
    public void disableDmnFeelLegacyBehavior() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    @Test
    public void evaluateDecisionWithDecisionService() {
        this.runtimeService.startProcessInstanceByKey("testProcess", (Map)Variables.createVariables().putValue("input1", null).putValue("myBean", (Object)new DecisionServiceDelegate()));
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assert.assertThat((Object)historicDecisionInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionId(), (Matcher)CoreMatchers.is((Object)decisionDefinitionId));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionKey(), (Matcher)CoreMatchers.is((Object)DECISION_DEFINITION_KEY));
        Assert.assertThat((Object)historicDecisionInstance.getDecisionDefinitionName(), (Matcher)CoreMatchers.is((Object)"sample decision"));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)processDefinition.getKey()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.is((Object)processDefinition.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)processInstance.getId()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionKey(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseDefinitionId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)historicDecisionInstance.getActivityId(), (Matcher)CoreMatchers.is((Object)this.activityId));
        Assert.assertThat((Object)historicDecisionInstance.getEvaluationTime(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

