/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import java.util.Date;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;

public class UserOperationLogJobDefinitionTest
extends AbstractUserOperationLogTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testSetOverridingPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        UserOperationLogJobDefinitionTest.assertNotNull((Object)userOperationLogEntry);
        UserOperationLogJobDefinitionTest.assertEquals((String)"JobDefinition", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobDefinitionTest.assertEquals((String)"SetPriority", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobDefinitionTest.assertEquals((String)"overridingPriority", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobDefinitionTest.assertEquals((String)"42", (String)userOperationLogEntry.getNewValue());
        UserOperationLogJobDefinitionTest.assertEquals(null, (String)userOperationLogEntry.getOrgValue());
        UserOperationLogJobDefinitionTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobDefinitionTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
        UserOperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getProcessDefinitionId(), (String)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getProcessDefinitionKey(), (String)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobDefinitionTest.assertEquals((String)this.deploymentId, (String)userOperationLogEntry.getDeploymentId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testOverwriteOverridingPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis()));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 10000L));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 43L);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)((UserOperationLogQuery)this.historyService.createUserOperationLogQuery().orderByTimestamp().desc()).listPage(0, 1).get(0);
        UserOperationLogJobDefinitionTest.assertNotNull((Object)userOperationLogEntry);
        UserOperationLogJobDefinitionTest.assertEquals((String)"JobDefinition", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobDefinitionTest.assertEquals((String)"SetPriority", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobDefinitionTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
        UserOperationLogJobDefinitionTest.assertEquals((String)"overridingPriority", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobDefinitionTest.assertEquals((String)"43", (String)userOperationLogEntry.getNewValue());
        UserOperationLogJobDefinitionTest.assertEquals((String)"42", (String)userOperationLogEntry.getOrgValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testClearOverridingPriority() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis()));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        ClockUtil.setCurrentTime((Date)new Date(System.currentTimeMillis() + 10000L));
        this.managementService.clearOverridingJobPriorityForJobDefinition(jobDefinition.getId());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)((UserOperationLogQuery)this.historyService.createUserOperationLogQuery().orderByTimestamp().desc()).listPage(0, 1).get(0);
        UserOperationLogJobDefinitionTest.assertNotNull((Object)userOperationLogEntry);
        UserOperationLogJobDefinitionTest.assertEquals((String)"JobDefinition", (String)userOperationLogEntry.getEntityType());
        UserOperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getId(), (String)userOperationLogEntry.getJobDefinitionId());
        UserOperationLogJobDefinitionTest.assertEquals((String)"SetPriority", (String)userOperationLogEntry.getOperationType());
        UserOperationLogJobDefinitionTest.assertEquals((String)"overridingPriority", (String)userOperationLogEntry.getProperty());
        UserOperationLogJobDefinitionTest.assertNull((Object)userOperationLogEntry.getNewValue());
        UserOperationLogJobDefinitionTest.assertEquals((String)"42", (String)userOperationLogEntry.getOrgValue());
        UserOperationLogJobDefinitionTest.assertEquals((String)"demo", (String)userOperationLogEntry.getUserId());
        UserOperationLogJobDefinitionTest.assertEquals((String)"Operator", (String)userOperationLogEntry.getCategory());
        UserOperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getProcessDefinitionId(), (String)userOperationLogEntry.getProcessDefinitionId());
        UserOperationLogJobDefinitionTest.assertEquals((String)jobDefinition.getProcessDefinitionKey(), (String)userOperationLogEntry.getProcessDefinitionKey());
        UserOperationLogJobDefinitionTest.assertEquals((String)this.deploymentId, (String)userOperationLogEntry.getDeploymentId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    public void testSetOverridingPriorityCascadeToJobs() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L, true);
        UserOperationLogJobDefinitionTest.assertEquals((long)3L, (long)this.historyService.createUserOperationLogQuery().count());
        UserOperationLogEntry processInstanceStartOpLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("ProcessInstance").singleResult();
        UserOperationLogJobDefinitionTest.assertNotNull((Object)processInstanceStartOpLogEntry);
        UserOperationLogEntry jobDefOpLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("JobDefinition").singleResult();
        UserOperationLogJobDefinitionTest.assertNotNull((Object)jobDefOpLogEntry);
        UserOperationLogEntry jobOpLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Job").singleResult();
        UserOperationLogJobDefinitionTest.assertNotNull((Object)jobOpLogEntry);
        UserOperationLogJobDefinitionTest.assertEquals((String)"the two job related entries should be part of the same operation", (String)jobDefOpLogEntry.getOperationId(), (String)jobOpLogEntry.getOperationId());
        UserOperationLogJobDefinitionTest.assertEquals((String)"Job", (String)jobOpLogEntry.getEntityType());
        UserOperationLogJobDefinitionTest.assertNull((String)"id should null because it is a bulk update operation", (Object)jobOpLogEntry.getJobId());
        UserOperationLogJobDefinitionTest.assertEquals((String)"SetPriority", (String)jobOpLogEntry.getOperationType());
        UserOperationLogJobDefinitionTest.assertEquals((String)"priority", (String)jobOpLogEntry.getProperty());
        UserOperationLogJobDefinitionTest.assertEquals((String)"42", (String)jobOpLogEntry.getNewValue());
        UserOperationLogJobDefinitionTest.assertNull((String)"Original Value should be null because it is not known for bulk operations", (Object)jobOpLogEntry.getOrgValue());
        UserOperationLogJobDefinitionTest.assertEquals((String)"demo", (String)jobOpLogEntry.getUserId());
        UserOperationLogJobDefinitionTest.assertEquals((String)"Operator", (String)jobOpLogEntry.getCategory());
        UserOperationLogJobDefinitionTest.assertEquals((String)job.getJobDefinitionId(), (String)jobOpLogEntry.getJobDefinitionId());
        UserOperationLogJobDefinitionTest.assertNull((String)"an unspecified set of process instances was affected by the operation", (Object)jobOpLogEntry.getProcessInstanceId());
        UserOperationLogJobDefinitionTest.assertEquals((String)job.getProcessDefinitionId(), (String)jobOpLogEntry.getProcessDefinitionId());
        UserOperationLogJobDefinitionTest.assertEquals((String)job.getProcessDefinitionKey(), (String)jobOpLogEntry.getProcessDefinitionKey());
        UserOperationLogJobDefinitionTest.assertEquals((String)this.deploymentId, (String)jobOpLogEntry.getDeploymentId());
    }
}

