/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.ProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class ProcessInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected static final String MESSAGE_BOUNDARY_PROCESS_KEY = "messageBoundaryProcess";
    protected static final String SIGNAL_BOUNDARY_PROCESS_KEY = "signalBoundaryProcess";
    protected static final String SIGNAL_START_PROCESS_KEY = "signalStartProcess";
    protected static final String THROW_WARNING_SIGNAL_PROCESS_KEY = "throwWarningSignalProcess";
    protected static final String THROW_ALERT_SIGNAL_PROCESS_KEY = "throwAlertSignalProcess";
    protected String deploymentId;
    protected boolean ensureSpecificVariablePermission;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageBoundaryEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/signalBoundaryEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/signalStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/throwWarningSignalEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/throwAlertSignalEventProcess.bpmn20.xml").getId();
        this.ensureSpecificVariablePermission = this.processEngineConfiguration.isEnforceSpecificVariablePermission();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(this.ensureSpecificVariablePermission);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testSimpleQueryWithMultiple() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnOneTaskProcess() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testSimpleQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadPermissionOnProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        ProcessInstance instance = (ProcessInstance)query.singleResult();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)instance);
        ProcessInstanceAuthorizationTest.assertEquals((String)processInstanceId, (String)instance.getId());
    }

    public void testQueryWithReadPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryWithReadInstancesPermissionOnOneTaskProcess() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithReadInstancesPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testStartProcessInstanceByKeyWithoutAuthorization() {
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByKeyWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByKeyWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByKey() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceByIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByIdWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByIdWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceById(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceById() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        this.runtimeService.startProcessInstanceById(processDefinitionId);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceAtActivitiesByKey() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceAtActivitiesByKeyWithoutAuthorization() {
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceAtActivitiesByKeyWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceAtActivitiesByKeyWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_KEY).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceAtActivitiesById() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceAtActivitiesByIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceAtActivitiesByIdWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'oneTaskProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceAtActivitiesByIdWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processDefinitionId = this.selectProcessDefinitionByKey(PROCESS_KEY).getId();
        try {
            ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceById(processDefinitionId).startBeforeActivity("theTask")).execute();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageWithoutAuthorization() {
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessage() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.runtimeService.startProcessInstanceByMessage("startInvoiceMessage");
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testStartProcessInstanceByMessageAndProcDefIdWithoutAuthorization() {
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageAndProcDefIdWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageAndProcDefIdWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to start a process instance");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByMessageAndProcDefId() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        String processDefinitionId = this.selectProcessDefinitionByKey(MESSAGE_START_PROCESS_KEY).getId();
        this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId("startInvoiceMessage", processDefinitionId);
        this.disableAuthorization();
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.deleteProcessInstance(processInstanceId, null);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete a process instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.DELETE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteProcessInstanceWithDeletePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstanceWithDeletePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstanceWithDeleteInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_INSTANCE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testDeleteProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_INSTANCE});
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        this.assertProcessEnded(processInstanceId);
        this.enableAuthorization();
    }

    public void testGetActiveActivityIdsWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.getActiveActivityIds(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve active ativity ids");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
    }

    public void testGetActiveActivityIdsWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActiveActivityIdsWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActiveActivityIdsWithReadInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActiveActivityIds() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List activityIds = this.runtimeService.getActiveActivityIds(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityIds);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)activityIds.isEmpty());
    }

    public void testGetActivityInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.getActivityInstance(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve ativity instances");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetActivityInstanceWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testGetActivityInstanceWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testGetActivityInstanceWithReadInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testGetActivityInstanceIds() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testSignalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.signal(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to signal an execution");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    public void testSignalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signal(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    public void testSignalWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signal(processInstanceId);
        this.assertProcessEnded(processInstanceId);
    }

    public void testSignal() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)activityInstance);
    }

    public void testSignalEventReceivedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.signalEventReceived("alert");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalEventReceivedWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceived() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.signalEventReceived("alert");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedTwoExecutionsShouldFail() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.signalEventReceived("alert");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(secondProcessInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalEventReceivedTwoExecutionsShouldSuccess() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, secondProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.signalEventReceived("alert");
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        for (Task task : tasks) {
            ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
        }
        this.enableAuthorization();
    }

    public void testSignalEventReceivedByExecutionIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        String executionId = this.selectSingleTask().getExecutionId();
        try {
            this.runtimeService.signalEventReceived("alert", executionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testSignalEventReceivedByExecutionIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedByExecutionIdWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedByExecutionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testSignalEventReceivedByExecutionId() {
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.signalEventReceived("alert", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testStartProcessInstanceBySignalEventReceivedWithoutAuthorization() {
        try {
            this.runtimeService.signalEventReceived("warning");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testStartProcessInstanceBySignalEventReceivedWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.signalEventReceived("warning");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'signalStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceBySignalEventReceived() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.signalEventReceived("warning");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
    }

    public void FAILING_testStartProcessInstanceByThrowSignalEventWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_WARNING_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.startProcessInstanceByKey(THROW_WARNING_SIGNAL_PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'signalStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testStartProcessInstanceByThrowSignalEvent() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_WARNING_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.startProcessInstanceByKey(THROW_WARNING_SIGNAL_PROCESS_KEY);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
    }

    public void FAILING_testThrowSignalEventWithoutAuthorization() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_ALERT_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.startProcessInstanceByKey(THROW_ALERT_SIGNAL_PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(SIGNAL_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testThrowSignalEvent() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, THROW_ALERT_SIGNAL_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        String processInstanceId = this.startProcessInstanceByKey(SIGNAL_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, SIGNAL_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.startProcessInstanceByKey(THROW_ALERT_SIGNAL_PROCESS_KEY);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String executionId = this.selectSingleTask().getExecutionId();
        try {
            this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a message event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testMessageEventReceivedByExecutionIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedByExecutionIdWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedByExecutionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testMessageEventReceivedByExecutionId() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        String executionId = this.selectSingleTask().getExecutionId();
        this.runtimeService.messageEventReceived("boundaryInvoiceMessage", executionId);
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecutionWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.correlateMessage("boundaryInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testCorrelateMessageExecutionWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecutionWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecutionWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageExecution() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.correlateMessage("boundaryInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateMessageProcessDefinitionWithoutAuthorization() {
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateMessageProcessDefinitionWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testCorrelateMessageProcessDefinitionWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.correlateMessage("startInvoiceMessage");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateMessageProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.correlateMessage("startInvoiceMessage");
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecutionWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testCorrelateAllExecutionWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecutionWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecutionWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllExecution() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
    }

    public void testCorrelateAllTwoExecutionsShouldFail() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to trigger a signal event");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(secondProcessInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testCorrelateAllTwoExecutionsShouldSuccess() {
        String firstProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        String secondProcessInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, firstProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, secondProcessInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.createMessageCorrelation("boundaryInvoiceMessage").correlateAll();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        for (Task task : tasks) {
            ProcessInstanceAuthorizationTest.assertEquals((String)"taskAfterBoundaryEvent", (String)task.getTaskDefinitionKey());
        }
        this.enableAuthorization();
    }

    public void testCorrelateAllProcessDefinitionWithoutAuthorization() {
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateAllProcessDefinitionWithCreatePermissionOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE_INSTANCE' permission on resource 'messageStartProcess' of type 'ProcessDefinition'", e.getMessage());
        }
    }

    public void testCorrelateAllProcessDefinitionWithCreateInstancesPermissionOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        try {
            this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to correlate a message.");
        }
        catch (AuthorizationException e) {
            this.assertTextPresent("The user with id 'test' does not have 'CREATE' permission on resource 'ProcessInstance'", e.getMessage());
        }
    }

    public void testCorrelateAllProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.CREATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_START_PROCESS_KEY, this.userId, new Permission[]{Permissions.CREATE_INSTANCE});
        this.runtimeService.createMessageCorrelation("startInvoiceMessage").correlateAll();
        Task task = this.selectSingleTask();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)task);
        ProcessInstanceAuthorizationTest.assertEquals((String)"task", (String)task.getTaskDefinitionKey());
    }

    public void testSuspendProcessInstanceByIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.suspendProcessInstanceById(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    public void testSuspendProcessInstanceByIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByIdWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByIdWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceById() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByIdWithSuspendPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByIdWithSuspendPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByIdWithSuspendInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceById(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to activate a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    public void testActivateProcessInstanceByIdWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithUpdateInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceById() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithSuspendPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithSuspendPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByIdWithSuspendInstancesPermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithoutAuthorization() {
        String processDefinitionId = this.startProcessInstanceByKey(PROCESS_KEY).getProcessDefinitionId();
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionId() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithSuspendPermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithSuspendPermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionIdWithSuspendInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processDefinitionId = instance.getProcessDefinitionId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithoutAuthorization() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionId() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithSuspendPermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithSuspendPermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionIdWithSuspendInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        String processDefinitionId = instance.getProcessDefinitionId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionId(processDefinitionId);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithUpdateInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionKey() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithSuspendPermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        try {
            this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithSuspendPermissionOnAnyProcessInstance() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testSuspendProcessInstanceByProcessDefinitionKeyWithSuspendInstancesPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.suspendProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        ProcessInstance instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertTrue((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithoutAuthorization() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdatePermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithUpdateInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionKey() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE, ProcessInstancePermissions.SUSPEND});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE, ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithSuspendPermissionOnProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        try {
            this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be posssible to suspend a process instance.");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(ProcessDefinitionPermissions.SUSPEND_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
            this.assertTextPresent(ProcessInstancePermissions.SUSPEND.getName(), message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
        }
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithSuspendPermissionOnAnyProcessInstance() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.SUSPEND});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testActivateProcessInstanceByProcessDefinitionKeyWithSuspendInstancesPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY);
        String processInstanceId = instance.getId();
        this.suspendProcessInstanceById(processInstanceId);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.SUSPEND_INSTANCE});
        this.runtimeService.activateProcessInstanceByProcessDefinitionKey(PROCESS_KEY);
        instance = this.selectSingleProcessInstance();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)instance.isSuspended());
    }

    public void testModifyProcessInstanceWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        try {
            ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.UPDATE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testModifyProcessInstanceWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testModifyProcessInstanceWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testModifyProcessInstanceWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testModifyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertFalse((boolean)tasks.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeleteAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        try {
            this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.DELETE_INSTANCE.getName(), message);
            this.assertTextPresent(MESSAGE_BOUNDARY_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeletePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.assertProcessEnded(processInstanceId);
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeletePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.DELETE});
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.assertProcessEnded(processInstanceId);
    }

    public void testDeleteProcessInstanceByModifyingWithoutDeleteInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(MESSAGE_BOUNDARY_PROCESS_KEY).getId();
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, MESSAGE_BOUNDARY_PROCESS_KEY);
        authorization.setUserId(this.userId);
        authorization.addPermission((Permission)Permissions.UPDATE_INSTANCE);
        authorization.addPermission((Permission)Permissions.DELETE_INSTANCE);
        this.saveAuthorization(authorization);
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("task").execute();
        this.assertProcessEnded(processInstanceId);
    }

    public void testClearProcessInstanceAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.TASK, "*", this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)authorization);
        String taskId = this.selectSingleTask().getId();
        this.taskService.complete(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNull((Object)authorization);
    }

    public void testDeleteProcessInstanceClearAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNotNull((Object)authorization);
        this.runtimeService.deleteProcessInstance(processInstanceId, null);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceId(processInstanceId).singleResult();
        this.enableAuthorization();
        ProcessInstanceAuthorizationTest.assertNull((Object)authorization);
    }

    public void testGetVariableWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariable(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariable(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariableWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Object variable = this.runtimeService.getVariable(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableLocalWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariableLocalWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableLocalWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableLocalWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableLocalWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableLocalWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Object variable = this.runtimeService.getVariableLocal(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variable);
    }

    public void testGetVariableTypedWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariableTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableTypedWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableTypedWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        TypedValue typedValue = this.runtimeService.getVariableTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableLocalTypedWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instance");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariableLocalTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableLocalTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableLocalTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableLocalTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableLocalTypedWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariableLocalTypedWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        TypedValue typedValue = this.runtimeService.getVariableLocalTyped(processInstanceId, "aVariableName");
        ProcessInstanceAuthorizationTest.assertNotNull((Object)typedValue);
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)typedValue.getValue());
    }

    public void testGetVariablesWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariables(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariables(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        this.verifyGetVariables(variables);
    }

    public void testGetVariablesWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariables(processInstanceId);
        this.verifyGetVariables(variables);
    }

    public void testGetVariablesLocalWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocal(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesLocal(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesLocalWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        this.verifyGetVariables(variables);
    }

    public void testGetVariablesLocalWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId);
        this.verifyGetVariables(variables);
    }

    public void testGetVariablesTypedWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesTyped(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesTyped(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    public void testGetVariablesTypedWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    public void testGetVariablesLocalTypedWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocalTyped(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesLocalTyped(processInstanceId);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesLocalTypedWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    public void testGetVariablesLocalTypedWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    public void testGetVariablesByNameWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesByNameWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyGetVariables(variables);
    }

    public void testGetVariablesByNameWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariables(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyGetVariables(variables);
    }

    public void testGetVariablesLocalByNameWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesLocalByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", variables.get("aVariableName"));
    }

    public void testGetVariablesLocalByNameWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyGetVariables(variables);
    }

    public void testGetVariablesLocalByNameWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        Map variables = this.runtimeService.getVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyGetVariables(variables);
    }

    public void testGetVariablesTypedByNameWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesTypedByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesTypedByNameWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    public void testGetVariablesTypedByNameWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    public void testGetVariablesLocalTypedByNameWithoutAuthorization() {
        String message;
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(processInstanceId, message);
            this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
            this.assertTextPresent(Permissions.READ_INSTANCE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
        this.setReadVariableAsDefaultReadVariablePermission();
        try {
            this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to retrieve the variable instances");
        }
        catch (AuthorizationException e) {
            message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testGetVariablesLocalTypedByNameWithReadPermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedByNameWithReadPermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedByNameWithReadInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedByNameWithReadInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        ProcessInstanceAuthorizationTest.assertNotNull((Object)variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get((Object)"aVariableName"));
    }

    public void testGetVariablesLocalTypedByNameWithReadInstanceVariablePermissionOnProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    public void testGetVariablesLocalTypedByNameWithReadInstanceVariablePermissionOnAnyProcessDefinition() {
        this.setReadVariableAsDefaultReadVariablePermission();
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE});
        VariableMap variables = this.runtimeService.getVariablesLocalTyped(processInstanceId, Arrays.asList("aVariableName"), false);
        this.verifyGetVariables((Map<String, Object>)variables);
    }

    public void testSetVariableWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariable(processInstanceId, "aVariableName", (Object)"aVariableValue");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.verifyMessageIsValid(processInstanceId, message);
        }
    }

    public void testSetVariableWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariable(processInstanceId);
    }

    public void testSetVariableWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariable(processInstanceId);
    }

    public void testSetVariableWithUpdateInstanceInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariable(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariableWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariable(processInstanceId);
    }

    public void testSetVariableWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariable(processInstanceId);
    }

    public void testSetVariableWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariable(processInstanceId);
    }

    public void testSetVariableWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariable(processInstanceId);
    }

    public void testSetVariableWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariable(processInstanceId);
    }

    public void testSetVariableLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariableLocal(processInstanceId, "aVariableName", (Object)"aVariableValue");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    public void testSetVariableLocalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariableLocal(processInstanceId);
    }

    public void testSetVariableLocalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariableLocal(processInstanceId);
    }

    public void testSetVariableLocalWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariableLocal(processInstanceId);
    }

    public void testSetVariableLocalWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.runtimeService.setVariableLocal(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.disableAuthorization();
        VariableInstanceQuery query = this.runtimeService.createVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.enableAuthorization();
    }

    public void testSetVariableLocalWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariableLocal(processInstanceId);
    }

    public void testSetVariableLocalWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariableLocal(processInstanceId);
    }

    public void testSetVariableLocalWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariableLocal(processInstanceId);
    }

    public void testSetVariableLocalWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariableLocal(processInstanceId);
    }

    public void testSetVariablesWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariables(processInstanceId, (Map)this.getVariables());
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    public void testSetVariablesWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariables(processInstanceId);
    }

    public void testSetVariablesWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariables(processInstanceId);
    }

    public void testSetVariablesWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariables(processInstanceId);
    }

    public void testSetVariablesWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariables(processInstanceId);
    }

    public void testSetVariablesWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariables(processInstanceId);
    }

    public void testSetVariablesWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariables(processInstanceId);
    }

    public void testSetVariablesWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariables(processInstanceId);
    }

    public void testSetVariablesWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariables(processInstanceId);
    }

    public void testSetVariablesLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            this.runtimeService.setVariablesLocal(processInstanceId, (Map)this.getVariables());
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    public void testSetVariablesLocalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    public void testSetVariablesLocalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    public void testSetVariablesLocalWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    public void testSetVariablesLocalWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    public void testSetVariablesLocalWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    public void testSetVariablesLocalWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    public void testSetVariablesLocalWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    public void testSetVariablesLocalWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifySetVariablesLocal(processInstanceId);
    }

    public void testRemoveVariableWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariable(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    public void testRemoveVariableWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariable(processInstanceId);
    }

    public void testRemoveVariableWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariable(processInstanceId);
    }

    public void testRemoveVariableWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariable(processInstanceId);
    }

    public void testRemoveVariableWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariable(processInstanceId);
    }

    public void testRemoveVariableWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariable(processInstanceId);
    }

    public void testRemoveVariableWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariable(processInstanceId);
    }

    public void testRemoveVariableWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariable(processInstanceId);
    }

    public void testRemoveVariableWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariable(processInstanceId);
    }

    public void testRemoveVariableLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariableLocal(processInstanceId, "aVariableName");
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    public void testRemoveVariableLocalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    public void testRemoveVariableLocalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    public void testRemoveVariableLocalWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    public void testRemoveVariableLocalWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    public void testRemoveVariableLocalWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    public void testRemoveVariableLocalWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    public void testRemoveVariableLocalWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    public void testRemoveVariableLocalWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariableLocal(processInstanceId);
    }

    public void testRemoveVariablesWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariables(processInstanceId, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    public void testRemoveVariablesWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariables(processInstanceId);
    }

    public void testRemoveVariablesWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariables(processInstanceId);
    }

    public void testRemoveVariablesWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariables(processInstanceId);
    }

    public void testRemoveVariablesWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariables(processInstanceId);
    }

    public void testRemoveVariablesWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariables(processInstanceId);
    }

    public void testRemoveVariablesWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariables(processInstanceId);
    }

    public void testRemoveVariablesWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariables(processInstanceId);
    }

    public void testRemoveVariablesWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariables(processInstanceId);
    }

    public void testRemoveVariablesLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        try {
            this.runtimeService.removeVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    public void testRemoveVariablesLocalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    public void testRemoveVariablesLocalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    public void testRemoveVariablesLocalWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    public void testRemoveVariablesLocalWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    public void testRemoveVariablesLocalWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    public void testRemoveVariablesLocalWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    public void testRemoveVariablesLocalWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    public void testRemoveVariablesLocalWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables()).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyRemoveVariablesLocal(processInstanceId);
    }

    public void testUpdateVariablesWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), null);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, null, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    public void testUpdateVariablesWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyUpdateVariables(processInstanceId);
    }

    public void testUpdateVariablesWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyUpdateVariables(processInstanceId);
    }

    public void testUpdateVariablesWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyUpdateVariables(processInstanceId);
    }

    public void testUpdateVariablesWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyUpdateVariables(processInstanceId);
    }

    public void testUpdateVariablesWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyUpdateVariables(processInstanceId);
    }

    public void testUpdateVariablesWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyUpdateVariables(processInstanceId);
    }

    public void testUpdateVariablesWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyUpdateVariables(processInstanceId);
    }

    public void testUpdateVariablesWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyUpdateVariables(processInstanceId);
    }

    public void testUpdateVariablesLocalWithoutAuthorization() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), null);
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, null, Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
        try {
            ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
            ProcessInstanceAuthorizationTest.fail((String)"Exception expected: It should not be to set a variable");
        }
        catch (AuthorizationException e) {
            this.verifyMessageIsValid(processInstanceId, e.getMessage());
        }
    }

    public void testUpdateVariablesLocalWithUpdatePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    public void testUpdateVariablesLocalWithUpdatePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.UPDATE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    public void testUpdateVariablesLocalWithUpdateInstancePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    public void testUpdateVariablesLocalWithUpdateInstancePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    public void testUpdateVariablesLocalWithUpdateVariablePermissionOnProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    public void testUpdateVariablesLocalWithUpdateVariablePermissionOnAnyProcessInstance() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{ProcessInstancePermissions.UPDATE_VARIABLE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    public void testUpdateVariablesLocalWithUpdateInstanceVariablePermissionOnProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    public void testUpdateVariablesLocalWithUpdateInstanceVariablePermissionOnAnyProcessDefinition() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE});
        this.verifyUpdateVariablesLocal(processInstanceId);
    }

    protected void verifyQueryResults(ProcessInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyQueryResults(VariableInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyMessageIsValid(String processInstanceId, String message) {
        this.assertTextPresent(this.userId, message);
        this.assertTextPresent(Permissions.UPDATE.getName(), message);
        this.assertTextPresent(ProcessInstancePermissions.UPDATE_VARIABLE.getName(), message);
        this.assertTextPresent(processInstanceId, message);
        this.assertTextPresent(Resources.PROCESS_INSTANCE.resourceName(), message);
        this.assertTextPresent(Permissions.UPDATE_INSTANCE.getName(), message);
        this.assertTextPresent(ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE.getName(), message);
        this.assertTextPresent(PROCESS_KEY, message);
        this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
    }

    protected void verifyVariableInstanceCountDisabledAuthorization(int count) {
        this.disableAuthorization();
        this.verifyQueryResults(this.runtimeService.createVariableInstanceQuery(), count);
        this.enableAuthorization();
    }

    protected void verifySetVariable(String processInstanceId) {
        this.runtimeService.setVariable(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariableLocal(String processInstanceId) {
        this.runtimeService.setVariableLocal(processInstanceId, "aVariableName", (Object)"aVariableValue");
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariables(String processInstanceId) {
        this.runtimeService.setVariables(processInstanceId, (Map)this.getVariables());
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifySetVariablesLocal(String processInstanceId) {
        this.runtimeService.setVariablesLocal(processInstanceId, (Map)this.getVariables());
        this.verifyVariableInstanceCountDisabledAuthorization(1);
    }

    protected void verifyRemoveVariable(String processInstanceId) {
        this.runtimeService.removeVariable(processInstanceId, "aVariableName");
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariableLocal(String processInstanceId) {
        this.runtimeService.removeVariableLocal(processInstanceId, "aVariableName");
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariables(String processInstanceId) {
        this.runtimeService.removeVariables(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyRemoveVariablesLocal(String processInstanceId) {
        this.runtimeService.removeVariablesLocal(processInstanceId, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyUpdateVariables(String processInstanceId) {
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), null);
        this.verifyVariableInstanceCountDisabledAuthorization(1);
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, null, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
        ((RuntimeServiceImpl)this.runtimeService).updateVariables(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void verifyUpdateVariablesLocal(String processInstanceId) {
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), null);
        this.verifyVariableInstanceCountDisabledAuthorization(1);
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, null, Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
        ((RuntimeServiceImpl)this.runtimeService).updateVariablesLocal(processInstanceId, (Map)this.getVariables(), Arrays.asList("aVariableName"));
        this.verifyVariableInstanceCountDisabledAuthorization(0);
    }

    protected void setReadVariableAsDefaultReadVariablePermission() {
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
    }

    protected void verifyGetVariables(Map<String, Object> variables) {
        ProcessInstanceAuthorizationTest.assertNotNull(variables);
        ProcessInstanceAuthorizationTest.assertFalse((boolean)variables.isEmpty());
        ProcessInstanceAuthorizationTest.assertEquals((int)1, (int)variables.size());
        ProcessInstanceAuthorizationTest.assertEquals((Object)"aVariableValue", (Object)variables.get("aVariableName"));
    }
}

