/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.HistoricTaskPermissions;
import org.camunda.bpm.engine.authorization.MissingAuthorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.PeriodUnit;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

@RequiredHistoryLevel(value="activity")
public class HistoricTaskInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(false);
        this.deleteDeployment(this.deploymentId);
    }

    public void testQueryAfterStandaloneTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithMultiple() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryAfterCaseTask() {
        this.createCaseInstanceByKey(CASE_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testMixedQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.createCaseInstanceByKey(CASE_KEY);
        this.createCaseInstanceByKey(CASE_KEY);
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 7);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testMixedQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.createCaseInstanceByKey(CASE_KEY);
        this.createCaseInstanceByKey(CASE_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 10);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testMixedQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY);
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.createCaseInstanceByKey(CASE_KEY);
        this.createCaseInstanceByKey(CASE_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 14);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        this.verifyQueryResults(query, 3);
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    public void testDeleteStandaloneTask() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.deleteTask(taskId, true);
    }

    public void testDeleteProcessTaskWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        try {
            this.historyService.deleteHistoricTaskInstance(taskId);
            HistoricTaskInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete the historic task instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE_HISTORY.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteProcessTaskWithDeleteHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testDeleteProcessTaskWithDeleteHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
    }

    public void testDeleteHistoricTaskInstanceAfterDeletingDeployment() {
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(taskId);
        this.verifyQueryResults(query, 0);
        this.enableAuthorization();
        this.disableAuthorization();
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        this.enableAuthorization();
    }

    public void testHistoricTaskInstanceDurationReportWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        try {
            this.historyService.createHistoricTaskInstanceReport().duration(PeriodUnit.MONTH);
            HistoricTaskInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to create a historic task instance report");
        }
        catch (AuthorizationException e) {
            List missingAuthorizations = e.getMissingAuthorizations();
            HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)missingAuthorizations.size());
            MissingAuthorization missingAuthorization = (MissingAuthorization)missingAuthorizations.get(0);
            HistoricTaskInstanceAuthorizationTest.assertEquals((String)Permissions.READ_HISTORY.toString(), (String)missingAuthorization.getViolatedPermissionName());
            HistoricTaskInstanceAuthorizationTest.assertEquals((String)Resources.PROCESS_DEFINITION.resourceName(), (String)missingAuthorization.getResourceType());
            HistoricTaskInstanceAuthorizationTest.assertEquals((String)"*", (String)missingAuthorization.getResourceId());
        }
    }

    public void testHistoricTaskInstanceReportWithHistoryReadPermissionOnAny() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricTaskInstanceReport().duration(PeriodUnit.MONTH);
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testHistoricTaskInstanceCountByProcessDefinitionReportWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        try {
            this.historyService.createHistoricTaskInstanceReport().countByProcessDefinitionKey();
            HistoricTaskInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to create a historic task instance report");
        }
        catch (AuthorizationException e) {
            List missingAuthorizations = e.getMissingAuthorizations();
            HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)missingAuthorizations.size());
            MissingAuthorization missingAuthorization = (MissingAuthorization)missingAuthorizations.get(0);
            HistoricTaskInstanceAuthorizationTest.assertEquals((String)Permissions.READ_HISTORY.toString(), (String)missingAuthorization.getViolatedPermissionName());
            HistoricTaskInstanceAuthorizationTest.assertEquals((String)Resources.PROCESS_DEFINITION.resourceName(), (String)missingAuthorization.getResourceType());
            HistoricTaskInstanceAuthorizationTest.assertEquals((String)"*", (String)missingAuthorization.getResourceId());
        }
    }

    public void testHistoricTaskInstanceReportGroupedByProcessDefinitionKeyWithHistoryReadPermissionOnAny() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricTaskInstanceReport().countByProcessDefinitionKey();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testHistoricTaskInstanceGroupedByTaskNameReportWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        try {
            this.historyService.createHistoricTaskInstanceReport().countByTaskName();
            HistoricTaskInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to create a historic task instance report");
        }
        catch (AuthorizationException e) {
            List missingAuthorizations = e.getMissingAuthorizations();
            HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)missingAuthorizations.size());
            MissingAuthorization missingAuthorization = (MissingAuthorization)missingAuthorizations.get(0);
            HistoricTaskInstanceAuthorizationTest.assertEquals((String)Permissions.READ_HISTORY.toString(), (String)missingAuthorization.getViolatedPermissionName());
            HistoricTaskInstanceAuthorizationTest.assertEquals((String)Resources.PROCESS_DEFINITION.resourceName(), (String)missingAuthorization.getResourceType());
            HistoricTaskInstanceAuthorizationTest.assertEquals((String)"*", (String)missingAuthorization.getResourceId());
        }
    }

    public void testHistoricTaskInstanceGroupedByTaskNameReportWithHistoryReadPermissionOnAny() {
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricTaskInstanceReport().countByTaskName();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testCheckAllHistoricTaskPermissions() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, "*", this.userId, new Permission[]{HistoricTaskPermissions.ALL});
        HistoricTaskInstanceAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.NONE, (Resource)Resources.HISTORIC_TASK));
        HistoricTaskInstanceAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.READ, (Resource)Resources.HISTORIC_TASK));
        HistoricTaskInstanceAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.READ_VARIABLE, (Resource)Resources.HISTORIC_TASK));
        HistoricTaskInstanceAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.ALL, (Resource)Resources.HISTORIC_TASK));
    }

    public void testCheckReadHistoricTaskPermissions() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, "*", this.userId, new Permission[]{HistoricTaskPermissions.READ});
        HistoricTaskInstanceAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.NONE, (Resource)Resources.HISTORIC_TASK));
        HistoricTaskInstanceAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.READ, (Resource)Resources.HISTORIC_TASK));
    }

    public void testCheckNoneHistoricTaskPermission() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, "*", this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        HistoricTaskInstanceAuthorizationTest.assertTrue((boolean)this.authorizationService.isUserAuthorized(this.userId, null, (Permission)HistoricTaskPermissions.NONE, (Resource)Resources.HISTORIC_TASK));
    }

    public void testCheckNonePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)0, (int)result.size());
    }

    public void testCheckReadPermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testCheckReadPermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
        this.deleteTask(taskId, true);
    }

    public void testCheckNonePermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)0, (int)result.size());
        this.deleteTask(taskId, true);
    }

    public void testCheckReadPermissionOnCompletedHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testCheckNonePermissionOndHistoricTaskAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testCheckReadPermissionOndHistoricTaskAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testHistoricTaskPermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        this.disableAuthorization();
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testHistoricTaskReadPermissionGrantedWhenAssign() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.TASK_ASSIGN});
        this.enableAuthorization();
        this.taskService.setAssignee(taskId, this.userId);
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testHistoricTaskReadPermissionGrantedWhenAddingIdentityLinkOnStandaloneTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.TASK_ASSIGN});
        this.enableAuthorization();
        this.taskService.setAssignee(taskId, this.userId);
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
        this.deleteTask(taskId, true);
    }

    public void testHistoricTaskReadPermissionGrantedWhenSettingOwner() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.TASK_ASSIGN});
        this.enableAuthorization();
        this.taskService.setOwner(taskId, this.userId);
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testHistoricTaskReadPermissionGrantedWhenSettingCandidateUser() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.TASK_ASSIGN});
        this.enableAuthorization();
        this.taskService.addCandidateUser(taskId, this.userId);
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testHistoricTaskReadPermissionGrantedWhenSettingCandidateGroup() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{TaskPermissions.TASK_ASSIGN});
        this.enableAuthorization();
        this.taskService.addCandidateGroup(taskId, this.groupId);
        List result = this.historyService.createHistoricTaskInstanceQuery().list();
        HistoricTaskInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testStandaloneTaskClearHistoricAuthorization() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).resourceId(taskId).singleResult();
        this.enableAuthorization();
        HistoricTaskInstanceAuthorizationTest.assertNotNull((Object)authorization);
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).resourceId(taskId).singleResult();
        this.enableAuthorization();
        HistoricTaskInstanceAuthorizationTest.assertNull((Object)authorization);
        this.taskService.deleteTask(taskId);
    }

    public void testProcessTaskClearHistoricAuthorization() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.ALL});
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{Permissions.ALL});
        this.disableAuthorization();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).resourceId(taskId).singleResult();
        this.enableAuthorization();
        HistoricTaskInstanceAuthorizationTest.assertNotNull((Object)authorization);
        this.taskService.complete(taskId);
        this.historyService.deleteHistoricTaskInstance(taskId);
        this.disableAuthorization();
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).resourceId(taskId).singleResult();
        this.enableAuthorization();
        HistoricTaskInstanceAuthorizationTest.assertNull((Object)authorization);
        this.taskService.deleteTask(taskId);
    }

    public void testCheckNonePermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    public void testCheckReadPermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    public void testCheckReadPermissionOnCompletedHHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    public void testCheckNoneOnHistoricProcessInstanceAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    public void testCheckReadPermissionOnHistoricProcessInstanceAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    protected void verifyQueryResults(HistoricTaskInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

