/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.HistoricTaskPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

@RequiredHistoryLevel(value="full")
public class HistoricVariableInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected String deploymentId;
    protected boolean ensureSpecificVariablePermission;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        this.ensureSpecificVariablePermission = this.processEngineConfiguration.isEnforceSpecificVariablePermission();
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(false);
        this.deleteDeployment(this.deploymentId);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(this.ensureSpecificVariablePermission);
    }

    public void testQueryAfterStandaloneTaskVariables() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testSimpleQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithMultiple() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithReadHistoryVariablePermissionOnProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithReadHistoryVariablePermissionOnAnyProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testSimpleQueryWithMultipleReadHistoryVariable() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testQueryWithoutAuthorization() {
        this.startMultipleProcessInstances();
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    public void testQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startMultipleProcessInstances();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startMultipleProcessInstances();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryWithReadHistoryVariablePermissionOnProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startMultipleProcessInstances();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 3);
    }

    public void testQueryWithReadHistoryVariablePermissionOnAnyProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startMultipleProcessInstances();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    public void testQueryAfterCaseVariables() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    public void testMixedQueryWithoutAuthorization() {
        this.startMultipleProcessInstances();
        this.setupMultipleMixedVariables();
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 7);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testMixedQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startMultipleProcessInstances();
        this.setupMultipleMixedVariables();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 10);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testMixedQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startMultipleProcessInstances();
        this.setupMultipleMixedVariables();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 14);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testMixedQueryWithReadHistoryVariablePermissionOnProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startMultipleProcessInstances();
        this.setupMultipleMixedVariables();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 10);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testMixedQueryWithReadHistoryVariablePermissionOnAnyProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startMultipleProcessInstances();
        this.setupMultipleMixedVariables();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 14);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 3);
        this.cleanUpAfterDeploymentDeletion();
    }

    public void testQueryAfterDeletingDeploymentWithReadHistoryVariable() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 3);
        this.cleanUpAfterDeploymentDeletion();
    }

    public void testDeleteHistoricProcessVariableInstanceWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.disableAuthorization();
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        HistoricVariableInstanceAuthorizationTest.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
        try {
            this.historyService.deleteHistoricVariableInstance(variableInstanceId);
            HistoricVariableInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete the historic variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE_HISTORY.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteHistoricProcessVariableInstanceWithDeleteHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        HistoricVariableInstanceAuthorizationTest.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
        try {
            this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        }
        catch (AuthorizationException e) {
            HistoricVariableInstanceAuthorizationTest.fail((String)"It should be possible to delete the historic variable instance with granted permissions");
        }
        this.verifyVariablesDeleted();
    }

    public void testDeleteHistoricProcessVariableInstanceAfterDeletingDeployment() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        HistoricVariableInstanceAuthorizationTest.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
        try {
            this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        }
        catch (AuthorizationException e) {
            HistoricVariableInstanceAuthorizationTest.fail((String)"It should be possible to delete the historic variable instance with granted permissions after the process definition is deleted");
        }
        this.verifyVariablesDeleted();
        this.cleanUpAfterDeploymentDeletion();
    }

    public void testDeleteHistoricCaseVariableInstance() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.disableAuthorization();
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        HistoricVariableInstanceAuthorizationTest.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.verifyVariablesDeleted();
    }

    public void testDeleteHistoricStandaloneTaskVariableInstance() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        HistoricVariableInstanceAuthorizationTest.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.verifyVariablesDeleted();
        this.deleteTask(taskId, true);
    }

    public void testDeleteHistoricProcessVariableInstancesWithoutAuthorization() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.verifyVariablesCreated();
        try {
            this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(instance.getId());
            HistoricVariableInstanceAuthorizationTest.fail((String)"Exception expected: It should not be possible to delete the historic variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.DELETE_HISTORY.getName(), message);
            this.assertTextPresent(PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testDeleteHistoricProcessVariableInstancesWithDeleteHistoryPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.verifyVariablesCreated();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        try {
            this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(instance.getId());
        }
        catch (AuthorizationException e) {
            HistoricVariableInstanceAuthorizationTest.fail((String)"It should be possible to delete the historic variable instance with granted permissions");
        }
        this.verifyVariablesDeleted();
    }

    public void testDeleteHistoricProcessVariableInstancesAfterDeletingDeployment() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.verifyVariablesCreated();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        try {
            this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(instance.getId());
        }
        catch (AuthorizationException e) {
            HistoricVariableInstanceAuthorizationTest.fail((String)"It should be possible to delete the historic variable instance with granted permissions after the process definition is deleted");
        }
        this.verifyVariablesDeleted();
        this.cleanUpAfterDeploymentDeletion();
    }

    protected void verifyQueryResults(HistoricVariableInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyVariablesDeleted() {
        this.disableAuthorization();
        HistoricVariableInstanceAuthorizationTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstanceAuthorizationTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
    }

    protected void verifyVariablesCreated() {
        this.disableAuthorization();
        HistoricVariableInstanceAuthorizationTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        HistoricVariableInstanceAuthorizationTest.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
    }

    protected void cleanUpAfterDeploymentDeletion() {
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    protected void startMultipleProcessInstances() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
    }

    protected void setupMultipleMixedVariables() {
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.disableAuthorization();
        this.taskService.setVariables("one", (Map)this.getVariables());
        this.taskService.setVariables("two", (Map)this.getVariables());
        this.taskService.setVariables("three", (Map)this.getVariables());
        this.taskService.setVariables("four", (Map)this.getVariables());
        this.taskService.setVariables("five", (Map)this.getVariables());
        this.enableAuthorization();
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
    }

    public void testCheckNonePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)0, (int)result.size());
    }

    public void testCheckReadPermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testCheckReadPermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
        this.deleteTask(taskId, true);
    }

    public void testCheckNonePermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)0, (int)result.size());
        this.deleteTask(taskId, true);
    }

    public void testCheckReadPermissionOnCompletedHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testCheckNonePermissionOnHistoricTaskAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testCheckReadPermissionOnHistoricTaskAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testCheckReadVariablePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testOnlyReadPermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)0, (int)result.size());
    }

    public void testIgnoreReadVariablePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(false);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)0, (int)result.size());
    }

    public void testCheckReadVariablePermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
        this.deleteTask(taskId, true);
    }

    public void testCheckReadVariablePermissionOnCompletedHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testCheckReadVariablePermissionOnHistoricTaskAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testCheckNonePermissionOnHistoricTaskAndReadHistoryVariablePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testHistoricTaskPermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        HistoricVariableInstanceAuthorizationTest.assertEquals((int)1, (int)result.size());
    }

    public void testCheckNonePermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    public void testCheckReadPermissionOnHistoricProcessInstance_GlobalVariable() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.disableAuthorization();
        this.runtimeService.setVariable(processInstanceId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    public void testCheckReadPermissionOnHistoricProcessInstance_LocalVariable() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    public void testCheckReadPermissionOnCompletedHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    public void testCheckNoneOnHistoricProcessInstanceAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    public void testCheckReadOnHistoricProcessInstanceAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    protected void setReadHistoryVariableAsDefaultReadPermission() {
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
    }
}

