/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class BulkHistoryDeleteDmnDisabledTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setDmnEnabled(false);
            return configuration;
        }
    };
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;
    private HistoryService historyService;

    @Before
    public void createProcessEngine() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Test
    public void bulkHistoryDeleteWithDisabledDmn() {
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)"someProcess").startEvent().userTask("userTask").endEvent().done();
        this.testRule.deploy(model);
        List<String> ids = this.prepareHistoricProcesses("someProcess");
        this.runtimeService.deleteProcessInstances(ids, null, true, true);
        this.historyService.deleteHistoricProcessInstancesBulk(ids);
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("someProcess").count());
    }

    private List<String> prepareHistoricProcesses(String businessKey) {
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(businessKey);
            processInstanceIds.add(processInstance.getId());
        }
        return processInstanceIds;
    }
}

