/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.BatchModificationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoryCleanupHistoricBatchTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setHistoryCleanupDegreeOfParallelism(3);
            return configuration;
        }
    };
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper migrationHelper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    protected BatchModificationHelper modificationHelper = new BatchModificationHelper(this.engineRule);
    private static final String DEFAULT_TTL_DAYS = "P5D";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private Random random = new Random();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.migrationRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processEngineConfiguration.setHistoryCleanupStrategy("endTimeBased");
    }

    @After
    public void clearDatabase() {
        this.migrationHelper.removeAllRunningAndHistoricBatches();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = HistoryCleanupHistoricBatchTest.this.managementService.createJobQuery().list();
                for (Job job : jobs) {
                    commandContext.getJobManager().deleteJob((JobEntity)job);
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                }
                List historicIncidents = HistoryCleanupHistoricBatchTest.this.historyService.createHistoricIncidentQuery().list();
                for (HistoricIncident historicIncident : historicIncidents) {
                    commandContext.getDbEntityManager().delete((DbEntity)((HistoricIncidentEntity)historicIncident));
                }
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
    }

    @After
    public void resetConfiguration() {
        this.processEngineConfiguration.setHistoryCleanupStrategy("removalTimeBased");
        this.processEngineConfiguration.setBatchOperationHistoryTimeToLive(null);
        this.processEngineConfiguration.setBatchOperationsForHistoryCleanup(null);
    }

    @Test
    public void testCleanupHistoricBatch() {
        this.initBatchOperationHistoryTimeToLive(DEFAULT_TTL_DAYS);
        int daysInThePast = -11;
        this.prepareHistoricBatches(3, daysInThePast);
        List historicList = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)3L, (long)historicList.size());
        this.runHistoryCleanup();
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricBatchQuery().count());
    }

    @Test
    public void testCleanupHistoricJobLog() {
        this.initBatchOperationHistoryTimeToLive(DEFAULT_TTL_DAYS);
        int daysInThePast = -11;
        this.prepareHistoricBatches(1, daysInThePast);
        HistoricBatch batch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        String batchId = batch.getId();
        this.runHistoryCleanup();
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration(batchId).count());
    }

    @Test
    public void testCleanupHistoricIncident() {
        this.initBatchOperationHistoryTimeToLive(DEFAULT_TTL_DAYS);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-11));
        BatchEntity batch = (BatchEntity)this.createFailingMigrationBatch();
        this.migrationHelper.completeSeedJobs((Batch)batch);
        List list = this.managementService.createJobQuery().list();
        for (Job job : list) {
            if (!((JobEntity)job).getJobHandlerType().equals("instance-migration")) continue;
            this.managementService.setJobRetries(job.getId(), 1);
        }
        this.migrationHelper.executeJobs((Batch)batch);
        List<String> byteArrayIds = this.findExceptionByteArrayIds();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)new Date(), (int)-10));
        this.managementService.deleteBatch(batch.getId(), false);
        ClockUtil.setCurrentTime((Date)new Date());
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        String batchId = historicBatch.getId();
        this.runHistoryCleanup();
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration(batchId).count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricIncidentQuery().count());
        this.verifyByteArraysWereRemoved(byteArrayIds.toArray(new String[0]));
    }

    @Test
    public void testHistoryCleanupBatchMetrics() {
        this.initBatchOperationHistoryTimeToLive(DEFAULT_TTL_DAYS);
        int daysInThePast = -11;
        int batchesCount = 5;
        this.prepareHistoricBatches(batchesCount, daysInThePast);
        this.runHistoryCleanup();
        long removedBatches = this.managementService.createMetricsQuery().name("history-cleanup-removed-batch-operations").sum();
        Assert.assertEquals((long)batchesCount, (long)removedBatches);
    }

    @Test
    public void testBatchOperationTypeConfigurationOnly() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instance-migration", "P2D");
        map.put("instance-deletion", DEFAULT_TTL_DAYS);
        this.processEngineConfiguration.setBatchOperationHistoryTimeToLive(null);
        this.processEngineConfiguration.setBatchOperationsForHistoryCleanup(map);
        this.processEngineConfiguration.initHistoryCleanup();
        Assert.assertNull((Object)this.processEngineConfiguration.getBatchOperationHistoryTimeToLive());
        Date startDate = ClockUtil.getCurrentTime();
        int daysInThePast = -11;
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)daysInThePast));
        ArrayList<String> batchIds = new ArrayList<String>();
        int migrationCountBatch = 10;
        batchIds.addAll(this.createMigrationBatchList(migrationCountBatch));
        int cancelationCountBatch = 20;
        batchIds.addAll(this.createCancelationBatchList(cancelationCountBatch));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-7));
        for (String batchId : batchIds) {
            this.managementService.deleteBatch(batchId, false);
        }
        ClockUtil.setCurrentTime((Date)new Date());
        List historicList = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)30L, (long)historicList.size());
        this.runHistoryCleanup();
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricBatchQuery().count());
        for (String batchId : batchIds) {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration(batchId).count());
        }
    }

    private void runHistoryCleanup() {
        this.historyService.cleanUpHistoryAsync(true);
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        for (Job historyCleanupJob : historyCleanupJobs) {
            this.managementService.executeJob(historyCleanupJob.getId());
        }
    }

    @Test
    public void testMixedConfiguration() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instance-modification", "P20D");
        this.processEngineConfiguration.setBatchOperationHistoryTimeToLive(DEFAULT_TTL_DAYS);
        this.processEngineConfiguration.setBatchOperationsForHistoryCleanup(map);
        this.processEngineConfiguration.initHistoryCleanup();
        Date startDate = ClockUtil.getCurrentTime();
        int daysInThePast = -11;
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)daysInThePast));
        Batch modificationBatch = this.createModificationBatch();
        ArrayList<String> batchIds = new ArrayList<String>();
        batchIds.add(modificationBatch.getId());
        int migrationCountBatch = 10;
        batchIds.addAll(this.createMigrationBatchList(migrationCountBatch));
        int cancelationCountBatch = 20;
        batchIds.addAll(this.createCancelationBatchList(cancelationCountBatch));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)-8));
        for (String batchId : batchIds) {
            this.managementService.deleteBatch(batchId, false);
        }
        ClockUtil.setCurrentTime((Date)new Date());
        List historicList = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)31L, (long)historicList.size());
        this.runHistoryCleanup();
        HistoricBatch modificationHistoricBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        Assert.assertEquals((Object)modificationBatch.getId(), (Object)modificationHistoricBatch.getId());
        Assert.assertEquals((long)2L, (long)this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration(modificationBatch.getId()).count());
        batchIds.remove(modificationBatch.getId());
        for (String batchId : batchIds) {
            Assert.assertEquals((long)0L, (long)this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration(batchId).count());
        }
    }

    @Test
    public void testWrongGlobalConfiguration() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid value");
        this.processEngineConfiguration.setBatchOperationHistoryTimeToLive("PD");
        this.processEngineConfiguration.initHistoryCleanup();
    }

    @Test
    public void testWrongSpecificConfiguration() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid value");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instance-modification", "PD");
        this.processEngineConfiguration.setBatchOperationHistoryTimeToLive(DEFAULT_TTL_DAYS);
        this.processEngineConfiguration.setBatchOperationsForHistoryCleanup(map);
        this.processEngineConfiguration.initHistoryCleanup();
    }

    @Test
    public void testWrongGlobalConfigurationNegativeTTL() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid value");
        this.processEngineConfiguration.setBatchOperationHistoryTimeToLive("P-1D");
        this.processEngineConfiguration.initHistoryCleanup();
    }

    @Test
    public void testWrongSpecificConfigurationNegativeTTL() {
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Invalid value");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instance-modification", "P-5D");
        this.processEngineConfiguration.setBatchOperationHistoryTimeToLive(DEFAULT_TTL_DAYS);
        this.processEngineConfiguration.setBatchOperationsForHistoryCleanup(map);
        this.processEngineConfiguration.initHistoryCleanup();
    }

    private void initBatchOperationHistoryTimeToLive(String days) {
        this.processEngineConfiguration.setBatchOperationHistoryTimeToLive(days);
        this.processEngineConfiguration.initHistoryCleanup();
    }

    private BpmnModelInstance createModelInstance() {
        BpmnModelInstance instance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start").userTask("userTask1").sequenceFlowId("seq")).userTask("userTask2").endEvent("end").done();
        return instance;
    }

    private void prepareHistoricBatches(int batchesCount, int daysInThePast) {
        Date startDate = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)daysInThePast));
        ArrayList<Batch> list = new ArrayList<Batch>();
        for (int i = 0; i < batchesCount; ++i) {
            list.add(this.migrationHelper.migrateProcessInstancesAsync(1));
        }
        for (Batch batch : list) {
            this.migrationHelper.completeSeedJobs(batch);
            this.migrationHelper.executeJobs(batch);
            ClockUtil.setCurrentTime((Date)DateUtils.setMinutes((Date)DateUtils.addDays((Date)startDate, (int)(++daysInThePast)), (int)this.random.nextInt(60)));
            this.migrationHelper.executeMonitorJob(batch);
        }
        ClockUtil.setCurrentTime((Date)new Date());
    }

    private Batch createFailingMigrationBatch() {
        BpmnModelInstance instance = this.createModelInstance();
        ProcessDefinition sourceProcessDefinition = this.migrationRule.deployAndGetDefinition(instance);
        ProcessDefinition targetProcessDefinition = this.migrationRule.deployAndGetDefinition(instance);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        Batch batch = this.runtimeService.newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId(), "unknownId")).executeAsync();
        return batch;
    }

    private List<String> createMigrationBatchList(int migrationCountBatch) {
        ArrayList<String> batchIds = new ArrayList<String>();
        for (int i = 0; i < migrationCountBatch; ++i) {
            batchIds.add(this.migrationHelper.migrateProcessInstancesAsync(1).getId());
        }
        return batchIds;
    }

    private Batch createModificationBatch() {
        BpmnModelInstance instance = this.createModelInstance();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(instance);
        Batch modificationBatch = this.modificationHelper.startAfterAsync("process", 1, "userTask1", processDefinition.getId());
        return modificationBatch;
    }

    private List<String> createCancelationBatchList(int cancelationCountBatch) {
        ArrayList<String> batchIds = new ArrayList<String>();
        BpmnModelInstance instance = this.createModelInstance();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(instance);
        String pId = this.runtimeService.startProcessInstanceById(processDefinition.getId()).getId();
        for (int i = 0; i < cancelationCountBatch; ++i) {
            batchIds.add(this.runtimeService.deleteProcessInstancesAsync(Arrays.asList(pId), "create-deletion-batch").getId());
        }
        return batchIds;
    }

    private void verifyByteArraysWereRemoved(final String ... errorDetailsByteArrayIds) {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                for (String errorDetailsByteArrayId : errorDetailsByteArrayIds) {
                    Assert.assertNull((Object)commandContext.getDbEntityManager().selectOne("selectByteArray", (Object)errorDetailsByteArrayId));
                }
                return null;
            }
        });
    }

    private List<String> findExceptionByteArrayIds() {
        ArrayList<String> exceptionByteArrayIds = new ArrayList<String>();
        List historicJobLogs = this.historyService.createHistoricJobLogQuery().list();
        for (HistoricJobLog historicJobLog : historicJobLogs) {
            HistoricJobLogEventEntity historicJobLogEventEntity = (HistoricJobLogEventEntity)historicJobLog;
            if (historicJobLogEventEntity.getExceptionByteArrayId() == null) continue;
            exceptionByteArrayIds.add(historicJobLogEventEntity.getExceptionByteArrayId());
        }
        return exceptionByteArrayIds;
    }
}

