/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.builder.DefaultExternalTaskModelBuilder;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricExternalTaskLogTest {
    protected final String WORKER_ID = "aWorkerId";
    protected final String ERROR_MESSAGE = "This is an error!";
    protected final String ERROR_DETAILS = "These are the error details!";
    protected final long LOCK_DURATION = 300000L;
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    protected ProcessInstance processInstance;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected ExternalTaskService externalTaskService;

    @Before
    public void setUp() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
    }

    @After
    public void tearDown() {
        List list = this.externalTaskService.createExternalTaskQuery().workerId("aWorkerId").list();
        for (ExternalTask externalTask : list) {
            this.externalTaskService.unlock(externalTask.getId());
        }
    }

    @Test
    public void testHistoricExternalTaskLogCreateProperties() {
        ExternalTask task = this.startExternalTaskProcess();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().creationLog().singleResult();
        this.assertHistoricLogPropertiesAreProperlySet(task, log);
        Assert.assertEquals(null, (Object)log.getWorkerId());
        this.assertLogIsInCreatedState(log);
    }

    @Test
    public void testHistoricExternalTaskLogFailedProperties() {
        ExternalTask task = this.startExternalTaskProcess();
        this.reportExternalTaskFailure(task.getId());
        task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().singleResult();
        this.assertHistoricLogPropertiesAreProperlySet(task, null, log);
        Assert.assertEquals((Object)"aWorkerId", (Object)log.getWorkerId());
        this.assertLogIsInFailedState(log);
    }

    @Test
    public void testHistoricExternalTaskLogSuccessfulProperties() {
        ExternalTask task = this.startExternalTaskProcess();
        this.completeExternalTask(task.getId());
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().successLog().singleResult();
        this.assertHistoricLogPropertiesAreProperlySet(task, log);
        Assert.assertEquals((Object)"aWorkerId", (Object)log.getWorkerId());
        this.assertLogIsInSuccessfulState(log);
    }

    @Test
    public void testHistoricExternalTaskLogDeletedProperties() {
        ExternalTask task = this.startExternalTaskProcess();
        this.runtimeService.deleteProcessInstance(task.getProcessInstanceId(), "Dummy reason for deletion!");
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().deletionLog().singleResult();
        this.assertHistoricLogPropertiesAreProperlySet(task, log);
        Assert.assertEquals(null, (Object)log.getWorkerId());
        this.assertLogIsInDeletedState(log);
    }

    @Test
    public void testRetriesAndWorkerIdWhenFirstFailureAndThenComplete() {
        ExternalTask task = this.startExternalTaskProcess();
        this.reportExternalTaskFailure(task.getId());
        this.completeExternalTask(task.getId());
        HistoricExternalTaskLog log = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().successLog().singleResult();
        Assert.assertEquals((Object)"aWorkerId", (Object)log.getWorkerId());
        Assert.assertEquals((Object)1, (Object)log.getRetries());
        this.assertLogIsInSuccessfulState(log);
    }

    @Test
    public void testErrorDetails() {
        ExternalTask task = this.startExternalTaskProcess();
        this.reportExternalTaskFailure(task.getId());
        String failedHistoricExternalTaskLogId = ((HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().singleResult()).getId();
        String stacktrace = this.historyService.getHistoricExternalTaskLogErrorDetails(failedHistoricExternalTaskLogId);
        TestCase.assertNotNull((Object)stacktrace);
        Assert.assertEquals((Object)"These are the error details!", (Object)stacktrace);
    }

    @Test
    public void testErrorDetailsWithTwoDifferentErrorsThrown() {
        ExternalTask task = this.startExternalTaskProcess();
        String firstErrorDetails = "Dummy error details!";
        String secondErrorDetails = "These are the error details!";
        this.reportExternalTaskFailure(task.getId(), "This is an error!", firstErrorDetails);
        this.ensureEnoughTimePassedByForTimestampOrdering();
        this.reportExternalTaskFailure(task.getId(), "This is an error!", secondErrorDetails);
        List list = ((HistoricExternalTaskLogQuery)this.historyService.createHistoricExternalTaskLogQuery().failureLog().orderByTimestamp().asc()).list();
        String firstFailedLogId = ((HistoricExternalTaskLog)list.get(0)).getId();
        String secondFailedLogId = ((HistoricExternalTaskLog)list.get(1)).getId();
        String stacktrace1 = this.historyService.getHistoricExternalTaskLogErrorDetails(firstFailedLogId);
        String stacktrace2 = this.historyService.getHistoricExternalTaskLogErrorDetails(secondFailedLogId);
        TestCase.assertNotNull((Object)stacktrace1);
        TestCase.assertNotNull((Object)stacktrace2);
        Assert.assertEquals((Object)firstErrorDetails, (Object)stacktrace1);
        Assert.assertEquals((Object)secondErrorDetails, (Object)stacktrace2);
    }

    @Test
    public void testGetExceptionStacktraceForNonexistentExternalTaskId() {
        try {
            this.historyService.getHistoricExternalTaskLogErrorDetails("foo");
            TestCase.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            String expectedMessage = "No historic external task log found with id foo";
            TestCase.assertTrue((boolean)re.getMessage().contains(expectedMessage));
        }
    }

    @Test
    public void testGetExceptionStacktraceForNullExternalTaskId() {
        try {
            this.historyService.getHistoricExternalTaskLogErrorDetails(null);
            TestCase.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            String expectedMessage = "historicExternalTaskLogId is null";
            TestCase.assertTrue((boolean)re.getMessage().contains(expectedMessage));
        }
    }

    @Test
    public void testErrorMessageTruncation() {
        String exceptionMessage = this.createStringOfLength(1000);
        ExternalTask task = this.startExternalTaskProcess();
        this.reportExternalTaskFailure(task.getId(), exceptionMessage, "These are the error details!");
        HistoricExternalTaskLog failedLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().failureLog().singleResult();
        String errorMessage = failedLog.getErrorMessage();
        String expectedErrorMessage = exceptionMessage.substring(0, 666);
        TestCase.assertNotNull((Object)failedLog);
        Assert.assertEquals((long)666L, (long)errorMessage.length());
        Assert.assertEquals((Object)expectedErrorMessage, (Object)errorMessage);
    }

    protected void assertLogIsInCreatedState(HistoricExternalTaskLog log) {
        TestCase.assertTrue((boolean)log.isCreationLog());
        TestCase.assertFalse((boolean)log.isFailureLog());
        TestCase.assertFalse((boolean)log.isSuccessLog());
        TestCase.assertFalse((boolean)log.isDeletionLog());
    }

    protected void assertLogIsInFailedState(HistoricExternalTaskLog log) {
        TestCase.assertFalse((boolean)log.isCreationLog());
        TestCase.assertTrue((boolean)log.isFailureLog());
        TestCase.assertFalse((boolean)log.isSuccessLog());
        TestCase.assertFalse((boolean)log.isDeletionLog());
    }

    protected void assertLogIsInSuccessfulState(HistoricExternalTaskLog log) {
        TestCase.assertFalse((boolean)log.isCreationLog());
        TestCase.assertFalse((boolean)log.isFailureLog());
        TestCase.assertTrue((boolean)log.isSuccessLog());
        TestCase.assertFalse((boolean)log.isDeletionLog());
    }

    protected void assertLogIsInDeletedState(HistoricExternalTaskLog log) {
        TestCase.assertFalse((boolean)log.isCreationLog());
        TestCase.assertFalse((boolean)log.isFailureLog());
        TestCase.assertFalse((boolean)log.isSuccessLog());
        TestCase.assertTrue((boolean)log.isDeletionLog());
    }

    protected void assertHistoricLogPropertiesAreProperlySet(ExternalTask task, HistoricExternalTaskLog log) {
        this.assertHistoricLogPropertiesAreProperlySet(task, task.getRetries(), log);
    }

    protected void assertHistoricLogPropertiesAreProperlySet(ExternalTask task, Integer retries, HistoricExternalTaskLog log) {
        TestCase.assertNotNull((Object)log);
        TestCase.assertNotNull((Object)log.getId());
        TestCase.assertNotNull((Object)log.getTimestamp());
        Assert.assertEquals((Object)task.getId(), (Object)log.getExternalTaskId());
        Assert.assertEquals((Object)task.getActivityId(), (Object)log.getActivityId());
        Assert.assertEquals((Object)task.getActivityInstanceId(), (Object)log.getActivityInstanceId());
        Assert.assertEquals((Object)task.getTopicName(), (Object)log.getTopicName());
        Assert.assertEquals((Object)retries, (Object)log.getRetries());
        Assert.assertEquals((Object)task.getExecutionId(), (Object)log.getExecutionId());
        Assert.assertEquals((Object)task.getProcessInstanceId(), (Object)log.getProcessInstanceId());
        Assert.assertEquals((Object)task.getProcessDefinitionId(), (Object)log.getProcessDefinitionId());
        Assert.assertEquals((Object)task.getProcessDefinitionKey(), (Object)log.getProcessDefinitionKey());
        Assert.assertEquals((long)task.getPriority(), (long)log.getPriority());
    }

    protected void completeExternalTask(String externalTaskId) {
        this.externalTaskService.fetchAndLock(100, "aWorkerId", false).topic("foo", 300000L).execute();
        this.externalTaskService.complete(externalTaskId, "aWorkerId");
    }

    protected void reportExternalTaskFailure(String externalTaskId) {
        this.reportExternalTaskFailure(externalTaskId, "This is an error!", "These are the error details!");
    }

    protected void reportExternalTaskFailure(String externalTaskId, String errorMessage, String errorDetails) {
        this.externalTaskService.fetchAndLock(100, "aWorkerId", false).topic("foo", 300000L).execute();
        this.externalTaskService.handleFailure(externalTaskId, "aWorkerId", errorMessage, errorDetails, 1, 0L);
    }

    protected ExternalTask startExternalTaskProcess() {
        BpmnModelInstance oneExternalTaskProcess = DefaultExternalTaskModelBuilder.createDefaultExternalTaskModel().build();
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(oneExternalTaskProcess);
        ProcessInstance pi = this.runtimeService.startProcessInstanceById(sourceProcessDefinition.getId());
        return (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(pi.getId()).singleResult();
    }

    protected String createStringOfLength(int count) {
        return this.repeatString(count, "a");
    }

    protected String repeatString(int count, String with) {
        return new String(new char[count]).replace("\u0000", with);
    }

    protected void ensureEnoughTimePassedByForTimestampOrdering() {
        long timeToAddInSeconds = 5000L;
        Date nowPlus5Seconds = new Date(ClockUtil.getCurrentTime().getTime() + timeToAddInSeconds);
        ClockUtil.setCurrentTime((Date)nowPlus5Seconds);
    }
}

