/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Arrays;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class DefaultUserPermissionsForTaskTest
extends AuthorizationTest {
    protected String userId2 = "demo";
    protected User user2;
    protected String groupId2 = "accounting2";
    protected Group group2;
    protected String defaultTaskPermissionValue;

    @Override
    public void tearDown() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.UPDATE);
        super.tearDown();
    }

    public void testShouldGrantTaskWorkOnAssign() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.TASK_WORK);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().setAssignee(taskId, this.userId2);
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.TASK_WORK, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)false, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    public void testShouldGrantUpdateOnAssign() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.UPDATE);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().setAssignee(taskId, this.userId2);
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    public void testShouldGrantTaskWorkOnSetCandidateUser() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.TASK_WORK);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().addCandidateUser(taskId, this.userId2);
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.TASK_WORK, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)false, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    public void testShouldGrantUpdateOnSetCandidateUser() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.UPDATE);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().addCandidateUser(taskId, this.userId2);
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    public void testShouldGrantTaskWorkOnSetOwner() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.TASK_WORK);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().setOwner(taskId, this.userId2);
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.TASK_WORK, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)false, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    public void testShouldGrantUpdateOnSetOwner() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.UPDATE);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().setOwner(taskId, this.userId2);
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, null, (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    public void testShouldGrantTaskWorkOnSetCandidateGroup() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.TASK_WORK);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().addCandidateGroup(taskId, this.groupId);
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, Arrays.asList(this.groupId), (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, Arrays.asList(this.groupId), (Permission)Permissions.TASK_WORK, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)false, (boolean)this.authorizationService.isUserAuthorized(this.userId2, Arrays.asList(this.groupId), (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }

    public void testShouldGrantUpdateOnSetCandidateGroup() {
        this.processEngineConfiguration.setDefaultUserPermissionForTask((Permission)Permissions.UPDATE);
        String taskId = "myTask";
        this.createTask(taskId);
        this.createGrantAuthorization((Resource)Resources.TASK, taskId, this.userId, new Permission[]{Permissions.UPDATE});
        this.processEngine.getTaskService().addCandidateGroup(taskId, this.groupId);
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, Arrays.asList(this.groupId), (Permission)Permissions.READ, (Resource)Resources.TASK, taskId));
        DefaultUserPermissionsForTaskTest.assertEquals((boolean)true, (boolean)this.authorizationService.isUserAuthorized(this.userId2, Arrays.asList(this.groupId), (Permission)Permissions.UPDATE, (Resource)Resources.TASK, taskId));
        this.deleteTask(taskId, true);
    }
}

