/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.dmn;

import java.util.Map;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class DecisionServiceUserOperationLogTest {
    protected static final String DMN_DECISION_TABLE = "org/camunda/bpm/engine/test/api/dmn/Example.dmn";
    protected static final String DMN_DECISION_TABLE_V2 = "org/camunda/bpm/engine/test/api/dmn/Example_v2.dmn";
    protected static final String DMN_DECISION_LITERAL_EXPRESSION = "org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn";
    protected static final String DMN_DECISION_LITERAL_EXPRESSION_V2 = "org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression_v2.dmn";
    protected static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String USER_ID = "userId";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected DecisionService decisionService;
    protected RepositoryService repositoryService;
    protected HistoryService historyService;
    protected IdentityService identityService;

    @Before
    public void init() {
        this.decisionService = this.engineRule.getDecisionService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService.clearAuthentication();
    }

    @Before
    public void enableDmnFeelLegacyBehavior() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
    }

    @After
    public void disableDmnFeelLegacyBehavior() {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.engineRule.getProcessEngineConfiguration().getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void logCreationOnEvaluateDecisionTableById() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.decisionService.evaluateDecisionTableById(decisionDefinition.getId(), (Map)this.createVariables());
        this.identityService.clearAuthentication();
        this.assertOperationLog(decisionDefinition);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void logCreationOnEvaluateDecisionTableByKey() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)this.createVariables());
        this.identityService.clearAuthentication();
        this.assertOperationLog(decisionDefinition);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void logCreationOnEvaluateDecisionTableByKeyAndLatestVersion() {
        this.testRule.deploy(DMN_DECISION_TABLE_V2);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().latestVersion().singleResult();
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)this.createVariables());
        this.identityService.clearAuthentication();
        this.assertOperationLog(decisionDefinition);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void logCreationOnEvaluateDecisionTableByKeyAndVersion() {
        this.testRule.deploy(DMN_DECISION_TABLE_V2);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionVersion(Integer.valueOf(1)).singleResult();
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.decisionService.evaluateDecisionTableByKeyAndVersion(DECISION_DEFINITION_KEY, Integer.valueOf(1), (Map)this.createVariables());
        this.identityService.clearAuthentication();
        this.assertOperationLog(decisionDefinition);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    @Test
    public void logCreationOnEvaluateDecisionTableByKeyAndNullVersion() {
        this.testRule.deploy(DMN_DECISION_TABLE_V2);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().latestVersion().singleResult();
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.decisionService.evaluateDecisionTableByKeyAndVersion(DECISION_DEFINITION_KEY, null, (Map)this.createVariables());
        this.identityService.clearAuthentication();
        this.assertOperationLog(decisionDefinition);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void logCreationOnEvaluateDecisionById() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.decisionService.evaluateDecisionById(decisionDefinition.getId()).variables((Map)this.createVariables()).evaluate();
        this.identityService.clearAuthentication();
        this.assertOperationLog(decisionDefinition);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void logCreationOnEvaluateDecisionByKey() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        this.identityService.clearAuthentication();
        this.assertOperationLog(decisionDefinition);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void logCreationOnEvaluateDecisionByKeyAndLatestVersion() {
        this.testRule.deploy(DMN_DECISION_LITERAL_EXPRESSION_V2);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().latestVersion().singleResult();
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).variables((Map)this.createVariables()).evaluate();
        this.identityService.clearAuthentication();
        this.assertOperationLog(decisionDefinition);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void logCreationOnEvaluateDecisionByKeyAndVersion() {
        this.testRule.deploy(DMN_DECISION_LITERAL_EXPRESSION_V2);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionVersion(Integer.valueOf(1)).singleResult();
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).version(Integer.valueOf(1)).variables((Map)this.createVariables()).evaluate();
        this.identityService.clearAuthentication();
        this.assertOperationLog(decisionDefinition);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void logCreationOnEvaluateDecisionByKeyAndNullVersion() {
        this.testRule.deploy(DMN_DECISION_LITERAL_EXPRESSION_V2);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().latestVersion().singleResult();
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.decisionService.evaluateDecisionByKey(DECISION_DEFINITION_KEY).version(null).variables((Map)this.createVariables()).evaluate();
        this.identityService.clearAuthentication();
        this.assertOperationLog(decisionDefinition);
    }

    protected VariableMap createVariables() {
        return Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
    }

    protected void assertOperationLog(DecisionDefinition definition) {
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)Matchers.is((Object)2L));
        this.assertLogEntry("decisionDefinitionId", definition.getId());
        this.assertLogEntry("decisionDefinitionKey", definition.getKey());
    }

    protected void assertLogEntry(String property, Object newValue) {
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property(property).singleResult();
        Assert.assertThat((Object)entry, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)entry.getOrgValue(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)entry.getNewValue(), (Matcher)Matchers.is((Object)String.valueOf(newValue)));
        Assert.assertThat((Object)entry.getCategory(), (Matcher)Matchers.is((Object)"Operator"));
        Assert.assertThat((Object)entry.getEntityType(), (Matcher)Matchers.is((Object)"DecisionDefinition"));
        Assert.assertThat((Object)entry.getOperationType(), (Matcher)Matchers.is((Object)"Evaluate"));
    }
}

