/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.filter;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.impl.QueryEntityRelationCondition;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.TaskQueryProperty;
import org.camunda.bpm.engine.impl.TaskQueryVariableValue;
import org.camunda.bpm.engine.impl.VariableOrderProperty;
import org.camunda.bpm.engine.impl.json.JsonTaskQueryConverter;
import org.camunda.bpm.engine.impl.persistence.entity.FilterEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.mock.Mocks;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;

public class FilterTaskQueryTest
extends PluggableProcessEngineTestCase {
    protected Filter filter;
    protected String testString = "test";
    protected Integer testInteger = 1;
    protected DelegationState testDelegationState = DelegationState.PENDING;
    protected Date testDate = new Date(0L);
    protected String[] testActivityInstances = new String[]{"a", "b", "c"};
    protected String[] testKeys = new String[]{"d", "e"};
    protected List<String> testCandidateGroups = new ArrayList<String>();
    protected String[] testInstances = new String[]{"x", "y", "z"};
    protected String[] variableNames = new String[]{"a", "b", "c", "d", "e", "f"};
    protected Object[] variableValues = new Object[]{1, 2, "3", "4", 5, 6};
    protected QueryOperator[] variableOperators = new QueryOperator[]{QueryOperator.EQUALS, QueryOperator.GREATER_THAN_OR_EQUAL, QueryOperator.LESS_THAN, QueryOperator.LIKE, QueryOperator.NOT_EQUALS, QueryOperator.LESS_THAN_OR_EQUAL};
    protected boolean[] isTaskVariable = new boolean[]{true, true, false, false, false, false};
    protected boolean[] isProcessVariable = new boolean[]{false, false, true, true, false, false};
    protected User testUser;
    protected Group testGroup;
    protected JsonTaskQueryConverter queryConverter;

    public void setUp() {
        this.filter = this.filterService.newTaskFilter("name").setOwner("owner").setQuery((Query)this.taskService.createTaskQuery()).setProperties(new HashMap());
        this.testUser = this.identityService.newUser("user");
        this.testGroup = this.identityService.newGroup("group");
        this.identityService.saveUser(this.testUser);
        this.identityService.saveGroup(this.testGroup);
        this.identityService.createMembership(this.testUser.getId(), this.testGroup.getId());
        Group anotherGroup = this.identityService.newGroup("anotherGroup");
        this.identityService.saveGroup(anotherGroup);
        this.testCandidateGroups.add(this.testGroup.getId());
        this.testCandidateGroups.add(anotherGroup.getId());
        this.createTasks();
        this.queryConverter = new JsonTaskQueryConverter();
    }

    public void tearDown() {
        this.processEngineConfiguration.setEnableExpressionsInAdhocQueries(false);
        Mocks.reset();
        for (Filter filter : this.filterService.createTaskFilterQuery().list()) {
            this.filterService.deleteFilter(filter.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Task task : this.taskService.createTaskQuery().list()) {
            if (task.getProcessInstanceId() != null) continue;
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    public void testEmptyQuery() {
        TaskQuery emptyQuery = this.taskService.createTaskQuery();
        String emptyQueryJson = "{}";
        this.filter.setQuery((Query)emptyQuery);
        FilterTaskQueryTest.assertEquals((String)emptyQueryJson, (String)((FilterEntity)this.filter).getQueryInternal());
        FilterTaskQueryTest.assertNotNull((Object)this.filter.getQuery());
    }

    public void testTaskQuery() {
        int i;
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskId(this.testString);
        query.taskName(this.testString);
        query.taskNameNotEqual(this.testString);
        query.taskNameLike(this.testString);
        query.taskNameNotLike(this.testString);
        query.taskDescription(this.testString);
        query.taskDescriptionLike(this.testString);
        query.taskPriority(this.testInteger);
        query.taskMinPriority(this.testInteger);
        query.taskMaxPriority(this.testInteger);
        query.taskAssignee(this.testString);
        query.taskAssigneeExpression(this.testString);
        query.taskAssigneeLike(this.testString);
        query.taskAssigneeLikeExpression(this.testString);
        query.taskAssigneeIn(new String[]{this.testString});
        query.taskAssigneeNotIn(new String[]{this.testString});
        query.taskInvolvedUser(this.testString);
        query.taskInvolvedUserExpression(this.testString);
        query.taskOwner(this.testString);
        query.taskOwnerExpression(this.testString);
        query.taskUnassigned();
        query.taskAssigned();
        query.taskDelegationState(this.testDelegationState);
        query.taskCandidateGroupIn(this.testCandidateGroups);
        query.taskCandidateGroupInExpression(this.testString);
        query.withCandidateGroups();
        query.withoutCandidateGroups();
        query.withCandidateUsers();
        query.withoutCandidateUsers();
        query.processInstanceId(this.testString);
        query.processInstanceIdIn(this.testInstances);
        query.executionId(this.testString);
        query.activityInstanceIdIn(this.testActivityInstances);
        query.taskCreatedOn(this.testDate);
        query.taskCreatedOnExpression(this.testString);
        query.taskCreatedBefore(this.testDate);
        query.taskCreatedBeforeExpression(this.testString);
        query.taskCreatedAfter(this.testDate);
        query.taskCreatedAfterExpression(this.testString);
        query.taskDefinitionKey(this.testString);
        query.taskDefinitionKeyIn(this.testKeys);
        query.taskDefinitionKeyLike(this.testString);
        query.processDefinitionKey(this.testString);
        query.processDefinitionKeyIn(this.testKeys);
        query.processDefinitionId(this.testString);
        query.processDefinitionName(this.testString);
        query.processDefinitionNameLike(this.testString);
        query.processInstanceBusinessKey(this.testString);
        query.processInstanceBusinessKeyExpression(this.testString);
        query.processInstanceBusinessKeyIn(this.testKeys);
        query.processInstanceBusinessKeyLike(this.testString);
        query.processInstanceBusinessKeyLikeExpression(this.testString);
        query.taskVariableValueEquals(this.variableNames[0], this.variableValues[0]);
        query.taskVariableValueGreaterThanOrEquals(this.variableNames[1], this.variableValues[1]);
        query.processVariableValueLessThan(this.variableNames[2], this.variableValues[2]);
        query.processVariableValueLike(this.variableNames[3], (String)this.variableValues[3]);
        query.caseInstanceVariableValueNotEquals(this.variableNames[4], this.variableValues[4]);
        query.caseInstanceVariableValueLessThanOrEquals(this.variableNames[5], this.variableValues[5]);
        query.dueDate(this.testDate);
        query.dueDateExpression(this.testString);
        query.dueBefore(this.testDate);
        query.dueBeforeExpression(this.testString);
        query.dueAfter(this.testDate);
        query.dueAfterExpression(this.testString);
        query.followUpDate(this.testDate);
        query.followUpDateExpression(this.testString);
        query.followUpBefore(this.testDate);
        query.followUpBeforeExpression(this.testString);
        query.followUpAfter(this.testDate);
        query.followUpAfterExpression(this.testString);
        query.excludeSubtasks();
        query.suspended();
        query.caseDefinitionKey(this.testString);
        query.caseDefinitionId(this.testString);
        query.caseDefinitionName(this.testString);
        query.caseDefinitionNameLike(this.testString);
        query.caseInstanceId(this.testString);
        query.caseInstanceBusinessKey(this.testString);
        query.caseInstanceBusinessKeyLike(this.testString);
        query.caseExecutionId(this.testString);
        query.orderByExecutionId().desc();
        query.orderByDueDate().asc();
        query.orderByProcessVariable("var", (ValueType)ValueType.STRING).desc();
        List expectedOrderingProperties = query.getOrderingProperties();
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        query = (TaskQueryImpl)this.filter.getQuery();
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getTaskId());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getName());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getNameNotEqual());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getNameNotLike());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getNameLike());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getDescription());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getDescriptionLike());
        FilterTaskQueryTest.assertEquals((Object)this.testInteger, (Object)query.getPriority());
        FilterTaskQueryTest.assertEquals((Object)this.testInteger, (Object)query.getMinPriority());
        FilterTaskQueryTest.assertEquals((Object)this.testInteger, (Object)query.getMaxPriority());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getAssignee());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("taskAssignee")));
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getAssigneeLike());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("taskAssigneeLike")));
        FilterTaskQueryTest.assertTrue((boolean)query.getAssigneeIn().contains(this.testString));
        FilterTaskQueryTest.assertTrue((boolean)query.getAssigneeNotIn().contains(this.testString));
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getInvolvedUser());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("taskInvolvedUser")));
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getOwner());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("taskOwner")));
        FilterTaskQueryTest.assertTrue((boolean)query.isUnassigned());
        FilterTaskQueryTest.assertTrue((boolean)query.isAssigned());
        FilterTaskQueryTest.assertEquals((Object)this.testDelegationState, (Object)query.getDelegationState());
        FilterTaskQueryTest.assertEquals(this.testCandidateGroups, (Object)query.getCandidateGroups());
        FilterTaskQueryTest.assertTrue((boolean)query.isWithCandidateGroups());
        FilterTaskQueryTest.assertTrue((boolean)query.isWithoutCandidateGroups());
        FilterTaskQueryTest.assertTrue((boolean)query.isWithCandidateUsers());
        FilterTaskQueryTest.assertTrue((boolean)query.isWithoutCandidateUsers());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("taskCandidateGroupIn")));
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getProcessInstanceId());
        FilterTaskQueryTest.assertEquals((int)this.testInstances.length, (int)query.getProcessInstanceIdIn().length);
        for (i = 0; i < query.getProcessInstanceIdIn().length; ++i) {
            FilterTaskQueryTest.assertEquals((String)this.testInstances[i], (String)query.getProcessInstanceIdIn()[i]);
        }
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getExecutionId());
        FilterTaskQueryTest.assertEquals((int)this.testActivityInstances.length, (int)query.getActivityInstanceIdIn().length);
        for (i = 0; i < query.getActivityInstanceIdIn().length; ++i) {
            FilterTaskQueryTest.assertEquals((String)this.testActivityInstances[i], (String)query.getActivityInstanceIdIn()[i]);
        }
        FilterTaskQueryTest.assertEquals((Object)this.testDate, (Object)query.getCreateTime());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("taskCreatedOn")));
        FilterTaskQueryTest.assertEquals((Object)this.testDate, (Object)query.getCreateTimeBefore());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("taskCreatedBefore")));
        FilterTaskQueryTest.assertEquals((Object)this.testDate, (Object)query.getCreateTimeAfter());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("taskCreatedAfter")));
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getKey());
        FilterTaskQueryTest.assertEquals((int)this.testKeys.length, (int)query.getKeys().length);
        for (i = 0; i < query.getKeys().length; ++i) {
            FilterTaskQueryTest.assertEquals((String)this.testKeys[i], (String)query.getKeys()[i]);
        }
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getKeyLike());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getProcessDefinitionKey());
        for (i = 0; i < query.getProcessDefinitionKeys().length; ++i) {
            FilterTaskQueryTest.assertEquals((String)this.testKeys[i], (String)query.getProcessDefinitionKeys()[i]);
        }
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getProcessDefinitionId());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getProcessDefinitionName());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getProcessDefinitionNameLike());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getProcessInstanceBusinessKey());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("processInstanceBusinessKey")));
        for (i = 0; i < query.getProcessInstanceBusinessKeys().length; ++i) {
            FilterTaskQueryTest.assertEquals((String)this.testKeys[i], (String)query.getProcessInstanceBusinessKeys()[i]);
        }
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getProcessInstanceBusinessKeyLike());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("processInstanceBusinessKeyLike")));
        List variables = query.getVariables();
        for (int i2 = 0; i2 < variables.size(); ++i2) {
            TaskQueryVariableValue variable = (TaskQueryVariableValue)variables.get(i2);
            FilterTaskQueryTest.assertEquals((String)this.variableNames[i2], (String)variable.getName());
            FilterTaskQueryTest.assertEquals((Object)this.variableValues[i2], (Object)variable.getValue());
            FilterTaskQueryTest.assertEquals((Object)this.variableOperators[i2], (Object)variable.getOperator());
            FilterTaskQueryTest.assertEquals((boolean)this.isTaskVariable[i2], (boolean)variable.isLocal());
            FilterTaskQueryTest.assertEquals((boolean)this.isProcessVariable[i2], (boolean)variable.isProcessInstanceVariable());
        }
        FilterTaskQueryTest.assertEquals((Object)this.testDate, (Object)query.getDueDate());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("dueDate")));
        FilterTaskQueryTest.assertEquals((Object)this.testDate, (Object)query.getDueBefore());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("dueBefore")));
        FilterTaskQueryTest.assertEquals((Object)this.testDate, (Object)query.getDueAfter());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("dueAfter")));
        FilterTaskQueryTest.assertEquals((Object)this.testDate, (Object)query.getFollowUpDate());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("followUpDate")));
        FilterTaskQueryTest.assertEquals((Object)this.testDate, (Object)query.getFollowUpBefore());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("followUpBefore")));
        FilterTaskQueryTest.assertEquals((Object)this.testDate, (Object)query.getFollowUpAfter());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("followUpAfter")));
        FilterTaskQueryTest.assertTrue((boolean)query.isExcludeSubtasks());
        FilterTaskQueryTest.assertEquals((Object)SuspensionState.SUSPENDED, (Object)query.getSuspensionState());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getCaseDefinitionKey());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getCaseDefinitionId());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getCaseDefinitionName());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getCaseDefinitionNameLike());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getCaseInstanceId());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getCaseInstanceBusinessKey());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getCaseInstanceBusinessKeyLike());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)query.getCaseExecutionId());
        this.verifyOrderingProperties(expectedOrderingProperties, query.getOrderingProperties());
    }

    protected void verifyOrderingProperties(List<QueryOrderingProperty> expectedProperties, List<QueryOrderingProperty> actualProperties) {
        FilterTaskQueryTest.assertEquals((int)expectedProperties.size(), (int)actualProperties.size());
        for (int i = 0; i < expectedProperties.size(); ++i) {
            QueryOrderingProperty expectedProperty = expectedProperties.get(i);
            QueryOrderingProperty actualProperty = actualProperties.get(i);
            FilterTaskQueryTest.assertEquals((String)expectedProperty.getRelation(), (String)actualProperty.getRelation());
            FilterTaskQueryTest.assertEquals((Object)expectedProperty.getDirection(), (Object)actualProperty.getDirection());
            FilterTaskQueryTest.assertEquals((boolean)expectedProperty.isContainedProperty(), (boolean)actualProperty.isContainedProperty());
            FilterTaskQueryTest.assertEquals((Object)expectedProperty.getQueryProperty(), (Object)actualProperty.getQueryProperty());
            List expectedRelationConditions = expectedProperty.getRelationConditions();
            List actualRelationConditions = expectedProperty.getRelationConditions();
            if (expectedRelationConditions != null && actualRelationConditions != null) {
                FilterTaskQueryTest.assertEquals((int)expectedRelationConditions.size(), (int)actualRelationConditions.size());
                for (int j = 0; j < expectedRelationConditions.size(); ++j) {
                    QueryEntityRelationCondition expectedFilteringProperty = (QueryEntityRelationCondition)expectedRelationConditions.get(j);
                    QueryEntityRelationCondition actualFilteringProperty = (QueryEntityRelationCondition)expectedRelationConditions.get(j);
                    FilterTaskQueryTest.assertEquals((Object)expectedFilteringProperty.getProperty(), (Object)actualFilteringProperty.getProperty());
                    FilterTaskQueryTest.assertEquals((Object)expectedFilteringProperty.getComparisonProperty(), (Object)actualFilteringProperty.getComparisonProperty());
                    FilterTaskQueryTest.assertEquals((Object)expectedFilteringProperty.getScalarValue(), (Object)actualFilteringProperty.getScalarValue());
                }
                continue;
            }
            if ((expectedRelationConditions != null || actualRelationConditions == null) && (expectedRelationConditions == null || actualRelationConditions != null)) continue;
            FilterTaskQueryTest.fail((String)("Expected filtering properties: " + expectedRelationConditions + ". Actual filtering properties: " + actualRelationConditions));
        }
    }

    public void testTaskQueryByBusinessKeyExpression() {
        String aBusinessKey = "business key";
        Mocks.register((String)"aBusinessKey", (Object)aBusinessKey);
        this.createDeploymentWithBusinessKey(aBusinessKey);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)this.taskService.createTaskQuery().processInstanceBusinessKeyExpression("${ " + Mocks.getMocks().keySet().toArray()[0] + " }");
        Filter filter = this.filterService.newTaskFilter("aFilterName");
        filter.setQuery((Query)extendedQuery);
        this.filterService.saveFilter(filter);
        TaskQueryImpl filterQuery = (TaskQueryImpl)this.filterService.getFilter(filter.getId()).getQuery();
        FilterTaskQueryTest.assertEquals((String)((String)extendedQuery.getExpressions().get("processInstanceBusinessKey")), (String)((String)filterQuery.getExpressions().get("processInstanceBusinessKey")));
        FilterTaskQueryTest.assertEquals((int)1, (int)this.filterService.list(filter.getId()).size());
    }

    public void testTaskQueryByBusinessKeyExpressionInAdhocQuery() {
        this.processEngineConfiguration.setEnableExpressionsInAdhocQueries(true);
        String aBusinessKey = "business key";
        Mocks.register((String)"aBusinessKey", (Object)aBusinessKey);
        this.createDeploymentWithBusinessKey(aBusinessKey);
        Filter filter = this.filterService.newTaskFilter("aFilterName");
        filter.setQuery((Query)this.taskService.createTaskQuery());
        this.filterService.saveFilter(filter);
        TaskQueryImpl extendingQuery = (TaskQueryImpl)this.taskService.createTaskQuery().processInstanceBusinessKeyExpression("${ " + Mocks.getMocks().keySet().toArray()[0] + " }");
        FilterTaskQueryTest.assertEquals((String)((String)extendingQuery.getExpressions().get("processInstanceBusinessKey")), (String)("${ " + Mocks.getMocks().keySet().toArray()[0] + " }"));
        FilterTaskQueryTest.assertEquals((int)1, (int)this.filterService.list(filter.getId(), (Query)extendingQuery).size());
    }

    public void testTaskQueryByBusinessKeyLikeExpression() {
        String aBusinessKey = "business key";
        Mocks.register((String)"aBusinessKeyLike", (Object)("%" + aBusinessKey.substring(5)));
        this.createDeploymentWithBusinessKey(aBusinessKey);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)this.taskService.createTaskQuery().processInstanceBusinessKeyLikeExpression("${ " + Mocks.getMocks().keySet().toArray()[0] + " }");
        Filter filter = this.filterService.newTaskFilter("aFilterName");
        filter.setQuery((Query)extendedQuery);
        this.filterService.saveFilter(filter);
        TaskQueryImpl filterQuery = (TaskQueryImpl)this.filterService.getFilter(filter.getId()).getQuery();
        FilterTaskQueryTest.assertEquals((String)((String)extendedQuery.getExpressions().get("processInstanceBusinessKeyLike")), (String)((String)filterQuery.getExpressions().get("processInstanceBusinessKeyLike")));
        FilterTaskQueryTest.assertEquals((int)1, (int)this.filterService.list(filter.getId()).size());
    }

    public void testTaskQueryByBusinessKeyLikeExpressionInAdhocQuery() {
        this.processEngineConfiguration.setEnableExpressionsInAdhocQueries(true);
        String aBusinessKey = "business key";
        Mocks.register((String)"aBusinessKeyLike", (Object)("%" + aBusinessKey.substring(5)));
        this.createDeploymentWithBusinessKey(aBusinessKey);
        Filter filter = this.filterService.newTaskFilter("aFilterName");
        filter.setQuery((Query)this.taskService.createTaskQuery());
        this.filterService.saveFilter(filter);
        TaskQueryImpl extendingQuery = (TaskQueryImpl)this.taskService.createTaskQuery().processInstanceBusinessKeyLikeExpression("${ " + Mocks.getMocks().keySet().toArray()[0] + " }");
        FilterTaskQueryTest.assertEquals((String)((String)extendingQuery.getExpressions().get("processInstanceBusinessKeyLike")), (String)("${ " + Mocks.getMocks().keySet().toArray()[0] + " }"));
        FilterTaskQueryTest.assertEquals((int)1, (int)this.filterService.list(filter.getId(), (Query)extendingQuery).size());
    }

    protected void createDeploymentWithBusinessKey(String aBusinessKey) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"aProcessDefinition").startEvent().userTask().endEvent().done();
        this.deployment(new BpmnModelInstance[]{modelInstance});
        this.runtimeService.startProcessInstanceByKey("aProcessDefinition", aBusinessKey);
    }

    public void testTaskQueryByFollowUpBeforeOrNotExistent() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.followUpBeforeOrNotExistent(this.testDate);
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        query = (TaskQueryImpl)this.filter.getQuery();
        FilterTaskQueryTest.assertTrue((boolean)query.isFollowUpNullAccepted());
        FilterTaskQueryTest.assertEquals((Object)this.testDate, (Object)query.getFollowUpBefore());
    }

    public void testTaskQueryByFollowUpBeforeOrNotExistentExtendingQuery() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.followUpBeforeOrNotExistent(this.testDate);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        List tasks = this.filterService.list(this.filter.getId(), (Query)query);
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        tasks = this.filterService.list(this.filter.getId());
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.orderByTaskCreateTime().asc();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
    }

    public void testTaskQueryByFollowUpBeforeOrNotExistentExpression() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.followUpBeforeOrNotExistentExpression(this.testString);
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        query = (TaskQueryImpl)this.filter.getQuery();
        FilterTaskQueryTest.assertTrue((boolean)query.isFollowUpNullAccepted());
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("followUpBeforeOrNotExistent")));
    }

    public void testTaskQueryByFollowUpBeforeOrNotExistentExpressionExtendingQuery() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.followUpBeforeOrNotExistentExpression("${dateTime().withMillis(0)}");
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        List tasks = this.filterService.list(this.filter.getId(), (Query)query);
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        this.filter.setQuery((Query)query);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        tasks = this.filterService.list(this.filter.getId());
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.orderByTaskCreateTime().asc();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
    }

    public void testTaskQueryCandidateUser() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateUser(this.testUser.getId());
        query.taskCandidateUserExpression(this.testUser.getId());
        this.filter.setQuery((Query)query);
        query = (TaskQueryImpl)this.filter.getQuery();
        FilterTaskQueryTest.assertEquals((String)this.testUser.getId(), (String)query.getCandidateUser());
        FilterTaskQueryTest.assertEquals((String)this.testUser.getId(), (String)((String)query.getExpressions().get("taskCandidateUser")));
    }

    public void testTaskQueryCandidateGroup() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateGroup(this.testGroup.getId());
        query.taskCandidateGroupExpression(this.testGroup.getId());
        this.filter.setQuery((Query)query);
        query = (TaskQueryImpl)this.filter.getQuery();
        FilterTaskQueryTest.assertEquals((String)this.testGroup.getId(), (String)query.getCandidateGroup());
        FilterTaskQueryTest.assertEquals((String)this.testGroup.getId(), (String)((String)query.getExpressions().get("taskCandidateGroup")));
    }

    public void testTaskQueryCandidateUserIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateUser(this.testUser.getId());
        query.includeAssignedTasks();
        this.saveQuery((Query)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        FilterTaskQueryTest.assertEquals((String)this.testUser.getId(), (String)query.getCandidateUser());
        FilterTaskQueryTest.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    public void testTaskQueryCandidateUserExpressionIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateUserExpression(this.testString);
        query.includeAssignedTasks();
        this.saveQuery((Query)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("taskCandidateUser")));
        FilterTaskQueryTest.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    public void testTaskQueryCandidateGroupIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateGroup(this.testGroup.getId());
        query.includeAssignedTasks();
        this.saveQuery((Query)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        FilterTaskQueryTest.assertEquals((String)this.testGroup.getId(), (String)query.getCandidateGroup());
        FilterTaskQueryTest.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    public void testTaskQueryCandidateGroupExpressionIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateGroupExpression(this.testString);
        query.includeAssignedTasks();
        this.saveQuery((Query)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("taskCandidateGroup")));
        FilterTaskQueryTest.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    public void testTaskQueryCandidateGroupsIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateGroupIn(this.testCandidateGroups);
        query.includeAssignedTasks();
        this.saveQuery((Query)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        FilterTaskQueryTest.assertEquals(this.testCandidateGroups, (Object)query.getCandidateGroupsInternal());
        FilterTaskQueryTest.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    public void testTaskQueryCandidateGroupsExpressionIncludeAssignedTasks() {
        TaskQueryImpl query = new TaskQueryImpl();
        query.taskCandidateGroupInExpression(this.testString);
        query.includeAssignedTasks();
        this.saveQuery((Query)query);
        query = (TaskQueryImpl)this.filterService.getFilter(this.filter.getId()).getQuery();
        FilterTaskQueryTest.assertEquals((String)this.testString, (String)((String)query.getExpressions().get("taskCandidateGroupIn")));
        FilterTaskQueryTest.assertTrue((boolean)query.isIncludeAssignedTasks());
    }

    public void testExecuteTaskQueryList() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskNameLike("Task%");
        this.saveQuery((Query)query);
        List tasks = this.filterService.list(this.filter.getId());
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        for (Task task : tasks) {
            FilterTaskQueryTest.assertEquals((String)this.testUser.getId(), (String)task.getOwner());
        }
    }

    public void testExtendingTaskQueryList() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery((Query)query);
        List tasks = this.filterService.list(this.filter.getId());
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        tasks = this.filterService.list(this.filter.getId(), (Query)query);
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskDelegationState(DelegationState.RESOLVED);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            FilterTaskQueryTest.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        }
    }

    public void testExtendingTaskQueryWithAssigneeIn() {
        Task task = this.taskService.newTask("assigneeTask");
        task.setName("Task 4");
        task.setOwner(this.testUser.getId());
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "john");
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeIn(new String[]{"john"});
        this.saveQuery((Query)query);
        List origQueryTasks = this.filterService.list(this.filter.getId());
        List selfExtendQueryTasks = this.filterService.list(this.filter.getId(), (Query)query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskAssigneeIn(new String[]{"john", "kermit"});
        List extendingQueryTasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)1, (int)origQueryTasks.size());
        FilterTaskQueryTest.assertEquals((int)1, (int)selfExtendQueryTasks.size());
        FilterTaskQueryTest.assertEquals((int)2, (int)extendingQueryTasks.size());
    }

    public void testExtendingTaskQueryWithAssigneeNotIn() {
        Task task = this.taskService.newTask("assigneeTask");
        task.setName("Task 5");
        task.setOwner(this.testUser.getId());
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "john");
        TaskQuery query = this.taskService.createTaskQuery().taskAssigneeNotIn(new String[]{"kermit"});
        this.saveQuery((Query)query);
        List origQueryTasks = this.filterService.list(this.filter.getId());
        List selfExtendQueryTasks = this.filterService.list(this.filter.getId(), (Query)query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskAssigneeNotIn(new String[]{"john", "kermit"});
        List extendingQueryTasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)1, (int)origQueryTasks.size());
        FilterTaskQueryTest.assertEquals((int)1, (int)selfExtendQueryTasks.size());
        FilterTaskQueryTest.assertEquals((int)0, (int)extendingQueryTasks.size());
    }

    public void testExtendingTaskQueryListWithCandidateGroups() {
        TaskQuery query = this.taskService.createTaskQuery();
        ArrayList<String> candidateGroups = new ArrayList<String>();
        candidateGroups.add("accounting");
        query.taskCandidateGroupIn(candidateGroups);
        this.saveQuery((Query)query);
        List tasks = this.filterService.list(this.filter.getId());
        FilterTaskQueryTest.assertEquals((int)1, (int)tasks.size());
        tasks = this.filterService.list(this.filter.getId(), (Query)query);
        FilterTaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.orderByTaskCreateTime().asc();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)1, (int)tasks.size());
    }

    public void testExtendingTaskQueryListWithIncludeAssignedTasks() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskCandidateGroup("accounting");
        this.saveQuery((Query)query);
        List tasks = this.filterService.list(this.filter.getId());
        FilterTaskQueryTest.assertEquals((int)1, (int)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskCandidateGroup("accounting").includeAssignedTasks();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)2, (int)tasks.size());
    }

    public void testExtendTaskQueryWithCandidateUserExpressionAndIncludeAssignedTasks() {
        TaskQuery emptyQuery = this.taskService.createTaskQuery();
        Filter emptyFilter = this.filterService.newTaskFilter("empty");
        emptyFilter.setQuery((Query)emptyQuery);
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskCandidateUserExpression("${'test'}").includeAssignedTasks();
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        Filter extendedFilter = emptyFilter.extend((Query)query);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        FilterTaskQueryTest.assertEquals((String)"${'test'}", (String)((String)extendedQuery.getExpressions().get("taskCandidateUser")));
        FilterTaskQueryTest.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
        extendedFilter = filter.extend((Query)emptyQuery);
        extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        FilterTaskQueryTest.assertEquals((String)"${'test'}", (String)((String)extendedQuery.getExpressions().get("taskCandidateUser")));
        FilterTaskQueryTest.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
    }

    public void testExtendTaskQueryWithCandidateGroupExpressionAndIncludeAssignedTasks() {
        TaskQuery emptyQuery = this.taskService.createTaskQuery();
        Filter emptyFilter = this.filterService.newTaskFilter("empty");
        emptyFilter.setQuery((Query)emptyQuery);
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskCandidateGroupExpression("${'test'}").includeAssignedTasks();
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        Filter extendedFilter = emptyFilter.extend((Query)query);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        FilterTaskQueryTest.assertEquals((String)"${'test'}", (String)((String)extendedQuery.getExpressions().get("taskCandidateGroup")));
        FilterTaskQueryTest.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
        extendedFilter = filter.extend((Query)emptyQuery);
        extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        FilterTaskQueryTest.assertEquals((String)"${'test'}", (String)((String)extendedQuery.getExpressions().get("taskCandidateGroup")));
        FilterTaskQueryTest.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
    }

    public void testExtendTaskQueryWithCandidateGroupInAndCandidateGroup() {
        TaskQueryImpl candidateGroupInQuery = (TaskQueryImpl)this.taskService.createTaskQuery().taskCandidateGroupIn(Arrays.asList("testGroup", "testGroup2"));
        FilterTaskQueryTest.assertEquals((int)2, (int)candidateGroupInQuery.getCandidateGroups().size());
        FilterTaskQueryTest.assertEquals((String)"testGroup", (String)((String)candidateGroupInQuery.getCandidateGroups().get(0)));
        FilterTaskQueryTest.assertEquals((String)"testGroup2", (String)((String)candidateGroupInQuery.getCandidateGroups().get(1)));
        Filter candidateGroupInFilter = this.filterService.newTaskFilter("Groups filter");
        candidateGroupInFilter.setQuery((Query)candidateGroupInQuery);
        TaskQuery candidateGroupQuery = this.taskService.createTaskQuery().taskCandidateGroup("testGroup2");
        Filter extendedFilter = candidateGroupInFilter.extend((Query)candidateGroupQuery);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        FilterTaskQueryTest.assertEquals((int)1, (int)extendedQuery.getCandidateGroups().size());
        FilterTaskQueryTest.assertEquals((String)"testGroup2", (String)((String)extendedQuery.getCandidateGroups().get(0)));
    }

    public void testTaskQueryWithCandidateGroupInExpressionAndCandidateGroup() {
        TaskQueryImpl candidateGroupInQuery = (TaskQueryImpl)this.taskService.createTaskQuery().taskCandidateGroupInExpression("${'test'}").taskCandidateGroup("testGroup");
        FilterTaskQueryTest.assertEquals((String)"${'test'}", (String)((String)candidateGroupInQuery.getExpressions().get("taskCandidateGroupIn")));
        FilterTaskQueryTest.assertEquals((String)"testGroup", (String)candidateGroupInQuery.getCandidateGroup());
    }

    public void testTaskQueryWithCandidateGroupInAndCandidateGroupExpression() {
        TaskQueryImpl candidateGroupInQuery = (TaskQueryImpl)this.taskService.createTaskQuery().taskCandidateGroupIn(Arrays.asList("testGroup", "testGroup2")).taskCandidateGroupExpression("${'test'}");
        FilterTaskQueryTest.assertEquals((String)"${'test'}", (String)((String)candidateGroupInQuery.getExpressions().get("taskCandidateGroup")));
        FilterTaskQueryTest.assertEquals((int)2, (int)candidateGroupInQuery.getCandidateGroups().size());
        FilterTaskQueryTest.assertEquals((String)"testGroup", (String)((String)candidateGroupInQuery.getCandidateGroups().get(0)));
        FilterTaskQueryTest.assertEquals((String)"testGroup2", (String)((String)candidateGroupInQuery.getCandidateGroups().get(1)));
    }

    public void testExtendTaskQueryWithCandidateGroupInExpressionAndIncludeAssignedTasks() {
        TaskQuery emptyQuery = this.taskService.createTaskQuery();
        Filter emptyFilter = this.filterService.newTaskFilter("empty");
        emptyFilter.setQuery((Query)emptyQuery);
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskCandidateGroupInExpression("${'test'}").includeAssignedTasks();
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        Filter extendedFilter = emptyFilter.extend((Query)query);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        FilterTaskQueryTest.assertEquals((String)"${'test'}", (String)((String)extendedQuery.getExpressions().get("taskCandidateGroupIn")));
        FilterTaskQueryTest.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
        extendedFilter = filter.extend((Query)emptyQuery);
        extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        FilterTaskQueryTest.assertEquals((String)"${'test'}", (String)((String)extendedQuery.getExpressions().get("taskCandidateGroupIn")));
        FilterTaskQueryTest.assertTrue((boolean)extendedQuery.isIncludeAssignedTasks());
    }

    public void testExecuteTaskQueryListPage() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskNameLike("Task%");
        this.saveQuery((Query)query);
        List tasks = this.filterService.listPage(this.filter.getId(), 1, 2);
        FilterTaskQueryTest.assertEquals((int)2, (int)tasks.size());
        for (Task task : tasks) {
            FilterTaskQueryTest.assertEquals((String)this.testUser.getId(), (String)task.getOwner());
        }
    }

    public void testExtendingTaskQueryListPage() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery((Query)query);
        List tasks = this.filterService.listPage(this.filter.getId(), 1, 2);
        FilterTaskQueryTest.assertEquals((int)2, (int)tasks.size());
        tasks = this.filterService.listPage(this.filter.getId(), (Query)query, 1, 2);
        FilterTaskQueryTest.assertEquals((int)2, (int)tasks.size());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskDelegationState(DelegationState.RESOLVED);
        tasks = this.filterService.listPage(this.filter.getId(), (Query)extendingQuery, 1, 2);
        FilterTaskQueryTest.assertEquals((int)1, (int)tasks.size());
        FilterTaskQueryTest.assertEquals((Object)DelegationState.RESOLVED, (Object)((Task)tasks.get(0)).getDelegationState());
    }

    public void testExecuteTaskQuerySingleResult() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskDelegationState(DelegationState.PENDING);
        this.saveQuery((Query)query);
        Task task = (Task)this.filterService.singleResult(this.filter.getId());
        FilterTaskQueryTest.assertNotNull((Object)task);
        FilterTaskQueryTest.assertEquals((String)"Task 1", (String)task.getName());
    }

    public void testFailTaskQuerySingleResult() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery((Query)query);
        try {
            this.filterService.singleResult(this.filter.getId());
            FilterTaskQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testExtendingTaskQuerySingleResult() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskDelegationState(DelegationState.PENDING);
        this.saveQuery((Query)query);
        Task task = (Task)this.filterService.singleResult(this.filter.getId());
        FilterTaskQueryTest.assertNotNull((Object)task);
        FilterTaskQueryTest.assertEquals((String)"Task 1", (String)task.getName());
        FilterTaskQueryTest.assertEquals((String)"task1", (String)task.getId());
        task = (Task)this.filterService.singleResult(this.filter.getId(), (Query)query);
        FilterTaskQueryTest.assertNotNull((Object)task);
        FilterTaskQueryTest.assertEquals((String)"Task 1", (String)task.getName());
        FilterTaskQueryTest.assertEquals((String)"task1", (String)task.getId());
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskId("task1");
        task = (Task)this.filterService.singleResult(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertNotNull((Object)task);
        FilterTaskQueryTest.assertEquals((String)"Task 1", (String)task.getName());
        FilterTaskQueryTest.assertEquals((String)"task1", (String)task.getId());
    }

    public void testTaskQueryLookupByNameCaseInsensitive() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskName("task 1");
        this.saveQuery((Query)query);
        List tasks = this.filterService.list(this.filter.getId());
        FilterTaskQueryTest.assertNotNull((Object)tasks);
        Assert.assertThat((Object)tasks.size(), (Matcher)Is.is((Object)1));
        query = this.taskService.createTaskQuery();
        query.taskName("tASk 2");
        this.saveQuery((Query)query);
        tasks = this.filterService.list(this.filter.getId());
        FilterTaskQueryTest.assertNotNull((Object)tasks);
        Assert.assertThat((Object)tasks.size(), (Matcher)Is.is((Object)1));
    }

    public void testTaskQueryLookupByNameLikeCaseInsensitive() {
        TaskQuery query = this.taskService.createTaskQuery();
        query.taskNameLike("%task%");
        this.saveQuery((Query)query);
        List tasks = this.filterService.list(this.filter.getId());
        FilterTaskQueryTest.assertNotNull((Object)tasks);
        Assert.assertThat((Object)tasks.size(), (Matcher)Is.is((Object)3));
        query = this.taskService.createTaskQuery();
        query.taskNameLike("%Task%");
        this.saveQuery((Query)query);
        tasks = this.filterService.list(this.filter.getId());
        FilterTaskQueryTest.assertNotNull((Object)tasks);
        Assert.assertThat((Object)tasks.size(), (Matcher)Is.is((Object)3));
    }

    public void testExecuteTaskQueryCount() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery((Query)query);
        long count = this.filterService.count(this.filter.getId());
        FilterTaskQueryTest.assertEquals((long)3L, (long)count);
        query.taskDelegationState(DelegationState.RESOLVED);
        this.saveQuery((Query)query);
        count = this.filterService.count(this.filter.getId());
        FilterTaskQueryTest.assertEquals((long)2L, (long)count);
    }

    public void testExtendingTaskQueryCount() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery((Query)query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.taskId("task3");
        long count = this.filterService.count(this.filter.getId());
        FilterTaskQueryTest.assertEquals((long)3L, (long)count);
        count = this.filterService.count(this.filter.getId(), (Query)query);
        FilterTaskQueryTest.assertEquals((long)3L, (long)count);
        count = this.filterService.count(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((long)1L, (long)count);
    }

    public void testSpecialExtendingQuery() {
        TaskQuery query = this.taskService.createTaskQuery();
        this.saveQuery((Query)query);
        long count = this.filterService.count(this.filter.getId(), (Query)null);
        FilterTaskQueryTest.assertEquals((long)3L, (long)count);
    }

    public void testExtendingSorting() {
        TaskQueryImpl query = (TaskQueryImpl)this.taskService.createTaskQuery();
        this.saveQuery((Query)query);
        query = (TaskQueryImpl)this.filter.getQuery();
        FilterTaskQueryTest.assertTrue((boolean)query.getOrderingProperties().isEmpty());
        TaskQueryImpl sortQuery = (TaskQueryImpl)this.taskService.createTaskQuery().orderByTaskName().asc();
        Filter extendedFilter = this.filter.extend((Query)sortQuery);
        query = (TaskQueryImpl)extendedFilter.getQuery();
        ArrayList<QueryOrderingProperty> expectedOrderingProperties = new ArrayList<QueryOrderingProperty>(sortQuery.getOrderingProperties());
        this.verifyOrderingProperties(expectedOrderingProperties, query.getOrderingProperties());
        TaskQueryImpl extendingQuery = (TaskQueryImpl)this.taskService.createTaskQuery().orderByTaskAssignee().desc();
        extendedFilter = extendedFilter.extend((Query)extendingQuery);
        query = (TaskQueryImpl)extendedFilter.getQuery();
        expectedOrderingProperties.addAll(extendingQuery.getOrderingProperties());
        this.verifyOrderingProperties(expectedOrderingProperties, query.getOrderingProperties());
        sortQuery = (TaskQueryImpl)this.taskService.createTaskQuery().orderByCaseExecutionId();
        extendedFilter = extendedFilter.extend((Query)sortQuery);
        query = (TaskQueryImpl)extendedFilter.getQuery();
        expectedOrderingProperties.addAll(sortQuery.getOrderingProperties());
        this.verifyOrderingProperties(expectedOrderingProperties, query.getOrderingProperties());
    }

    public void testDeprecatedOrderingFormatDeserializationSingleOrdering() {
        String sortByNameAsc = "RES." + TaskQueryProperty.NAME.getName() + " " + Direction.ASCENDING.getName();
        JsonTaskQueryConverter converter = (JsonTaskQueryConverter)FilterEntity.queryConverter.get("Task");
        JsonObject queryJson = converter.toJsonObject((TaskQuery)this.filter.getQuery());
        queryJson.addProperty("orderBy", sortByNameAsc);
        TaskQueryImpl deserializedTaskQuery = (TaskQueryImpl)converter.toObject(queryJson);
        FilterTaskQueryTest.assertEquals((int)1, (int)deserializedTaskQuery.getOrderingProperties().size());
        QueryOrderingProperty orderingProperty = (QueryOrderingProperty)deserializedTaskQuery.getOrderingProperties().get(0);
        FilterTaskQueryTest.assertNull((Object)orderingProperty.getRelation());
        FilterTaskQueryTest.assertEquals((String)"asc", (String)orderingProperty.getDirection().getName());
        FilterTaskQueryTest.assertNull((Object)orderingProperty.getRelationConditions());
        FilterTaskQueryTest.assertTrue((boolean)orderingProperty.isContainedProperty());
        FilterTaskQueryTest.assertEquals((String)TaskQueryProperty.NAME.getName(), (String)orderingProperty.getQueryProperty().getName());
        FilterTaskQueryTest.assertNull((Object)orderingProperty.getQueryProperty().getFunction());
    }

    public void testDeprecatedOrderingFormatDeserializationSecondaryOrdering() {
        String sortByNameAsc = "RES." + TaskQueryProperty.NAME.getName() + " " + Direction.ASCENDING.getName();
        String secondaryOrdering = sortByNameAsc + ", RES." + TaskQueryProperty.ASSIGNEE.getName() + " " + Direction.DESCENDING.getName();
        JsonTaskQueryConverter converter = (JsonTaskQueryConverter)FilterEntity.queryConverter.get("Task");
        JsonObject queryJson = converter.toJsonObject((TaskQuery)this.filter.getQuery());
        queryJson.addProperty("orderBy", secondaryOrdering);
        TaskQueryImpl deserializedTaskQuery = (TaskQueryImpl)converter.toObject(queryJson);
        FilterTaskQueryTest.assertEquals((int)2, (int)deserializedTaskQuery.getOrderingProperties().size());
        QueryOrderingProperty orderingProperty1 = (QueryOrderingProperty)deserializedTaskQuery.getOrderingProperties().get(0);
        FilterTaskQueryTest.assertNull((Object)orderingProperty1.getRelation());
        FilterTaskQueryTest.assertEquals((String)"asc", (String)orderingProperty1.getDirection().getName());
        FilterTaskQueryTest.assertNull((Object)orderingProperty1.getRelationConditions());
        FilterTaskQueryTest.assertTrue((boolean)orderingProperty1.isContainedProperty());
        FilterTaskQueryTest.assertEquals((String)TaskQueryProperty.NAME.getName(), (String)orderingProperty1.getQueryProperty().getName());
        FilterTaskQueryTest.assertNull((Object)orderingProperty1.getQueryProperty().getFunction());
        QueryOrderingProperty orderingProperty2 = (QueryOrderingProperty)deserializedTaskQuery.getOrderingProperties().get(1);
        FilterTaskQueryTest.assertNull((Object)orderingProperty2.getRelation());
        FilterTaskQueryTest.assertEquals((String)"desc", (String)orderingProperty2.getDirection().getName());
        FilterTaskQueryTest.assertNull((Object)orderingProperty2.getRelationConditions());
        FilterTaskQueryTest.assertTrue((boolean)orderingProperty2.isContainedProperty());
        FilterTaskQueryTest.assertEquals((String)TaskQueryProperty.ASSIGNEE.getName(), (String)orderingProperty2.getQueryProperty().getName());
        FilterTaskQueryTest.assertNull((Object)orderingProperty2.getQueryProperty().getFunction());
    }

    public void testDeprecatedOrderingFormatDeserializationFunctionOrdering() {
        String orderingWithFunction = "LOWER(RES." + TaskQueryProperty.NAME.getName() + ") asc";
        JsonTaskQueryConverter converter = (JsonTaskQueryConverter)FilterEntity.queryConverter.get("Task");
        JsonObject queryJson = converter.toJsonObject((TaskQuery)this.filter.getQuery());
        queryJson.addProperty("orderBy", orderingWithFunction);
        TaskQueryImpl deserializedTaskQuery = (TaskQueryImpl)converter.toObject(queryJson);
        FilterTaskQueryTest.assertEquals((int)1, (int)deserializedTaskQuery.getOrderingProperties().size());
        QueryOrderingProperty orderingProperty = (QueryOrderingProperty)deserializedTaskQuery.getOrderingProperties().get(0);
        FilterTaskQueryTest.assertNull((Object)orderingProperty.getRelation());
        FilterTaskQueryTest.assertEquals((String)"asc", (String)orderingProperty.getDirection().getName());
        FilterTaskQueryTest.assertNull((Object)orderingProperty.getRelationConditions());
        FilterTaskQueryTest.assertFalse((boolean)orderingProperty.isContainedProperty());
        FilterTaskQueryTest.assertEquals((String)TaskQueryProperty.NAME_CASE_INSENSITIVE.getName(), (String)orderingProperty.getQueryProperty().getName());
        FilterTaskQueryTest.assertEquals((String)TaskQueryProperty.NAME_CASE_INSENSITIVE.getFunction(), (String)orderingProperty.getQueryProperty().getFunction());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/oneTaskWithFormKeyProcess.bpmn20.xml"})
    public void testInitializeFormKeysEnabled() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        TaskQuery query = this.taskService.createTaskQuery().processInstanceId(processInstance.getId());
        this.saveQuery((Query)query);
        Task task = (Task)this.filterService.list(this.filter.getId()).get(0);
        FilterTaskQueryTest.assertEquals((String)"exampleFormKey", (String)task.getFormKey());
        task = (Task)this.filterService.singleResult(this.filter.getId());
        FilterTaskQueryTest.assertEquals((String)"exampleFormKey", (String)task.getFormKey());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "test");
    }

    public void testExtendingVariableQuery() {
        TaskQuery taskQuery = this.taskService.createTaskQuery().processVariableValueEquals("hello", (Object)"world");
        this.saveQuery((Query)taskQuery);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskVariableValueEquals("hello", (Object)"world").caseInstanceVariableValueEquals("hello", (Object)"world");
        Filter extendedFilter = this.filter.extend((Query)extendingQuery);
        TaskQueryImpl extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        List variables = extendedQuery.getVariables();
        FilterTaskQueryTest.assertEquals((int)3, (int)variables.size());
        FilterTaskQueryTest.assertEquals((String)"hello", (String)((TaskQueryVariableValue)variables.get(0)).getName());
        FilterTaskQueryTest.assertEquals((Object)"world", (Object)((TaskQueryVariableValue)variables.get(0)).getValue());
        FilterTaskQueryTest.assertEquals((Object)QueryOperator.EQUALS, (Object)((TaskQueryVariableValue)variables.get(0)).getOperator());
        FilterTaskQueryTest.assertFalse((boolean)((TaskQueryVariableValue)variables.get(0)).isProcessInstanceVariable());
        FilterTaskQueryTest.assertTrue((boolean)((TaskQueryVariableValue)variables.get(0)).isLocal());
        FilterTaskQueryTest.assertEquals((String)"hello", (String)((TaskQueryVariableValue)variables.get(1)).getName());
        FilterTaskQueryTest.assertEquals((Object)"world", (Object)((TaskQueryVariableValue)variables.get(1)).getValue());
        FilterTaskQueryTest.assertEquals((Object)QueryOperator.EQUALS, (Object)((TaskQueryVariableValue)variables.get(1)).getOperator());
        FilterTaskQueryTest.assertFalse((boolean)((TaskQueryVariableValue)variables.get(1)).isProcessInstanceVariable());
        FilterTaskQueryTest.assertFalse((boolean)((TaskQueryVariableValue)variables.get(1)).isLocal());
        FilterTaskQueryTest.assertEquals((String)"hello", (String)((TaskQueryVariableValue)variables.get(2)).getName());
        FilterTaskQueryTest.assertEquals((Object)"world", (Object)((TaskQueryVariableValue)variables.get(2)).getValue());
        FilterTaskQueryTest.assertEquals((Object)QueryOperator.EQUALS, (Object)((TaskQueryVariableValue)variables.get(2)).getOperator());
        FilterTaskQueryTest.assertTrue((boolean)((TaskQueryVariableValue)variables.get(2)).isProcessInstanceVariable());
        FilterTaskQueryTest.assertFalse((boolean)((TaskQueryVariableValue)variables.get(2)).isLocal());
        extendingQuery = this.taskService.createTaskQuery().processVariableValueLessThan("hello", (Object)42).taskVariableValueLessThan("hello", (Object)42).caseInstanceVariableValueLessThan("hello", (Object)42);
        extendedFilter = this.filter.extend((Query)extendingQuery);
        extendedQuery = (TaskQueryImpl)extendedFilter.getQuery();
        variables = extendedQuery.getVariables();
        FilterTaskQueryTest.assertEquals((int)3, (int)variables.size());
        FilterTaskQueryTest.assertEquals((String)"hello", (String)((TaskQueryVariableValue)variables.get(0)).getName());
        FilterTaskQueryTest.assertEquals((Object)42, (Object)((TaskQueryVariableValue)variables.get(0)).getValue());
        FilterTaskQueryTest.assertEquals((Object)QueryOperator.LESS_THAN, (Object)((TaskQueryVariableValue)variables.get(0)).getOperator());
        FilterTaskQueryTest.assertTrue((boolean)((TaskQueryVariableValue)variables.get(0)).isProcessInstanceVariable());
        FilterTaskQueryTest.assertFalse((boolean)((TaskQueryVariableValue)variables.get(0)).isLocal());
        FilterTaskQueryTest.assertEquals((String)"hello", (String)((TaskQueryVariableValue)variables.get(1)).getName());
        FilterTaskQueryTest.assertEquals((Object)42, (Object)((TaskQueryVariableValue)variables.get(1)).getValue());
        FilterTaskQueryTest.assertEquals((Object)QueryOperator.LESS_THAN, (Object)((TaskQueryVariableValue)variables.get(1)).getOperator());
        FilterTaskQueryTest.assertFalse((boolean)((TaskQueryVariableValue)variables.get(1)).isProcessInstanceVariable());
        FilterTaskQueryTest.assertTrue((boolean)((TaskQueryVariableValue)variables.get(1)).isLocal());
        FilterTaskQueryTest.assertEquals((String)"hello", (String)((TaskQueryVariableValue)variables.get(2)).getName());
        FilterTaskQueryTest.assertEquals((Object)42, (Object)((TaskQueryVariableValue)variables.get(2)).getValue());
        FilterTaskQueryTest.assertEquals((Object)QueryOperator.LESS_THAN, (Object)((TaskQueryVariableValue)variables.get(2)).getOperator());
        FilterTaskQueryTest.assertFalse((boolean)((TaskQueryVariableValue)variables.get(2)).isProcessInstanceVariable());
        FilterTaskQueryTest.assertFalse((boolean)((TaskQueryVariableValue)variables.get(2)).isLocal());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testExtendTaskQueryByOrderByProcessVariable() {
        ProcessInstance instance500 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)500));
        ProcessInstance instance1000 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)1000));
        ProcessInstance instance250 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)250));
        TaskQuery query = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess");
        this.saveQuery((Query)query);
        TaskQuery extendingQuery = (TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc();
        List tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        FilterTaskQueryTest.assertEquals((String)instance250.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        FilterTaskQueryTest.assertEquals((String)instance500.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
        FilterTaskQueryTest.assertEquals((String)instance1000.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
        extendingQuery = (TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.INTEGER).desc();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        FilterTaskQueryTest.assertEquals((String)instance1000.getId(), (String)((Task)tasks.get(0)).getProcessInstanceId());
        FilterTaskQueryTest.assertEquals((String)instance500.getId(), (String)((Task)tasks.get(1)).getProcessInstanceId());
        FilterTaskQueryTest.assertEquals((String)instance250.getId(), (String)((Task)tasks.get(2)).getProcessInstanceId());
        this.runtimeService.deleteProcessInstance(instance250.getId(), null);
        this.runtimeService.deleteProcessInstance(instance500.getId(), null);
        this.runtimeService.deleteProcessInstance(instance1000.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testExtendTaskQueryByOrderByTaskVariable() {
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task500 = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        this.taskService.setVariableLocal(task500.getId(), "var", (Object)500);
        Task task250 = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        this.taskService.setVariableLocal(task250.getId(), "var", (Object)250);
        Task task1000 = (Task)this.taskService.createTaskQuery().processInstanceId(instance3.getId()).singleResult();
        this.taskService.setVariableLocal(task1000.getId(), "var", (Object)1000);
        TaskQuery query = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess");
        this.saveQuery((Query)query);
        TaskQuery extendingQuery = (TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.INTEGER).asc();
        List tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        FilterTaskQueryTest.assertEquals((String)task250.getId(), (String)((Task)tasks.get(0)).getId());
        FilterTaskQueryTest.assertEquals((String)task500.getId(), (String)((Task)tasks.get(1)).getId());
        FilterTaskQueryTest.assertEquals((String)task1000.getId(), (String)((Task)tasks.get(2)).getId());
        extendingQuery = (TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("var", (ValueType)ValueType.INTEGER).desc();
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)3, (int)tasks.size());
        FilterTaskQueryTest.assertEquals((String)task1000.getId(), (String)((Task)tasks.get(0)).getId());
        FilterTaskQueryTest.assertEquals((String)task500.getId(), (String)((Task)tasks.get(1)).getId());
        FilterTaskQueryTest.assertEquals((String)task250.getId(), (String)((Task)tasks.get(2)).getId());
        this.runtimeService.deleteProcessInstance(instance1.getId(), null);
        this.runtimeService.deleteProcessInstance(instance2.getId(), null);
        this.runtimeService.deleteProcessInstance(instance3.getId(), null);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testExtendTaskQueryByTaskVariableIgnoreCase() {
        String variableName = "variableName";
        String variableValueCamelCase = "someVariableValue";
        String variableValueLowerCase = variableValueCamelCase.toLowerCase();
        ProcessInstance instance1 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance2 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        ProcessInstance instance3 = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task taskCamelCase = (Task)this.taskService.createTaskQuery().processInstanceId(instance1.getId()).singleResult();
        this.taskService.setVariableLocal(taskCamelCase.getId(), variableName, (Object)variableValueCamelCase);
        Task taskLowerCase = (Task)this.taskService.createTaskQuery().processInstanceId(instance2.getId()).singleResult();
        this.taskService.setVariableLocal(taskLowerCase.getId(), variableName, (Object)variableValueLowerCase);
        Task taskWithNoVariable = (Task)this.taskService.createTaskQuery().processInstanceId(instance3.getId()).singleResult();
        TaskQuery query = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess");
        this.saveQuery((Query)query);
        List tasks = this.filterService.list(this.filter.getId(), (Query)query);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskWithNoVariable));
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().taskVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().taskVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().taskVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().taskVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().matchVariableValuesIgnoreCase().taskVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase.toLowerCase());
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testExtendTaskQueryByCaseInstanceVariableIgnoreCase() {
        String variableName = "variableName";
        String variableValueCamelCase = "someVariableValue";
        String variableValueLowerCase = variableValueCamelCase.toLowerCase();
        HashMap<String, String> variables = new HashMap<String, String>();
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        variables.put(variableName, variableValueCamelCase);
        CaseInstance instanceCamelCase = this.caseService.createCaseInstanceById(caseDefinitionId, variables);
        variables.put(variableName, variableValueLowerCase);
        CaseInstance instanceLowerCase = this.caseService.createCaseInstanceById(caseDefinitionId, variables);
        CaseInstance instanceWithoutVariables = this.caseService.createCaseInstanceById(caseDefinitionId);
        Task taskCamelCase = (Task)this.taskService.createTaskQuery().caseInstanceId(instanceCamelCase.getId()).singleResult();
        Task taskLowerCase = (Task)this.taskService.createTaskQuery().caseInstanceId(instanceLowerCase.getId()).singleResult();
        Task taskWithNoVariable = (Task)this.taskService.createTaskQuery().caseInstanceId(instanceWithoutVariables.getId()).singleResult();
        TaskQuery query = this.taskService.createTaskQuery().caseDefinitionId(caseDefinitionId);
        this.saveQuery((Query)query);
        List tasks = this.filterService.list(this.filter.getId(), (Query)query);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskWithNoVariable));
        TaskQuery extendingQuery = this.taskService.createTaskQuery().caseInstanceVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().caseInstanceVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().caseInstanceVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().caseInstanceVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().caseInstanceVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().matchVariableValuesIgnoreCase().caseInstanceVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        this.caseService.terminateCaseExecution(instanceCamelCase.getId());
        this.caseService.terminateCaseExecution(instanceLowerCase.getId());
        this.caseService.terminateCaseExecution(instanceWithoutVariables.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testExtendTaskQueryByProcessVariableIgnoreCase() {
        String variableName = "variableName";
        String variableValueCamelCase = "someVariableValue";
        String variableValueLowerCase = variableValueCamelCase.toLowerCase();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(variableName, variableValueCamelCase);
        ProcessInstance instanceCamelCase = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        variables.put(variableName, variableValueLowerCase);
        ProcessInstance instanceLowerCase = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        ProcessInstance instanceWithoutVariables = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task taskCamelCase = (Task)this.taskService.createTaskQuery().processInstanceId(instanceCamelCase.getId()).singleResult();
        Task taskLowerCase = (Task)this.taskService.createTaskQuery().processInstanceId(instanceLowerCase.getId()).singleResult();
        Task taskWithNoVariable = (Task)this.taskService.createTaskQuery().processInstanceId(instanceWithoutVariables.getId()).singleResult();
        TaskQuery query = this.taskService.createTaskQuery().processDefinitionKey("oneTaskProcess");
        this.saveQuery((Query)query);
        List tasks = this.filterService.list(this.filter.getId(), (Query)query);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskWithNoVariable));
        TaskQuery extendingQuery = this.taskService.createTaskQuery().processVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().processVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotEquals(variableName, (Object)variableValueLowerCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().processVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike(variableName, "somevariable%");
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().processVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
        extendingQuery = this.taskService.createTaskQuery().matchVariableNamesIgnoreCase().matchVariableValuesIgnoreCase().processVariableValueEquals(variableName.toLowerCase(), (Object)variableValueCamelCase);
        tasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskCamelCase));
        FilterTaskQueryTest.assertTrue((boolean)tasks.contains(taskLowerCase));
        FilterTaskQueryTest.assertFalse((boolean)tasks.contains(taskWithNoVariable));
    }

    public void testExtendTaskQuery_ORInExtendingQuery() {
        this.createTasksForOrQueries();
        TaskQuery extendedQuery = this.taskService.createTaskQuery().taskName("taskForOr");
        Filter extendedFilter = this.filterService.newTaskFilter("extendedOrFilter");
        extendedFilter.setQuery((Query)extendedQuery);
        this.filterService.saveFilter(extendedFilter);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().or().taskDescription("aTaskDescription").taskOwner("aTaskOwner").endOr().or().taskPriority(Integer.valueOf(3)).taskAssignee("aTaskAssignee").endOr();
        FilterTaskQueryTest.assertEquals((int)4, (int)extendedQuery.list().size());
        FilterTaskQueryTest.assertEquals((int)4, (int)this.filterService.list(extendedFilter.getId()).size());
        FilterTaskQueryTest.assertEquals((int)6, (int)extendingQuery.list().size());
        FilterTaskQueryTest.assertEquals((int)3, (int)this.filterService.list(extendedFilter.getId(), (Query)extendingQuery).size());
    }

    public void testExtendTaskQuery_ORInExtendedQuery() {
        this.createTasksForOrQueries();
        TaskQuery extendedQuery = this.taskService.createTaskQuery().or().taskDescription("aTaskDescription").taskOwner("aTaskOwner").endOr().or().taskPriority(Integer.valueOf(3)).taskAssignee("aTaskAssignee").endOr();
        Filter extendedFilter = this.filterService.newTaskFilter("extendedOrFilter");
        extendedFilter.setQuery((Query)extendedQuery);
        this.filterService.saveFilter(extendedFilter);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskName("taskForOr");
        FilterTaskQueryTest.assertEquals((int)6, (int)extendedQuery.list().size());
        FilterTaskQueryTest.assertEquals((int)6, (int)this.filterService.list(extendedFilter.getId()).size());
        FilterTaskQueryTest.assertEquals((int)4, (int)extendingQuery.list().size());
        FilterTaskQueryTest.assertEquals((int)3, (int)this.filterService.list(extendedFilter.getId(), (Query)extendingQuery).size());
    }

    public void testExtendTaskQuery_ORInBothExtendedAndExtendingQuery() {
        this.createTasksForOrQueries();
        TaskQuery extendedQuery = this.taskService.createTaskQuery().or().taskName("taskForOr").taskDescription("aTaskDescription").endOr();
        Filter extendedFilter = this.filterService.newTaskFilter("extendedOrFilter");
        extendedFilter.setQuery((Query)extendedQuery);
        this.filterService.saveFilter(extendedFilter);
        TaskQuery extendingQuery = this.taskService.createTaskQuery().or().tenantIdIn(new String[]{"aTenantId"}).taskOwner("aTaskOwner").endOr().or().taskPriority(Integer.valueOf(3)).taskAssignee("aTaskAssignee").endOr();
        FilterTaskQueryTest.assertEquals((int)6, (int)extendedQuery.list().size());
        FilterTaskQueryTest.assertEquals((int)6, (int)this.filterService.list(extendedFilter.getId()).size());
        FilterTaskQueryTest.assertEquals((int)4, (int)extendingQuery.list().size());
        FilterTaskQueryTest.assertEquals((int)3, (int)this.filterService.list(extendedFilter.getId(), (Query)extendingQuery).size());
    }

    public void testOrderByVariables() {
        TaskQueryImpl query = (TaskQueryImpl)((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().orderByProcessVariable("foo", (ValueType)ValueType.STRING).asc()).orderByExecutionVariable("foo", (ValueType)ValueType.STRING).asc()).orderByCaseInstanceVariable("foo", (ValueType)ValueType.STRING).asc()).orderByCaseExecutionVariable("foo", (ValueType)ValueType.STRING).asc()).orderByTaskVariable("foo", (ValueType)ValueType.STRING).asc();
        Filter filter = this.filterService.newTaskFilter("extendedOrFilter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        filter = this.filterService.getFilter(filter.getId());
        ArrayList<QueryOrderingProperty> expectedOrderingProperties = new ArrayList<QueryOrderingProperty>(query.getOrderingProperties());
        this.verifyOrderingProperties(expectedOrderingProperties, ((TaskQueryImpl)filter.getQuery()).getOrderingProperties());
        for (QueryOrderingProperty prop : ((TaskQueryImpl)filter.getQuery()).getOrderingProperties()) {
            FilterTaskQueryTest.assertTrue((boolean)(prop instanceof VariableOrderProperty));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testBooleanVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("booleanVariable", (Object)true));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("booleanVariable", (Object)true);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assert.assertThat((Object)this.filterService.count(filter.getId()), (Matcher)Is.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testIntVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("intVariable", (Object)7));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("intVariable", (Object)7);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assert.assertThat((Object)this.filterService.count(filter.getId()), (Matcher)Is.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testIntOutOfRangeVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("longVariable", (Object)0x80000000L));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("longVariable", (Object)0x80000000L);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assert.assertThat((Object)this.filterService.count(filter.getId()), (Matcher)Is.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDoubleVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("doubleVariable", (Object)88.89));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("doubleVariable", (Object)88.89);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assert.assertThat((Object)this.filterService.count(filter.getId()), (Matcher)Is.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStringVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("stringVariable", (Object)"aVariableValue"));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("stringVariable", (Object)"aVariableValue");
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assert.assertThat((Object)this.filterService.count(filter.getId()), (Matcher)Is.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testNullVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("nullVariable", null));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("nullVariable", null);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assert.assertThat((Object)this.filterService.count(filter.getId()), (Matcher)Is.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDueDate() {
        Date date = new Date();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();
        task.setDueDate(date);
        this.taskService.saveTask(task);
        TaskQuery query = this.taskService.createTaskQuery().dueDate(date);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assert.assertThat((Object)this.filterService.count(filter.getId()), (Matcher)Is.is((Object)1L));
    }

    public void testAssigneeInPositive() {
        TaskQueryImpl taskQuery = new TaskQueryImpl();
        taskQuery.taskAssigneeIn(new String[]{this.testString});
        this.filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        taskQuery = (TaskQueryImpl)this.filter.getQuery();
        FilterTaskQueryTest.assertTrue((boolean)taskQuery.getAssigneeIn().contains(this.testString));
    }

    public void testAssigneeNotInPositive() {
        TaskQueryImpl taskQuery = new TaskQueryImpl();
        taskQuery.taskAssigneeNotIn(new String[]{this.testString});
        this.filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        taskQuery = (TaskQueryImpl)this.filter.getQuery();
        FilterTaskQueryTest.assertTrue((boolean)taskQuery.getAssigneeNotIn().contains(this.testString));
    }

    public void testAssigneeInNegative() {
        TaskQueryImpl taskQuery = new TaskQueryImpl();
        this.filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        taskQuery = (TaskQueryImpl)this.filter.getQuery();
        FilterTaskQueryTest.assertNull((Object)taskQuery.getAssigneeIn());
    }

    public void testAssigneeNotInNegative() {
        TaskQueryImpl taskQuery = new TaskQueryImpl();
        this.filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(this.filter);
        this.filter = (Filter)this.filterService.createTaskFilterQuery().singleResult();
        taskQuery = (TaskQueryImpl)this.filter.getQuery();
        FilterTaskQueryTest.assertNull((Object)taskQuery.getAssigneeNotIn());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void FAILING_testDateVariable() {
        Date date = new Date();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("dateVariable", (Object)date));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("dateVariable", (Object)date);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assert.assertThat((Object)this.filterService.count(filter.getId()), (Matcher)Is.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void FAILING_testByteArrayVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("bytesVariable", (Object)"aByteArray".getBytes()));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("bytesVariable", (Object)"aByteArray".getBytes());
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assert.assertThat((Object)this.filterService.count(filter.getId()), (Matcher)Is.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void FAILING_testLongVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("longVariable", (Object)7L));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("longVariable", (Object)7L);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assert.assertThat((Object)this.filterService.count(filter.getId()), (Matcher)Is.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void FAILING_testShortVariable() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("shortVariable", (Object)7));
        TaskQuery query = this.taskService.createTaskQuery().processVariableValueEquals("shortVariable", (Object)7);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)query);
        this.filterService.saveFilter(filter);
        Assert.assertThat((Object)this.filterService.count(filter.getId()), (Matcher)Is.is((Object)1L));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testExtendingTaskQueryWithProcessInstanceIn() {
        String firstId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        String secondId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getProcessInstanceId();
        TaskQuery query = this.taskService.createTaskQuery().processInstanceIdIn(new String[]{firstId});
        this.saveQuery((Query)query);
        List origQueryTasks = this.filterService.list(this.filter.getId());
        List selfExtendQueryTasks = this.filterService.list(this.filter.getId(), (Query)query);
        TaskQuery extendingQuery = this.taskService.createTaskQuery();
        extendingQuery.processInstanceIdIn(new String[]{firstId, secondId});
        List extendingQueryTasks = this.filterService.list(this.filter.getId(), (Query)extendingQuery);
        FilterTaskQueryTest.assertEquals((int)1, (int)origQueryTasks.size());
        FilterTaskQueryTest.assertEquals((int)1, (int)selfExtendQueryTasks.size());
        FilterTaskQueryTest.assertEquals((int)2, (int)extendingQueryTasks.size());
    }

    protected void saveQuery(Query query) {
        this.filter.setQuery(query);
        this.filterService.saveFilter(this.filter);
        this.filter = this.filterService.getFilter(this.filter.getId());
    }

    protected void createTasks() {
        Task task = this.taskService.newTask("task1");
        task.setName("Task 1");
        task.setOwner(this.testUser.getId());
        task.setDelegationState(DelegationState.PENDING);
        this.taskService.saveTask(task);
        this.taskService.addCandidateGroup(task.getId(), "accounting");
        task = this.taskService.newTask("task2");
        task.setName("Task 2");
        task.setOwner(this.testUser.getId());
        task.setDelegationState(DelegationState.RESOLVED);
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), "kermit");
        this.taskService.addCandidateGroup(task.getId(), "accounting");
        task = this.taskService.newTask("task3");
        task.setName("Task 3");
        task.setOwner(this.testUser.getId());
        task.setDelegationState(DelegationState.RESOLVED);
        this.taskService.saveTask(task);
    }

    protected void createTasksForOrQueries() {
        Task task1 = this.taskService.newTask();
        task1.setName("taskForOr");
        task1.setDescription("aTaskDescription");
        task1.setPriority(3);
        this.taskService.saveTask(task1);
        Task task2 = this.taskService.newTask();
        task2.setName("taskForOr");
        task2.setDescription("aTaskDescription");
        task2.setAssignee("aTaskAssignee");
        task2.setTenantId("aTenantId");
        this.taskService.saveTask(task2);
        Task task3 = this.taskService.newTask();
        task3.setName("taskForOr");
        task3.setOwner("aTaskOwner");
        this.taskService.saveTask(task3);
        Task task4 = this.taskService.newTask();
        task4.setName("taskForOr");
        task4.setOwner("aTaskOwner");
        task4.setPriority(3);
        this.taskService.saveTask(task4);
        Task task5 = this.taskService.newTask();
        task5.setDescription("aTaskDescription");
        task5.setAssignee("aTaskAssignee");
        this.taskService.saveTask(task5);
        Task task6 = this.taskService.newTask();
        task6.setDescription("aTaskDescription");
        task6.setAssignee("aTaskAssignee");
        task6.setTenantId("aTenantId");
        this.taskService.saveTask(task6);
        Task task7 = this.taskService.newTask();
        task7.setTenantId("aTenantId");
        task7.setOwner("aTaskOwner");
        task7.setPriority(3);
        task7.setAssignee("aTaskAssignee");
        this.taskService.saveTask(task7);
    }
}

