/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class AdminUsersTest {
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule();
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected IdentityService identityService;
    protected AuthorizationService authorizationService;
    protected ManagementService managementService;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.identityService = this.engineRule.getIdentityService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.managementService = this.engineRule.getManagementService();
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.cleanupAfterTest();
    }

    protected void cleanupAfterTest() {
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
    }

    @Test
    public void testWithoutAdminUser() {
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.identityService.setAuthentication("adminUser", null, null);
        Authorization userAuth = this.authorizationService.createNewAuthorization(1);
        userAuth.setUserId("adminUser");
        userAuth.setResource((Resource)Resources.USER);
        userAuth.setResourceId("*");
        userAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(userAuth);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.thrown.expect(AuthorizationException.class);
        this.thrown.expectMessage("Required admin authenticated group or user.");
        this.managementService.getProperties();
    }

    @Test
    public void testWithAdminUser() {
        this.processEngineConfiguration.getAdminUsers().add("adminUser");
        this.processEngineConfiguration.setAuthorizationEnabled(false);
        this.identityService.setAuthentication("adminUser", null, null);
        Authorization userAuth = this.authorizationService.createNewAuthorization(1);
        userAuth.setUserId("adminUser");
        userAuth.setResource((Resource)Resources.USER);
        userAuth.setResourceId("*");
        userAuth.addPermission((Permission)Permissions.READ);
        this.authorizationService.saveAuthorization(userAuth);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
        this.managementService.getProperties();
    }
}

