/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.SuspensionState;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BatchSuspensionTest {
    public static final String USER_ID = "userId";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.migrationRule);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected int defaultBatchJobsPerSeed;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Before
    public void saveAndReduceBatchJobsPerSeed() {
        ProcessEngineConfigurationImpl configuration = this.engineRule.getProcessEngineConfiguration();
        this.defaultBatchJobsPerSeed = configuration.getBatchJobsPerSeed();
        configuration.setBatchJobsPerSeed(1);
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @After
    public void resetBatchJobsPerSeed() {
        this.engineRule.getProcessEngineConfiguration().setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
    }

    @Test
    public void shouldSuspendBatch() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch.getId());
        batch = (Batch)this.managementService.createBatchQuery().batchId(batch.getId()).singleResult();
        Assert.assertTrue((boolean)batch.isSuspended());
    }

    @Test
    public void shouldFailWhenSuspendingUsingUnknownId() {
        try {
            this.managementService.suspendBatchById("unknown");
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Batch for id 'unknown' cannot be found"));
        }
    }

    @Test
    public void shouldFailWhenSuspendingUsingNullId() {
        try {
            this.managementService.suspendBatchById(null);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"batch id is null"));
        }
    }

    @Test
    public void shouldSuspendSeedJobAndDefinition() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch.getId());
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertTrue((boolean)seedJobDefinition.isSuspended());
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertTrue((boolean)seedJob.isSuspended());
    }

    @Test
    public void shouldCreateSuspendedSeedJob() {
        Batch batch = this.helper.migrateProcessInstancesAsync(2);
        this.managementService.suspendBatchById(batch.getId());
        this.helper.executeSeedJob(batch);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertTrue((boolean)seedJob.isSuspended());
    }

    @Test
    public void shouldSuspendMonitorJobAndDefinition() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.executeSeedJob(batch);
        this.managementService.suspendBatchById(batch.getId());
        JobDefinition monitorJobDefinition = this.helper.getMonitorJobDefinition(batch);
        Assert.assertTrue((boolean)monitorJobDefinition.isSuspended());
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertTrue((boolean)monitorJob.isSuspended());
    }

    @Test
    public void shouldCreateSuspendedMonitorJob() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch.getId());
        this.helper.executeSeedJob(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertTrue((boolean)monitorJob.isSuspended());
    }

    @Test
    public void shouldSuspendExecutionJobsAndDefinition() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.executeSeedJob(batch);
        this.managementService.suspendBatchById(batch.getId());
        JobDefinition migrationJobDefinition = this.helper.getExecutionJobDefinition(batch);
        Assert.assertTrue((boolean)migrationJobDefinition.isSuspended());
        Job migrationJob = this.helper.getExecutionJobs(batch).get(0);
        Assert.assertTrue((boolean)migrationJob.isSuspended());
    }

    @Test
    public void shouldCreateSuspendedExecutionJobs() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch.getId());
        this.helper.executeSeedJob(batch);
        Job migrationJob = this.helper.getExecutionJobs(batch).get(0);
        Assert.assertTrue((boolean)migrationJob.isSuspended());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldCreateUserOperationLogForBatchSuspension() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.suspendBatchById(batch.getId());
        this.identityService.clearAuthentication();
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)batch.getId(), (Object)entry.getBatchId());
        Assert.assertEquals((Object)"suspensionState", (Object)entry.getProperty());
        Assert.assertNull((Object)entry.getOrgValue());
        Assert.assertEquals((Object)SuspensionState.SUSPENDED.getName(), (Object)entry.getNewValue());
    }

    @Test
    public void shouldActivateBatch() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch.getId());
        this.managementService.activateBatchById(batch.getId());
        batch = (Batch)this.managementService.createBatchQuery().batchId(batch.getId()).singleResult();
        Assert.assertFalse((boolean)batch.isSuspended());
    }

    @Test
    public void shouldFailWhenActivatingUsingUnknownId() {
        try {
            this.managementService.activateBatchById("unknown");
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Batch for id 'unknown' cannot be found"));
        }
    }

    @Test
    public void shouldFailWhenActivatingUsingNullId() {
        try {
            this.managementService.activateBatchById(null);
            Assert.fail((String)"Exception expected");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"batch id is null"));
        }
    }

    @Test
    public void shouldActivateSeedJobAndDefinition() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch.getId());
        this.managementService.activateBatchById(batch.getId());
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertFalse((boolean)seedJobDefinition.isSuspended());
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertFalse((boolean)seedJob.isSuspended());
    }

    @Test
    public void shouldCreateActivatedSeedJob() {
        Batch batch = this.helper.migrateProcessInstancesAsync(2);
        this.helper.executeSeedJob(batch);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertFalse((boolean)seedJob.isSuspended());
    }

    @Test
    public void shouldActivateMonitorJobAndDefinition() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch.getId());
        this.helper.executeSeedJob(batch);
        this.managementService.activateBatchById(batch.getId());
        JobDefinition monitorJobDefinition = this.helper.getMonitorJobDefinition(batch);
        Assert.assertFalse((boolean)monitorJobDefinition.isSuspended());
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertFalse((boolean)monitorJob.isSuspended());
    }

    @Test
    public void shouldCreateActivatedMonitorJob() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.executeSeedJob(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertFalse((boolean)monitorJob.isSuspended());
    }

    @Test
    public void shouldActivateExecutionJobsAndDefinition() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch.getId());
        this.helper.executeSeedJob(batch);
        this.managementService.activateBatchById(batch.getId());
        JobDefinition migrationJobDefinition = this.helper.getExecutionJobDefinition(batch);
        Assert.assertFalse((boolean)migrationJobDefinition.isSuspended());
        Job migrationJob = this.helper.getExecutionJobs(batch).get(0);
        Assert.assertFalse((boolean)migrationJob.isSuspended());
    }

    @Test
    public void shouldCreateActivatedExecutionJobs() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.helper.executeSeedJob(batch);
        Job migrationJob = this.helper.getExecutionJobs(batch).get(0);
        Assert.assertFalse((boolean)migrationJob.isSuspended());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void shouldCreateUserOperationLogForBatchActivation() {
        Batch batch = this.helper.migrateProcessInstancesAsync(1);
        this.managementService.suspendBatchById(batch.getId());
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.activateBatchById(batch.getId());
        this.identityService.clearAuthentication();
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)batch.getId(), (Object)entry.getBatchId());
        Assert.assertEquals((Object)"suspensionState", (Object)entry.getProperty());
        Assert.assertNull((Object)entry.getOrgValue());
        Assert.assertEquals((Object)SuspensionState.ACTIVE.getName(), (Object)entry.getNewValue());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUserOperationLogQueryByBatchEntityType() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.suspendBatchById(batch1.getId());
        this.managementService.suspendBatchById(batch2.getId());
        this.managementService.activateBatchById(batch1.getId());
        this.identityService.clearAuthentication();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().entityType("Batch");
        Assert.assertEquals((long)3L, (long)query.count());
        Assert.assertEquals((long)3L, (long)query.list().size());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testUserOperationLogQueryByBatchId() {
        Batch batch1 = this.helper.migrateProcessInstancesAsync(1);
        Batch batch2 = this.helper.migrateProcessInstancesAsync(1);
        this.identityService.setAuthenticatedUserId(USER_ID);
        this.managementService.suspendBatchById(batch1.getId());
        this.managementService.suspendBatchById(batch2.getId());
        this.managementService.activateBatchById(batch1.getId());
        this.identityService.clearAuthentication();
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().batchId(batch1.getId());
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertEquals((long)2L, (long)query.list().size());
        query = this.historyService.createUserOperationLogQuery().batchId(batch2.getId());
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((long)1L, (long)query.list().size());
    }
}

