/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.google.gson.Gson;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.telemetry.dto.Data;
import org.camunda.bpm.engine.impl.telemetry.dto.Database;
import org.camunda.bpm.engine.impl.telemetry.dto.Internals;
import org.camunda.bpm.engine.impl.telemetry.dto.Product;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TelemetryReporterTest {
    protected static final String TELEMETRY_ENDPOINT = "http://localhost:8082/pings";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public WireMockRule wireMockRule = new WireMockRule(8082);
    protected ProcessEngineConfigurationImpl configuration;
    protected ManagementService managementService;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.configuration.getManagementService();
    }

    @After
    public void tearDown() {
        this.managementService.toggleTelemetry(false);
    }

    @Test
    public void shouldSendTelemetry() {
        this.managementService.toggleTelemetry(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT)).willReturn(WireMock.aResponse().withStatus(202)));
        Data data = this.createDataToSend();
        TelemetryReporter telemetryReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, data, (HttpClient)HttpClientBuilder.create().build());
        telemetryReporter.reportNow();
        String requestBody = new Gson().toJson((Object)data);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/pings")).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldReportDataWhenTelemetryInitialized() {
        Data data = this.createDataToSend();
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setTelemetryEndpoint(TELEMETRY_ENDPOINT).setInitializeTelemetry(true).setTelemetryData(data).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)TELEMETRY_ENDPOINT)).willReturn(WireMock.aResponse().withStatus(202)));
        processEngineConfiguration.buildProcessEngine();
        processEngineConfiguration.getTelemetryReporter().reportNow();
        String requestBody = new Gson().toJson((Object)data);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/pings")).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogTelemetrySent() throws ClientProtocolException, IOException {
        this.managementService.toggleTelemetry(true);
        HttpClient mockedClient = (HttpClient)Mockito.mock(HttpClient.class);
        TelemetryReporter telemetryReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, this.createDataToSend(), mockedClient);
        HttpResponse mockedResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)mockedClient.execute((HttpUriRequest)Matchers.any())).thenReturn((Object)mockedResponse);
        StatusLine mockedStatus = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)mockedResponse.getStatusLine()).thenReturn((Object)mockedStatus);
        Mockito.when((Object)mockedStatus.getStatusCode()).thenReturn((Object)202);
        telemetryReporter.reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Start telemetry sending task").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Telemetry data sent").size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogUnexpectedResponse() throws ClientProtocolException, IOException {
        this.managementService.toggleTelemetry(true);
        HttpClient mockedClient = (HttpClient)Mockito.mock(HttpClient.class);
        TelemetryReporter telemetryReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, this.createDataToSend(), mockedClient);
        Mockito.when((Object)mockedClient.execute((HttpUriRequest)Matchers.any())).thenReturn(null);
        telemetryReporter.reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Unexpect response while sending telemetry data").size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogTelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Sending telemetry is disabled").size()).isPositive();
    }

    protected Data createDataToSend() {
        Database database = new Database("mySpecialDb", "v.1.2.3");
        Internals internals = new Internals(database);
        Product product = new Product("Runtime", "7.14", "special", internals);
        Data data = new Data("f5b19e2e-b49a-11ea-b3de-0242ac130004", product);
        return data;
    }
}

