/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.BatchModificationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.bpmn.multiinstance.DelegateEvent;
import org.camunda.bpm.engine.test.bpmn.multiinstance.DelegateExecutionListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ModificationExecutionAsyncTest {
    protected static final Date START_DATE = new Date(1457326800000L);
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.rule);
    protected BatchModificationHelper helper = new BatchModificationHelper(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);
    protected ProcessEngineConfigurationImpl configuration;
    protected RuntimeService runtimeService;
    protected BpmnModelInstance instance;
    private int defaultBatchJobsPerSeed;
    private int defaultInvocationsPerBatchJob;
    private boolean defaultEnsureJobDueDateSet;
    @Parameterized.Parameter(value=0)
    public boolean ensureJobDueDateSet;
    @Parameterized.Parameter(value=1)
    public Date currentTime;

    @Parameterized.Parameters(name="Job DueDate is set: {0}")
    public static Collection<Object[]> scenarios() throws ParseException {
        return Arrays.asList({false, null}, {true, START_DATE});
    }

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
    }

    @Before
    public void setClock() {
        ClockUtil.setCurrentTime((Date)START_DATE);
    }

    @Before
    public void storeEngineSettings() {
        this.configuration = this.rule.getProcessEngineConfiguration();
        this.defaultBatchJobsPerSeed = this.configuration.getBatchJobsPerSeed();
        this.defaultInvocationsPerBatchJob = this.configuration.getInvocationsPerBatchJob();
        this.defaultEnsureJobDueDateSet = this.configuration.isEnsureJobDueDateNotNull();
        this.configuration.setEnsureJobDueDateNotNull(this.ensureJobDueDateSet);
    }

    @Before
    public void createBpmnModelInstance() {
        this.instance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").userTask("user1").sequenceFlowId("seq")).userTask("user2").endEvent("end").done();
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @After
    public void restoreEngineSettings() {
        this.configuration.setBatchJobsPerSeed(this.defaultBatchJobsPerSeed);
        this.configuration.setInvocationsPerBatchJob(this.defaultInvocationsPerBatchJob);
        this.configuration.setEnsureJobDueDateNotNull(this.defaultEnsureJobDueDateSet);
    }

    @After
    public void removeInstanceIds() {
        this.helper.currentProcessInstances = new ArrayList<String>();
    }

    @After
    public void removeBatches() {
        this.helper.removeAllRunningAndHistoricBatches();
    }

    @Test
    public void createBatchModification() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> processInstanceIds = this.helper.startInstances("process1", 2);
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startAfterActivity("user2")).processInstanceIds(processInstanceIds).executeAsync();
        this.assertBatchCreated(batch, 2);
    }

    @Test
    public void createModificationWithNullProcessInstanceIdsListAsync() {
        try {
            ((ModificationBuilder)this.runtimeService.createModification("processDefinitionId").startAfterActivity("user1")).processInstanceIds((List)null).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Process instance ids is empty"));
        }
    }

    @Test
    public void createModificationWithNullProcessDefinitionId() {
        try {
            this.runtimeService.createModification(null).cancelAllForActivity("activityId").processInstanceIds(Arrays.asList("20", "1--0")).executeAsync();
            Assert.fail((String)"Should not succed");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"processDefinitionId is null"));
        }
    }

    @Test
    public void createModificationUsingProcessInstanceIdsListWithNullValueAsync() {
        try {
            ((ModificationBuilder)this.runtimeService.createModification("processDefinitionId").startAfterActivity("user1")).processInstanceIds(Arrays.asList("foo", null, "bar")).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Process instance ids contains null value"));
        }
    }

    @Test
    public void createModificationWithEmptyProcessInstanceIdsListAsync() {
        try {
            ((ModificationBuilder)this.runtimeService.createModification("processDefinitionId").startAfterActivity("user1")).processInstanceIds(Collections.emptyList()).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Process instance ids is empty"));
        }
    }

    @Test
    public void createModificationWithNullProcessInstanceIdsArrayAsync() {
        try {
            ((ModificationBuilder)this.runtimeService.createModification("processDefinitionId").startAfterActivity("user1")).processInstanceIds((String[])null).executeAsync();
            Assert.fail((String)"Should not be able to modify");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Process instance ids is empty"));
        }
    }

    @Test
    public void createModificationUsingProcessInstanceIdsArrayWithNullValueAsync() {
        try {
            this.runtimeService.createModification("processDefinitionId").cancelAllForActivity("user1").processInstanceIds(new String[]{"foo", null, "bar"}).executeAsync();
            Assert.fail((String)"Should not be able to modify");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Process instance ids contains null value"));
        }
    }

    @Test
    public void testNullProcessInstanceQueryAsync() {
        try {
            ((ModificationBuilder)this.runtimeService.createModification("processDefinitionId").startAfterActivity("user1")).processInstanceQuery(null).executeAsync();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Process instance ids is empty"));
        }
    }

    @Test
    public void createModificationWithNonExistingProcessDefinitionId() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        deployment.getDeployedProcessDefinitions().get(0);
        List<String> processInstanceIds = this.helper.startInstances("process1", 2);
        try {
            this.runtimeService.createModification("foo").cancelAllForActivity("activityId").processInstanceIds(processInstanceIds).executeAsync();
            Assert.fail((String)"Should not succed");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"processDefinition is null"));
        }
    }

    @Test
    public void createSeedJob() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startAfterAsync("process1", 3, "user1", processDefinition.getId());
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Assert.assertEquals((Object)batch.getId(), (Object)seedJobDefinition.getJobConfiguration());
        Assert.assertEquals((Object)"batch-seed-job", (Object)seedJobDefinition.getJobType());
        Assert.assertEquals((Object)seedJobDefinition.getDeploymentId(), (Object)processDefinition.getDeploymentId());
        JobDefinition modificationJobDefinition = this.helper.getExecutionJobDefinition(batch);
        Assert.assertNotNull((Object)modificationJobDefinition);
        Assert.assertEquals((Object)"instance-modification", (Object)modificationJobDefinition.getJobType());
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNotNull((Object)seedJob);
        Assert.assertEquals((Object)seedJobDefinition.getId(), (Object)seedJob.getJobDefinitionId());
        Assert.assertEquals((Object)this.currentTime, (Object)seedJob.getDuedate());
        Assert.assertEquals((Object)seedJobDefinition.getDeploymentId(), (Object)seedJob.getDeploymentId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionId());
        Assert.assertNull((Object)seedJob.getProcessDefinitionKey());
        Assert.assertNull((Object)seedJob.getProcessInstanceId());
        Assert.assertNull((Object)seedJob.getExecutionId());
        List<Job> modificationJobs = this.helper.getExecutionJobs(batch);
        Assert.assertEquals((long)0L, (long)modificationJobs.size());
    }

    @Test
    public void createModificationJobs() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        this.rule.getProcessEngineConfiguration().setBatchJobsPerSeed(10);
        Batch batch = this.helper.startAfterAsync("process1", 20, "user1", processDefinition.getId());
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        JobDefinition modificationJobDefinition = this.helper.getExecutionJobDefinition(batch);
        this.helper.executeSeedJob(batch);
        List<Job> modificationJobs = this.helper.getJobsForDefinition(modificationJobDefinition);
        Assert.assertEquals((long)10L, (long)modificationJobs.size());
        for (Job modificationJob : modificationJobs) {
            Assert.assertEquals((Object)modificationJobDefinition.getId(), (Object)modificationJob.getJobDefinitionId());
            Assert.assertEquals((Object)this.currentTime, (Object)modificationJob.getDuedate());
            Assert.assertNull((Object)modificationJob.getProcessDefinitionId());
            Assert.assertNull((Object)modificationJob.getProcessDefinitionKey());
            Assert.assertNull((Object)modificationJob.getProcessInstanceId());
            Assert.assertNull((Object)modificationJob.getExecutionId());
        }
        Job seedJob = this.helper.getJobForDefinition(seedJobDefinition);
        Assert.assertNotNull((Object)seedJob);
    }

    @Test
    public void createMonitorJob() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startAfterAsync("process1", 10, "user1", processDefinition.getId());
        this.helper.completeSeedJobs(batch);
        JobDefinition seedJobDefinition = this.helper.getSeedJobDefinition(batch);
        Assert.assertNotNull((Object)seedJobDefinition);
        Job seedJob = this.helper.getSeedJob(batch);
        Assert.assertNull((Object)seedJob);
        JobDefinition monitorJobDefinition = this.helper.getMonitorJobDefinition(batch);
        Assert.assertNotNull((Object)monitorJobDefinition);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertNotNull((Object)monitorJob);
    }

    @Test
    public void executeModificationJobsForStartAfter() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition processDefinition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        Batch batch = this.helper.startAfterAsync("process1", 10, "user1", processDefinition.getId());
        this.helper.completeSeedJobs(batch);
        List<Job> modificationJobs = this.helper.getExecutionJobs(batch);
        for (Job modificationJob : modificationJobs) {
            this.helper.executeJob(modificationJob);
        }
        for (String processInstanceId : this.helper.currentProcessInstances) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNotNull((Object)updatedTree);
            Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("user1").activity("user2").done());
        }
        Assert.assertEquals((long)0L, (long)this.helper.getExecutionJobs(batch).size());
        Assert.assertNotNull((Object)this.helper.getMonitorJob(batch));
    }

    @Test
    public void executeModificationJobsForStartBefore() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition processDefinition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        Batch batch = this.helper.startBeforeAsync("process1", 10, "user2", processDefinition.getId());
        this.helper.completeSeedJobs(batch);
        List<Job> modificationJobs = this.helper.getExecutionJobs(batch);
        for (Job modificationJob : modificationJobs) {
            this.helper.executeJob(modificationJob);
        }
        for (String processInstanceId : this.helper.currentProcessInstances) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNotNull((Object)updatedTree);
            Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("user1").activity("user2").done());
        }
        Assert.assertEquals((long)0L, (long)this.helper.getExecutionJobs(batch).size());
        Assert.assertNotNull((Object)this.helper.getMonitorJob(batch));
    }

    @Test
    public void executeModificationJobsForStartTransition() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition processDefinition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        Batch batch = this.helper.startTransitionAsync("process1", 10, "seq", processDefinition.getId());
        this.helper.completeSeedJobs(batch);
        List<Job> modificationJobs = this.helper.getExecutionJobs(batch);
        for (Job modificationJob : modificationJobs) {
            this.helper.executeJob(modificationJob);
        }
        for (String processInstanceId : this.helper.currentProcessInstances) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNotNull((Object)updatedTree);
            Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("user1").activity("user2").done());
        }
        Assert.assertEquals((long)0L, (long)this.helper.getExecutionJobs(batch).size());
        Assert.assertNotNull((Object)this.helper.getMonitorJob(batch));
    }

    @Test
    public void executeModificationJobsForCancelAll() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.cancelAllAsync("process1", 10, "user1", processDefinition.getId());
        this.helper.completeSeedJobs(batch);
        List<Job> modificationJobs = this.helper.getExecutionJobs(batch);
        for (Job modificationJob : modificationJobs) {
            this.helper.executeJob(modificationJob);
        }
        for (String processInstanceId : this.helper.currentProcessInstances) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNull((Object)updatedTree);
        }
        Assert.assertEquals((long)0L, (long)this.helper.getExecutionJobs(batch).size());
        Assert.assertNotNull((Object)this.helper.getMonitorJob(batch));
    }

    @Test
    public void executeModificationJobsForStartAfterAndCancelAll() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition processDefinition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        List<String> instances = this.helper.startInstances("process1", 10);
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startAfterActivity("user1")).cancelAllForActivity("user1").processInstanceIds(instances).executeAsync();
        this.helper.completeSeedJobs(batch);
        List<Job> modificationJobs = this.helper.getExecutionJobs(batch);
        for (Job modificationJob : modificationJobs) {
            this.helper.executeJob(modificationJob);
        }
        for (String processInstanceId : this.helper.currentProcessInstances) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNotNull((Object)updatedTree);
            Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("user2").done());
        }
        Assert.assertEquals((long)0L, (long)this.helper.getExecutionJobs(batch).size());
        Assert.assertNotNull((Object)this.helper.getMonitorJob(batch));
    }

    @Test
    public void executeModificationJobsForStartBeforeAndCancelAll() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> instances = this.helper.startInstances("process1", 10);
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("user1")).cancelAllForActivity("user1").processInstanceIds(instances).executeAsync();
        this.helper.completeSeedJobs(batch);
        List<Job> modificationJobs = this.helper.getExecutionJobs(batch);
        for (Job modificationJob : modificationJobs) {
            this.helper.executeJob(modificationJob);
        }
        for (String processInstanceId : this.helper.currentProcessInstances) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNull((Object)updatedTree);
        }
        Assert.assertEquals((long)0L, (long)this.helper.getExecutionJobs(batch).size());
        Assert.assertNotNull((Object)this.helper.getMonitorJob(batch));
    }

    @Test
    public void executeModificationJobsForStartTransitionAndCancelAll() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition processDefinition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        List<String> instances = this.helper.startInstances("process1", 10);
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startTransition("seq")).cancelAllForActivity("user1").processInstanceIds(instances).executeAsync();
        this.helper.completeSeedJobs(batch);
        List<Job> modificationJobs = this.helper.getExecutionJobs(batch);
        for (Job modificationJob : modificationJobs) {
            this.helper.executeJob(modificationJob);
        }
        for (String processInstanceId : this.helper.currentProcessInstances) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNotNull((Object)updatedTree);
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("user2").done());
        }
        Assert.assertEquals((long)0L, (long)this.helper.getExecutionJobs(batch).size());
        Assert.assertNotNull((Object)this.helper.getMonitorJob(batch));
    }

    @Test
    public void executeModificationJobsForProcessInstancesWithDifferentStates() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition processDefinition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        List<String> processInstanceIds = this.helper.startInstances("process1", 1);
        Task task = (Task)this.rule.getTaskService().createTaskQuery().singleResult();
        this.rule.getTaskService().complete(task.getId());
        List<String> anotherProcessInstanceIds = this.helper.startInstances("process1", 1);
        processInstanceIds.addAll(anotherProcessInstanceIds);
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("user2")).processInstanceIds(processInstanceIds).executeAsync();
        this.helper.completeSeedJobs(batch);
        List<Job> modificationJobs = this.helper.getExecutionJobs(batch);
        for (Job modificationJob : modificationJobs) {
            this.helper.executeJob(modificationJob);
        }
        ActivityInstance updatedTree = null;
        String processInstanceId = processInstanceIds.get(0);
        updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("user2").activity("user2").done());
        processInstanceId = processInstanceIds.get(1);
        updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("user1").activity("user2").done());
        Assert.assertEquals((long)0L, (long)this.helper.getExecutionJobs(batch).size());
        Assert.assertNotNull((Object)this.helper.getMonitorJob(batch));
    }

    @Test
    public void testMonitorJobPollingForCompletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startAfterAsync("process1", 3, "user1", processDefinition.getId());
        Date createDate = START_DATE;
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        Assert.assertNotNull((Object)monitorJob);
        Assert.assertEquals((Object)this.currentTime, (Object)monitorJob.getDuedate());
        this.helper.executeMonitorJob(batch);
        monitorJob = this.helper.getMonitorJob(batch);
        Date dueDate = this.helper.addSeconds(createDate, 30);
        Assert.assertEquals((Object)dueDate, (Object)monitorJob.getDuedate());
    }

    @Test
    public void testMonitorJobRemovesBatchAfterCompletion() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startBeforeAsync("process1", 10, "user2", processDefinition.getId());
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        this.helper.executeMonitorJob(batch);
        Assert.assertEquals((long)0L, (long)this.rule.getManagementService().createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.rule.getManagementService().createJobQuery().count());
    }

    @Test
    public void testBatchDeletionWithCascade() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startTransitionAsync("process1", 10, "seq", processDefinition.getId());
        this.helper.completeSeedJobs(batch);
        this.rule.getManagementService().deleteBatch(batch.getId(), true);
        Assert.assertEquals((long)0L, (long)this.rule.getManagementService().createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.rule.getManagementService().createJobDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.rule.getManagementService().createJobQuery().count());
    }

    @Test
    public void testBatchDeletionWithoutCascade() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startBeforeAsync("process1", 10, "user2", processDefinition.getId());
        this.helper.completeSeedJobs(batch);
        this.rule.getManagementService().deleteBatch(batch.getId(), false);
        Assert.assertEquals((long)0L, (long)this.rule.getManagementService().createBatchQuery().count());
        Assert.assertEquals((long)0L, (long)this.rule.getManagementService().createJobDefinitionQuery().count());
        Assert.assertEquals((long)0L, (long)this.rule.getManagementService().createJobQuery().count());
    }

    @Test
    public void testBatchWithFailedSeedJobDeletionWithCascade() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.cancelAllAsync("process1", 2, "user1", processDefinition.getId());
        Job seedJob = this.helper.getSeedJob(batch);
        this.rule.getManagementService().setJobRetries(seedJob.getId(), 0);
        this.rule.getManagementService().deleteBatch(batch.getId(), true);
        long historicIncidents = this.rule.getHistoryService().createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    @Test
    public void testBatchWithFailedModificationJobDeletionWithCascade() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startAfterAsync("process1", 2, "user1", processDefinition.getId());
        this.helper.completeSeedJobs(batch);
        List<Job> modificationJobs = this.helper.getExecutionJobs(batch);
        for (Job modificationJob : modificationJobs) {
            this.rule.getManagementService().setJobRetries(modificationJob.getId(), 0);
        }
        this.rule.getManagementService().deleteBatch(batch.getId(), true);
        long historicIncidents = this.rule.getHistoryService().createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    @Test
    public void testBatchWithFailedMonitorJobDeletionWithCascade() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        Batch batch = this.helper.startBeforeAsync("process1", 2, "user2", processDefinition.getId());
        this.helper.completeSeedJobs(batch);
        Job monitorJob = this.helper.getMonitorJob(batch);
        this.rule.getManagementService().setJobRetries(monitorJob.getId(), 0);
        this.rule.getManagementService().deleteBatch(batch.getId(), true);
        long historicIncidents = this.rule.getHistoryService().createHistoricIncidentQuery().count();
        Assert.assertEquals((long)0L, (long)historicIncidents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModificationJobsExecutionByJobExecutorWithAuthorizationEnabledAndTenant() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.rule.getProcessEngineConfiguration();
        processEngineConfiguration.setAuthorizationEnabled(true);
        ProcessDefinition processDefinition = this.testRule.deployForTenantAndGetDefinition("tenantId", this.instance);
        try {
            Batch batch = this.helper.startAfterAsync("process1", 10, "user1", processDefinition.getId());
            this.helper.completeSeedJobs(batch);
            this.testRule.executeAvailableJobs();
            for (String processInstanceId : this.helper.currentProcessInstances) {
                ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
                Assert.assertNotNull((Object)updatedTree);
                Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
                ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("user1").activity("user2").done());
            }
        }
        finally {
            processEngineConfiguration.setAuthorizationEnabled(false);
        }
    }

    @Test
    public void testBatchExecutionFailureWithMissingProcessInstance() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition processDefinition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        Batch batch = this.helper.startAfterAsync("process1", 2, "user1", processDefinition.getId());
        this.helper.completeSeedJobs(batch);
        List processInstances = this.runtimeService.createProcessInstanceQuery().list();
        String deletedProcessInstanceId = ((ProcessInstance)processInstances.get(0)).getId();
        this.runtimeService.deleteProcessInstance(deletedProcessInstanceId, "test");
        this.helper.executeJobs(batch);
        for (String processInstanceId : this.helper.currentProcessInstances) {
            ActivityInstance updatedTree;
            if (processInstanceId.equals(this.helper.currentProcessInstances.get(0))) {
                updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
                Assert.assertNull((Object)updatedTree);
                continue;
            }
            updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNotNull((Object)updatedTree);
            Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processDefinition.getId()).activity("user1").activity("user2").done());
        }
        List<Job> modificationJobs = this.helper.getExecutionJobs(batch);
        Assert.assertEquals((long)1L, (long)modificationJobs.size());
        Job failedJob = modificationJobs.get(0);
        Assert.assertEquals((long)2L, (long)failedJob.getRetries());
        Assert.assertThat((Object)failedJob.getExceptionMessage(), (Matcher)CoreMatchers.startsWith((String)"ENGINE-13036"));
        Assert.assertThat((Object)failedJob.getExceptionMessage(), (Matcher)CoreMatchers.containsString((String)("Process instance '" + deletedProcessInstanceId + "' cannot be modified")));
    }

    @Test
    public void testBatchCreationWithProcessInstanceQuery() {
        int processInstanceCount = 15;
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition processDefinition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        this.helper.startInstances("process1", 15);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId());
        Assert.assertEquals((long)processInstanceCount, (long)processInstanceQuery.count());
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startAfterActivity("user1")).processInstanceQuery(processInstanceQuery).executeAsync();
        this.assertBatchCreated(batch, processInstanceCount);
    }

    @Test
    public void testBatchCreationWithOverlappingProcessInstanceIdsAndQuery() {
        int processInstanceCount = 15;
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition processDefinition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        List<String> processInstanceIds = this.helper.startInstances("process1", 15);
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId());
        Assert.assertEquals((long)processInstanceCount, (long)processInstanceQuery.count());
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startTransition("seq")).processInstanceIds(processInstanceIds).processInstanceQuery(processInstanceQuery).executeAsync();
        this.assertBatchCreated(batch, processInstanceCount);
    }

    @Test
    public void testListenerInvocation() {
        DelegateEvent.clearEvents();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(this.instance).activityBuilder("user2").camundaExecutionListenerClass("start", DelegateExecutionListener.class.getName()).done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("user2")).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        List<DelegateEvent> recordedEvents = DelegateEvent.getEvents();
        Assert.assertEquals((long)1L, (long)recordedEvents.size());
        DelegateEvent event = recordedEvents.get(0);
        Assert.assertEquals((Object)processDefinition.getId(), (Object)event.getProcessDefinitionId());
        Assert.assertEquals((Object)"user2", (Object)event.getCurrentActivityId());
        DelegateEvent.clearEvents();
    }

    @Test
    public void testSkipListenerInvocationF() {
        DelegateEvent.clearEvents();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(this.instance).activityBuilder("user2").camundaExecutionListenerClass("start", DelegateExecutionListener.class.getName()).done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Batch batch = this.runtimeService.createModification(processDefinition.getId()).cancelAllForActivity("user2").processInstanceIds(Arrays.asList(processInstance.getId())).skipCustomListeners().executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        Assert.assertEquals((long)0L, (long)DelegateEvent.getEvents().size());
    }

    @Test
    public void testIoMappingInvocation() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(this.instance).activityBuilder("user1").camundaInputParameter("foo", "bar").done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startAfterActivity("user2")).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        VariableInstance inputVariable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertNotNull((Object)inputVariable);
        Assert.assertEquals((Object)"foo", (Object)inputVariable.getName());
        Assert.assertEquals((Object)"bar", (Object)inputVariable.getValue());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(processInstance.getId());
        Assert.assertEquals((Object)activityInstance.getActivityInstances("user1")[0].getId(), (Object)inputVariable.getActivityInstanceId());
    }

    @Test
    public void testSkipIoMappingInvocation() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(ModifiableBpmnModelInstance.modify(this.instance).activityBuilder("user2").camundaInputParameter("foo", "bar").done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId());
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("user2")).processInstanceIds(Arrays.asList(processInstance.getId())).skipIoMappings().executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    @Test
    public void testCancelWithoutFlag() {
        this.instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").serviceTask("ser").camundaExpression("${true}")).userTask("user").endEvent("end").done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> processInstanceIds = this.helper.startInstances("process1", 1);
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("ser")).cancelAllForActivity("user").processInstanceIds(processInstanceIds).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().list().size());
    }

    @Test
    public void testCancelWithoutFlag2() {
        this.instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").serviceTask("ser").camundaExpression("${true}")).userTask("user").endEvent("end").done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> processInstanceIds = this.helper.startInstances("process1", 1);
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("ser")).cancelAllForActivity("user", false).processInstanceIds(processInstanceIds).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().list().size());
    }

    @Test
    public void testCancelWithFlag() {
        this.instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").serviceTask("ser").camundaExpression("${true}")).userTask("user").endEvent("end").done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> processInstanceIds = this.helper.startInstances("process1", 1);
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("ser")).cancelAllForActivity("user", true).processInstanceIds(processInstanceIds).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)"user", (Object)execution.getActivityId());
    }

    @Test
    public void testCancelWithFlagForManyInstances() {
        this.instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").serviceTask("ser").camundaExpression("${true}")).userTask("user").endEvent("end").done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> processInstanceIds = this.helper.startInstances("process1", 10);
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("ser")).cancelAllForActivity("user", true).processInstanceIds(processInstanceIds).executeAsync();
        this.helper.completeSeedJobs(batch);
        this.helper.executeJobs(batch);
        for (String processInstanceId : processInstanceIds) {
            Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).singleResult();
            Assert.assertNotNull((Object)execution);
            Assert.assertEquals((Object)"user", (Object)((ExecutionEntity)execution).getActivityId());
        }
    }

    @Test
    public void shouldSetInvocationsPerBatchType() {
        this.configuration.getInvocationsPerBatchJobByBatchType().put("instance-modification", 42);
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> processInstanceIds = this.helper.startInstances("process1", 2);
        Batch batch = ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startAfterActivity("user2")).processInstanceIds(processInstanceIds).executeAsync();
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.configuration.setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    protected void assertBatchCreated(Batch batch, int processInstanceCount) {
        Assert.assertNotNull((Object)batch);
        Assert.assertNotNull((Object)batch.getId());
        Assert.assertEquals((Object)"instance-modification", (Object)batch.getType());
        Assert.assertEquals((long)processInstanceCount, (long)batch.getTotalJobs());
        Assert.assertEquals((long)this.defaultBatchJobsPerSeed, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)this.defaultInvocationsPerBatchJob, (long)batch.getInvocationsPerBatchJob());
    }
}

