/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.callactivity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.EventSubscriptionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.callactivity.MyVersionDelegate;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.CallActivity;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaIn;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaOut;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class CallActivityTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSimpleSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        this.taskService.complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcessParentVariableAccess.bpmn20.xml"})
    public void testAccessSuperInstanceVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        CallActivityTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "greeting"));
        this.taskService.complete(taskBeforeSubProcess.getId());
        CallActivityTest.assertEquals((Object)"hello", (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/concurrentSubProcessParentVariableAccess.bpmn20.xml"})
    public void testAccessSuperInstanceVariablesFromConcurrentExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        CallActivityTest.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "greeting"));
        this.taskService.complete(taskBeforeSubProcess.getId());
        CallActivityTest.assertEquals((Object)"hello", (Object)this.runtimeService.getVariable(processInstance.getId(), "greeting"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcessWithExpressions.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSimpleSubProcessWithExpressions() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.setVariable(taskBeforeSubProcess.getId(), "simpleSubProcessExpression", (Object)"simpleSubProcess");
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        this.taskService.complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessEndsSuperProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessEndsSuperProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessEndsSuperProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.complete(taskBeforeSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallParallelSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleParallelSubProcess.bpmn20.xml"})
    public void testCallParallelSubProcess() {
        this.runtimeService.startProcessInstanceByKey("callParallelSubProcess");
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        List tasks = taskQuery.list();
        CallActivityTest.assertEquals((int)2, (int)tasks.size());
        Task taskA = (Task)tasks.get(0);
        Task taskB = (Task)tasks.get(1);
        CallActivityTest.assertEquals((String)"Task A", (String)taskA.getName());
        CallActivityTest.assertEquals((String)"Task B", (String)taskB.getName());
        this.taskService.complete(taskA.getId());
        CallActivityTest.assertEquals((int)1, (int)taskQuery.list().size());
        this.taskService.complete(taskB.getId());
        CallActivityTest.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSequentialSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcessWithExpressions.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess2.bpmn20.xml"})
    public void testCallSequentialSubProcessWithExpressions() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSequentialSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.setVariable(taskBeforeSubProcess.getId(), "simpleSubProcessExpression", (Object)"simpleSubProcess");
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        this.taskService.complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.setVariable(taskBeforeSubProcess.getId(), "simpleSubProcessExpression", (Object)"simpleSubProcess2");
        this.taskService.complete(taskBeforeSubProcess.getId());
        taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess 2", (String)taskInSubProcess.getName());
        this.taskService.complete(taskInSubProcess.getId());
        taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testTimerOnCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testTimerOnCallActivity() {
        this.runtimeService.startProcessInstanceByKey("timerOnCallActivity");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        CallActivityTest.assertNotNull((Object)timer);
        this.managementService.executeJob(timer.getId());
        Task escalatedTask = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Escalated Task", (String)escalatedTask.getName());
        this.taskService.complete(escalatedTask.getId());
        CallActivityTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataInputOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessWithDataInputOutput() {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("superVariable", "Hello from the super process.");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskBeforeSubProcess.getName());
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskBeforeSubProcess.getProcessInstanceId(), "subVariable"));
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.taskService.getVariable(taskBeforeSubProcess.getId(), "subVariable"));
        this.runtimeService.setVariable(taskBeforeSubProcess.getProcessInstanceId(), "subVariable", (Object)"Hello from sub process.");
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "superVariable"));
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in super process", (String)taskAfterSubProcess.getName());
        CallActivityTest.assertEquals((Object)"Hello from sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Hello from sub process.", (Object)this.taskService.getVariable(taskAfterSubProcess.getId(), "superVariable"));
        vars.clear();
        vars.put("x", new Long(5L));
        this.taskService.complete(taskAfterSubProcess.getId(), vars);
        Task taskInSecondSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskInSecondSubProcess.getName());
        CallActivityTest.assertEquals((Object)10L, (Object)this.runtimeService.getVariable(taskInSecondSubProcess.getProcessInstanceId(), "y"));
        CallActivityTest.assertEquals((Object)10L, (Object)this.taskService.getVariable(taskInSecondSubProcess.getId(), "y"));
        this.taskService.complete(taskInSecondSubProcess.getId());
        Task taskAfterSecondSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in super process", (String)taskAfterSecondSubProcess.getName());
        CallActivityTest.assertEquals((Object)15L, (Object)this.runtimeService.getVariable(taskAfterSecondSubProcess.getProcessInstanceId(), "z"));
        CallActivityTest.assertEquals((Object)15L, (Object)this.taskService.getVariable(taskAfterSecondSubProcess.getId(), "z"));
        this.taskService.complete(taskAfterSecondSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessLimitedDataInputOutputTypedApi.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessWithLimitedDataInputOutputTypedApi() {
        StringValue superVariable = Variables.stringValue(null);
        VariableMap vars = Variables.createVariables();
        vars.putValueTyped("superVariable", (TypedValue)superVariable);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput", (Map)vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        Assert.assertThat((Object)taskInSubProcess.getName(), (Matcher)CoreMatchers.is((Object)"Task in subprocess"));
        Assert.assertThat((Object)this.runtimeService.getVariableTyped(taskInSubProcess.getProcessInstanceId(), "subVariable"), (Matcher)CoreMatchers.is((Object)superVariable));
        Assert.assertThat((Object)this.taskService.getVariableTyped(taskInSubProcess.getId(), "subVariable"), (Matcher)CoreMatchers.is((Object)superVariable));
        StringValue subVariable = Variables.stringValue(null);
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "subVariable", (Object)subVariable);
        Assert.assertThat((Object)this.runtimeService.getVariableTyped(processInstance.getId(), "superVariable"), (Matcher)CoreMatchers.is((Object)superVariable));
        this.taskService.complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        Assert.assertThat((Object)taskAfterSubProcess.getName(), (Matcher)CoreMatchers.is((Object)"Task in super process"));
        Assert.assertThat((Object)this.runtimeService.getVariableTyped(processInstance.getId(), "superVariable"), (Matcher)CoreMatchers.is((Object)subVariable));
        Assert.assertThat((Object)this.taskService.getVariableTyped(taskAfterSubProcess.getId(), "superVariable"), (Matcher)CoreMatchers.is((Object)subVariable));
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessAllDataInputOutputTypedApi.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessWithAllDataInputOutputTypedApi() {
        StringValue superVariable = Variables.stringValue(null);
        VariableMap vars = Variables.createVariables();
        vars.putValueTyped("superVariable", (TypedValue)superVariable);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput", (Map)vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        Assert.assertThat((Object)taskInSubProcess.getName(), (Matcher)CoreMatchers.is((Object)"Task in subprocess"));
        Assert.assertThat((Object)this.runtimeService.getVariableTyped(taskInSubProcess.getProcessInstanceId(), "superVariable"), (Matcher)CoreMatchers.is((Object)superVariable));
        Assert.assertThat((Object)this.taskService.getVariableTyped(taskInSubProcess.getId(), "superVariable"), (Matcher)CoreMatchers.is((Object)superVariable));
        StringValue subVariable = Variables.stringValue(null);
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "subVariable", (Object)subVariable);
        this.taskService.complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        Assert.assertThat((Object)taskAfterSubProcess.getName(), (Matcher)CoreMatchers.is((Object)"Task in super process"));
        Assert.assertThat((Object)this.runtimeService.getVariableTyped(processInstance.getId(), "subVariable"), (Matcher)CoreMatchers.is((Object)subVariable));
        Assert.assertThat((Object)this.taskService.getVariableTyped(taskAfterSubProcess.getId(), "superVariable"), (Matcher)CoreMatchers.is((Object)superVariable));
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    public void testSubProcessWithDataInputOutputWithoutTarget() {
        String processId = "subProcessDataInputOutputWithoutTarget";
        BpmnModelInstance modelInstance = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().callActivity("callActivity").calledElement("simpleSubProcess")).userTask().endEvent().done();
        CallActivityBuilder callActivityBuilder = ((CallActivity)modelInstance.getModelElementById("callActivity")).builder();
        CamundaIn camundaIn = (CamundaIn)modelInstance.newInstance(CamundaIn.class);
        camundaIn.setCamundaSource("superVariable");
        callActivityBuilder.addExtensionElement((BpmnModelElementInstance)camundaIn);
        this.deployAndExpectException(modelInstance);
        camundaIn.setCamundaTarget("subVariable");
        camundaIn = (CamundaIn)modelInstance.newInstance(CamundaIn.class);
        camundaIn.setCamundaSourceExpression("${x+5}");
        callActivityBuilder.addExtensionElement((BpmnModelElementInstance)camundaIn);
        this.deployAndExpectException(modelInstance);
        camundaIn.setCamundaTarget("subVariable2");
        CamundaOut camundaOut = (CamundaOut)modelInstance.newInstance(CamundaOut.class);
        camundaOut.setCamundaSource("subVariable");
        callActivityBuilder.addExtensionElement((BpmnModelElementInstance)camundaOut);
        this.deployAndExpectException(modelInstance);
        camundaOut.setCamundaTarget("superVariable");
        camundaOut = (CamundaOut)modelInstance.newInstance(CamundaOut.class);
        camundaOut.setCamundaSourceExpression("${y+1}");
        callActivityBuilder.addExtensionElement((BpmnModelElementInstance)camundaOut);
        this.deployAndExpectException(modelInstance);
        camundaOut.setCamundaTarget("superVariable2");
        try {
            String deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
            this.repositoryService.deleteDeployment(deploymentId, true);
        }
        catch (ProcessEngineException e) {
            CallActivityTest.fail((String)"No exception expected");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataInputOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/dataSubProcess.bpmn20.xml"})
    public void testSubProcessWithNullDataInput() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput").getId();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityTest.assertNull((Object)variable);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CallActivityTest.assertNotNull((Object)task);
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        CallActivityTest.assertNull((Object)this.taskService.getVariable(task.getId(), "subVariable"));
        String subProcessInstanceId = task.getProcessInstanceId();
        CallActivityTest.assertFalse((boolean)processInstanceId.equals(subProcessInstanceId));
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{subProcessInstanceId}).variableName("subVariable").singleResult();
        CallActivityTest.assertNotNull((Object)variable);
        CallActivityTest.assertNull((Object)variable.getValue());
        CallActivityTest.assertEquals((String)"subVariable", (String)variable.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataInputOutputAsExpression.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/dataSubProcess.bpmn20.xml"})
    public void testSubProcessWithNullDataInputAsExpression() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("superVariable", null);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput", params).getId();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityTest.assertNotNull((Object)variable);
        CallActivityTest.assertNull((Object)variable.getValue());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CallActivityTest.assertNotNull((Object)task);
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        CallActivityTest.assertNull((Object)this.taskService.getVariable(task.getId(), "subVariable"));
        String subProcessInstanceId = task.getProcessInstanceId();
        CallActivityTest.assertFalse((boolean)processInstanceId.equals(subProcessInstanceId));
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{subProcessInstanceId}).variableName("subVariable").singleResult();
        CallActivityTest.assertNotNull((Object)variable);
        CallActivityTest.assertNull((Object)variable.getValue());
        CallActivityTest.assertEquals((String)"subVariable", (String)variable.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataInputOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/dataSubProcess.bpmn20.xml"})
    public void testSubProcessWithNullDataOutput() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput").getId();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityTest.assertNull((Object)variable);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CallActivityTest.assertNotNull((Object)task);
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        this.taskService.complete(task.getId());
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityTest.assertNotNull((Object)variable);
        CallActivityTest.assertNull((Object)variable.getValue());
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("hisLocalVariable").singleResult();
        CallActivityTest.assertNotNull((Object)variable);
        CallActivityTest.assertNull((Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataInputOutputAsExpression.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/dataSubProcess.bpmn20.xml"})
    public void testSubProcessWithNullDataOutputAsExpression() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("superVariable", null);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput", params).getId();
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityTest.assertNotNull((Object)variable);
        CallActivityTest.assertNull((Object)variable.getValue());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CallActivityTest.assertNotNull((Object)task);
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)task.getName());
        VariableMap variables = Variables.createVariables().putValue("myLocalVariable", null);
        this.taskService.complete(task.getId(), (Map)variables);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("subVariable").singleResult();
        CallActivityTest.assertNull((Object)variable);
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("superVariable").singleResult();
        CallActivityTest.assertNotNull((Object)variable);
        CallActivityTest.assertNull((Object)variable.getValue());
        variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processInstanceId}).variableName("hisLocalVariable").singleResult();
        CallActivityTest.assertNotNull((Object)variable);
        CallActivityTest.assertNull((Object)variable.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployAndExpectException(BpmnModelInstance modelInstance) {
        String deploymentId = null;
        try {
            deploymentId = this.repositoryService.createDeployment().addModelInstance("process.bpmn", modelInstance).deploy().getId();
            CallActivityTest.fail((String)"Exception expected");
        }
        catch (ParseException e) {
            this.assertTextPresent("Missing attribute 'target'", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"callActivity");
        }
        finally {
            if (deploymentId != null) {
                this.repositoryService.deleteDeployment(deploymentId, true);
            }
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testTwoSubProcesses.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testTwoSubProcesses() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callTwoSubProcesses");
        List instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityTest.assertNotNull((Object)instanceList);
        CallActivityTest.assertEquals((int)3, (int)instanceList.size());
        List taskList = this.taskService.createTaskQuery().list();
        CallActivityTest.assertNotNull((Object)taskList);
        CallActivityTest.assertEquals((int)2, (int)taskList.size());
        this.runtimeService.deleteProcessInstance(processInstance.getId(), "Test cascading");
        instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityTest.assertNotNull((Object)instanceList);
        CallActivityTest.assertEquals((int)0, (int)instanceList.size());
        taskList = this.taskService.createTaskQuery().list();
        CallActivityTest.assertNotNull((Object)taskList);
        CallActivityTest.assertEquals((int)0, (int)taskList.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessAllDataInputOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessAllDataInputOutput() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("superVariable", "Hello from the super process.");
        vars.put("testVariable", "Only a test.");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessAllDataInputOutput", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskBeforeSubProcess.getProcessInstanceId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.taskService.getVariable(taskBeforeSubProcess.getId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Only a test.", (Object)this.runtimeService.getVariable(taskBeforeSubProcess.getProcessInstanceId(), "testVariable"));
        CallActivityTest.assertEquals((Object)"Only a test.", (Object)this.taskService.getVariable(taskBeforeSubProcess.getId(), "testVariable"));
        this.taskService.complete(taskBeforeSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskInSubProcess.getProcessInstanceId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.taskService.getVariable(taskInSubProcess.getId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Only a test.", (Object)this.runtimeService.getVariable(taskInSubProcess.getProcessInstanceId(), "testVariable"));
        CallActivityTest.assertEquals((Object)"Only a test.", (Object)this.taskService.getVariable(taskInSubProcess.getId(), "testVariable"));
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "superVariable", (Object)"Hello from sub process.");
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "testVariable", (Object)"Variable changed in sub process.");
        this.taskService.complete(taskInSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        CallActivityTest.assertEquals((Object)"Hello from sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Variable changed in sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "testVariable"));
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessAllDataInputOutputWithAdditionalInputMapping.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessAllDataInputOutputWithAdditionalInputMapping() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("superVariable", "Hello from the super process.");
        vars.put("testVariable", "Only a test.");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessAllDataInputOutput", vars);
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskBeforeSubProcess.getProcessInstanceId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.taskService.getVariable(taskBeforeSubProcess.getId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Only a test.", (Object)this.runtimeService.getVariable(taskBeforeSubProcess.getProcessInstanceId(), "testVariable"));
        CallActivityTest.assertEquals((Object)"Only a test.", (Object)this.taskService.getVariable(taskBeforeSubProcess.getId(), "testVariable"));
        this.taskService.complete(taskBeforeSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskInSubProcess.getProcessInstanceId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.runtimeService.getVariable(taskInSubProcess.getProcessInstanceId(), "subVariable"));
        CallActivityTest.assertEquals((Object)"Hello from the super process.", (Object)this.taskService.getVariable(taskInSubProcess.getId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Only a test.", (Object)this.runtimeService.getVariable(taskInSubProcess.getProcessInstanceId(), "testVariable"));
        CallActivityTest.assertEquals((Object)"Only a test.", (Object)this.taskService.getVariable(taskInSubProcess.getId(), "testVariable"));
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "superVariable", (Object)"Hello from sub process.");
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "testVariable", (Object)"Variable changed in sub process.");
        this.taskService.complete(taskInSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        CallActivityTest.assertEquals((Object)"Hello from sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Variable changed in sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "testVariable"));
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessAllDataInputOutput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessAllDataOutput() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessAllDataInputOutput");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.complete(taskBeforeSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "superVariable", (Object)"Hello from sub process.");
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "testVariable", (Object)"Variable changed in sub process.");
        this.taskService.complete(taskInSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        CallActivityTest.assertEquals((Object)"Hello from sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "superVariable"));
        CallActivityTest.assertEquals((Object)"Variable changed in sub process.", (Object)this.runtimeService.getVariable(processInstance.getId(), "testVariable"));
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessLocalInputAllVariables.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessLocalInputAllVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessLocalInputAllVariables");
        Task beforeCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariable(processInstance.getId(), "callingProcessVar1", (Object)"val1");
        this.taskService.complete(beforeCallActivityTask.getId());
        ProcessInstance calledInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        Map calledInstanceVariables = this.runtimeService.getVariables(calledInstance.getId());
        CallActivityTest.assertEquals((int)1, (int)calledInstanceVariables.size());
        CallActivityTest.assertEquals((Object)"val2", calledInstanceVariables.get("inputParameter"));
        this.runtimeService.setVariable(calledInstance.getId(), "calledProcessVar1", (Object)42L);
        Task calledProcessInstanceTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(calledProcessInstanceTask.getId());
        Map callingInstanceVariables = this.runtimeService.getVariables(processInstance.getId());
        CallActivityTest.assertEquals((int)3, (int)callingInstanceVariables.size());
        CallActivityTest.assertEquals((Object)"val1", callingInstanceVariables.get("callingProcessVar1"));
        CallActivityTest.assertEquals((Object)42L, callingInstanceVariables.get("calledProcessVar1"));
        CallActivityTest.assertEquals((Object)43L, callingInstanceVariables.get("outputParameter"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessLocalInputSingleVariable.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessLocalInputSingleVariable() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessLocalInputSingleVariable");
        Task beforeCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariable(processInstance.getId(), "callingProcessVar1", (Object)"val1");
        this.taskService.complete(beforeCallActivityTask.getId());
        ProcessInstance calledInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        Map calledInstanceVariables = this.runtimeService.getVariables(calledInstance.getId());
        CallActivityTest.assertEquals((int)1, (int)calledInstanceVariables.size());
        CallActivityTest.assertEquals((Object)"val2", calledInstanceVariables.get("mappedInputParameter"));
        this.runtimeService.setVariable(calledInstance.getId(), "calledProcessVar1", (Object)42L);
        Task calledProcessInstanceTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(calledProcessInstanceTask.getId());
        Map callingInstanceVariables = this.runtimeService.getVariables(processInstance.getId());
        CallActivityTest.assertEquals((int)4, (int)callingInstanceVariables.size());
        CallActivityTest.assertEquals((Object)"val1", callingInstanceVariables.get("callingProcessVar1"));
        CallActivityTest.assertEquals((Object)"val2", callingInstanceVariables.get("mappedInputParameter"));
        CallActivityTest.assertEquals((Object)42L, callingInstanceVariables.get("calledProcessVar1"));
        CallActivityTest.assertEquals((Object)43L, callingInstanceVariables.get("outputParameter"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessLocalInputSingleVariableExpression.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessLocalInputSingleVariableExpression() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessLocalInputSingleVariableExpression");
        Task beforeCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(beforeCallActivityTask.getId());
        ProcessInstance calledInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        Map calledInstanceVariables = this.runtimeService.getVariables(calledInstance.getId());
        CallActivityTest.assertEquals((int)1, (int)calledInstanceVariables.size());
        CallActivityTest.assertEquals((Object)43L, calledInstanceVariables.get("mappedInputParameter"));
        Task callActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(callActivityTask.getId());
        Task beforeSecondCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariable(processInstance.getId(), "globalVariable", (Object)"42");
        try {
            this.taskService.complete(beforeSecondCallActivityTask.getId());
            CallActivityTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Cannot resolve identifier 'globalVariable'", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessLocalOutputAllVariables.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessLocalOutputAllVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessLocalOutputAllVariables");
        Task beforeCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariable(processInstance.getId(), "callingProcessVar1", (Object)"val1");
        this.taskService.complete(beforeCallActivityTask.getId());
        ProcessInstance calledInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        Map calledInstanceVariables = this.runtimeService.getVariables(calledInstance.getId());
        CallActivityTest.assertEquals((int)2, (int)calledInstanceVariables.size());
        CallActivityTest.assertEquals((Object)"val1", calledInstanceVariables.get("callingProcessVar1"));
        CallActivityTest.assertEquals((Object)"val2", calledInstanceVariables.get("inputParameter"));
        this.runtimeService.setVariable(calledInstance.getId(), "calledProcessVar1", (Object)42L);
        Task calledProcessInstanceTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(calledProcessInstanceTask.getId());
        Map callingInstanceVariables = this.runtimeService.getVariables(processInstance.getId());
        CallActivityTest.assertEquals((int)2, (int)callingInstanceVariables.size());
        CallActivityTest.assertEquals((Object)"val1", callingInstanceVariables.get("callingProcessVar1"));
        CallActivityTest.assertEquals((Object)43L, callingInstanceVariables.get("outputParameter"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessLocalOutputSingleVariable.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessLocalOutputSingleVariable() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessLocalOutputSingleVariable");
        Task beforeCallActivityTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.runtimeService.setVariable(processInstance.getId(), "callingProcessVar1", (Object)"val1");
        this.taskService.complete(beforeCallActivityTask.getId());
        ProcessInstance calledInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
        Map calledInstanceVariables = this.runtimeService.getVariables(calledInstance.getId());
        CallActivityTest.assertEquals((int)2, (int)calledInstanceVariables.size());
        CallActivityTest.assertEquals((Object)"val1", calledInstanceVariables.get("callingProcessVar1"));
        CallActivityTest.assertEquals((Object)"val2", calledInstanceVariables.get("inputParameter"));
        this.runtimeService.setVariable(calledInstance.getId(), "calledProcessVar1", (Object)42L);
        Task calledProcessInstanceTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(calledProcessInstanceTask.getId());
        Map callingInstanceVariables = this.runtimeService.getVariables(processInstance.getId());
        CallActivityTest.assertEquals((int)2, (int)callingInstanceVariables.size());
        CallActivityTest.assertEquals((Object)"val1", callingInstanceVariables.get("callingProcessVar1"));
        CallActivityTest.assertEquals((Object)43L, callingInstanceVariables.get("outputParameter"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessBusinessKeyInput.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSubProcessBusinessKeyInput() {
        String businessKey = "myBusinessKey";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("subProcessBusinessKeyInput", businessKey);
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        CallActivityTest.assertEquals((String)"myBusinessKey", (String)processInstance.getBusinessKey());
        this.taskService.complete(taskBeforeSubProcess.getId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).singleResult();
            CallActivityTest.assertEquals((String)businessKey, (String)hpi.getBusinessKey());
            CallActivityTest.assertEquals((int)2, (int)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).list().size());
        }
        taskQuery = this.taskService.createTaskQuery();
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(taskInSubProcess.getProcessInstanceId()).singleResult();
        CallActivityTest.assertEquals((String)"myBusinessKey", (String)subProcessInstance.getBusinessKey());
        this.taskService.complete(taskInSubProcess.getId());
        taskQuery = this.taskService.createTaskQuery();
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
        CallActivityTest.assertEquals((int)0, (int)this.runtimeService.createExecutionQuery().list().size());
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstance.getId()).finished().singleResult();
            CallActivityTest.assertEquals((String)businessKey, (String)hpi.getBusinessKey());
            CallActivityTest.assertEquals((int)2, (int)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessKey).finished().list().size());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcessWithHashExpressions.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testCallSimpleSubProcessWithHashExpressions() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task before subprocess", (String)taskBeforeSubProcess.getName());
        this.taskService.setVariable(taskBeforeSubProcess.getId(), "simpleSubProcessExpression", (Object)"simpleSubProcess");
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task in subprocess", (String)taskInSubProcess.getName());
        this.taskService.complete(taskInSubProcess.getId());
        Task taskAfterSubProcess = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Task after subprocess", (String)taskAfterSubProcess.getName());
        this.taskService.complete(taskAfterSubProcess.getId());
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testInterruptingEventSubProcessEventSubscriptions.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/interruptingEventSubProcessEventSubscriptions.bpmn20.xml"})
    public void testInterruptingMessageEventSubProcessEventSubscriptionsInsideCallActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callInterruptingEventSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskInsideCallActivity = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"taskBeforeInterruptingEventSubprocess", (String)taskInsideCallActivity.getTaskDefinitionKey());
        CallActivityTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().processInstanceId(processInstance.getId()).count());
        String calledProcessInstanceId = taskInsideCallActivity.getProcessInstanceId();
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery().processInstanceId(calledProcessInstanceId);
        List subscriptions = eventSubscriptionQuery.list();
        CallActivityTest.assertEquals((int)2, (int)subscriptions.size());
        this.runtimeService.correlateMessage("newMessage");
        Task taskAfterMessageStartEvent = (Task)taskQuery.processInstanceId(calledProcessInstanceId).singleResult();
        CallActivityTest.assertEquals((String)"taskAfterMessageStartEvent", (String)taskAfterMessageStartEvent.getTaskDefinitionKey());
        CallActivityTest.assertEquals((long)0L, (long)eventSubscriptionQuery.count());
        this.taskService.complete(taskAfterMessageStartEvent.getId());
        this.assertProcessEnded(calledProcessInstanceId);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testInterruptingEventSubProcessEventSubscriptions.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/interruptingEventSubProcessEventSubscriptions.bpmn20.xml"})
    public void testInterruptingSignalEventSubProcessEventSubscriptionsInsideCallActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callInterruptingEventSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskInsideCallActivity = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"taskBeforeInterruptingEventSubprocess", (String)taskInsideCallActivity.getTaskDefinitionKey());
        CallActivityTest.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().processInstanceId(processInstance.getId()).count());
        String calledProcessInstanceId = taskInsideCallActivity.getProcessInstanceId();
        EventSubscriptionQuery eventSubscriptionQuery = this.runtimeService.createEventSubscriptionQuery().processInstanceId(calledProcessInstanceId);
        List subscriptions = eventSubscriptionQuery.list();
        CallActivityTest.assertEquals((int)2, (int)subscriptions.size());
        this.runtimeService.signalEventReceived("newSignal");
        Task taskAfterSignalStartEvent = (Task)taskQuery.processInstanceId(calledProcessInstanceId).singleResult();
        CallActivityTest.assertEquals((String)"taskAfterSignalStartEvent", (String)taskAfterSignalStartEvent.getTaskDefinitionKey());
        CallActivityTest.assertEquals((long)0L, (long)eventSubscriptionQuery.count());
        this.taskService.complete(taskAfterSignalStartEvent.getId());
        this.assertProcessEnded(calledProcessInstanceId);
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testLiteralSourceExpression.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testInputParameterLiteralSourceExpression() {
        this.runtimeService.startProcessInstanceByKey("process");
        String subInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("simpleSubProcess").singleResult()).getId();
        Object variable = this.runtimeService.getVariable(subInstanceId, "inLiteralVariable");
        CallActivityTest.assertEquals((Object)"inLiteralValue", (Object)variable);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testLiteralSourceExpression.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testOutputParameterLiteralSourceExpression() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        Object variable = this.runtimeService.getVariable(processInstanceId, "outLiteralVariable");
        CallActivityTest.assertEquals((Object)"outLiteralValue", (Object)variable);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataOutputOnError.bpmn", "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithError.bpmn"})
    public void testSubProcessDataOutputOnError() {
        String variableName = "subVariable";
        String variableValue = "Hello from Subprocess";
        this.runtimeService.startProcessInstanceByKey("Process_1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"SubTask"));
        this.runtimeService.setVariable(task.getProcessInstanceId(), variableName, (Object)variableValue);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"Task after error"));
        Object variable = this.runtimeService.getVariable(task.getProcessInstanceId(), variableName);
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Object)variableValue));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessDataOutputOnThrownError.bpmn", "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithThrownError.bpmn"})
    public void testSubProcessDataOutputOnThrownError() {
        String variableName = "subVariable";
        String variableValue = "Hello from Subprocess";
        this.runtimeService.startProcessInstanceByKey("Process_1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"SubTask"));
        this.runtimeService.setVariable(task.getProcessInstanceId(), variableName, (Object)variableValue);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"Task after error"));
        Object variable = this.runtimeService.getVariable(task.getProcessInstanceId(), variableName);
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Object)variableValue));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testTwoSubProcessesDataOutputOnError.bpmn", "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessCallErrorSubProcess.bpmn", "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithError.bpmn"})
    public void testTwoSubProcessesDataOutputOnError() {
        String variableName = "subVariable";
        String variableValue = "Hello from Subprocess";
        this.runtimeService.startProcessInstanceByKey("Process_1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"SubTask"));
        this.runtimeService.setVariable(task.getProcessInstanceId(), variableName, (Object)variableValue);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"Task after error"));
        Object variable = this.runtimeService.getVariable(task.getProcessInstanceId(), variableName);
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Object)variableValue));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testTwoSubProcessesLimitedDataOutputOnError.bpmn", "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessCallErrorSubProcessWithLimitedOutMapping.bpmn", "org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithError.bpmn"})
    public void testTwoSubProcessesLimitedDataOutputOnError() {
        String variableName1 = "subSubVariable1";
        String variableName2 = "subSubVariable2";
        String variableName3 = "subVariable";
        String variableValue = "Hello from Subsubprocess";
        String variableValue2 = "Hello from Subprocess";
        this.runtimeService.startProcessInstanceByKey("Process_1");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"Task"));
        this.runtimeService.setVariable(task.getProcessInstanceId(), variableName3, (Object)variableValue2);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"SubTask"));
        this.runtimeService.setVariable(task.getProcessInstanceId(), variableName1, (Object)"foo");
        this.runtimeService.setVariable(task.getProcessInstanceId(), variableName2, (Object)variableValue);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"Task after error"));
        Object variable = this.runtimeService.getVariable(task.getProcessInstanceId(), variableName2);
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Object)variableValue));
        variable = this.runtimeService.getVariable(task.getProcessInstanceId(), variableName3);
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Object)variableValue2));
        variable = this.runtimeService.getVariable(task.getProcessInstanceId(), variableName1);
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityAdvancedTest.testCallProcessByVersionAsExpression.bpmn20.xml", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCallCaseByVersionAsExpression() {
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String processDefinitionIdInSecondDeployment = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").deploymentId(secondDeploymentId).singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValue("myVersion", (Object)2);
        this.runtimeService.startProcessInstanceByKey("process", (Map)variables).getId();
        ProcessInstance subInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").singleResult();
        CallActivityTest.assertNotNull((Object)subInstance);
        CallActivityTest.assertEquals((String)processDefinitionIdInSecondDeployment, (String)subInstance.getProcessDefinitionId());
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivityAdvancedTest.testCallProcessByVersionAsDelegateExpression.bpmn20.xml", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCallCaseByVersionAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myDelegate", new MyVersionDelegate());
        String bpmnResourceName = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String thirdDeploymentId = this.repositoryService.createDeployment().addClasspathResource(bpmnResourceName).deploy().getId();
        String processDefinitionIdInSecondDeployment = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").deploymentId(secondDeploymentId).singleResult()).getId();
        VariableMap variables = Variables.createVariables().putValue("myVersion", (Object)2);
        this.runtimeService.startProcessInstanceByKey("process", (Map)variables).getId();
        ProcessInstance subInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("oneTaskProcess").singleResult();
        CallActivityTest.assertNotNull((Object)subInstance);
        CallActivityTest.assertEquals((String)processDefinitionIdInSecondDeployment, (String)subInstance.getProcessDefinitionId());
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        this.repositoryService.deleteDeployment(thirdDeploymentId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithVersionTag.bpmn20.xml"})
    public void testCallProcessByVersionTag() {
        BpmnModelInstance modelInstance = this.getModelWithCallActivityVersionTagBinding("ver_tag_1");
        this.deployment(new BpmnModelInstance[]{modelInstance});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance subInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess").superProcessInstanceId(processInstance.getId()).singleResult();
        CallActivityTest.assertNotNull((Object)subInstance);
        this.cleanupDeployments();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithVersionTag.bpmn20.xml"})
    public void testCallProcessByVersionTagAsExpression() {
        BpmnModelInstance modelInstance = this.getModelWithCallActivityVersionTagBinding("${versionTagExpr}");
        this.deployment(new BpmnModelInstance[]{modelInstance});
        VariableMap variables = Variables.createVariables().putValue("versionTagExpr", (Object)"ver_tag_1");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", (Map)variables);
        ProcessInstance subInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess").superProcessInstanceId(processInstance.getId()).singleResult();
        CallActivityTest.assertNotNull((Object)subInstance);
        this.cleanupDeployments();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithVersionTag.bpmn20.xml"})
    public void testCallProcessByVersionTagAsDelegateExpression() {
        this.processEngineConfiguration.getBeans().put("myDelegate", new MyVersionDelegate());
        BpmnModelInstance modelInstance = this.getModelWithCallActivityVersionTagBinding("${myDelegate.getVersionTag()}");
        this.deployment(new BpmnModelInstance[]{modelInstance});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        ProcessInstance subInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("subProcess").superProcessInstanceId(processInstance.getId()).singleResult();
        CallActivityTest.assertNotNull((Object)subInstance);
        this.cleanupDeployments();
    }

    public void testCallProcessWithoutVersionTag() {
        BpmnModelInstance modelInstance = ((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().callActivity("callActivity").calledElement("subProcess")).camundaCalledElementBinding("versionTag")).endEvent().done();
        try {
            this.deployment(new BpmnModelInstance[]{modelInstance});
            CallActivityTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            CallActivityTest.assertTrue((boolean)e.getMessage().contains("Could not parse BPMN process."));
            CallActivityTest.assertTrue((boolean)e.getMessage().contains("Missing attribute 'calledElementVersionTag' when 'calledElementBinding' has value 'versionTag'"));
        }
    }

    public void testCallProcessByVersionTagNoneSubprocess() {
        BpmnModelInstance modelInstance = this.getModelWithCallActivityVersionTagBinding("ver_tag_1");
        this.deployment(new BpmnModelInstance[]{modelInstance});
        try {
            this.runtimeService.startProcessInstanceByKey("process");
            CallActivityTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            CallActivityTest.assertTrue((boolean)e.getMessage().contains("no processes deployed with key = 'subProcess', versionTag = 'ver_tag_1' and tenant-id = 'null': processDefinition is null"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithVersionTag.bpmn20.xml"})
    public void testCallProcessByVersionTagTwoSubprocesses() {
        BpmnModelInstance modelInstance = this.getModelWithCallActivityVersionTagBinding("ver_tag_1");
        this.deployment(new BpmnModelInstance[]{modelInstance});
        this.deployment(new String[]{"org/camunda/bpm/engine/test/bpmn/callactivity/subProcessWithVersionTag.bpmn20.xml"});
        try {
            this.runtimeService.startProcessInstanceByKey("process");
            CallActivityTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            CallActivityTest.assertTrue((boolean)e.getMessage().contains("There are '2' results for a process definition with key 'subProcess', versionTag 'ver_tag_1' and tenant-id '{}'."));
        }
        this.cleanupDeployments();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/orderProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/checkCreditProcess.bpmn20.xml"})
    public void testOrderProcessWithCallActivity() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("orderProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task verifyCreditTask = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Verify credit history", (String)verifyCreditTask.getName());
        ProcessInstance subProcessInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().superProcessInstanceId(pi.getId()).singleResult();
        CallActivityTest.assertNotNull((Object)subProcessInstance);
        CallActivityTest.assertEquals((String)pi.getId(), (String)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().subProcessInstanceId(subProcessInstance.getId()).singleResult()).getId());
        this.taskService.complete(verifyCreditTask.getId(), CollectionUtil.singletonMap((String)"creditApproved", (Object)true));
        Task prepareAndShipTask = (Task)taskQuery.singleResult();
        CallActivityTest.assertEquals((String)"Prepare and Ship", (String)prepareAndShipTask.getName());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testDeleteProcessInstanceInCallActivity() {
        this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        List instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityTest.assertNotNull((Object)instanceList);
        CallActivityTest.assertEquals((int)2, (int)instanceList.size());
        this.runtimeService.deleteProcessInstance(taskInSubProcess.getProcessInstanceId(), "Test upstream deletion");
        instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityTest.assertNotNull((Object)instanceList);
        CallActivityTest.assertEquals((int)0, (int)instanceList.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testTwoSubProcesses.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testSingleDeletionWithTwoSubProcesses() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callTwoSubProcesses");
        List instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityTest.assertNotNull((Object)instanceList);
        CallActivityTest.assertEquals((int)3, (int)instanceList.size());
        List taskList = this.taskService.createTaskQuery().list();
        CallActivityTest.assertNotNull((Object)taskList);
        CallActivityTest.assertEquals((int)2, (int)taskList.size());
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getProcessInstanceId());
        CallActivityTest.assertNotNull((Object)activeActivityIds);
        CallActivityTest.assertEquals((int)2, (int)activeActivityIds.size());
        this.runtimeService.deleteProcessInstance(((Task)taskList.get(0)).getProcessInstanceId(), "Test upstream deletion");
        instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityTest.assertNotNull((Object)instanceList);
        CallActivityTest.assertEquals((int)2, (int)instanceList.size());
        activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getProcessInstanceId());
        CallActivityTest.assertNotNull((Object)activeActivityIds);
        CallActivityTest.assertEquals((int)1, (int)activeActivityIds.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testNestedCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testDeleteMultilevelProcessInstanceInCallActivity() {
        this.runtimeService.startProcessInstanceByKey("nestedCallActivity");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        this.taskService.complete(taskInSubProcess.getId());
        Task taskInNestedSubProcess = (Task)taskQuery.singleResult();
        List instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityTest.assertNotNull((Object)instanceList);
        CallActivityTest.assertEquals((int)3, (int)instanceList.size());
        this.runtimeService.deleteProcessInstance(taskInNestedSubProcess.getProcessInstanceId(), "Test cascading upstream deletion");
        instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityTest.assertNotNull((Object)instanceList);
        CallActivityTest.assertEquals((int)0, (int)instanceList.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testNestedCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testDoubleNestedCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml"})
    public void testDeleteDoubleNestedProcessInstanceInCallActivity() {
        this.runtimeService.startProcessInstanceByKey("doubleNestedCallActivity");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        this.taskService.complete(taskInSubProcess.getId());
        Task taskInNestedSubProcess = (Task)taskQuery.singleResult();
        this.taskService.complete(taskInNestedSubProcess.getId());
        Task taskInDoubleNestedSubProcess = (Task)taskQuery.singleResult();
        List instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityTest.assertNotNull((Object)instanceList);
        CallActivityTest.assertEquals((int)4, (int)instanceList.size());
        this.runtimeService.deleteProcessInstance(taskInDoubleNestedSubProcess.getProcessInstanceId(), "Test cascading upstream deletion");
        instanceList = this.runtimeService.createProcessInstanceQuery().list();
        CallActivityTest.assertNotNull((Object)instanceList);
        CallActivityTest.assertEquals((int)0, (int)instanceList.size());
    }

    public void testTransientVariableInputMapping() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"simpleSubProcess").startEvent().serviceTask().camundaClass(AssertTransientVariableDelegate.class)).userTask().endEvent().done();
        this.deployment(new String[]{"org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testSubProcessAllDataInputOutputTypedApi.bpmn20.xml"});
        this.deployment(new BpmnModelInstance[]{modelInstance});
        VariableMap variables = Variables.createVariables().putValue("var", (Object)Variables.stringValue((String)"value", (boolean)true));
        this.runtimeService.startProcessInstanceByKey("subProcessDataInputOutput", (Map)variables);
        long numVariables = this.runtimeService.createVariableInstanceQuery().count();
        Assertions.assertThat((long)numVariables).isEqualTo(0L);
    }

    public void testTransientVariableOutputMapping() {
        BpmnModelInstance modelInstance = ((ServiceTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"superProcess").startEvent().callActivity().calledElement("oneTaskProcess")).camundaOut("var", "var")).serviceTask().camundaClass(AssertTransientVariableDelegate.class)).userTask().endEvent().done();
        this.deployment(new BpmnModelInstance[]{modelInstance});
        this.deployment(new String[]{"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"});
        this.runtimeService.startProcessInstanceByKey("superProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        VariableMap variables = Variables.createVariables().putValue("var", (Object)Variables.stringValue((String)"value", (boolean)true));
        this.taskService.complete(task.getId(), (Map)variables);
        long numVariables = this.runtimeService.createVariableInstanceQuery().count();
        Assertions.assertThat((long)numVariables).isEqualTo(0L);
    }

    protected BpmnModelInstance getModelWithCallActivityVersionTagBinding(String versionTag) {
        return ((CallActivityBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().callActivity("callActivity").calledElement("subProcess")).camundaCalledElementBinding("versionTag")).camundaCalledElementVersionTag(versionTag)).endEvent().done();
    }

    protected void cleanupDeployments() {
        List deployments = this.repositoryService.createDeploymentQuery().list();
        for (org.camunda.bpm.engine.repository.Deployment currentDeployment : deployments) {
            this.repositoryService.deleteDeployment(currentDeployment.getId(), true);
        }
    }

    public static class AssertTransientVariableDelegate
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            TypedValue typedValue = execution.getVariableTyped("var");
            Assertions.assertThat((Object)typedValue).isNotNull();
            Assertions.assertThat((Object)typedValue.getType()).isEqualTo((Object)ValueType.STRING);
            Assertions.assertThat((boolean)typedValue.isTransient()).isTrue();
            Assertions.assertThat((Object)typedValue.getValue()).isEqualTo((Object)"value");
        }
    }
}

