/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.external;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.test.Deployment;

public class ExternalTaskParseTest
extends PluggableProcessEngineTestCase {
    public void testParseExternalTaskWithoutTopic() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/external/ExternalTaskParseTest.testParseExternalTaskWithoutTopic.bpmn20.xml");
        try {
            deploymentBuilder.deploy();
            ExternalTaskParseTest.fail((String)"exception expected");
        }
        catch (ParseException e) {
            this.assertTextPresent("External tasks must specify a 'topic' attribute in the camunda namespace", e.getMessage());
            Assertions.assertThat((int)((ResourceReport)e.getResorceReports().get(0)).getErrors().size()).isEqualTo(1);
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"externalTask");
        }
    }

    @Deployment
    public void testParseExternalTaskWithExpressionTopic() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("topicName", "testTopicExpression");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithExpressionTopicProcess", variables);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assertions.assertThat((String)"testTopicExpression").isEqualTo((Object)task.getTopicName());
    }

    @Deployment
    public void testParseExternalTaskWithStringTopic() {
        HashMap variables = new HashMap();
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithStringTopicProcess", variables);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assertions.assertThat((String)"testTopicString").isEqualTo((Object)task.getTopicName());
    }
}

