/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.BootstrapEngineCommand;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.util.DatabaseHelper;

public class ConcurrentInstallationIdInitializationTest
extends ConcurrencyTestCase {
    protected void runTest() throws Throwable {
        Integer transactionIsolationLevel = DatabaseHelper.getTransactionIsolationLevel(this.processEngineConfiguration);
        String databaseType = DatabaseHelper.getDatabaseType(this.processEngineConfiguration);
        if (!("h2".equals(databaseType) || "mariadb".equals(databaseType) || transactionIsolationLevel != null && !transactionIsolationLevel.equals(2))) {
            TestHelper.deleteInstallationId((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
            super.runTest();
        }
    }

    public void test() throws InterruptedException {
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableInstallationIdInitializationCommand());
        thread1.waitForSync();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableInstallationIdInitializationCommand());
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.waitUntilDone();
        thread2.waitForSync();
        thread2.waitUntilDone();
        ConcurrentInstallationIdInitializationTest.assertNull((Object)thread1.exception);
        ConcurrentInstallationIdInitializationTest.assertNull((Object)thread2.exception);
        String id = this.processEngineConfiguration.getInstallationId();
        Assertions.assertThat((String)id).isNotEmpty();
        Assertions.assertThat((String)id).matches((CharSequence)"[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}");
    }

    protected static class ControllableInstallationIdInitializationCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected ControllableInstallationIdInitializationCommand() {
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new BootstrapEngineCommand().initializeInstallationId(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

