/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.BootstrapEngineCommand;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.util.DatabaseHelper;

public class ConcurrentTelemetryConfigurationTest
extends ConcurrencyTestCase {
    protected void runTest() throws Throwable {
        Integer transactionIsolationLevel = DatabaseHelper.getTransactionIsolationLevel(this.processEngineConfiguration);
        String databaseType = DatabaseHelper.getDatabaseType(this.processEngineConfiguration);
        if (!("h2".equals(databaseType) || "mariadb".equals(databaseType) || transactionIsolationLevel != null && !transactionIsolationLevel.equals(2))) {
            TestHelper.deleteTelemetryProperty((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
            super.runTest();
        }
    }

    public void testEnableTelemetryWithoutConcurancyIssue() throws InterruptedException {
        ConcurrencyTestCase.ThreadControl thread1 = this.executeControllableCommand(new ControllableUpdateTelemetrySetupCommand(false));
        thread1.waitForSync();
        ConcurrencyTestCase.ThreadControl thread2 = this.executeControllableCommand(new ControllableUpdateTelemetrySetupCommand(false));
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.waitUntilDone();
        thread2.waitForSync();
        thread2.waitUntilDone();
        ConcurrentTelemetryConfigurationTest.assertNull((Object)thread1.exception);
        ConcurrentTelemetryConfigurationTest.assertNull((Object)thread2.exception);
        Assertions.assertThat((boolean)this.managementService.isTelemetryEnabled()).isFalse();
    }

    protected static class ControllableUpdateTelemetrySetupCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        boolean telemetryEnabled;

        public ControllableUpdateTelemetrySetupCommand(boolean telemetryEnabled) {
            this.telemetryEnabled = telemetryEnabled;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new BootstrapEngineCommand().initializeTelemetryProperty(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

