/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.AcquiredJobs;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.AcquirableJobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class AcquireJobCmdUnitTest {
    protected static final String PROCESS_INSTANCE_ID_1 = "pi_1";
    protected static final String PROCESS_INSTANCE_ID_2 = "pi_2";
    protected static final String JOB_ID_1 = "job_1";
    protected static final String JOB_ID_2 = "job_2";
    protected AcquireJobsCmd acquireJobsCmd;
    protected JobManager jobManager;
    protected CommandContext commandContext;

    @Before
    public void initCommand() {
        JobExecutor jobExecutor = (JobExecutor)Mockito.mock(JobExecutor.class);
        Mockito.when((Object)jobExecutor.getMaxJobsPerAcquisition()).thenReturn((Object)3);
        Mockito.when((Object)jobExecutor.getLockOwner()).thenReturn((Object)"test");
        Mockito.when((Object)jobExecutor.getLockTimeInMillis()).thenReturn((Object)300000);
        this.acquireJobsCmd = new AcquireJobsCmd(jobExecutor);
        this.commandContext = (CommandContext)Mockito.mock(CommandContext.class);
        DbEntityManager dbEntityManager = (DbEntityManager)Mockito.mock(DbEntityManager.class);
        Mockito.when((Object)this.commandContext.getDbEntityManager()).thenReturn((Object)dbEntityManager);
        this.jobManager = (JobManager)Mockito.mock(JobManager.class);
        Mockito.when((Object)this.commandContext.getJobManager()).thenReturn((Object)this.jobManager);
    }

    @Test
    public void nonExclusiveJobsSameInstance() {
        AcquirableJobEntity job1 = this.createNonExclusiveJob(JOB_ID_1, PROCESS_INSTANCE_ID_1);
        AcquirableJobEntity job2 = this.createNonExclusiveJob(JOB_ID_2, PROCESS_INSTANCE_ID_1);
        Mockito.when((Object)this.jobManager.findNextJobsToExecute((Page)Matchers.any(Page.class))).thenReturn(Arrays.asList(job1, job2));
        this.checkThatAcquiredJobsInDifferentBatches();
    }

    @Test
    public void nonExclusiveDifferentInstance() {
        AcquirableJobEntity job1 = this.createNonExclusiveJob(JOB_ID_1, PROCESS_INSTANCE_ID_1);
        AcquirableJobEntity job2 = this.createNonExclusiveJob(JOB_ID_2, PROCESS_INSTANCE_ID_2);
        Mockito.when((Object)this.jobManager.findNextJobsToExecute((Page)Matchers.any(Page.class))).thenReturn(Arrays.asList(job1, job2));
        this.checkThatAcquiredJobsInDifferentBatches();
    }

    @Test
    public void exclusiveJobsSameInstance() {
        AcquirableJobEntity job1 = this.createExclusiveJob(JOB_ID_1, PROCESS_INSTANCE_ID_1);
        AcquirableJobEntity job2 = this.createExclusiveJob(JOB_ID_2, PROCESS_INSTANCE_ID_1);
        Mockito.when((Object)this.jobManager.findNextJobsToExecute((Page)Matchers.any(Page.class))).thenReturn(Arrays.asList(job1, job2));
        AcquiredJobs acquiredJobs = this.acquireJobsCmd.execute(this.commandContext);
        List jobIdBatches = acquiredJobs.getJobIdBatches();
        Assert.assertThat((Object)jobIdBatches.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((List)jobIdBatches.get(0)).size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(jobIdBatches.get(0), (Matcher)CoreMatchers.hasItems((Object[])new String[]{JOB_ID_1, JOB_ID_2}));
    }

    @Test
    public void exclusiveJobsDifferentInstance() {
        AcquirableJobEntity job1 = this.createExclusiveJob(JOB_ID_1, PROCESS_INSTANCE_ID_1);
        AcquirableJobEntity job2 = this.createExclusiveJob(JOB_ID_2, PROCESS_INSTANCE_ID_2);
        Mockito.when((Object)this.jobManager.findNextJobsToExecute((Page)Matchers.any(Page.class))).thenReturn(Arrays.asList(job1, job2));
        this.checkThatAcquiredJobsInDifferentBatches();
    }

    protected AcquirableJobEntity createExclusiveJob(String id, String processInstanceId) {
        AcquirableJobEntity job = this.createNonExclusiveJob(id, processInstanceId);
        Mockito.when((Object)job.isExclusive()).thenReturn((Object)true);
        return job;
    }

    protected AcquirableJobEntity createNonExclusiveJob(String id, String processInstanceId) {
        AcquirableJobEntity job = (AcquirableJobEntity)Mockito.mock(AcquirableJobEntity.class);
        Mockito.when((Object)job.getId()).thenReturn((Object)id);
        Mockito.when((Object)job.getProcessInstanceId()).thenReturn((Object)processInstanceId);
        return job;
    }

    protected void checkThatAcquiredJobsInDifferentBatches() {
        AcquiredJobs acquiredJobs = this.acquireJobsCmd.execute(this.commandContext);
        List jobIdBatches = acquiredJobs.getJobIdBatches();
        Assert.assertThat((Object)jobIdBatches.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((List)jobIdBatches.get(0)).size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((List)jobIdBatches.get(1)).size(), (Matcher)CoreMatchers.is((Object)1));
    }
}

