/*
 * Decompiled with CFR 0.152.
 */
package camundajar.impl.org.apache.http.client.protocol;

import camundajar.impl.org.apache.commons.logging.Log;
import camundajar.impl.org.apache.commons.logging.LogFactory;
import camundajar.impl.org.apache.http.HttpException;
import camundajar.impl.org.apache.http.HttpRequest;
import camundajar.impl.org.apache.http.HttpRequestInterceptor;
import camundajar.impl.org.apache.http.annotation.Contract;
import camundajar.impl.org.apache.http.annotation.ThreadingBehavior;
import camundajar.impl.org.apache.http.client.protocol.HttpClientContext;
import camundajar.impl.org.apache.http.conn.routing.RouteInfo;
import camundajar.impl.org.apache.http.protocol.HttpContext;
import camundajar.impl.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

