/*
 * Decompiled with CFR 0.152.
 */
package camundajar.impl.org.apache.http.client.protocol;

import camundajar.impl.org.apache.http.HttpEntity;
import camundajar.impl.org.apache.http.HttpEntityEnclosingRequest;
import camundajar.impl.org.apache.http.HttpException;
import camundajar.impl.org.apache.http.HttpRequest;
import camundajar.impl.org.apache.http.HttpRequestInterceptor;
import camundajar.impl.org.apache.http.HttpVersion;
import camundajar.impl.org.apache.http.ProtocolVersion;
import camundajar.impl.org.apache.http.annotation.Contract;
import camundajar.impl.org.apache.http.annotation.ThreadingBehavior;
import camundajar.impl.org.apache.http.client.config.RequestConfig;
import camundajar.impl.org.apache.http.client.protocol.HttpClientContext;
import camundajar.impl.org.apache.http.protocol.HttpContext;
import camundajar.impl.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

