/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.telemetry.reporter;

import camundajar.impl.org.apache.http.HttpResponse;
import camundajar.impl.org.apache.http.client.HttpClient;
import camundajar.impl.org.apache.http.client.methods.HttpPost;
import camundajar.impl.org.apache.http.entity.StringEntity;
import java.nio.charset.StandardCharsets;
import java.util.TimerTask;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.telemetry.TelemetryLogger;
import org.camunda.bpm.engine.impl.telemetry.dto.Data;
import org.camunda.bpm.engine.impl.util.JsonUtil;

public class TelemetrySendingTask
extends TimerTask {
    protected static final TelemetryLogger LOG = ProcessEngineLogger.TELEMETRY_LOGGER;
    protected CommandExecutor commandExecutor;
    protected String telemetryEndpoint;
    protected Data data;
    protected HttpClient httpClient;

    public TelemetrySendingTask(CommandExecutor commandExecutor, String telemetryEndpoint, Data data, HttpClient httpClient) {
        this.commandExecutor = commandExecutor;
        this.telemetryEndpoint = telemetryEndpoint;
        this.data = data;
        this.httpClient = httpClient;
    }

    @Override
    public void run() {
        LOG.startTelemetrySendingTask();
        try {
            this.sendData();
        }
        catch (Exception e) {
            LOG.exceptionWhileSendingTelemetryData(e.getMessage());
        }
    }

    protected void sendData() {
        this.commandExecutor.execute(commandContext -> {
            block5: {
                if (commandContext.getProcessEngineConfiguration().getManagementService().isTelemetryEnabled()) {
                    try {
                        HttpPost request = new HttpPost(this.telemetryEndpoint);
                        String telemetryData = JsonUtil.asString(this.data);
                        StringEntity requestBody = new StringEntity(telemetryData, StandardCharsets.UTF_8);
                        request.setHeader("Content-Type", "application/json");
                        request.setEntity(requestBody);
                        HttpResponse response = this.httpClient.execute(request);
                        if (response == null || 202 != response.getStatusLine().getStatusCode()) {
                            LOG.unexpectedResponseWhileSendingTelemetryData();
                            break block5;
                        }
                        LOG.telemetryDataSent(telemetryData);
                    }
                    catch (Exception e) {
                        LOG.exceptionWhileSendingTelemetryData(e.getMessage());
                    }
                } else {
                    LOG.telemetryDisabled();
                }
            }
            return null;
        });
    }
}

