/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.deployment;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class CmmnDisabledTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/camunda/bpm/application/impl/deployment/cmmn.disabled.camunda.cfg.xml");
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected EmbeddedProcessApplication processApplication;

    @Before
    public void setUp() throws Exception {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.processApplication = new EmbeddedProcessApplication();
    }

    @Test
    public void testCmmnDisabled() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertNotNull((Object)processDefinition);
        Assert.assertEquals((long)1L, (long)processDefinition.getVersion());
        try {
            this.repositoryService.createCaseDefinitionQuery().singleResult();
            Assert.fail((String)"Cmmn Disabled: It should not be possible to query for a case definition.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Test
    public void testVariableInstanceQuery() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        VariableMap variables = Variables.createVariables().putValue("my-variable", (Object)"a-value");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)variables);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
        VariableInstance variableInstance = (VariableInstance)result.get(0);
        Assert.assertEquals((Object)"my-variable", (Object)variableInstance.getName());
        Assert.assertNotNull((Object)this.runtimeService.getVariable(processInstance.getId(), "my-variable"));
        Assert.assertNotNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "my-variable"));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }
}

