/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.runtime.DefaultDeserializationTypeValidator;
import org.junit.Before;
import org.junit.Test;

public class DefaultDeserializationTypeValidatorTest {
    private static final String ANOTHER_CLASS = "another.class.Class";
    private static final String ANOTHER_PACKAGE = "another.class";
    private static final String SOME_CLASS = "some.class.Class";
    private static final String SOME_PACKAGE = "some.class";
    protected DefaultDeserializationTypeValidator validator;

    @Before
    public void setUp() {
        this.validator = new DefaultDeserializationTypeValidator();
    }

    @Test
    public void shouldAcceptNullListOfAllowedClasses() {
        this.validator.setAllowedClasses(null);
        Assertions.assertThat((Iterable)this.validator.allowedClasses).isEmpty();
    }

    @Test
    public void shouldAcceptEmptyListOfAllowedClasses() {
        this.validator.setAllowedClasses("");
        Assertions.assertThat((Iterable)this.validator.allowedClasses).isEmpty();
    }

    @Test
    public void shouldAcceptListOfEmptyAllowedClasses() {
        this.validator.setAllowedClasses("\r\n  , \t , ,,\n,\r");
        Assertions.assertThat((Iterable)this.validator.allowedClasses).isEmpty();
    }

    @Test
    public void shouldAcceptSingleStringOfAllowedClasses() {
        this.validator.setAllowedClasses("some.Class");
        Assertions.assertThat((Iterable)this.validator.allowedClasses).containsExactly((Object[])new String[]{"some.Class"});
    }

    @Test
    public void shouldAcceptStringListOfAllowedClasses() {
        this.validator.setAllowedClasses("  some.class.Class , another.class.Class  ");
        Assertions.assertThat((Iterable)this.validator.allowedClasses).containsExactlyInAnyOrder((Object[])new String[]{SOME_CLASS, ANOTHER_CLASS});
    }

    @Test
    public void shouldOverrideAllowedClasses() {
        this.validator.setAllowedClasses(SOME_CLASS);
        this.validator.setAllowedClasses(ANOTHER_CLASS);
        Assertions.assertThat((Iterable)this.validator.allowedClasses).containsExactly((Object[])new String[]{ANOTHER_CLASS});
    }

    @Test
    public void shouldClearAllowedClasses() {
        this.validator.setAllowedClasses(SOME_CLASS);
        this.validator.setAllowedClasses(null);
        Assertions.assertThat((Iterable)this.validator.allowedClasses).isEmpty();
    }

    @Test
    public void shouldAcceptNullListOfAllowedPackages() {
        this.validator.setAllowedPackages(null);
        Assertions.assertThat((Iterable)this.validator.allowedPackages).isEmpty();
    }

    @Test
    public void shouldAcceptEmptyListOfAllowedPackages() {
        this.validator.setAllowedPackages("");
        Assertions.assertThat((Iterable)this.validator.allowedPackages).isEmpty();
    }

    @Test
    public void shouldAcceptListOfEmptyAllowedPackages() {
        this.validator.setAllowedPackages("\r\n  , \t , ,,\n,\r");
        Assertions.assertThat((Iterable)this.validator.allowedPackages).isEmpty();
    }

    @Test
    public void shouldAcceptSingleStringOfAllowedPackages() {
        this.validator.setAllowedPackages("some.");
        Assertions.assertThat((Iterable)this.validator.allowedPackages).containsExactly((Object[])new String[]{"some."});
    }

    @Test
    public void shouldAcceptStringListOfAllowedPackages() {
        this.validator.setAllowedPackages("  some.class , another.class  ");
        Assertions.assertThat((Iterable)this.validator.allowedPackages).containsExactlyInAnyOrder((Object[])new String[]{SOME_PACKAGE, ANOTHER_PACKAGE});
    }

    @Test
    public void shouldOverrideAllowedPackages() {
        this.validator.setAllowedPackages(SOME_PACKAGE);
        this.validator.setAllowedPackages(ANOTHER_PACKAGE);
        Assertions.assertThat((Iterable)this.validator.allowedPackages).containsExactly((Object[])new String[]{ANOTHER_PACKAGE});
    }

    @Test
    public void shouldClearAllowedPackages() {
        this.validator.setAllowedPackages(SOME_PACKAGE);
        this.validator.setAllowedPackages(null);
        Assertions.assertThat((Iterable)this.validator.allowedPackages).isEmpty();
    }

    @Test
    public void shouldForbidUnknownClassOnEmptyWhitelist() {
        Assertions.assertThat((boolean)this.validator.validate(SOME_CLASS)).isFalse();
    }

    @Test
    public void shouldAllowJavaLangClassOnEmptyWhitelist() {
        Assertions.assertThat((boolean)this.validator.validate(Number.class.getName())).isTrue();
    }

    @Test
    public void shouldAllowJavaUtilContainerClassesOnEmptyWhitelist() {
        Assertions.assertThat((boolean)this.validator.validate(ArrayList.class.getName())).isTrue();
        Assertions.assertThat((boolean)this.validator.validate(HashMap.class.getName())).isTrue();
        Assertions.assertThat((boolean)this.validator.validate(Arrays.asList("a", "n").getClass().getName())).isTrue();
    }

    @Test
    public void shouldAllowClassOnWhitelistedClass() {
        this.validator.setAllowedClasses(SOME_CLASS);
        Assertions.assertThat((boolean)this.validator.validate(SOME_CLASS)).isTrue();
    }

    @Test
    public void shouldAllowClassOnWhitelistedClasses() {
        this.validator.setAllowedClasses("some.class.Class,another.class.Class");
        Assertions.assertThat((boolean)this.validator.validate(SOME_CLASS)).isTrue();
    }

    @Test
    public void shouldForbidClassOnNonWhitelistedClass() {
        this.validator.setAllowedClasses(SOME_CLASS);
        Assertions.assertThat((boolean)this.validator.validate(ANOTHER_CLASS)).isFalse();
    }

    @Test
    public void shouldForbidClassOnNonWhitelistedClasses() {
        this.validator.setAllowedClasses("some.class.Class,another.class.Class");
        Assertions.assertThat((boolean)this.validator.validate("different.Class")).isFalse();
    }

    @Test
    public void shouldForbidClassOnEmptyClasses() {
        this.validator.setAllowedClasses(",  ,,");
        Assertions.assertThat((boolean)this.validator.validate(SOME_CLASS)).isFalse();
    }

    @Test
    public void shouldAllowClassOnWhitelistedPackage() {
        this.validator.setAllowedPackages(SOME_PACKAGE);
        Assertions.assertThat((boolean)this.validator.validate(SOME_CLASS)).isTrue();
    }

    @Test
    public void shouldAllowClassOnWhitelistedPackages() {
        this.validator.setAllowedPackages("some.class,another.class");
        Assertions.assertThat((boolean)this.validator.validate(SOME_CLASS)).isTrue();
    }

    @Test
    public void shouldForbidClassOnNonWhitelistedPackage() {
        this.validator.setAllowedPackages(SOME_PACKAGE);
        Assertions.assertThat((boolean)this.validator.validate(ANOTHER_CLASS)).isFalse();
    }

    @Test
    public void shouldForbidClassOnNonWhitelistedPackages() {
        this.validator.setAllowedPackages("some.class,another.class");
        Assertions.assertThat((boolean)this.validator.validate("different.Class")).isFalse();
    }

    @Test
    public void shouldForbidClassOnEmptyPackages() {
        this.validator.setAllowedPackages(",  ,,");
        Assertions.assertThat((boolean)this.validator.validate(SOME_CLASS)).isFalse();
    }

    @Test
    public void shouldAllowClassOnWhitelistedClassAndNonWhitelistedPackage() {
        this.validator.setAllowedClasses(SOME_CLASS);
        this.validator.setAllowedPackages(ANOTHER_PACKAGE);
        Assertions.assertThat((boolean)this.validator.validate(SOME_CLASS)).isTrue();
    }

    @Test
    public void shouldAllowClassOnNonWhitelistedClassAndWhitelistedPackage() {
        this.validator.setAllowedClasses(ANOTHER_CLASS);
        this.validator.setAllowedPackages(SOME_PACKAGE);
        Assertions.assertThat((boolean)this.validator.validate(SOME_CLASS)).isTrue();
    }

    @Test
    public void shouldForbidClassOnNonWhitelistedClassAndNonWhitelistedPackage() {
        this.validator.setAllowedPackages(SOME_PACKAGE);
        this.validator.setAllowedClasses(SOME_CLASS);
        Assertions.assertThat((boolean)this.validator.validate(ANOTHER_CLASS)).isFalse();
    }
}

