/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.HistoricProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.HistoricTaskPermissions;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricVariableInstanceAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    protected static final String MESSAGE_START_PROCESS_KEY = "messageStartProcess";
    protected static final String CASE_KEY = "oneTaskCase";
    protected boolean ensureSpecificVariablePermission;
    protected String deploymentId;

    @Override
    @Before
    public void setUp() throws Exception {
        this.deploymentId = this.testRule.deploy("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/messageStartEventProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/authorization/oneTaskCase.cmmn").getId();
        this.ensureSpecificVariablePermission = this.processEngineConfiguration.isEnforceSpecificVariablePermission();
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(false);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(this.ensureSpecificVariablePermission);
    }

    @Test
    public void testQueryAfterStandaloneTaskVariables() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        this.enableAuthorization();
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
        this.deleteTask(taskId, true);
    }

    @Test
    public void testSimpleQueryWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testSimpleQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleQueryWithMultiple() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleQueryWithReadHistoryVariablePermissionOnProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleQueryWithReadHistoryVariablePermissionOnAnyProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testSimpleQueryWithMultipleReadHistoryVariable() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryWithoutAuthorization() {
        this.startMultipleProcessInstances();
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startMultipleProcessInstances();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startMultipleProcessInstances();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    @Test
    public void testQueryWithReadHistoryVariablePermissionOnProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startMultipleProcessInstances();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryWithReadHistoryVariablePermissionOnAnyProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startMultipleProcessInstances();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 7);
    }

    @Test
    public void testQueryAfterCaseVariables() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testMixedQueryWithoutAuthorization() {
        this.startMultipleProcessInstances();
        this.setupMultipleMixedVariables();
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 7);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testMixedQueryWithReadHistoryPermissionOnProcessDefinition() {
        this.startMultipleProcessInstances();
        this.setupMultipleMixedVariables();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 10);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testMixedQueryWithReadHistoryPermissionOnAnyProcessDefinition() {
        this.startMultipleProcessInstances();
        this.setupMultipleMixedVariables();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 14);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testMixedQueryWithReadHistoryVariablePermissionOnProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startMultipleProcessInstances();
        this.setupMultipleMixedVariables();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 10);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testMixedQueryWithReadHistoryVariablePermissionOnAnyProcessDefinition() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startMultipleProcessInstances();
        this.setupMultipleMixedVariables();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 14);
        this.deleteTask("one", true);
        this.deleteTask("two", true);
        this.deleteTask("three", true);
        this.deleteTask("four", true);
        this.deleteTask("five", true);
    }

    @Test
    public void testQueryAfterDeletingDeployment() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 3);
        this.cleanUpAfterDeploymentDeletion();
    }

    @Test
    public void testQueryAfterDeletingDeploymentWithReadHistoryVariable() {
        this.setReadHistoryVariableAsDefaultReadPermission();
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        this.disableAuthorization();
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.enableAuthorization();
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        this.verifyQueryResults(query, 3);
        this.cleanUpAfterDeploymentDeletion();
    }

    @Test
    public void testDeleteHistoricProcessVariableInstanceWithoutAuthorization() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.disableAuthorization();
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
        try {
            this.historyService.deleteHistoricVariableInstance(variableInstanceId);
            Assert.fail((String)"Exception expected: It should not be possible to delete the historic variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.DELETE_HISTORY.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testDeleteHistoricProcessVariableInstanceWithDeleteHistoryPermissionOnProcessDefinition() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
        try {
            this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        }
        catch (AuthorizationException e) {
            Assert.fail((String)"It should be possible to delete the historic variable instance with granted permissions");
        }
        this.verifyVariablesDeleted();
    }

    @Test
    public void testDeleteHistoricProcessVariableInstanceAfterDeletingDeployment() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
        try {
            this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        }
        catch (AuthorizationException e) {
            Assert.fail((String)"It should be possible to delete the historic variable instance with granted permissions after the process definition is deleted");
        }
        this.verifyVariablesDeleted();
        this.cleanUpAfterDeploymentDeletion();
    }

    @Test
    public void testDeleteHistoricCaseVariableInstance() {
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.disableAuthorization();
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.verifyVariablesDeleted();
    }

    @Test
    public void testDeleteHistoricStandaloneTaskVariableInstance() {
        String taskId = "myTask";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariables(taskId, (Map)this.getVariables());
        String variableInstanceId = ((HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult()).getId();
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
        this.historyService.deleteHistoricVariableInstance(variableInstanceId);
        this.verifyVariablesDeleted();
        this.deleteTask(taskId, true);
    }

    @Test
    public void testDeleteHistoricProcessVariableInstancesWithoutAuthorization() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.verifyVariablesCreated();
        try {
            this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(instance.getId());
            Assert.fail((String)"Exception expected: It should not be possible to delete the historic variable instance");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.testRule.assertTextPresent(this.userId, message);
            this.testRule.assertTextPresent(Permissions.DELETE_HISTORY.getName(), message);
            this.testRule.assertTextPresent(PROCESS_KEY, message);
            this.testRule.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    @Test
    public void testDeleteHistoricProcessVariableInstancesWithDeleteHistoryPermissionOnProcessDefinition() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.verifyVariablesCreated();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        try {
            this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(instance.getId());
        }
        catch (AuthorizationException e) {
            Assert.fail((String)"It should be possible to delete the historic variable instance with granted permissions");
        }
        this.verifyVariablesDeleted();
    }

    @Test
    public void testDeleteHistoricProcessVariableInstancesAfterDeletingDeployment() {
        ProcessInstance instance = this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.verifyVariablesCreated();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.DELETE_HISTORY});
        this.disableAuthorization();
        this.repositoryService.deleteDeployment(this.deploymentId);
        this.enableAuthorization();
        try {
            this.historyService.deleteHistoricVariableInstancesByProcessInstanceId(instance.getId());
        }
        catch (AuthorizationException e) {
            Assert.fail((String)"It should be possible to delete the historic variable instance with granted permissions after the process definition is deleted");
        }
        this.verifyVariablesDeleted();
        this.cleanUpAfterDeploymentDeletion();
    }

    protected void verifyQueryResults(HistoricVariableInstanceQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }

    protected void verifyVariablesDeleted() {
        this.disableAuthorization();
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
    }

    protected void verifyVariablesCreated() {
        this.disableAuthorization();
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        Assert.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().count());
        this.enableAuthorization();
    }

    protected void cleanUpAfterDeploymentDeletion() {
        this.disableAuthorization();
        List instances = this.historyService.createHistoricProcessInstanceQuery().list();
        for (HistoricProcessInstance instance : instances) {
            this.historyService.deleteHistoricProcessInstance(instance.getId());
        }
        this.enableAuthorization();
    }

    protected void startMultipleProcessInstances() {
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
        this.startProcessInstanceByKey(MESSAGE_START_PROCESS_KEY, (Map<String, Object>)this.getVariables());
    }

    protected void setupMultipleMixedVariables() {
        this.createTask("one");
        this.createTask("two");
        this.createTask("three");
        this.createTask("four");
        this.createTask("five");
        this.disableAuthorization();
        this.taskService.setVariables("one", (Map)this.getVariables());
        this.taskService.setVariables("two", (Map)this.getVariables());
        this.taskService.setVariables("three", (Map)this.getVariables());
        this.taskService.setVariables("four", (Map)this.getVariables());
        this.taskService.setVariables("five", (Map)this.getVariables());
        this.enableAuthorization();
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
        this.createCaseInstanceByKey(CASE_KEY, (Map<String, Object>)this.getVariables());
    }

    @Test
    public void testCheckNonePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testCheckNonePermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testCheckReadPermissionOnCompletedHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckNonePermissionOnHistoricTaskAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadPermissionOnHistoricTaskAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadVariablePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testOnlyReadPermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testIgnoreReadVariablePermissionOnHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(false);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testCheckReadVariablePermissionOnStandaloneHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        String taskId = "aTaskId";
        this.createTask(taskId);
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
        this.deleteTask(taskId, true);
    }

    @Test
    public void testCheckReadVariablePermissionOnCompletedHistoricTask() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckReadVariablePermissionOnHistoricTaskAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.READ_VARIABLE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckNonePermissionOnHistoricTaskAndReadHistoryVariablePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
        this.startProcessInstanceByKey(PROCESS_KEY, (Map<String, Object>)this.getVariables());
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_TASK, taskId, this.userId, new Permission[]{HistoricTaskPermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.READ_HISTORY_VARIABLE});
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testHistoricTaskPermissionsAuthorizationDisabled() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        List result = this.historyService.createHistoricVariableInstanceQuery().list();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCheckNonePermissionOnHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).isEmpty();
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstance_GlobalVariable() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.disableAuthorization();
        this.runtimeService.setVariable(processInstanceId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadPermissionOnHistoricProcessInstance_LocalVariable() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadPermissionOnCompletedHistoricProcessInstance() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckNoneOnHistoricProcessInstanceAndReadHistoryPermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.NONE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{Permissions.READ_HISTORY});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    @Test
    public void testCheckReadOnHistoricProcessInstanceAndNonePermissionOnProcessDefinition() {
        this.processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        String processInstanceId = this.startProcessInstanceByKey(PROCESS_KEY).getId();
        String taskId = this.selectSingleTask().getId();
        this.disableAuthorization();
        this.taskService.setVariable(taskId, "foo", (Object)"bar");
        this.taskService.complete(taskId);
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.HISTORIC_PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{HistoricProcessInstancePermissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, PROCESS_KEY, this.userId, new Permission[]{ProcessDefinitionPermissions.NONE});
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assertions.assertThat((List)query.list()).extracting("processInstanceId").containsExactly(new Object[]{processInstanceId});
    }

    protected void setReadHistoryVariableAsDefaultReadPermission() {
        this.processEngineConfiguration.setEnforceSpecificVariablePermission(true);
    }
}

