/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.DeleteJobsCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JobQueryTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    private CommandExecutor commandExecutor;
    private String deploymentId;
    private String messageId;
    private TimerEntity timerEntity;
    private boolean defaultEnsureJobDueDateSet;
    private Date testStartTime;
    private Date timerOneFireTime;
    private Date timerTwoFireTime;
    private Date timerThreeFireTime;
    private Date messageDueDate;
    private String processInstanceIdOne;
    private String processInstanceIdTwo;
    private String processInstanceIdThree;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_SECOND = 1000L;
    private static final String EXCEPTION_MESSAGE = "java.lang.RuntimeException: This is an exception thrown from scriptTask";
    @Parameterized.Parameter
    public boolean ensureJobDueDateSet;

    @Parameterized.Parameters(name="Job DueDate is set: {0}")
    public static Collection<Object[]> scenarios() throws ParseException {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void setUp() throws Exception {
        this.processEngineConfiguration = this.rule.getProcessEngineConfiguration();
        this.runtimeService = this.rule.getRuntimeService();
        this.repositoryService = this.rule.getRepositoryService();
        this.managementService = this.rule.getManagementService();
        this.commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        this.defaultEnsureJobDueDateSet = this.processEngineConfiguration.isEnsureJobDueDateNotNull();
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(this.ensureJobDueDateSet);
        this.deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/timerOnTask.bpmn20.xml").deploy().getId();
        Calendar startTime = Calendar.getInstance();
        startTime.set(14, 0);
        Date t1 = startTime.getTime();
        ClockUtil.setCurrentTime((Date)t1);
        this.processInstanceIdOne = this.runtimeService.startProcessInstanceByKey("timerOnTask").getId();
        this.testStartTime = t1;
        this.timerOneFireTime = new Date(t1.getTime() + 3600000L);
        startTime.add(11, 1);
        Date t2 = startTime.getTime();
        ClockUtil.setCurrentTime((Date)t2);
        this.processInstanceIdTwo = this.runtimeService.startProcessInstanceByKey("timerOnTask").getId();
        this.timerTwoFireTime = new Date(t2.getTime() + 3600000L);
        startTime.add(11, 1);
        Date t3 = startTime.getTime();
        ClockUtil.setCurrentTime((Date)t3);
        this.processInstanceIdThree = this.runtimeService.startProcessInstanceByKey("timerOnTask").getId();
        this.timerThreeFireTime = new Date(t3.getTime() + 3600000L);
        startTime.add(11, 2);
        this.messageDueDate = startTime.getTime();
        this.messageId = (String)this.commandExecutor.execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                MessageEntity message = new MessageEntity();
                if (JobQueryTest.this.ensureJobDueDateSet) {
                    message.setDuedate(JobQueryTest.this.messageDueDate);
                }
                commandContext.getJobManager().send(message);
                return message.getId();
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        this.repositoryService.deleteDeployment(this.deploymentId, true);
        this.commandExecutor.execute((Command)new DeleteJobsCmd(this.messageId, true));
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(this.defaultEnsureJobDueDateSet);
    }

    @Test
    public void testQueryByNoCriteria() {
        JobQuery query = this.managementService.createJobQuery();
        this.verifyQueryResults(query, 4);
    }

    @Test
    public void testQueryByActivityId() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobQuery query = this.managementService.createJobQuery().activityId(jobDefinition.getActivityId());
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryByInvalidActivityId() {
        JobQuery query = this.managementService.createJobQuery().activityId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().activityId(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testByJobDefinitionId() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobQuery query = this.managementService.createJobQuery().jobDefinitionId(jobDefinition.getId());
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testByInvalidJobDefinitionId() {
        JobQuery query = this.managementService.createJobQuery().jobDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().jobDefinitionId(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByProcessInstanceId() {
        JobQuery query = this.managementService.createJobQuery().processInstanceId(this.processInstanceIdOne);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidProcessInstanceId() {
        JobQuery query = this.managementService.createJobQuery().processInstanceId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().processInstanceId(null);
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByExecutionId() {
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(this.processInstanceIdOne).singleResult();
        JobQuery query = this.managementService.createJobQuery().executionId(job.getExecutionId());
        Assert.assertEquals((Object)((Job)query.singleResult()).getId(), (Object)job.getId());
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByInvalidExecutionId() {
        JobQuery query = this.managementService.createJobQuery().executionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().executionId(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryByProcessDefinitionId() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().list().get(0);
        JobQuery query = this.managementService.createJobQuery().processDefinitionId(processDefinition.getId());
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryByInvalidProcessDefinitionId() {
        JobQuery query = this.managementService.createJobQuery().processDefinitionId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().processDefinitionId(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobQueryTest.testTimeCycleQueryByProcessDefinitionId.bpmn20.xml"})
    public void testTimeCycleQueryByProcessDefinitionId() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process").singleResult()).getId();
        JobQuery query = this.managementService.createJobQuery().processDefinitionId(processDefinitionId);
        this.verifyQueryResults(query, 1);
        String jobId = ((Job)query.singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.verifyQueryResults(query, 1);
        String anotherJobId = ((Job)query.singleResult()).getId();
        Assert.assertFalse((boolean)jobId.equals(anotherJobId));
    }

    @Test
    public void testQueryByProcessDefinitionKey() {
        JobQuery query = this.managementService.createJobQuery().processDefinitionKey("timerOnTask");
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryByInvalidProcessDefinitionKey() {
        JobQuery query = this.managementService.createJobQuery().processDefinitionKey("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().processDefinitionKey(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/JobQueryTest.testTimeCycleQueryByProcessDefinitionId.bpmn20.xml"})
    public void testTimeCycleQueryByProcessDefinitionKey() {
        JobQuery query = this.managementService.createJobQuery().processDefinitionKey("process");
        this.verifyQueryResults(query, 1);
        String jobId = ((Job)query.singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.verifyQueryResults(query, 1);
        String anotherJobId = ((Job)query.singleResult()).getId();
        Assert.assertFalse((boolean)jobId.equals(anotherJobId));
    }

    @Test
    public void testQueryByRetriesLeft() {
        JobQuery query = this.managementService.createJobQuery().withRetriesLeft();
        this.verifyQueryResults(query, 4);
        this.setRetries(this.processInstanceIdOne, 0);
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryByExecutable() {
        long testTime = this.ensureJobDueDateSet ? this.messageDueDate.getTime() : this.timerThreeFireTime.getTime();
        int expectedCount = this.ensureJobDueDateSet ? 0 : 1;
        ClockUtil.setCurrentTime((Date)new Date(testTime + 1000L));
        JobQuery query = this.managementService.createJobQuery().executable();
        this.verifyQueryResults(query, 4);
        this.setRetries(this.processInstanceIdOne, 0);
        this.verifyQueryResults(query, 3);
        ClockUtil.setCurrentTime((Date)this.testStartTime);
        this.verifyQueryResults(query, expectedCount);
    }

    @Test
    public void testQueryByOnlyTimers() {
        JobQuery query = this.managementService.createJobQuery().timers();
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryByOnlyMessages() {
        JobQuery query = this.managementService.createJobQuery().messages();
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testInvalidOnlyTimersUsage() {
        try {
            this.managementService.createJobQuery().timers().messages().list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot combine onlyTimers() with onlyMessages() in the same query"));
        }
    }

    @Test
    public void testQueryByDuedateLowerThen() {
        JobQuery query = this.managementService.createJobQuery().duedateLowerThen(this.testStartTime);
        this.verifyQueryResults(query, 0);
        query = this.managementService.createJobQuery().duedateLowerThen(new Date(this.timerOneFireTime.getTime() + 1000L));
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobQuery().duedateLowerThen(new Date(this.timerTwoFireTime.getTime() + 1000L));
        this.verifyQueryResults(query, 2);
        query = this.managementService.createJobQuery().duedateLowerThen(new Date(this.timerThreeFireTime.getTime() + 1000L));
        this.verifyQueryResults(query, 3);
        if (this.ensureJobDueDateSet) {
            query = this.managementService.createJobQuery().duedateLowerThen(new Date(this.messageDueDate.getTime() + 1000L));
            this.verifyQueryResults(query, 4);
        }
    }

    @Test
    public void testQueryByDuedateLowerThenOrEqual() {
        JobQuery query = this.managementService.createJobQuery().duedateLowerThenOrEquals(this.testStartTime);
        this.verifyQueryResults(query, 0);
        query = this.managementService.createJobQuery().duedateLowerThenOrEquals(this.timerOneFireTime);
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobQuery().duedateLowerThenOrEquals(this.timerTwoFireTime);
        this.verifyQueryResults(query, 2);
        query = this.managementService.createJobQuery().duedateLowerThenOrEquals(this.timerThreeFireTime);
        this.verifyQueryResults(query, 3);
        if (this.ensureJobDueDateSet) {
            query = this.managementService.createJobQuery().duedateLowerThenOrEquals(this.messageDueDate);
            this.verifyQueryResults(query, 4);
        }
    }

    @Test
    public void testQueryByDuedateHigherThen() {
        int startTimeExpectedCount = this.ensureJobDueDateSet ? 4 : 3;
        int timerOneExpectedCount = this.ensureJobDueDateSet ? 3 : 2;
        int timerTwoExpectedCount = this.ensureJobDueDateSet ? 2 : 1;
        int timerThreeExpectedCount = this.ensureJobDueDateSet ? 1 : 0;
        JobQuery query = this.managementService.createJobQuery().duedateHigherThen(this.testStartTime);
        this.verifyQueryResults(query, startTimeExpectedCount);
        query = this.managementService.createJobQuery().duedateHigherThen(this.timerOneFireTime);
        this.verifyQueryResults(query, timerOneExpectedCount);
        query = this.managementService.createJobQuery().duedateHigherThen(this.timerTwoFireTime);
        this.verifyQueryResults(query, timerTwoExpectedCount);
        query = this.managementService.createJobQuery().duedateHigherThen(this.timerThreeFireTime);
        this.verifyQueryResults(query, timerThreeExpectedCount);
        if (this.ensureJobDueDateSet) {
            query = this.managementService.createJobQuery().duedateHigherThen(this.messageDueDate);
            this.verifyQueryResults(query, 0);
        }
    }

    @Test
    public void testQueryByDuedateHigherThenOrEqual() {
        int startTimeExpectedCount = this.ensureJobDueDateSet ? 4 : 3;
        int timerOneExpectedCount = this.ensureJobDueDateSet ? 3 : 2;
        int timerTwoExpectedCount = this.ensureJobDueDateSet ? 2 : 1;
        int timerThreeExpectedCount = this.ensureJobDueDateSet ? 1 : 0;
        JobQuery query = this.managementService.createJobQuery().duedateHigherThenOrEquals(this.testStartTime);
        this.verifyQueryResults(query, startTimeExpectedCount);
        query = this.managementService.createJobQuery().duedateHigherThenOrEquals(this.timerOneFireTime);
        this.verifyQueryResults(query, startTimeExpectedCount);
        query = this.managementService.createJobQuery().duedateHigherThenOrEquals(new Date(this.timerOneFireTime.getTime() + 1000L));
        this.verifyQueryResults(query, timerOneExpectedCount);
        query = this.managementService.createJobQuery().duedateHigherThenOrEquals(this.timerThreeFireTime);
        this.verifyQueryResults(query, timerTwoExpectedCount);
        query = this.managementService.createJobQuery().duedateHigherThenOrEquals(new Date(this.timerThreeFireTime.getTime() + 1000L));
        this.verifyQueryResults(query, timerThreeExpectedCount);
        if (this.ensureJobDueDateSet) {
            query = this.managementService.createJobQuery().duedateHigherThenOrEquals(new Date(this.messageDueDate.getTime() + 1000L));
            this.verifyQueryResults(query, 0);
        }
    }

    @Test
    public void testQueryByDuedateCombinations() {
        JobQuery query = this.managementService.createJobQuery().duedateHigherThan(this.testStartTime).duedateLowerThan(new Date(this.timerThreeFireTime.getTime() + 1000L));
        this.verifyQueryResults(query, 3);
        query = this.managementService.createJobQuery().duedateHigherThan(new Date(this.timerThreeFireTime.getTime() + 1000L)).duedateLowerThan(this.testStartTime);
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQueryByCreateTimeCombinations() {
        JobQuery query = this.managementService.createJobQuery().processInstanceId(this.processInstanceIdOne);
        List jobs = query.list();
        Assert.assertEquals((long)1L, (long)jobs.size());
        Date jobCreateTime = ((Job)jobs.get(0)).getCreateTime();
        query = this.managementService.createJobQuery().processInstanceId(this.processInstanceIdOne).createdAfter(new Date(jobCreateTime.getTime() - 1L));
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobQuery().processInstanceId(this.processInstanceIdOne).createdAfter(jobCreateTime);
        this.verifyQueryResults(query, 0);
        query = this.managementService.createJobQuery().processInstanceId(this.processInstanceIdOne).createdBefore(jobCreateTime);
        this.verifyQueryResults(query, 1);
        query = this.managementService.createJobQuery().processInstanceId(this.processInstanceIdOne).createdBefore(new Date(jobCreateTime.getTime() - 1L));
        this.verifyQueryResults(query, 0);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testQueryByException() {
        JobQuery query = this.managementService.createJobQuery().withException();
        this.verifyQueryResults(query, 0);
        ProcessInstance processInstance = this.startProcessInstanceWithFailingJob();
        query = this.managementService.createJobQuery().withException();
        this.verifyFailedJob(query, processInstance);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testQueryByExceptionMessage() {
        JobQuery query = this.managementService.createJobQuery().exceptionMessage(EXCEPTION_MESSAGE);
        this.verifyQueryResults(query, 0);
        ProcessInstance processInstance = this.startProcessInstanceWithFailingJob();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        query = this.managementService.createJobQuery().exceptionMessage(job.getExceptionMessage());
        this.verifyFailedJob(query, processInstance);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testQueryByExceptionMessageEmpty() {
        JobQuery query = this.managementService.createJobQuery().exceptionMessage("");
        this.verifyQueryResults(query, 0);
        this.startProcessInstanceWithFailingJob();
        query = this.managementService.createJobQuery().exceptionMessage("");
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQueryByExceptionMessageNull() {
        try {
            this.managementService.createJobQuery().exceptionMessage(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            Assert.assertEquals((Object)"Provided exception message is null", (Object)e.getMessage());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    public void testQueryByFailedActivityId() {
        JobQuery query = this.managementService.createJobQuery().failedActivityId("theScriptTask");
        this.verifyQueryResults(query, 0);
        ProcessInstance processInstance = this.startProcessInstanceWithFailingJob();
        query = this.managementService.createJobQuery().failedActivityId("theScriptTask");
        this.verifyFailedJob(query, processInstance);
    }

    @Test
    public void testQueryByInvalidFailedActivityId() {
        JobQuery query = this.managementService.createJobQuery().failedActivityId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.managementService.createJobQuery().failedActivityId(null).list();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testJobQueryWithExceptions() throws Throwable {
        this.createJobWithoutExceptionMsg();
        Job job = (Job)this.managementService.createJobQuery().jobId(this.timerEntity.getId()).singleResult();
        Assert.assertNotNull((Object)job);
        List list = this.managementService.createJobQuery().withException().list();
        Assert.assertEquals((long)list.size(), (long)1L);
        this.deleteJobInDatabase();
        this.createJobWithoutExceptionStacktrace();
        job = (Job)this.managementService.createJobQuery().jobId(this.timerEntity.getId()).singleResult();
        Assert.assertNotNull((Object)job);
        list = this.managementService.createJobQuery().withException().list();
        Assert.assertEquals((long)list.size(), (long)1L);
        this.deleteJobInDatabase();
    }

    @Test
    public void testQueryByNoRetriesLeft() {
        JobQuery query = this.managementService.createJobQuery().noRetriesLeft();
        this.verifyQueryResults(query, 0);
        this.setRetries(this.processInstanceIdOne, 0);
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByActive() {
        JobQuery query = this.managementService.createJobQuery().active();
        this.verifyQueryResults(query, 4);
    }

    @Test
    public void testQueryBySuspended() {
        JobQuery query = this.managementService.createJobQuery().suspended();
        this.verifyQueryResults(query, 0);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("timerOnTask", true);
        this.verifyQueryResults(query, 3);
    }

    @Test
    public void testQueryByJobIdsWithOneId() {
        String id = ((Job)this.managementService.createJobQuery().processInstanceId(this.processInstanceIdOne).singleResult()).getId();
        JobQuery query = this.managementService.createJobQuery().jobIds(Collections.singleton(id));
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByJobIdsWithMultipleIds() {
        Set ids = this.managementService.createJobQuery().list().stream().map(Job::getId).collect(Collectors.toSet());
        JobQuery query = this.managementService.createJobQuery().jobIds(ids);
        this.verifyQueryResults(query, 4);
    }

    @Test
    public void testQueryByJobIdsWithMultipleIdsIncludingFakeIds() {
        HashSet ids = new HashSet();
        ids.addAll(this.managementService.createJobQuery().list().stream().map(Job::getId).collect(Collectors.toSet()));
        Collections.addAll(ids, "fakeIdOne", "fakeIdTwo");
        JobQuery query = this.managementService.createJobQuery().jobIds(ids);
        this.verifyQueryResults(query, 4);
    }

    @Test
    public void testQueryByJobIdsWithEmptyList() {
        Set ids = Collections.emptySet();
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Set of job ids is empty");
        this.managementService.createJobQuery().jobIds(ids);
    }

    @Test
    public void testQueryByJobIdsWithNull() {
        Set ids = null;
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Set of job ids is null");
        this.managementService.createJobQuery().jobIds(ids);
    }

    @Test
    public void testQueryByJobIdsWithFakeIds() {
        HashSet ids = new HashSet();
        Collections.addAll(ids, "fakeIdOne", "fakeIdTwo");
        JobQuery query = this.managementService.createJobQuery().jobIds(ids);
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQueryByProcessInstanceIdsWithOneId() {
        JobQuery query = this.managementService.createJobQuery().processInstanceIds(Collections.singleton(this.processInstanceIdOne));
        this.verifyQueryResults(query, 1);
    }

    @Test
    public void testQueryByProcessInstanceIdsWithMultipleIds() {
        HashSet ids = new HashSet();
        Collections.addAll(ids, this.processInstanceIdOne, this.processInstanceIdThree);
        JobQuery query = this.managementService.createJobQuery().processInstanceIds(ids);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByProcessInstanceIdsWithMultipleIdsIncludingFakeIds() {
        HashSet ids = new HashSet();
        Collections.addAll(ids, this.processInstanceIdOne, this.processInstanceIdThree, "fakeIdOne", "fakeIdTwo");
        JobQuery query = this.managementService.createJobQuery().processInstanceIds(ids);
        this.verifyQueryResults(query, 2);
    }

    @Test
    public void testQueryByProcessInstanceIdsWithEmptyList() {
        Set ids = Collections.emptySet();
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Set of process instance ids is empty");
        this.managementService.createJobQuery().processInstanceIds(ids);
    }

    @Test
    public void testQueryByProcessInstanceIdsWithNull() {
        Set ids = null;
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Set of process instance ids is null");
        this.managementService.createJobQuery().processInstanceIds(ids);
    }

    @Test
    public void testQueryByProcessInstanceIdsWithFakeIds() {
        HashSet ids = new HashSet();
        Collections.addAll(ids, "fakeIdOne", "fakeIdTwo");
        JobQuery query = this.managementService.createJobQuery().processInstanceIds(ids);
        this.verifyQueryResults(query, 0);
    }

    @Test
    public void testQuerySorting() {
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobId().asc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobDuedate().asc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByExecutionId().asc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessInstanceId().asc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobRetries().asc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessDefinitionId().asc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessDefinitionKey().asc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobId().desc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobDuedate().desc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByExecutionId().desc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessInstanceId().desc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByJobRetries().desc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessDefinitionId().desc()).count());
        Assert.assertEquals((long)4L, (long)((JobQuery)this.managementService.createJobQuery().orderByProcessDefinitionKey().desc()).count());
        this.setRetries(this.processInstanceIdTwo, 2);
        ClockUtil.setCurrentTime((Date)new Date(this.timerThreeFireTime.getTime() + 1000L));
        JobQuery query = (JobQuery)((JobQuery)this.managementService.createJobQuery().timers().executable().orderByJobRetries().asc()).orderByJobDuedate().desc();
        List jobs = query.list();
        Assert.assertEquals((long)3L, (long)jobs.size());
        Assert.assertEquals((long)2L, (long)((Job)jobs.get(0)).getRetries());
        Assert.assertEquals((long)3L, (long)((Job)jobs.get(1)).getRetries());
        Assert.assertEquals((long)3L, (long)((Job)jobs.get(2)).getRetries());
        Assert.assertEquals((Object)this.processInstanceIdTwo, (Object)((Job)jobs.get(0)).getProcessInstanceId());
        Assert.assertEquals((Object)this.processInstanceIdThree, (Object)((Job)jobs.get(1)).getProcessInstanceId());
        Assert.assertEquals((Object)this.processInstanceIdOne, (Object)((Job)jobs.get(2)).getProcessInstanceId());
    }

    @Test
    public void testQueryInvalidSortingUsage() {
        try {
            this.managementService.createJobQuery().orderByJobId().list();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"call asc() or desc() after using orderByXX()"));
        }
        try {
            this.managementService.createJobQuery().asc();
            Assert.fail();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"You should call any of the orderBy methods first before specifying a direction"));
        }
    }

    private void setRetries(String processInstanceId, final int retries) {
        final Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstanceId).singleResult();
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobEntity timer = (JobEntity)commandContext.getDbEntityManager().selectById(JobEntity.class, job.getId());
                timer.setRetries(retries);
                return null;
            }
        });
    }

    private ProcessInstance startProcessInstanceWithFailingJob() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        try {
            this.managementService.executeJob(timerJob.getId());
            Assert.fail((String)"RuntimeException from within the script task expected");
        }
        catch (RuntimeException re) {
            Assert.assertThat((Object)re.getMessage(), (Matcher)CoreMatchers.containsString((String)EXCEPTION_MESSAGE));
        }
        return processInstance;
    }

    private void verifyFailedJob(JobQuery query, ProcessInstance processInstance) {
        this.verifyQueryResults(query, 1);
        Job failedJob = (Job)query.singleResult();
        Assert.assertNotNull((Object)failedJob);
        Assert.assertEquals((Object)processInstance.getId(), (Object)failedJob.getProcessInstanceId());
        Assert.assertNotNull((Object)failedJob.getExceptionMessage());
        Assert.assertThat((Object)failedJob.getExceptionMessage(), (Matcher)CoreMatchers.containsString((String)EXCEPTION_MESSAGE));
    }

    private void verifyQueryResults(JobQuery query, int countExpected) {
        Assert.assertEquals((long)countExpected, (long)query.list().size());
        Assert.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            Assert.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            Assert.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(JobQuery query) {
        try {
            query.singleResult();
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    private void createJobWithoutExceptionMsg() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                JobQueryTest.this.timerEntity = new TimerEntity();
                JobQueryTest.this.timerEntity.setLockOwner(UUID.randomUUID().toString());
                JobQueryTest.this.timerEntity.setDuedate(new Date());
                JobQueryTest.this.timerEntity.setRetries(0);
                StringWriter stringWriter = new StringWriter();
                NullPointerException exception = new NullPointerException();
                exception.printStackTrace(new PrintWriter(stringWriter));
                JobQueryTest.this.timerEntity.setExceptionStacktrace(stringWriter.toString());
                jobManager.insert((DbEntity)JobQueryTest.this.timerEntity);
                Assert.assertNotNull((Object)JobQueryTest.this.timerEntity.getId());
                return null;
            }
        });
    }

    private void createJobWithoutExceptionStacktrace() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                JobQueryTest.this.timerEntity = new TimerEntity();
                JobQueryTest.this.timerEntity.setLockOwner(UUID.randomUUID().toString());
                JobQueryTest.this.timerEntity.setDuedate(new Date());
                JobQueryTest.this.timerEntity.setRetries(0);
                JobQueryTest.this.timerEntity.setExceptionMessage("I'm supposed to fail");
                jobManager.insert((DbEntity)JobQueryTest.this.timerEntity);
                Assert.assertNotNull((Object)JobQueryTest.this.timerEntity.getId());
                return null;
            }
        });
    }

    private void deleteJobInDatabase() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobQueryTest.this.timerEntity.delete();
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(JobQueryTest.this.timerEntity.getId());
                List historicIncidents = Context.getProcessEngineConfiguration().getHistoryService().createHistoricIncidentQuery().list();
                for (HistoricIncident historicIncident : historicIncidents) {
                    commandContext.getDbEntityManager().delete((DbEntity)historicIncident);
                }
                return null;
            }
        });
    }
}

