/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ParseUtil;
import org.camunda.bpm.engine.impl.util.ProcessEngineDetails;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ProcessEngineDetailsTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    ProcessEngineConfigurationImpl configuration;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void shouldAssertProcessEngineVersionSnapshotTrimSuffix() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.0-SNAPSHOT", (boolean)true);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.0-SNAPSHOT");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"community");
    }

    @Test
    public void shouldAssertProcessEngineVersionAlphaTrimSuffix() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.0-alpha1", (boolean)true);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.0-alpha1");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"community");
    }

    @Test
    public void shouldAssertProcessEngineVersionSnapshotAlphaEETrimSuffix() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.0-alpha1-ee", (boolean)true);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.0-alpha1");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"enterprise");
    }

    @Test
    public void shouldAssertProcessEngineVersionSnapshotMinorTrimSuffix() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.0", (boolean)true);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.0");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"community");
    }

    @Test
    public void shouldAssertProcessEngineVersionSnapshotMinorEETrimSuffix() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.0-ee", (boolean)true);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.0");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"enterprise");
    }

    @Test
    public void shouldAssertProcessEngineVersionSnapshotPatchTrimSuffix() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.1-ee", (boolean)true);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.1");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"enterprise");
    }

    @Test
    public void shouldAssertProcessEngineVersionSnapshot() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.0-SNAPSHOT", (boolean)false);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.0-SNAPSHOT");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"community");
    }

    @Test
    public void shouldAssertProcessEngineVersionAlpha() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.0-alpha1", (boolean)false);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.0-alpha1");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"community");
    }

    @Test
    public void shouldAssertProcessEngineVersionSnapshotAlphaEE() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.0-alpha1-ee", (boolean)false);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.0-alpha1-ee");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"enterprise");
    }

    @Test
    public void shouldAssertProcessEngineVersionSnapshotMinor() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.0", (boolean)false);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.0");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"community");
    }

    @Test
    public void shouldAssertProcessEngineVersionSnapshotMinorEE() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.0-ee", (boolean)false);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.0-ee");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"enterprise");
    }

    @Test
    public void shouldAssertProcessEngineVersionSnapshotPatch() {
        ProcessEngineDetails engineInfo = ParseUtil.parseProcessEngineVersion((String)"7.14.1-ee", (boolean)false);
        Assertions.assertThat((String)engineInfo.getVersion()).isEqualTo((Object)"7.14.1-ee");
        Assertions.assertThat((String)engineInfo.getEdition()).isEqualTo((Object)"enterprise");
    }
}

