/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;

public class TelemetryConfigurationTest {
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @After
    public void reset() {
        ProcessEngineImpl processEngineImpl = this.processEngineConfiguration.getProcessEngine();
        processEngineImpl.close();
        processEngineImpl = null;
    }

    @Test
    public void shouldHaveDisabledTelemetryByDefault() {
        this.processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        this.processEngineConfiguration.setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        this.processEngineConfiguration.buildProcessEngine();
        Assertions.assertThat((boolean)this.processEngineConfiguration.isInitializeTelemetry()).isFalse();
        Assertions.assertThat((boolean)this.processEngineConfiguration.getManagementService().isTelemetryEnabled()).isFalse();
    }

    @Test
    public void shouldStartEngineWithTelemetryEnabled() {
        this.processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        this.processEngineConfiguration.setInitializeTelemetry(true).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        this.processEngineConfiguration.buildProcessEngine();
        Assertions.assertThat((boolean)this.processEngineConfiguration.isInitializeTelemetry()).isTrue();
        Assertions.assertThat((boolean)this.processEngineConfiguration.getManagementService().isTelemetryEnabled()).isTrue();
    }

    @Test
    public void shouldStartEngineWithChangedTelemetryEndpoint() {
        String telemetryEndpoint = "http://localhost:8081/pings";
        this.processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        this.processEngineConfiguration.setTelemetryEndpoint(telemetryEndpoint).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        this.processEngineConfiguration.buildProcessEngine();
        Assertions.assertThat((String)this.processEngineConfiguration.getTelemetryEndpoint()).isEqualTo((Object)telemetryEndpoint);
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.persistence"}, level="DEBUG")
    public void shouldLogTelemetryPersistenceLog() {
        boolean telemetryInitialized = true;
        this.processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        this.processEngineConfiguration.setInitializeTelemetry(telemetryInitialized).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        this.processEngineConfiguration.buildProcessEngine();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("No telemetry property found in the database").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Creating the telemetry property in database with the value: " + telemetryInitialized).size()).isOne();
    }
}

