/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.telemetry;

import camundajar.impl.com.google.gson.Gson;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.telemetry.dto.Data;
import org.camunda.bpm.engine.impl.telemetry.dto.Database;
import org.camunda.bpm.engine.impl.telemetry.dto.Internals;
import org.camunda.bpm.engine.impl.telemetry.dto.Product;
import org.camunda.bpm.engine.impl.telemetry.reporter.TelemetryReporter;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TelemetryReporterTest {
    protected static final String TELEMETRY_ENDPOINT = "http://localhost:8082/pings";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> configuration.setTelemetryEndpoint(TELEMETRY_ENDPOINT));
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    @ClassRule
    public static WireMockRule wireMockRule = new WireMockRule(8082);
    protected ProcessEngine standaloneProcessEngine;
    protected ProcessEngineConfigurationImpl configuration;
    protected ManagementService managementService;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.configuration.getManagementService();
    }

    @After
    public void tearDown() {
        this.managementService.toggleTelemetry(false);
        if (this.standaloneProcessEngine != null) {
            this.standaloneProcessEngine.close();
            ProcessEngines.unregister((ProcessEngine)this.standaloneProcessEngine);
        }
    }

    @Test
    public void shouldSendTelemetry() {
        this.managementService.toggleTelemetry(true);
        Data data = this.createDataToSend();
        String requestBody = new Gson().toJson((Object)data);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/pings")).willReturn(WireMock.aResponse().withBody(requestBody).withStatus(202)));
        TelemetryReporter telemetryReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, data, this.configuration.getTelemetryHttpConnector());
        telemetryReporter.reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/pings")).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldReportDataWhenTelemetryInitialized() {
        Data data = this.createDataToSend();
        StandaloneInMemProcessEngineConfiguration processEngineConfiguration = new StandaloneInMemProcessEngineConfiguration();
        processEngineConfiguration.setTelemetryEndpoint(TELEMETRY_ENDPOINT).setInitializeTelemetry(true).setTelemetryData(data).setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/pings")).willReturn(WireMock.aResponse().withStatus(202)));
        this.standaloneProcessEngine = processEngineConfiguration.buildProcessEngine();
        processEngineConfiguration.getTelemetryReporter().reportNow();
        String requestBody = new Gson().toJson((Object)data);
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/pings")).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    public void shouldSendTelemetryWhenHttpConnectorNotInitialized() {
        this.managementService.toggleTelemetry(true);
        Data data = this.createDataToSend();
        String requestBody = new Gson().toJson((Object)data);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/pings")).willReturn(WireMock.aResponse().withBody(requestBody).withStatus(202)));
        TelemetryReporter telemetryReporter = new TelemetryReporter(this.configuration.getCommandExecutorTxRequired(), TELEMETRY_ENDPOINT, data, null);
        telemetryReporter.reportNow();
        WireMock.verify((RequestPatternBuilder)WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/pings")).withRequestBody(WireMock.equalToJson((String)requestBody)).withHeader("Content-Type", WireMock.equalTo((String)"application/json")));
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogTelemetrySent() {
        this.managementService.toggleTelemetry(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/pings")).willReturn(WireMock.aResponse().withStatus(202)));
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Start telemetry sending task").size()).isOne();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Telemetry data sent").size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogUnexpectedResponse() {
        this.managementService.toggleTelemetry(true);
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/pings")).willReturn(WireMock.aResponse().withStatus(406)));
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Unexpected response while sending telemetry data. Status code: 406").size()).isOne();
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.telemetry"}, level="DEBUG")
    public void shouldLogTelemetryDisabled() {
        this.managementService.toggleTelemetry(false);
        this.configuration.getTelemetryReporter().reportNow();
        Assertions.assertThat((int)this.loggingRule.getFilteredLog("Sending telemetry is disabled").size()).isPositive();
    }

    protected Data createDataToSend() {
        Database database = new Database("mySpecialDb", "v.1.2.3");
        Internals internals = new Internals(database);
        Product product = new Product("Runtime", "7.14", "special", internals);
        Data data = new Data("b647de4d-e557-455a-a64f-feaecd55f53c", product);
        return data;
    }
}

