/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyExecutionPropagationTest
extends PluggableProcessEngineTest {
    protected static final String CMMN_FILE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String SET_VARIABLE_CMMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/HumanTaskSetVariableExecutionListener.cmmn";
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final String TENANT_ID = "tenant1";

    @Test
    public void testPropagateTenantIdToProcessDefinition() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).done());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertNotNull((Object)processDefinition);
        Assert.assertEquals((Object)TENANT_ID, (Object)processDefinition.getTenantId());
    }

    @Test
    public void testPropagateTenantIdToProcessInstance() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)processInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToConcurrentExecution() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().parallelGateway("fork").userTask().parallelGateway("join").endEvent().moveToNode("fork").userTask().connectTo("join").done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        List executions = this.runtimeService.createExecutionQuery().list();
        Assert.assertThat((Object)executions.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Execution)executions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
        Assert.assertThat((Object)((Execution)executions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
        Assert.assertThat((Object)((Execution)executions.get(2)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToEmbeddedSubprocess() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().subProcess().embeddedSubProcess().startEvent().userTask().endEvent().subProcessDone().endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        List executions = this.runtimeService.createExecutionQuery().list();
        Assert.assertThat((Object)executions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Execution)executions.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
        Assert.assertThat((Object)((Execution)executions.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToTask() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)task.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceOnStartProcessInstance() {
        this.testRule.deployForTenant(TENANT_ID, Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done());
        VariableMap variables = Variables.putValue((String)"var", (Object)"test");
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId(), (Map)variables);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertThat((Object)variableInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variableInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceFromExecution() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().serviceTask().camundaClass(SetVariableTask.class.getName())).camundaAsyncAfter()).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertThat((Object)variableInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variableInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceFromTask() {
        this.testRule.deployForTenant(TENANT_ID, ((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().camundaAsyncAfter()).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        VariableMap variables = Variables.createVariables().putValue("var", (Object)"test");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariablesLocal(task.getId(), (Map)variables);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertThat((Object)variableInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variableInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToStartMessageEventSubscription() {
        this.testRule.deployForTenant(TENANT_ID, ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().message("start")).endEvent().done());
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertThat((Object)eventSubscription, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)eventSubscription.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToStartSignalEventSubscription() {
        this.testRule.deployForTenant(TENANT_ID, ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().signal("start")).endEvent().done());
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertThat((Object)eventSubscription, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)eventSubscription.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToIntermediateMessageEventSubscription() {
        this.testRule.deployForTenant(TENANT_ID, ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().intermediateCatchEvent().message("start")).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertThat((Object)eventSubscription, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)eventSubscription.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToIntermediateSignalEventSubscription() {
        this.testRule.deployForTenant(TENANT_ID, ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().intermediateCatchEvent().signal("start")).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertThat((Object)eventSubscription, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)eventSubscription.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToCompensationEventSubscription() {
        this.testRule.deployForTenant(TENANT_ID, "org/camunda/bpm/engine/test/api/multitenancy/compensationBoundaryEvent.bpmn");
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertThat((Object)eventSubscription, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)eventSubscription.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToStartTimerJobDefinition() {
        this.testRule.deployForTenant(TENANT_ID, ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().timerWithDuration("PT1M")).endEvent().done());
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        Assert.assertThat((Object)jobDefinition, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)jobDefinition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToIntermediateTimerJob() {
        this.testRule.deployForTenant(TENANT_ID, ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().intermediateCatchEvent().timerWithDuration("PT1M")).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)job.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToAsyncJob() {
        this.testRule.deployForTenant(TENANT_ID, ((UserTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().camundaAsyncBefore()).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)job.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToFailedJobIncident() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().serviceTask().camundaExpression("${failing}")).camundaAsyncBefore()).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertThat((Object)incident, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)incident.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToFailedStartTimerIncident() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().timerWithDuration("PT1M")).serviceTask().camundaExpression("${failing}")).endEvent().done());
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertThat((Object)incident, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)incident.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToFailedExternalTaskIncident() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().serviceTask().camundaType("external")).camundaTopic("test")).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        List tasks = this.externalTaskService.fetchAndLock(1, "test-worker").topic("test", 1000L).execute();
        this.externalTaskService.handleFailure(((LockedExternalTask)tasks.get(0)).getId(), "test-worker", "expected", 0, 0L);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertThat((Object)incident, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)incident.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToExternalTask() {
        this.testRule.deployForTenant(TENANT_ID, ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().serviceTask().camundaType("external")).camundaTopic("test")).endEvent().done());
        this.startProcessInstance(PROCESS_DEFINITION_KEY);
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assert.assertThat((Object)externalTask, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)externalTask.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
        List externalTasks = this.externalTaskService.fetchAndLock(1, "test").topic("test", 1000L).execute();
        Assert.assertThat((Object)externalTasks.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((LockedExternalTask)externalTasks.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceOnCreateCaseInstance() {
        this.testRule.deployForTenant(TENANT_ID, CMMN_FILE);
        VariableMap variables = Variables.putValue((String)"var", (Object)"test");
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.caseService.createCaseInstanceById(caseDefinition.getId(), (Map)variables);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertThat((Object)variableInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variableInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceFromCaseExecution() {
        this.testRule.deployForTenant(TENANT_ID, SET_VARIABLE_CMMN_FILE);
        this.createCaseInstance();
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertThat((Object)variableInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variableInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToVariableInstanceFromHumanTask() {
        this.testRule.deployForTenant(TENANT_ID, CMMN_FILE);
        this.createCaseInstance();
        VariableMap variables = Variables.createVariables().putValue("var", (Object)"test");
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.caseService.setVariables(caseExecution.getId(), (Map)variables);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertThat((Object)variableInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variableInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void testPropagateTenantIdToTaskOnCreateCaseInstance() {
        this.testRule.deployForTenant(TENANT_ID, CMMN_FILE);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.caseService.createCaseInstanceById(caseDefinition.getId());
        Task task = (Task)this.taskService.createTaskQuery().taskName("A HumanTask").singleResult();
        Assert.assertThat((Object)task, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)task.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    protected void startProcessInstance(String processDefinitionKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
    }

    protected CaseInstance createCaseInstance() {
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        return this.caseService.createCaseInstanceById(caseDefinition.getId());
    }

    public static class SetVariableTask
    implements JavaDelegate {
        public void execute(DelegateExecution execution) throws Exception {
            execution.setVariable("var", (Object)"test");
        }
    }
}

